/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class Fonts {
    public static int fontsCnt;
    public static Graphics g;
    public static Image[] imageCache;
    public static byte[] imageColorVariantsCnt;
    private static final int UPPER_START_LA = 65;
    private static final int UPPER_END_LA = 90;
    private static final int LOWER_START_LA = 97;
    private static final int LOWER_END_LA = 122;
    private static final int UPPER_START_RU = 1040;
    private static final int UPPER_END_RU = 1071;
    private static final int LOWER_START_RU = 1072;
    private static final int LOWER_END_RU = 1103;
    private static final int UPPER_START_GR = 913;
    private static final int UPPER_END_GR = 937;
    private static final int LOWER_START_GR = 945;
    private static final int LOWER_END_GR = 969;
    static int UPPER_START;
    static int UPPER_END;
    static int LOWER_START;
    static int LOWER_END;
    private static int N_UPPER;
    private static int N_LOWER;
    private static int N_BASE_LETTERS;
    private static final int SPACE = 32;
    private static final int NO_BREAK_SPACE = 160;
    private static final int FRG_OFFSET_X_INDEX = 0;
    private static final int FRG_OFFSET_Y_INDEX = 1;
    private static final int FRG_W_INDEX = 2;
    private static final int FRG_H_INDEX = 3;
    private static final int FRG_BASE_LINE_INDEX = 4;
    private static final int FRG_INFO_CNT = 5;
    static char[] baseDiacritics;
    public static char[] baseLetters;
    private static byte[] baseDecodes;
    private static char[][] fontChars;
    private static byte[] fontW;
    private static byte[] fontH;
    private static byte[] diacriticXShift;
    private static byte[] diacriticYShift;
    private static byte[] diacriticYUpShift;
    private static byte[][] lettersProp;
    public static boolean[] upperLetters;
    private static boolean[] inverseFont;
    public static byte[] spaceLetterW;
    public static byte[] spaceW;
    public static String fontName;
    private static char[] textBuffer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void loadFonts(Class aClass) {
        if (Fonts.initFont()) {
            InputStream in = aClass.getResourceAsStream(fontName);
            try {
                DataInputStream din = new DataInputStream(in);
                Fonts.readFontGraphics(din);
                din.close();
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            finally {
                try {
                    in.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean initFont() {
        boolean fontDiffers;
        String name;
        String currentLangCode;
        if (Menu.lang_sel < 0 || Menu.lang_sel >= Menu.languageCount) {
            Menu.lang_sel = 0;
        }
        if ((currentLangCode = Menu.languageCodes[Menu.lang_sel].toLowerCase()).equals("el")) {
            name = "/font__el";
            UPPER_START = 913;
            UPPER_END = 937;
            LOWER_START = 945;
            LOWER_END = 969;
        } else if (currentLangCode.equals("ru")) {
            name = "/font__ru";
            UPPER_START = 1040;
            UPPER_END = 1071;
            LOWER_START = 1072;
            LOWER_END = 1103;
        } else {
            name = "/font";
            UPPER_START = 65;
            UPPER_END = 90;
            LOWER_START = 97;
            LOWER_END = 122;
        }
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        boolean bl = fontDiffers = !name.equals(fontName);
        if (fontDiffers && imageCache != null && imageCache.length > 0) {
            for (int i2 = imageCache.length - 1; i2 > -1; --i2) {
                Fonts.imageCache[i2] = null;
            }
        }
        fontName = name;
        return fontDiffers;
    }

    public static void clearFont(int fontID) {
        if (imageCache != null && imageCache.length > 0) {
            for (int i2 = imageCache.length - 1; i2 > -1; --i2) {
                if (fontID != i2) continue;
                Fonts.imageCache[i2] = null;
            }
        }
    }

    public static void readFontGraphics(DataInputStream dis) throws IOException {
        Fonts.initFont();
        fontsCnt = dis.readShort();
        imageCache = new Image[fontsCnt];
        imageColorVariantsCnt = new byte[fontsCnt];
        for (int i2 = 0; i2 < fontsCnt; i2 += imageColorVariantsCnt[i2]) {
            MainMIDlet.readDiffImage(dis, imageCache, imageColorVariantsCnt, i2, -1, false);
        }
        String bd = dis.readUTF();
        baseDiacritics = bd.toCharArray();
        String bl = dis.readUTF();
        baseLetters = bl.toCharArray();
        baseDecodes = new byte[dis.readShort()];
        if (baseDecodes.length > 0) {
            dis.readFully(baseDecodes, 0, baseDecodes.length);
        }
        if (baseDiacritics.length != baseLetters.length || baseLetters.length != baseDecodes.length) {
            System.out.println("ASSERT: nesouhlasi pocty zakladu sady - baseDiacriticts:" + baseDiacritics.length + " baseLetters:" + baseLetters.length + " baseDecodes:" + baseDecodes.length);
        }
        dis.readShort();
        System.out.println("Pocet fontu:" + fontsCnt);
        fontChars = new char[fontsCnt][];
        fontH = new byte[fontsCnt];
        fontW = new byte[fontsCnt];
        diacriticXShift = new byte[fontsCnt];
        diacriticYShift = new byte[fontsCnt];
        diacriticYUpShift = new byte[fontsCnt];
        upperLetters = new boolean[fontsCnt];
        inverseFont = new boolean[fontsCnt];
        lettersProp = new byte[fontsCnt][];
        spaceW = new byte[fontsCnt];
        spaceLetterW = new byte[fontsCnt];
        dis.readShort();
        for (int i3 = 0; i3 < fontsCnt; ++i3) {
            int imgIndex = i3;
            int variantsNum = imageColorVariantsCnt[imgIndex];
            String fc = dis.readUTF();
            Fonts.fontChars[i3] = fc.toCharArray();
            Fonts.upperLetters[i3] = false;
            Fonts.lettersProp[i3] = null;
            Fonts.spaceW[i3] = 0;
            int cntO = dis.readShort();
            while (--cntO >= 0) {
                switch (dis.readByte()) {
                    case 0: {
                        Fonts.upperLetters[i3] = dis.readBoolean();
                        break;
                    }
                    case 1: {
                        short cnt = dis.readShort();
                        System.out.println("letters:" + cnt);
                        Fonts.lettersProp[i3] = new byte[cnt];
                        if (cnt > 0) {
                            dis.readFully(lettersProp[i3]);
                        }
                        Fonts.fontH[i3] = (byte)(lettersProp[i3][3] + lettersProp[i3][4]);
                        break;
                    }
                    case 2: {
                        Fonts.spaceW[i3] = dis.readByte();
                        break;
                    }
                    case 3: {
                        Fonts.diacriticYUpShift[i3] = dis.readByte();
                        break;
                    }
                    case 4: {
                        Fonts.fontH[i3] = dis.readByte();
                        break;
                    }
                    case 5: {
                        Fonts.diacriticXShift[i3] = dis.readByte();
                        break;
                    }
                    case 6: {
                        Fonts.diacriticYShift[i3] = dis.readByte();
                        break;
                    }
                    case 7: {
                        Fonts.inverseFont[i3] = dis.readByte() != 0;
                        break;
                    }
                    case 8: {
                        Fonts.spaceLetterW[i3] = dis.readByte();
                    }
                }
            }
            if (spaceLetterW[i3] <= 0) {
                Fonts.spaceLetterW[i3] = lettersProp[i3][2];
            }
            System.out.println("font:" + i3 + " extra znaky:" + new String(fontChars[i3]) + " fontW:" + fontW[i3] + " upperL:" + upperLetters[i3]);
            while (variantsNum > 1) {
                System.out.println("Vytvariam variantu fontu:" + variantsNum);
                Fonts.fontChars[++i3] = fontChars[i3 - 1];
                Fonts.fontH[i3] = fontH[i3 - 1];
                Fonts.fontW[i3] = fontW[i3 - 1];
                Fonts.upperLetters[i3] = upperLetters[i3 - 1];
                Fonts.lettersProp[i3] = lettersProp[i3 - 1];
                Fonts.spaceW[i3] = spaceW[i3 - 1];
                Fonts.spaceLetterW[i3] = spaceLetterW[i3 - 1];
                Fonts.diacriticXShift[i3] = diacriticXShift[i3 - 1];
                Fonts.diacriticYShift[i3] = diacriticYShift[i3 - 1];
                Fonts.diacriticYUpShift[i3] = diacriticYUpShift[i3 - 1];
                Fonts.inverseFont[i3] = inverseFont[i3 - 1];
                --variantsNum;
            }
        }
    }

    public static void drawGraphicString(int fontN, char[] text, int textOffset, int textLength, int x, int y, int anchor) {
        byte letterSpaceW;
        int letterIndex;
        if (lettersProp == null || fontN >= lettersProp.length) {
            System.out.println("Zvoleny font neni pristupny!:" + fontN);
            return;
        }
        Image fontImg = imageCache[fontN];
        byte diaX = diacriticXShift[fontN];
        byte diaYLo = diacriticYShift[fontN];
        byte diaYUp = diacriticYUpShift[fontN];
        boolean upperChars = upperLetters[fontN];
        int lettersLength = lettersProp[fontN].length / 5;
        if ((anchor & 8) != 0) {
            x -= Fonts.getStringWidth(fontN, text, 0, textLength);
        } else if ((anchor & 1) != 0) {
            x -= Fonts.getStringWidth(fontN, text, 0, textLength) >> 1;
        }
        if ((anchor & 0x20) != 0) {
            y -= fontH[fontN];
        } else if ((anchor & 2) != 0) {
            y -= fontH[fontN] >> 1;
            letterIndex = (lettersLength - 10 + 9) * 5;
            y += lettersProp[fontN][letterIndex + 3] - diaYUp;
        } else if ((anchor & 0x10) != 0) {
            letterIndex = (lettersLength - 10 + 9) * 5;
            y += lettersProp[fontN][letterIndex + 3] - diaYUp;
        }
        int ANCHOR = 20;
        int fImgY = 0;
        byte bFontW = letterSpaceW = spaceLetterW[fontN];
        byte bFontH = fontH[fontN];
        int shift = 0;
        byte lSpaceW = spaceW[fontN];
        int nBase = N_BASE_LETTERS + 2;
        if (upperChars) {
            nBase = N_LOWER + 1;
        }
        int textLimit = textOffset + textLength;
        for (int i2 = textOffset; i2 < textLimit; ++i2) {
            boolean isLower;
            int diacriticDecode;
            int actChar;
            block32: {
                block33: {
                    block31: {
                        actChar = text[i2];
                        if (upperChars && (actChar >= UPPER_START && actChar <= UPPER_END || actChar >= LOWER_START && actChar <= LOWER_END || LOWER_START != 97 && actChar >= 97 && actChar <= 122)) {
                            actChar = Fonts.toUpperCase((char)actChar);
                        } else if (LOWER_START != 97 && actChar >= 97 && actChar <= 122) {
                            actChar = Fonts.toUpperCase((char)actChar);
                        }
                        diacriticDecode = 0;
                        boolean isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                        isLower = false;
                        if (!isUpper && !upperChars) {
                            boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                        }
                        if (!isUpper && !isLower) {
                            int nBaseLetters = baseDiacritics.length;
                            for (int j2 = 0; j2 < nBaseLetters; ++j2) {
                                if (baseDiacritics[j2] != actChar) continue;
                                actChar = baseLetters[j2];
                                diacriticDecode = baseDecodes[j2];
                                if (!upperChars) break;
                                actChar = Fonts.toUpperCase((char)actChar);
                                break;
                            }
                            isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                            isLower = false;
                            if (!isUpper && !upperChars) {
                                boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                            }
                        }
                        if (!isUpper) break block31;
                        shift = actChar - UPPER_START;
                        break block32;
                    }
                    if (!isLower) break block33;
                    shift = actChar - LOWER_START + N_UPPER + 1;
                    if (actChar != 105 || diacriticDecode != 0) break block32;
                    diacriticDecode = 10;
                    break block32;
                }
                if (actChar == 32 || actChar == 160) {
                    x += letterSpaceW + lSpaceW;
                    continue;
                }
                int nChars = fontChars[fontN].length;
                int tmpUpperChar = actChar;
                if (upperChars) {
                    if (actChar == 231) {
                        tmpUpperChar = 199;
                    } else if (actChar == 261) {
                        tmpUpperChar = 260;
                    } else if (actChar == 281) {
                        tmpUpperChar = 280;
                    } else if (actChar == 322) {
                        tmpUpperChar = 321;
                    }
                }
                char[] fc = fontChars[fontN];
                for (int j3 = 0; j3 < nChars; ++j3) {
                    char tmpChar = fc[j3];
                    if (tmpChar != actChar && (!upperChars || tmpChar != tmpUpperChar)) continue;
                    shift = j3 + nBase;
                    break;
                }
            }
            int letterIndex2 = shift * 5;
            int fImgX = lettersProp[fontN][letterIndex2++] & 0xFF;
            fImgY = lettersProp[fontN][letterIndex2++] & 0xFF;
            bFontW = lettersProp[fontN][letterIndex2++];
            bFontH = lettersProp[fontN][letterIndex2++];
            int baseLine = lettersProp[fontN][letterIndex2];
            if (fImgX + bFontW > fontImg.getWidth()) {
                System.out.println("ASSERT Offset prez sirku obr! fontu:" + fontN + " x:" + (fImgX + bFontW));
            }
            if (fImgY + bFontH > fontImg.getHeight()) {
                System.out.println("ASSERT Offset prez vysku obr! fontu:" + fontN + " x:" + (fImgY + bFontH));
            }
            g.drawRegion(fontImg, fImgX, fImgY, (int)bFontW, (int)bFontH, 0, x, y + baseLine, 20);
            if (diacriticDecode > 0 && (diacriticDecode != 10 || actChar != 105)) {
                letterIndex2 = (lettersLength - 10 + (diacriticDecode > 1 ? diacriticDecode - 1 : 1)) * 5;
                fImgX = lettersProp[fontN][letterIndex2++] & 0xFF;
                fImgY = lettersProp[fontN][letterIndex2++] & 0xFF;
                byte diacW = lettersProp[fontN][letterIndex2++];
                byte diacH = lettersProp[fontN][letterIndex2++];
                int yPosCorr = baseLine;
                int xPosCorr = diacriticDecode == 1 ? bFontW - diacW + 2 >> 1 : (diacriticDecode == 2 ? bFontW - diacW : bFontW - diacW + 1 >> 1);
                yPosCorr = isLower ? (yPosCorr += diaYLo) : (yPosCorr += diaYUp);
                g.drawRegion(fontImg, fImgX, fImgY, (int)diacW, (int)diacH, 0, x + (xPosCorr += diaX), y + yPosCorr - diacH, 20);
                fImgY = 0;
            }
            x += bFontW + lSpaceW;
        }
    }

    private static int toTextBuffer(String texts) {
        int length = texts.length();
        if (textBuffer.length < length) {
            textBuffer = new char[length];
        }
        texts.getChars(0, length, textBuffer, 0);
        return length;
    }

    public static void drawGraphicString(int fontN, String texts, int x, int y, int anchor) {
        int length = Fonts.toTextBuffer(texts);
        Fonts.drawGraphicString(fontN, textBuffer, 0, length, x, y -= 3, anchor);
    }

    public static int getStringWidth(int fontN, String text) {
        if (lettersProp == null || fontN >= lettersProp.length) {
            System.out.println("Zvoleny font neni pristupny!:" + fontN);
            return -1;
        }
        int width = 0;
        int length = text.length();
        for (int i2 = 0; i2 < length; ++i2) {
            width += Fonts.getCharWidth(fontN, text.charAt(i2));
        }
        return width - spaceW[fontN];
    }

    public static int getStringWidth(int fontN, char[] text, int offset, int length) {
        if (offset > text.length) {
            return 0;
        }
        int width = 0;
        for (int i2 = offset; i2 < length; ++i2) {
            width += Fonts.getCharWidth(fontN, text[i2]);
        }
        return width - spaceW[fontN];
    }

    public static int getCharWidth(int fontN, char actChar) {
        int shift;
        int actFontW;
        block9: {
            boolean upperChars;
            block10: {
                block8: {
                    if (lettersProp == null || fontN >= lettersProp.length) {
                        System.out.println("Zvoleny font neni pristupny!:" + fontN);
                        return -1;
                    }
                    upperChars = upperLetters[fontN];
                    actFontW = fontW[fontN];
                    shift = 0;
                    boolean isUpper = actChar >= UPPER_START && actChar <= UPPER_END;
                    boolean isLower = false;
                    if (!isUpper && !upperChars) {
                        boolean bl = isLower = actChar >= LOWER_START && actChar <= LOWER_END;
                    }
                    if (!isUpper && !isLower) {
                        int nBaseLetters = baseDiacritics.length;
                        for (int j2 = 0; j2 < nBaseLetters; ++j2) {
                            if (baseDiacritics[j2] != actChar) continue;
                            actChar = baseLetters[j2];
                            break;
                        }
                    }
                    if (upperChars && (actChar >= UPPER_START && actChar <= UPPER_END || actChar >= LOWER_START && actChar <= LOWER_END || LOWER_START != 97 && actChar >= 'a' && actChar <= 'z')) {
                        actChar = Fonts.toUpperCase(actChar);
                    }
                    if (actChar < UPPER_START || actChar > UPPER_END) break block8;
                    shift = actChar - UPPER_START;
                    break block9;
                }
                if (actChar < LOWER_START || actChar > LOWER_END) break block10;
                shift = actChar - LOWER_START + N_UPPER + 1;
                if (!upperChars) break block9;
                shift -= N_UPPER + 1;
                break block9;
            }
            if (actChar == ' ' || actChar == '\u00a0') {
                return spaceLetterW[fontN] + spaceW[fontN];
            }
            char[] fc = fontChars[fontN];
            int nChars = fc.length;
            for (int j3 = 0; j3 < nChars; ++j3) {
                if (fc[j3] != actChar) continue;
                if (upperChars) {
                    shift = j3 + N_BASE_LETTERS - N_LOWER + 1;
                    break;
                }
                shift = j3 + N_BASE_LETTERS + 2;
                break;
            }
        }
        actFontW = lettersProp[fontN][shift * 5 + 2] + spaceW[fontN];
        return actFontW;
    }

    public static char toUpperCase(char actChar) {
        if (actChar >= UPPER_START && actChar <= UPPER_END) {
            return actChar;
        }
        if (actChar == '\u03c2') {
            return '\u03a3';
        }
        if ((char)(actChar + UPPER_START - LOWER_START) != Character.toUpperCase(actChar)) {
            System.out.println("ASSERT: toUpperCase differ for char " + actChar + " (" + actChar + ")");
        }
        return (char)(actChar + UPPER_START - LOWER_START);
    }

    public static String toUpperCase(String text) {
        char[] chars = text.toCharArray();
        for (int i2 = 0; i2 < chars.length; ++i2) {
            chars[i2] = Fonts.toUpperCase(chars[i2]);
        }
        return new String(chars);
    }

    public static int getFontHeight(int fontN) {
        if (fontH == null || fontN >= fontH.length) {
            System.out.println("Zvoleny font neni pristupny!:" + fontN);
            return -1;
        }
        return fontH[fontN];
    }

    static {
        UPPER_START = 65;
        UPPER_END = 90;
        LOWER_START = 97;
        LOWER_END = 122;
        N_UPPER = UPPER_END - UPPER_START;
        N_LOWER = LOWER_END - LOWER_START;
        N_BASE_LETTERS = N_UPPER + N_LOWER;
        textBuffer = new char[64];
    }
}

