/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class XFont {
    final boolean debugColor;
    public static final char WHITE_SPACE = ' ';
    public static final char LINE_BREAK = '|';
    public static final char PAGE_BREAK = '\u00b6';
    int numCol;
    private int color = 0;
    public static final int COL_WHITE = 0;
    public static final int COL_BLACK = 1;
    private byte[][] col_palette;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    private int style;
    private int xfontWordspace;
    private int xfontTracking;
    private boolean isXFont = false;
    public int fontID;
    private static int[] CRCTable;

    public XFont() {
        this(null);
    }

    public XFont(byte[][] palette) {
        this.debugColor = true;
    }

    public void setTracking(int xfontTracking) {
        this.xfontTracking = xfontTracking;
    }

    public int getTracking() {
        return this.xfontTracking;
    }

    public void setStyle(int newStyle) {
        if (newStyle == 1 && this.style == 0) {
            ++this.xfontTracking;
        }
        if (newStyle == 0 && this.style == 1) {
            --this.xfontTracking;
        }
        this.style = newStyle;
    }

    public void setColor(int color) {
        if (color > this.numCol - 1) {
            color = 0;
        }
        this.color = color;
    }

    public int getHeight() {
        return Fonts.getFontHeight(this.fontID);
    }

    public int getBaseline() {
        return 0;
    }

    public int stringWidth(String str) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        return Fonts.getStringWidth(this.fontID, str);
    }

    public int charWidth(char c2) {
        return Fonts.getCharWidth(this.fontID, c2);
    }

    public final void drawString(Graphics g2, String str, int x, int y, int anchor) {
        if (str == null || str.length() == 0) {
            return;
        }
        Fonts.g = g2;
        Fonts.drawGraphicString(this.fontID, str, x, y, anchor);
    }

    public void load(int fID) {
        MainMIDlet.menu.readLanguageDefinition();
        Fonts.loadFonts(this.getClass());
        this.isXFont = false;
        this.fontID = fID;
        this.setTracking(Fonts.spaceLetterW[fID]);
    }

    public void unload() {
        Fonts.clearFont(this.fontID);
    }

    public Image createModifiedImage(byte[] b2, byte[] plte) {
        int pos = 0;
        try {
            for (int i2 = 16; i2 < b2.length; ++i2) {
                if (b2[i2 - 3] != 80 || b2[i2 - 2] != 76 || b2[i2 - 1] != 84 || b2[i2 - 0] != 69) continue;
                pos = i2 + 1;
                break;
            }
            byte[] newData = new byte[b2.length];
            System.arraycopy(b2, 0, newData, 0, b2.length);
            System.arraycopy(plte, 0, newData, pos, plte.length);
            int crc = ~XFont.crc32(newData, pos - 4, plte.length + 4);
            pos += plte.length;
            newData[pos++] = (byte)(crc >> 24);
            newData[pos++] = (byte)(crc >> 16);
            newData[pos++] = (byte)(crc >> 8);
            newData[pos] = (byte)crc;
            return Image.createImage((byte[])newData, (int)0, (int)newData.length);
        }
        catch (Exception e2) {
            System.out.println("ex createModifiedImage: " + e2.getMessage());
            e2.printStackTrace();
            return null;
        }
    }

    private char[] wrap(String text, int width) {
        int len = text.length();
        int k2 = 0;
        int lineLen = 0;
        int wordLen = 0;
        byte spaceLen = Fonts.spaceW[this.fontID];
        char[] string = text.toCharArray();
        for (int i2 = 0; i2 < len; ++i2) {
            if (string[i2] == ' ' || string[i2] == '/') {
                k2 = i2 + 1;
                wordLen = 0;
                if (k2 < len) {
                    while (string[k2] != ' ' && string[k2] != '/' && string[k2] != '|' && string[k2] != '\u00b6' && lineLen + wordLen <= width) {
                        wordLen += this.charWidth(string[k2]) + Fonts.spaceLetterW[this.fontID];
                        if (++k2 < len) continue;
                    }
                }
                if (lineLen + wordLen + spaceLen > width) {
                    if (string[i2] == '/') {
                        int a2;
                        char[] tmpS = string;
                        string = new char[++len];
                        for (a2 = 0; a2 <= i2; ++a2) {
                            string[a2] = tmpS[a2];
                        }
                        string[i2 + 1] = 124;
                        for (a2 = i2 + 2; a2 < len; ++a2) {
                            string[a2] = tmpS[a2 - 1];
                        }
                    } else {
                        string[i2] = 124;
                    }
                } else {
                    lineLen += spaceLen;
                }
            }
            if (string[i2] != '|' && string[i2] != '\u00b6' && string[i2] != ' ' && string[i2] != '/') {
                lineLen += this.charWidth(string[i2]) + Fonts.spaceLetterW[this.fontID];
                continue;
            }
            if (string[i2] != '|' && string[i2] != '\u00b6') continue;
            lineLen = 0;
        }
        return string;
    }

    public String[][] breakPages(String src, int width, int height) {
        if (height <= 0) {
            height = 10000;
        }
        Vector pages = new Vector();
        Vector<String> lines = new Vector<String>();
        StringBuffer line = new StringBuffer();
        int lineLen = height / this.getHeight();
        char[] string = this.wrap(src, width + 70);
        int len = string.length;
        for (int i2 = 0; i2 < len; ++i2) {
            if (string[i2] == '|' || string[i2] == '\u00b6') {
                lines.addElement(line.toString());
                line = new StringBuffer();
                --lineLen;
            } else {
                line.append(string[i2]);
            }
            if (lineLen > 0 && string[i2] != '\u00b6') continue;
            pages.addElement(lines);
            lines = new Vector();
            lineLen = height / this.getHeight();
        }
        lines.addElement(line.toString());
        pages.addElement(lines);
        String[][] texts = new String[pages.size()][];
        for (int i3 = 0; i3 < texts.length; ++i3) {
            Vector v = (Vector)pages.elementAt(i3);
            texts[i3] = new String[v.size()];
            for (int j2 = 0; j2 < texts[i3].length; ++j2) {
                texts[i3][j2] = (String)v.elementAt(j2);
            }
        }
        return texts;
    }

    private static int crc32(byte[] buffer, int start, int count) {
        int crc;
        int i2;
        if (CRCTable == null) {
            CRCTable = new int[256];
            for (i2 = 0; i2 < 256; ++i2) {
                crc = i2;
                for (int j2 = 8; j2 > 0; --j2) {
                    if ((crc & 1) == 1) {
                        crc = crc >>> 1 ^ 0xEDB88320;
                        continue;
                    }
                    crc >>>= 1;
                }
                XFont.CRCTable[i2] = crc;
            }
        }
        i2 = start;
        crc = -1;
        while (count-- != 0) {
            crc = CRCTable[(crc ^ buffer[i2++]) & 0xFF] ^ crc >>> 8;
        }
        return crc;
    }

    public static String valueOf(int number, int figure) {
        String num = String.valueOf(number);
        return figure <= num.length() ? num : ("0000000000000000" + num).substring(16 + num.length() - figure, 16 + num.length());
    }

    public static String replace(String replace, String src) {
        try {
            String tag = "%";
            String temp1 = src.substring(0, src.indexOf("%"));
            String temp2 = src.substring(src.indexOf("%") + 1, src.length());
            return temp1 + replace + temp2;
        }
        catch (Exception e2) {
            return src;
        }
    }

    public String replace(String src, String[] args) {
        return this.replace(new StringBuffer(src), 0, args).toString();
    }

    private StringBuffer replace(StringBuffer src, int pos, String[] args) {
        StringBuffer result = new StringBuffer();
        for (int i2 = pos; i2 < src.length(); ++i2) {
            if ('(' == src.charAt(i2)) {
                this.replace(src, i2 + 1, args);
                --i2;
                continue;
            }
            if (')' == src.charAt(i2)) {
                StringBuffer res = this.replace(result, args);
                src.delete(pos - 1, i2 + 1);
                src.insert(pos - 1, res.toString());
                return res;
            }
            result.append(src.charAt(i2));
        }
        return src;
    }

    private StringBuffer replace(StringBuffer src, String[] args) {
        StringBuffer result = new StringBuffer();
        StringBuffer left = new StringBuffer();
        StringBuffer right = new StringBuffer();
        int sign = 0;
        boolean qestion = false;
        boolean comment = false;
        int pos = 0;
        block17: for (int i2 = 0; i2 < src.length(); ++i2) {
            char c2 = src.charAt(i2);
            if ('\"' == c2) {
                comment = !comment;
                continue;
            }
            if (!comment && ' ' == c2) continue;
            if ('$' == c2) {
                int number = "0123456789".indexOf(src.charAt(++i2));
                switch (pos) {
                    case 0: {
                        if (0 == sign) {
                            left.append(args[number]);
                            break;
                        }
                        right.append(args[number]);
                        break;
                    }
                    case 1: {
                        if (!qestion) break;
                        result.append(args[number]);
                        break;
                    }
                    case 2: {
                        if (qestion) break;
                        result.append(args[number]);
                    }
                }
                continue;
            }
            if ('!' == c2) {
                sign |= 1;
                continue;
            }
            if ('=' == c2) {
                sign |= 2;
                continue;
            }
            if ('<' == c2) {
                sign |= 4;
                continue;
            }
            if ('>' == c2) {
                sign |= 8;
                continue;
            }
            if ('?' == c2) {
                switch (sign) {
                    case 3: {
                        if (0 != right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 6: {
                        if (0 <= right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 10: {
                        if (0 >= right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 4: {
                        if (0 < right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    case 8: {
                        if (0 > right.toString().compareTo(left.toString())) {
                            qestion = true;
                            break;
                        }
                        qestion = false;
                        break;
                    }
                    default: {
                        qestion = 0 == right.toString().compareTo(left.toString());
                    }
                }
                pos = 1;
                continue;
            }
            if (':' == c2) {
                pos = 2;
                continue;
            }
            switch (pos) {
                case 0: {
                    if (0 == sign) {
                        left.append(c2);
                        continue block17;
                    }
                    right.append(c2);
                    continue block17;
                }
                case 1: {
                    if (!qestion) continue block17;
                    result.append(c2);
                    continue block17;
                }
                case 2: {
                    if (qestion) continue block17;
                    result.append(c2);
                }
            }
        }
        if (0 == pos) {
            result = left;
        }
        return result;
    }

    public String getLabelString(String str, int width) {
        if (width < this.stringWidth(str)) {
            int w = this.stringWidth("...");
            int count = 0;
            for (int i2 = 0; i2 < str.length() && width >= (w += this.charWidth(str.charAt(i2))); ++i2) {
                ++count;
            }
            return str.substring(0, count) + "...";
        }
        return str;
    }
}

