/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

class SoundPlayer
implements ISound {
    SoundBank soundBank;
    private Player[] fxPlayer = new Player[8];
    private Player tunePlayer;
    public static boolean bHasIntroTune = false;
    private boolean _isSoundOn = true;
    private static int lastsoundplayed = -1;
    String sOutput;

    SoundPlayer() {
    }

    public void setSoundBank(SoundBank soundBank) {
        this.soundBank = soundBank;
    }

    public void loadSounds() {
        int n;
        for (n = 0; n < this.soundBank.getNumberOfTunes(); ++n) {
            this.LoadTune(n);
        }
        for (n = this.soundBank.getNumberOfTunes(); n < this.soundBank.getNumberOfSounds(); ++n) {
            this.LoadSound(n);
        }
    }

    void LoadSound(int n) {
        String string = this.soundBank.getSound(n);
        if (string == null) {
            this.fxPlayer[n] = null;
            return;
        }
        if (this.fxPlayer[n] != null) {
            try {
                this.fxPlayer[n].stop();
                this.fxPlayer[n].close();
                this.fxPlayer[n] = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.fxPlayer[n] = Manager.createPlayer((InputStream)inputStream, (String)this.soundBank.getSoundMIMEType(n));
        }
        catch (Exception exception) {
            this.fxPlayer[n] = null;
        }
    }

    void LoadTune(int n) {
        String string = this.soundBank.getTune(n);
        if (string == null) {
            bHasIntroTune = false;
            this.tunePlayer = null;
            return;
        }
        if (this.tunePlayer != null) {
            try {
                this.tunePlayer.stop();
                this.tunePlayer.close();
                this.tunePlayer = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            this.tunePlayer = Manager.createPlayer((InputStream)inputStream, (String)this.soundBank.getSoundMIMEType(n));
            bHasIntroTune = true;
        }
        catch (Exception exception) {
            bHasIntroTune = false;
            this.tunePlayer = null;
        }
    }

    public void setSoundOn(boolean bl) {
        this.stopAllSounds();
        this._isSoundOn = bl;
    }

    public void playSound(int n) {
        this.playSound(n, false);
    }

    public void playSound(int n, int n2) {
        this.playSound(n, n2 == -1);
    }

    public void playSound(int n, boolean bl) {
        if (!this._isSoundOn || n == -1) {
            return;
        }
        try {
            if (this.fxPlayer[n] == null) {
                return;
            }
            this.fxPlayer[n].start();
            lastsoundplayed = n;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopSound(int n) {
        if (this.fxPlayer[n] == null) {
            return;
        }
        try {
            lastsoundplayed = -1;
            this.fxPlayer[n].stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopAllSounds() {
        for (int i = 0; i < this.fxPlayer.length; ++i) {
            this.stopSound(i);
        }
        this.stopTune();
    }

    public void playTune(int n) {
        this.playTune(n, false);
    }

    public void playTune(int n, int n2) {
        this.playTune(n, n2 == -1);
    }

    public void playTune(int n, boolean bl) {
        if (!this._isSoundOn || n == -1) {
            return;
        }
        if (n >= this.soundBank.getNumberOfTunes()) {
            return;
        }
        try {
            if (this.tunePlayer == null) {
                return;
            }
            this.tunePlayer.setLoopCount(bl ? -1 : 1);
            this.tunePlayer.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stopTune() {
        if (this.tunePlayer != null) {
            try {
                this.tunePlayer.stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

