/*
 * Decompiled with CFR 0.152.
 */
package borisplus.j2me.mail;

import borisplus.j2me.mail.MailException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.io.Connector;
import javax.microedition.io.StreamConnection;

public class MailSocket {
    private static final boolean DEBUG = false;
    public static final String CRLF = "\r\n";
    private String serverAddress;
    private String serverPort;
    private String login;
    private String password;
    private StreamConnection connection;
    private DataInputStream in;
    private DataOutputStream out;
    private String error;

    public MailSocket(String _serverAddress, String _serverPort, String _login, String _password) {
        this.serverAddress = _serverAddress;
        this.serverPort = _serverPort;
        this.login = _login;
        this.password = _password;
        this.connection = null;
        this.in = null;
        this.out = null;
        this.error = "";
    }

    public String getError() {
        return this.error;
    }

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String _serverAddress) {
        this.serverAddress = _serverAddress;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String _serverPort) {
        this.serverPort = _serverPort;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String _login) {
        this.login = _login;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String _password) {
        this.password = _password;
    }

    public DataInputStream getInput() {
        return this.in;
    }

    public void setInput(DataInputStream _in) {
        this.in = _in;
    }

    public DataOutputStream getOutput() {
        return this.out;
    }

    public void setOutput(DataOutputStream _out) {
        this.out = _out;
    }

    public StreamConnection getStreamConnection() {
        return this.connection;
    }

    public void setStreamConnection(StreamConnection _connection) {
        this.connection = _connection;
    }

    public void connect() throws MailException {
        try {
            this.setStreamConnection((StreamConnection)Connector.open((String)("socket://" + this.getServerAddress() + ":" + this.getServerPort()), (int)3));
            this.setInput(this.getStreamConnection().openDataInputStream());
            this.setOutput(this.getStreamConnection().openDataOutputStream());
        }
        catch (IOException exc) {
            throw new MailException("Connect MailSocet IOException");
        }
    }

    public void disconnect() {
        if (this.getInput() != null) {
            try {
                this.getInput().close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.getOutput() != null) {
            try {
                this.getOutput().close();
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (this.getStreamConnection() != null) {
            try {
                this.getStreamConnection().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.setInput(null);
        this.setOutput(null);
        this.setStreamConnection(null);
    }

    public void writeCommand(String command) throws MailException {
        try {
            byte[] b2 = command.getBytes();
            this.getOutput().write(b2, 0, b2.length);
            this.getOutput().flush();
        }
        catch (IOException exc) {
            throw new MailException("WriteCommand MailSocet IOException");
        }
    }

    public String readLine() throws MailException {
        StringBuffer buffer = new StringBuffer();
        try {
            byte[] ch2 = new byte[1];
            this.getInput().read(ch2);
            while (ch2[0] != 13) {
                buffer.append(new String(ch2));
                this.getInput().read(ch2);
            }
            this.getInput().read(ch2);
        }
        catch (IOException exc) {
            throw new MailException("WriteCommand MailSocet IOException");
        }
        return buffer.toString();
    }

    public String readAll() throws MailException {
        StringBuffer buffer = new StringBuffer();
        try {
            int c2 = 0;
            while ((c2 = this.getInput().read()) != -1 && this.getInput().available() > 0) {
                buffer.append((char)c2);
            }
        }
        catch (IOException exc) {
            throw new MailException("WriteCommand MailSocet IOException");
        }
        return buffer.toString();
    }

    public boolean isOk(String serverMessage, String ok, String message) throws MailException {
        if (serverMessage == null || !serverMessage.trim().startsWith(ok)) {
            this.error = message + ":'" + serverMessage + "'";
            throw new MailException(this.error);
        }
        return true;
    }
}

