/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller;

import com.foxmobile.ghostcamera.controller.ResourcePreparer;
import com.foxmobile.ghostcamera.controller.state.AbstractCanvasState;
import com.foxmobile.ghostcamera.controller.state.AppState;
import com.foxmobile.ghostcamera.controller.state.HelpState;
import com.foxmobile.ghostcamera.controller.state.InitialState;
import com.foxmobile.ghostcamera.controller.state.LogoState;
import com.foxmobile.ghostcamera.controller.state.MenuState;
import com.foxmobile.ghostcamera.controller.state.PhotoCaptureState;
import com.foxmobile.ghostcamera.controller.state.PhotoEditingState;
import com.foxmobile.ghostcamera.controller.state.SettingsState;
import com.foxmobile.ghostcamera.controller.state.TitleState;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Preconditions;
import com.foxmobile.ghostcamera.framework.Streams;
import com.foxmobile.ghostcamera.framework.Strings;
import com.foxmobile.ghostcamera.framework.Threads;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.graphics.PNG;
import com.foxmobile.ghostcamera.framework.language.Language;
import com.foxmobile.ghostcamera.framework.resources.PreparedResources;
import com.foxmobile.ghostcamera.graphics.Canvas;
import com.foxmobile.ghostcamera.graphics.CanvasKeyListener;
import com.foxmobile.ghostcamera.l10n.L10nResources;
import com.foxmobile.ghostcamera.model.Settings;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public final class AppController
implements CanvasKeyListener {
    public static final int TOTAL_GHOSTS = 5;
    public static final int GHOST_LEFT = 0;
    public static final int GHOST_CENTER = 1;
    public static final int GHOST_RIGHT = 2;
    public static final int GHOST_MAX_POSITION = 2;
    private static final int MAX_PHOTO_SIZE = 400;
    private static final String TAG;
    private static final AppController instance;
    private MIDlet midlet;
    private AppState appState = null;
    private Canvas canvas = null;
    private DeviceTraits traits = null;
    private PreparedResources preparedResources = new PreparedResources();
    private Language activeLanguage;
    private L10nResources l10nResources;
    private Vector availableLanguages = new Vector();
    private RecordStore recordStore;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.controller.AppController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
        instance = new AppController();
    }

    public static final AppController getInstance() {
        return instance;
    }

    private AppController() {
        this.initRecordStore();
        this.changeStateTo(new InitialState());
        this.initLanguages();
    }

    private void initRecordStore() {
        try {
            this.recordStore = RecordStore.openRecordStore((String)"foxmobile.ghostcamera", (boolean)true);
        }
        catch (Throwable t) {
            this.handleFatalError(t);
        }
    }

    private void initLanguages() {
        this.availableLanguages.addElement(new Language("en-US", "English"));
        this.availableLanguages.addElement(new Language("fr-FR", "Fran\u00e7ais"));
        this.availableLanguages.addElement(new Language("it-IT", "Italiano"));
        this.availableLanguages.addElement(new Language("de-DE", "Deutsch"));
        this.availableLanguages.addElement(new Language("es-ES", "Espa\u00f1ol"));
        this.changeActiveLanguage((Language)this.availableLanguages.elementAt(0));
    }

    public void startApp(MIDlet midlet) {
        Preconditions.checkState(this.appState instanceof InitialState, "invalid state");
        this.midlet = midlet;
        if (this.verifyDeviceFeatures()) {
            this.initCanvas();
            this.traits = DeviceTraits.initFrom(this.canvas);
            Log.log(TAG, "Device traits: {0}", this.traits.toString());
            this.changeStateTo(new LogoState(this.canvas));
        }
    }

    private boolean verifyDeviceFeatures() {
        boolean result = true;
        String capture = System.getProperty("supports.video.capture");
        result = result && capture != null && capture.equalsIgnoreCase("true");
        Log.log(TAG, "MMAPI capture is {0}supported", result ? "" : "not ");
        boolean jsr75 = false;
        try {
            Class.forName("javax.microedition.io.file.FileConnection");
            jsr75 = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        result = result && jsr75;
        Log.log(TAG, "JSR-75 file management is {0}supported", jsr75 ? "" : "not ");
        if (!result) {
            Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)new Alert("Unsupported Device", "Sorry, your device is not supported. Please visit the Fox Mobile website to see the list of supported devices.", null, AlertType.ERROR));
        }
        return result;
    }

    private void initCanvas() {
        this.canvas = new Canvas(this);
        this.canvas.setFullScreenMode(true);
        Display.getDisplay((MIDlet)this.midlet).setCurrent((Displayable)this.canvas);
        this.canvas.launchLoop();
    }

    public AppState getState(Class expectedState) {
        Preconditions.checkState(expectedState.isInstance(this.appState), "unexpected state");
        return this.appState;
    }

    private void changeStateTo(AppState newState) {
        Log.log(TAG, "changing state from {0} to {1}", this.appState, newState);
        if (this.appState != null) {
            this.appState.doBeforeLeaving();
        }
        this.appState = newState;
        if (newState != null) {
            newState.doAfterEntering();
        }
    }

    public DeviceTraits getDeviceTraits() {
        return this.traits;
    }

    public synchronized void startPreparingResources() {
        Log.log(TAG, "Starting resource preload");
        new Thread(new ResourcePreparer(this.midlet)).start();
    }

    public synchronized void handleResourcePreparingDone() {
        Log.log(TAG, "Resource preloading done");
        this.changeStateTo(new TitleState(this.canvas));
    }

    public PreparedResources getPreparedResources() {
        return this.preparedResources;
    }

    public synchronized Language getActiveLanguage() {
        return this.activeLanguage;
    }

    public synchronized void changeActiveLanguage(Language language) {
        this.activeLanguage = language;
        this.l10nResources = L10nResources.getL10nResources(this.activeLanguage.getCode());
        if (this.appState != null) {
            this.appState.handleActiveLanguageChanged(language);
        }
    }

    public synchronized int cycleActiveLanguage() {
        int index = this.availableLanguages.indexOf(this.activeLanguage);
        int newIndex = (index + 1) % this.availableLanguages.size();
        this.changeActiveLanguage((Language)this.availableLanguages.elementAt(newIndex));
        return newIndex;
    }

    public synchronized void saveActiveLanguage() {
        int index = this.availableLanguages.indexOf(this.activeLanguage);
        Settings settings = this.loadSettings();
        if (settings.getLanguage() != index) {
            settings.setLanguage(index);
            this.saveSettings(settings);
        }
    }

    public int getNextLanguageIndex(int currentLanguageIndex) {
        int newIndex = (currentLanguageIndex + 1) % this.availableLanguages.size();
        return newIndex;
    }

    public void keyPressed(int keyCode) {
        this.appState.handleKeyPressed(keyCode);
    }

    public void keyReleased(int keyCode) {
        this.appState.handleKeyReleased(keyCode);
    }

    public void handleGoToMenu() {
        this.changeStateTo(new MenuState(this.canvas));
    }

    public void handleGoToSettings() {
        this.changeStateTo(new SettingsState(this.canvas));
    }

    public void handleGoToHelp() {
        this.changeStateTo(new HelpState(Display.getDisplay((MIDlet)this.midlet)));
    }

    public String getString(String key) {
        String string = this.l10nResources.getString(key);
        if (string == null) {
            Log.log(TAG, "Warning: no string for key {0}", key);
        }
        return string;
    }

    public void stopApp() {
        this.midlet.notifyDestroyed();
    }

    public void openMoreAppsBrowser() {
        try {
            String url = this.midlet.getAppProperty("more-apps-url");
            if (url == null) {
                url = "http://www.foxmobileentertainment.com/";
            }
            this.midlet.platformRequest(url);
            this.stopApp();
        }
        catch (ConnectionNotFoundException e) {
            Log.log(TAG, "Warning: failed to open the browser");
        }
    }

    public void takePicture() {
        this.changeStateTo(new PhotoCaptureState(Display.getDisplay((MIDlet)this.midlet)));
    }

    public void handlePhotoCaptureCanceled() {
        this.changeStateTo(new MenuState(this.canvas));
    }

    public void handlePhotoCaptureSnapshot(byte[] snapshot) {
        Image image = null;
        try {
            image = Image.createImage((byte[])snapshot, (int)0, (int)snapshot.length);
            float aspect = (float)image.getWidth() / (float)image.getHeight();
            if (image.getHeight() > 400) {
                image = Bitmaps.scaleImageHq(image, (int)(aspect * 400.0f), 400);
            } else if (image.getWidth() > 400) {
                image = Bitmaps.scaleImageHq(image, 400, (int)(400.0f / aspect));
            }
        }
        catch (Throwable t) {
            this.handleFatalError(t);
        }
        if (image != null) {
            this.changeStateTo(new PhotoEditingState(this.canvas, image));
        }
    }

    public void handleFatalError(Throwable t) {
        Log.log(TAG, "Fatal error: {0}", t);
        Display.getDisplay((MIDlet)this.midlet).setCurrent(new Alert("ERROR", t.toString(), null, AlertType.ERROR), (Displayable)new Form("Close Me"));
        while (true) {
            Threads.sleep(1000L);
        }
    }

    public void sizeChanged(int w, int h) {
        if (this.appState instanceof AbstractCanvasState) {
            ((AbstractCanvasState)this.appState).handleSizeChanged(w, h);
        }
    }

    public void handleTakeAnotherPicture() {
        this.takePicture();
    }

    public void handleCancelEditing() {
        this.changeStateTo(new MenuState(this.canvas));
    }

    public String saveImage(Image image) {
        String savedPath;
        block7: {
            int[] argb = new int[image.getWidth() * image.getHeight()];
            image.getRGB(argb, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
            byte[] png = PNG.toPNG(image.getWidth(), image.getHeight(), argb);
            argb = null;
            Log.log(TAG, "PNG size: {0} Kb", new Integer(png.length / 1024));
            savedPath = null;
            String foundDirectory = this.findDirectoryForPhotos();
            if (foundDirectory == null) {
                Log.log(TAG, "Did not find any suitable directory for pics");
            } else {
                String pathToSave = String.valueOf(foundDirectory) + "ghost" + Strings.formatDate(new Date()) + ".png";
                FileConnection connection = null;
                OutputStream stream = null;
                try {
                    try {
                        Log.log(TAG, "Trying to save to {0}", pathToSave);
                        connection = (FileConnection)Connector.open((String)pathToSave, (int)2);
                        connection.create();
                        stream = connection.openOutputStream();
                        stream.write(png);
                        savedPath = pathToSave;
                        Log.log(TAG, "Successfully saved image to {0}", savedPath);
                    }
                    catch (IOException e) {
                        Log.log(TAG, "Failed to save the image: {0}", e);
                        Streams.close(stream);
                        Streams.close((Connection)connection);
                        break block7;
                    }
                }
                catch (Throwable throwable) {
                    Streams.close(stream);
                    Streams.close(connection);
                    throw throwable;
                }
                Streams.close(stream);
                Streams.close((Connection)connection);
            }
        }
        return savedPath;
    }

    private static final String getFolderName(String url) {
        int secondSlashIndex;
        String result = "";
        int firstSlashIndex = url.lastIndexOf(47);
        if (firstSlashIndex > 0 && (secondSlashIndex = url.lastIndexOf(47, firstSlashIndex - 1)) > 0) {
            result = url.substring(secondSlashIndex + 1, firstSlashIndex);
        }
        return result;
    }

    private static final String getFileName(String url) {
        String result = "";
        int firstSlashIndex = url.lastIndexOf(47);
        if (firstSlashIndex > 0 && firstSlashIndex < url.length() - 1) {
            result = url.substring(firstSlashIndex + 1);
        }
        return result;
    }

    public void handleSaveImage(Image image) {
        String path = this.saveImage(image);
        Alert alert = null;
        if (path == null) {
            alert = new Alert(this.getString("ERROR"), this.getString("PHOTOSAVINGFAILED"), null, AlertType.ERROR);
        } else {
            String folderName = AppController.getFolderName(path);
            String fileName = AppController.getFileName(path);
            alert = new Alert(this.getString("PHOTOSAVEDTITLE"), Strings.format(this.getString("PHOTOSAVEDMESSAGE"), folderName, fileName), null, AlertType.INFO);
        }
        alert.setTimeout(-2);
        this.changeStateTo(new MenuState(this.canvas));
        Display.getDisplay((MIDlet)this.midlet).setCurrent(alert, (Displayable)this.canvas);
    }

    private String findDirectoryForPhotos() {
        String foundDirectory = null;
        Enumeration fileSystemRoots = FileSystemRegistry.listRoots();
        while (fileSystemRoots.hasMoreElements()) {
            String root = (String)fileSystemRoots.nextElement();
            if (!root.endsWith("/")) {
                root = String.valueOf(root) + "/";
            }
            Log.log(TAG, "Trying root: {0}", root);
            FileConnection rootConnection = null;
            try {
                rootConnection = (FileConnection)Connector.open((String)("file:///" + root), (int)1);
                if (!rootConnection.isDirectory()) {
                    Log.log(TAG, "Root {0} is not a directory", root);
                } else {
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*photo*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*picture*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*Photo*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*Picture*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*image*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*Image*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*download*");
                    }
                    if (foundDirectory == null) {
                        foundDirectory = this.checkRoot(root, rootConnection, "*Download*");
                    }
                    if (foundDirectory != null) {
                        Streams.close((Connection)rootConnection);
                        break;
                    }
                }
            }
            catch (IOException e) {
                Log.log(TAG, "Failed to traverse root: {0}", root);
                continue;
            }
            finally {
                Streams.close(rootConnection);
            }
            Streams.close((Connection)rootConnection);
        }
        return foundDirectory;
    }

    private String checkRoot(String root, FileConnection rootConnection, String regexp) throws IOException {
        Enumeration photoEntries = rootConnection.list(regexp, true);
        while (photoEntries.hasMoreElements()) {
            String entry = (String)photoEntries.nextElement();
            Log.log(TAG, "Checking entry: {0}", entry);
            String entryUrl = "file:///" + root + entry;
            FileConnection entryConnection = (FileConnection)Connector.open((String)entryUrl, (int)1);
            try {
                if (!entryConnection.isDirectory()) continue;
                if (!entryUrl.endsWith("/")) {
                    entryUrl = String.valueOf(entryUrl) + "/";
                }
                Log.log(TAG, "Found directory for photos: {0}", entryUrl);
                String string = entryUrl;
                return string;
            }
            finally {
                Streams.close((Connection)entryConnection);
            }
        }
        return null;
    }

    public void handleExit() {
        this.midlet.notifyDestroyed();
    }

    public Settings loadSettings() {
        Settings result = null;
        try {
            byte[] record = this.recordStore.getRecord(this.recordStore.getNextRecordID() - 1);
            result = Settings.deserialize(record);
        }
        catch (Exception e) {
            Log.log(TAG, "Failed to load settings (non-fatal): {0}", e);
            result = new Settings();
        }
        return result;
    }

    public void saveSettings(Settings settings) {
        byte[] bytes = settings.serialize();
        try {
            if (this.recordStore.getNumRecords() < 1) {
                this.recordStore.addRecord(bytes, 0, bytes.length);
            } else {
                this.recordStore.setRecord(this.recordStore.getNextRecordID() - 1, bytes, 0, bytes.length);
            }
            Log.log(TAG, "Saved settings");
        }
        catch (Exception e) {
            Log.log(TAG, "Failed to save settings: {0}", e);
        }
    }
}

