/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractCanvasState;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Size;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import com.foxmobile.ghostcamera.graphics.Canvas;
import com.foxmobile.ghostcamera.model.Settings;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PhotoEditingState
extends AbstractCanvasState {
    private static final String TAG;
    private static final float FLOAT_PI = 3.1416f;
    private static final int TOP_PADDING = 10;
    private static final int TOOLBAR_HEIGHT = 60;
    private static final float NUMBER_AMPLITUDE = 6.0f;
    private Image photo;
    private volatile Image thumbnail;
    private Image backgroundImage;
    private AppFont font;
    private int currentGhost = 0;
    private Image ghost;
    private volatile int thumbnailLeft = 0;
    private volatile int thumbnailTop = 0;
    private volatile float scale = 1.0f;
    private int menuItemWidth = 0;
    private int menuItemTop = 5;
    private int menuItemBottom = 33;
    private int menuItemHeight = 60 - this.menuItemTop - this.menuItemBottom;
    private int totalMenuItems = 6;
    private int menuItemPadding = 5;
    private int cursorPosition = -1;
    private float cursorPhase = 0.0f;
    private float[] itemPhases = new float[this.totalMenuItems];
    private float[] itemVelocities = new float[this.totalMenuItems];
    private volatile boolean thumbnailOff = false;
    private volatile boolean thumbnailDirty = true;
    private String[] itemLabels = new String[this.totalMenuItems];
    private static final float LABEL_AMPLITUDE = 5.0f;
    private float labelPhase = 0.0f;
    private float labelVelocity = 0.0f;
    private float labelAcceleration = 0.0f;
    private float labelDecay = 0.0f;
    private int thumbnailRotation = 0;
    private int ghostPosition = 0;
    private volatile boolean inProgress = false;
    private Settings settings = null;
    private Runnable thumbnailRecreator = new Runnable(){

        public void run() {
            PhotoEditingState.this.inProgress = true;
            PhotoEditingState.this.thumbnailOff = true;
            PhotoEditingState.this.thumbnailDirty = true;
            try {
                try {
                    PhotoEditingState.this.createThumbnail();
                    PhotoEditingState.this.calculateThumbnailPosition();
                }
                catch (Throwable t) {
                    AppController.getInstance().handleFatalError(t);
                    PhotoEditingState.this.inProgress = false;
                    PhotoEditingState.this.thumbnailOff = false;
                    PhotoEditingState.this.thumbnailDirty = true;
                }
            }
            finally {
                PhotoEditingState.this.inProgress = false;
                PhotoEditingState.this.thumbnailOff = false;
                PhotoEditingState.this.thumbnailDirty = true;
            }
        }
    };
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.controller.state.PhotoEditingState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public PhotoEditingState(Canvas canvas, Image photo) {
        super(canvas);
        this.photo = photo;
    }

    protected void doBeforeLoop() {
        this.settings = AppController.getInstance().loadSettings();
        this.ghostPosition = this.settings.getDefaultPosition();
        this.currentGhost = this.settings.getDefaultGhost();
        this.backgroundImage = (Image)AppController.getInstance().getPreparedResources().getResource("menuBackground");
        this.font = (AppFont)AppController.getInstance().getPreparedResources().getResource("defaultFont");
        this.loadGhost();
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        this.recreateThumbnail();
        int canvasWidth = traits.getCanvasWidth();
        this.menuItemWidth = (canvasWidth - this.menuItemPadding * (this.totalMenuItems + 1)) / this.totalMenuItems;
        int i = 0;
        while (i < this.totalMenuItems) {
            this.itemPhases[i] = 0.0f;
            this.itemVelocities[i] = 0.0f;
            ++i;
        }
        this.changeCursorPosition(0);
        i = 0;
        this.itemLabels[i++] = AppController.getInstance().getString("CHANGEGHOSTITEM");
        this.itemLabels[i++] = AppController.getInstance().getString("GHOSTPOSITIONITEM");
        this.itemLabels[i++] = AppController.getInstance().getString("ROTATEITEM");
        this.itemLabels[i++] = AppController.getInstance().getString("TAKEANOTHERPICTURE");
        this.itemLabels[i++] = AppController.getInstance().getString("SAVEPHOTOITEM");
        this.itemLabels[i++] = AppController.getInstance().getString("CANCELITEM");
    }

    private void loadGhost() {
        this.ghost = ResourceProvider.getInstance().loadBitmap("ghost" + this.currentGhost + "-");
    }

    private void createThumbnail() {
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        int targetHeight = this.getMaxThumbnailHeight(traits);
        this.thumbnail = this.photo;
        int newWidth = this.photo.getWidth();
        int newHeight = this.photo.getHeight();
        float aspect = (float)newWidth / (float)newHeight;
        int minDimension = Math.min(traits.getCanvasWidth(), targetHeight);
        if (this.photo.getWidth() > this.photo.getHeight()) {
            if (this.photo.getWidth() > minDimension) {
                newWidth = minDimension;
                newHeight = (int)((float)newWidth / aspect);
            }
        } else if (this.photo.getHeight() > minDimension) {
            newHeight = minDimension;
            newWidth = (int)((float)newHeight * aspect);
        }
        if (newWidth != this.photo.getWidth() || newHeight != this.photo.getHeight()) {
            this.thumbnail = Bitmaps.scaleImage(this.photo, newWidth, newHeight);
        }
        this.scale = (float)this.thumbnail.getWidth() / (float)this.photo.getWidth();
        Log.log(TAG, "Scale: {0}", new Float(this.scale));
        int i = 0;
        while (i < this.thumbnailRotation % 4) {
            this.thumbnail = Bitmaps.rotateImageLeft(this.thumbnail);
            ++i;
        }
        this.applyGhostToThumbnail();
    }

    private void applyGhostToThumbnail() {
        float ghostAspect = (float)this.ghost.getWidth() / (float)this.ghost.getHeight();
        int desiredGhostHeight = this.photo.getHeight() - 20;
        if ((float)desiredGhostHeight > (float)this.ghost.getHeight() * 3.0f) {
            desiredGhostHeight = (int)((float)this.ghost.getHeight() * 3.0f);
        }
        int resultingGhostWidth = (int)((float)desiredGhostHeight * ghostAspect);
        Image scaledGhost = Bitmaps.scaleImage(this.ghost, (int)((float)resultingGhostWidth * this.scale), (int)((float)desiredGhostHeight * this.scale));
        int ghostX = 0;
        switch (this.ghostPosition) {
            case 0: {
                ghostX = 0;
                break;
            }
            case 1: {
                ghostX = (this.thumbnail.getWidth() - scaledGhost.getWidth()) / 2;
                break;
            }
            case 2: {
                ghostX = this.thumbnail.getWidth() - scaledGhost.getWidth();
            }
        }
        this.thumbnail = Bitmaps.applyAlpha(this.thumbnail, scaledGhost, ghostX, (this.thumbnail.getHeight() - 20 - scaledGhost.getHeight()) / 2 + 10, this.getAlphaShift());
    }

    private int getAlphaShift() {
        switch (this.settings.getTransparency()) {
            case 25: {
                return 2;
            }
            case 50: {
                return 1;
            }
        }
        return 0;
    }

    private void calculateThumbnailPosition() {
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        int canvasWidth = traits.getCanvasWidth();
        int canvasHeight = traits.getCanvasHeight();
        this.thumbnailLeft = (canvasWidth - this.thumbnail.getWidth()) / 2;
        this.thumbnailTop = (canvasHeight - 10 - 60 - this.thumbnail.getHeight()) / 2 + 10;
    }

    private void recreateThumbnail() {
        new Thread(this.thumbnailRecreator).start();
    }

    private int getMaxThumbnailHeight(DeviceTraits traits) {
        return traits.getCanvasHeight() - 10 - 60;
    }

    private void changeCursorPosition(int newPosition) {
        if (this.cursorPosition != -1) {
            this.startLabelShaking();
        }
        this.itemVelocities[newPosition] = 3.1416f * (newPosition % 2 == 0 ? -1.0f : 1.0f);
        this.cursorPosition = newPosition;
    }

    protected void executeRedraw(Graphics graphics, Timing timing) {
        if (this.thumbnailDirty) {
            graphics.drawImage(this.backgroundImage, 0, 0, 0);
            if (this.thumbnail != null && !this.thumbnailOff) {
                graphics.drawImage(this.thumbnail, this.thumbnailLeft, this.thumbnailTop, 0);
                graphics.setColor(0);
                graphics.drawRect(this.thumbnailLeft, this.thumbnailTop, this.thumbnail.getWidth() - 1, this.thumbnail.getHeight() - 1);
                graphics.drawRect(this.thumbnailLeft + 1, this.thumbnailTop + 1, this.thumbnail.getWidth() - 2, this.thumbnail.getHeight() - 2);
            }
            this.thumbnailDirty = false;
        } else {
            graphics.drawRegion(this.backgroundImage, 0, this.canvas.getHeight() - 60, this.canvas.getWidth(), 60, 0, 0, this.canvas.getHeight() - 60, 0);
        }
        this.drawMenuItems(graphics, timing);
        int xShift = this.getLabelXShift();
        if (!this.inProgress) {
            String itemLabel = this.itemLabels[this.cursorPosition];
            Size size = this.font.measureString(itemLabel, graphics);
            this.font.blitString(graphics, itemLabel, xShift + (this.canvas.getWidth() - size.getWidth()) / 2, this.canvas.getHeight() - this.font.getDescent());
        } else {
            String progressLabel = AppController.getInstance().getString("PLEASEWAIT");
            Size size = this.font.measureString(progressLabel, graphics);
            this.font.blitString(graphics, progressLabel, (this.canvas.getWidth() - size.getWidth()) / 2, this.canvas.getHeight() - this.font.getDescent());
        }
    }

    protected void afterFlush(Timing timing) {
        super.afterFlush(timing);
        this.moveLabel(timing);
    }

    private void drawMenuItems(Graphics graphics, Timing timing) {
        int i = 0;
        while (i < this.totalMenuItems) {
            int baseItemY;
            int x = this.menuItemPadding + i * (this.menuItemWidth + this.menuItemPadding);
            int y = this.canvas.getHeight() - this.menuItemHeight - this.menuItemBottom;
            String number = "" + (i + 1);
            Size size = this.font.measureString(number, graphics);
            int intY = baseItemY = y + this.font.getAscent() + (this.menuItemHeight - this.font.getAscent()) / 2 + 6;
            if (this.itemVelocities[i] != 0.0f) {
                float previousQuadrant;
                float currentQuadrant;
                float itemY = (float)baseItemY + (float)Math.sin(this.itemPhases[i]) * 6.0f;
                intY = (int)itemY;
                float previousPhase = this.itemPhases[i];
                float angularVelocity = this.itemVelocities[i];
                this.itemPhases[i] = this.itemPhases[i] + timing.calculateDelta(angularVelocity);
                if (this.cursorPosition != i && (currentQuadrant = (float)Math.ceil(this.itemPhases[i] / 3.1416f)) != (previousQuadrant = (float)Math.ceil(previousPhase / 3.1416f))) {
                    this.itemPhases[i] = 0.0f;
                    this.itemVelocities[i] = 0.0f;
                }
                if (this.itemPhases[i] > 6.2832f) {
                    int n = i;
                    this.itemPhases[n] = this.itemPhases[n] - 6.2832f;
                }
            }
            if (this.cursorPosition == i) {
                this.drawCursor(graphics, timing, x, intY);
            }
            this.font.blitString(graphics, number, x + (this.menuItemWidth - size.getWidth()) / 2, intY);
            ++i;
        }
    }

    private void drawCursor(Graphics graphics, Timing timing, int x, int intY) {
        int cursorX = x + this.menuItemWidth / 2;
        int cursorY = intY - this.font.getAscent() + this.menuItemHeight / 2;
        this.cursorPhase += timing.calculateDelta(3.1416f);
        if (this.cursorPhase >= 6.2832f) {
            this.cursorPhase -= 6.2832f;
        }
        float distance = (float)this.font.getAscent() * 0.66f;
        int pointX = (int)((double)cursorX + Math.sin(this.cursorPhase) * (double)distance);
        int pointY = (int)((double)cursorY + Math.cos(this.cursorPhase) * (double)distance);
        graphics.setColor(-3355444);
        graphics.fillRect(pointX - 2, pointY - 2, 4, 4);
        pointX = (int)((double)cursorX + Math.sin(this.cursorPhase + 2.0944f) * (double)distance);
        pointY = (int)((double)cursorY + Math.cos(this.cursorPhase + 2.0944f) * (double)distance);
        graphics.setColor(-5592406);
        graphics.fillRect(pointX - 2, pointY - 2, 4, 4);
        pointX = (int)((double)cursorX + Math.sin(this.cursorPhase + 4.1888f) * (double)distance);
        pointY = (int)((double)cursorY + Math.cos(this.cursorPhase + 4.1888f) * (double)distance);
        graphics.setColor(-6710887);
        graphics.fillRect(pointX - 2, pointY - 2, 4, 4);
    }

    private void fireCursor() {
        this.startLabelShaking();
        switch (this.cursorPosition) {
            case 0: {
                this.cycleGhosts();
                break;
            }
            case 1: {
                this.cycleGhostPosition();
                break;
            }
            case 2: {
                this.rotateThumbnail();
                break;
            }
            case 3: {
                AppController.getInstance().handleTakeAnotherPicture();
                break;
            }
            case 4: {
                this.savePhoto();
                break;
            }
            case 5: {
                AppController.getInstance().handleCancelEditing();
            }
        }
    }

    private void savePhoto() {
        new Thread(new Runnable(){

            public void run() {
                PhotoEditingState.this.inProgress = true;
                try {
                    try {
                        Image rotatedPhoto = PhotoEditingState.this.photo;
                        int i = 0;
                        while (i < PhotoEditingState.this.thumbnailRotation % 4) {
                            rotatedPhoto = Bitmaps.rotateImageLeft(rotatedPhoto);
                            ++i;
                        }
                        float ghostAspect = (float)PhotoEditingState.this.ghost.getWidth() / (float)PhotoEditingState.this.ghost.getHeight();
                        int desiredGhostHeight = rotatedPhoto.getHeight() - 20;
                        if ((float)desiredGhostHeight > (float)PhotoEditingState.this.ghost.getHeight() * 3.0f) {
                            desiredGhostHeight = (int)((float)PhotoEditingState.this.ghost.getHeight() * 3.0f);
                        }
                        int resultingGhostWidth = (int)((float)desiredGhostHeight * ghostAspect);
                        Image scaledGhost = Bitmaps.scaleImage(PhotoEditingState.this.ghost, resultingGhostWidth, desiredGhostHeight);
                        int ghostX = 0;
                        switch (PhotoEditingState.this.ghostPosition) {
                            case 0: {
                                ghostX = 0;
                                break;
                            }
                            case 1: {
                                ghostX = (rotatedPhoto.getWidth() - scaledGhost.getWidth()) / 2;
                                break;
                            }
                            case 2: {
                                ghostX = rotatedPhoto.getWidth() - scaledGhost.getWidth();
                            }
                        }
                        Image result = Bitmaps.applyAlpha(rotatedPhoto, scaledGhost, ghostX, (rotatedPhoto.getHeight() - 20 - scaledGhost.getHeight()) / 2 + 10, PhotoEditingState.this.getAlphaShift());
                        AppController.getInstance().handleSaveImage(result);
                    }
                    catch (Throwable t) {
                        AppController.getInstance().handleFatalError(t);
                        PhotoEditingState.this.inProgress = false;
                    }
                }
                finally {
                    PhotoEditingState.this.inProgress = false;
                }
            }
        }).start();
    }

    private void cycleGhosts() {
        this.currentGhost = (this.currentGhost + 1) % 5;
        new Thread(new Runnable(){

            public void run() {
                PhotoEditingState.this.inProgress = true;
                try {
                    PhotoEditingState.this.loadGhost();
                    PhotoEditingState.this.thumbnailRecreator.run();
                }
                catch (Throwable t) {
                    AppController.getInstance().handleFatalError(t);
                }
            }
        }).start();
    }

    private void cycleGhostPosition() {
        this.ghostPosition = (this.ghostPosition + 1) % 3;
        this.recreateThumbnail();
    }

    private void rotateThumbnail() {
        ++this.thumbnailRotation;
        this.recreateThumbnail();
    }

    public void handleKeyPressed(int keyCode) {
        if (!this.inProgress) {
            DeviceTraits traits = AppController.getInstance().getDeviceTraits();
            if (traits.isRightKeyCode(keyCode)) {
                this.changeCursorPosition((this.cursorPosition + 1) % this.totalMenuItems);
            } else if (traits.isLeftKeyCode(keyCode)) {
                this.changeCursorPosition(this.cursorPosition == 0 ? this.totalMenuItems - 1 : this.cursorPosition - 1);
            } else if (traits.isRightSoftKeyCode(keyCode) || traits.isSelectKeyCode(keyCode)) {
                this.fireCursor();
            } else if (keyCode >= 49 && keyCode <= 55) {
                int position = keyCode - 49;
                if (position == this.cursorPosition) {
                    this.fireCursor();
                } else {
                    this.changeCursorPosition(position);
                }
            } else {
                super.handleKeyPressed(keyCode);
            }
        }
    }

    private void startLabelShaking() {
        this.labelPhase = 0.0f;
        this.labelVelocity = 25.1328f;
        this.labelAcceleration = -25.1328f;
        this.labelDecay = 0.8f;
    }

    private void moveLabel(Timing timing) {
        if (this.labelVelocity > 0.0f) {
            this.labelPhase += timing.calculateDelta(this.labelVelocity);
            if (this.labelPhase >= 6.2832f) {
                this.labelPhase -= 6.2832f;
            }
            this.labelVelocity += timing.calculateDelta(this.labelAcceleration);
            if (this.labelVelocity <= 0.01f) {
                this.labelVelocity = 0.0f;
            }
            this.labelDecay -= timing.calculateDelta(1.0f);
            if (this.labelDecay < 0.0f) {
                this.labelDecay = 0.0f;
            }
        }
    }

    private int getLabelXShift() {
        return (int)(Math.sin(this.labelPhase) * 5.0 * (double)this.labelDecay);
    }

    public void handleSizeChanged(int w, int h) {
        super.handleSizeChanged(w, h);
        this.thumbnailDirty = true;
    }
}

