/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractAppState;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import java.io.IOException;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VideoControl;

public class PhotoCaptureState
extends AbstractAppState
implements CommandListener,
Runnable {
    private static final String TAG;
    private Command okCommand = new Command(AppController.getInstance().getString("OK"), 4, 2);
    private Command cancelCommand = new Command(AppController.getInstance().getString("CANCEL"), 3, 1);
    private Command pleaseWaitCommand = new Command(AppController.getInstance().getString("PLEASEWAIT"), 1, 1);
    private Display display;
    private Displayable previousDisplayable;
    private int padding = 0;
    private VideoControl control;
    private Player player;
    private byte[] snapshot;
    private Canvas canvas;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.controller.state.PhotoCaptureState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public PhotoCaptureState(Display display) {
        this.display = display;
    }

    public void doAfterEntering() {
        super.doAfterEntering();
        this.previousDisplayable = this.display.getCurrent();
        this.canvas = new Canvas(){

            protected void paint(Graphics g) {
                if (PhotoCaptureState.this.padding > 0) {
                    g.setColor(0, 0, 0);
                    g.fillRect(0, 0, this.getWidth(), PhotoCaptureState.this.padding);
                    g.fillRect(0, this.getHeight() - PhotoCaptureState.this.padding, this.getWidth(), PhotoCaptureState.this.padding);
                }
            }
        };
        this.canvas.addCommand(this.pleaseWaitCommand);
        this.canvas.setCommandListener((CommandListener)this);
        this.display.setCurrent((Displayable)this.canvas);
        new Thread(){

            public void run() {
                try {
                    PhotoCaptureState.this.createPlayer();
                    PhotoCaptureState.this.canvas.removeCommand(PhotoCaptureState.this.pleaseWaitCommand);
                    PhotoCaptureState.this.canvas.addCommand(PhotoCaptureState.this.okCommand);
                    PhotoCaptureState.this.canvas.addCommand(PhotoCaptureState.this.cancelCommand);
                }
                catch (Throwable t) {
                    Log.log(TAG, "Failed to init photo capture: {0}", t);
                    AppController.getInstance().handleFatalError(t);
                }
            }
        }.start();
    }

    public void doBeforeLeaving() {
        try {
            if (this.player != null) {
                this.player.stop();
                this.player.deallocate();
            }
            this.player = null;
            this.control = null;
        }
        catch (Throwable t) {
            Log.log(TAG, "Warning: failed to release player: {0}", t);
        }
        this.display.setCurrent(this.previousDisplayable);
        super.doBeforeLeaving();
    }

    public void commandAction(Command c, Displayable d) {
        if (c == this.okCommand) {
            this.canvas.removeCommand(this.okCommand);
            this.canvas.removeCommand(this.cancelCommand);
            this.canvas.addCommand(this.pleaseWaitCommand);
            this.snapshot = null;
            Thread thread = new Thread(this);
            thread.start();
        } else if (c == this.cancelCommand) {
            AppController.getInstance().handlePhotoCaptureCanceled();
        }
    }

    public void run() {
        try {
            this.takeSnapshot();
            Log.log(TAG, "Snapshot size: {0}", this.snapshot == null ? null : new Integer(this.snapshot.length));
            this.player.stop();
            AppController.getInstance().handlePhotoCaptureSnapshot(this.snapshot);
        }
        catch (Throwable t) {
            Log.log(TAG, "Snapshot failed: {0}", t);
            AppController.getInstance().handleFatalError(t);
        }
    }

    private void takeSnapshot() throws MediaException {
        try {
            this.snapshot = this.control.getSnapshot("encoding=png");
            if (this.snapshot == null) {
                throw new RuntimeException("snapshot is null");
            }
        }
        catch (Throwable t) {
            Log.log(TAG, "Failed to getSnapshot(\"encoding=png\"), trying getSnapshot(null)");
            this.snapshot = this.control.getSnapshot(null);
        }
    }

    private void createPlayer() throws IOException, MediaException {
        try {
            this.player = Manager.createPlayer((String)"capture://audio_video");
            this.initPlayer();
        }
        catch (Throwable t) {
            Log.log(TAG, "Failed to open capture://audio_video, trying capture://image");
            try {
                this.player = Manager.createPlayer((String)"capture://image");
                this.initPlayer();
            }
            catch (Throwable t1) {
                Log.log(TAG, "Failed to open capture://image, trying capture://video");
                this.player = Manager.createPlayer((String)"capture://video");
                this.initPlayer();
            }
        }
    }

    private void initPlayer() throws MediaException {
        this.player.realize();
        DeviceTraits traits = AppController.getInstance().getDeviceTraits();
        int canvasWidth = traits.getCanvasWidth();
        int canvasHeight = traits.getCanvasHeight();
        this.control = (VideoControl)this.player.getControl("VideoControl");
        int frameWidth = this.control.getSourceWidth();
        int frameHeight = this.control.getSourceHeight();
        float aspect = (float)frameWidth / (float)frameHeight;
        if (frameWidth - canvasWidth > 0) {
            frameWidth = canvasWidth;
            frameHeight = (int)((float)frameWidth / aspect);
        }
        if (canvasWidth < canvasHeight) {
            if (canvasWidth - frameWidth > 10) {
                frameWidth = canvasWidth - 10;
                frameHeight = Math.min((int)((float)frameWidth / aspect), canvasHeight - 30);
            }
        } else if (canvasHeight - frameHeight > 30) {
            frameHeight = canvasHeight - 30;
            frameWidth = Math.min((int)((float)frameHeight * aspect), canvasWidth - 10);
        }
        this.padding = (canvasHeight - frameHeight) / 2;
        this.control.initDisplayMode(1, (Object)this.canvas);
        this.control.setDisplaySize(frameWidth, frameHeight);
        this.control.setDisplayLocation((canvasWidth - frameWidth) / 2, 0);
        this.control.setVisible(true);
        this.player.start();
    }
}

