/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractCanvasState;
import com.foxmobile.ghostcamera.controller.state.components.TitleHeader;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.framework.device.DeviceTraits;
import com.foxmobile.ghostcamera.framework.graphics.AppFont;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.graphics.Label;
import com.foxmobile.ghostcamera.framework.graphics.Sprite;
import com.foxmobile.ghostcamera.framework.language.Language;
import com.foxmobile.ghostcamera.framework.resources.PreparedResources;
import com.foxmobile.ghostcamera.graphics.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class TitleState
extends AbstractCanvasState {
    private Image background;
    private Image invertedBackground;
    private TitleHeader titleHeader;
    private Sprite rightArrow;
    private float arrowVelocity = 14.0f;
    private float arrowDistance = 0.0f;
    private AppFont defaultFont;
    private Label languageLabel;

    public TitleState(Canvas canvas) {
        super(canvas);
    }

    protected void doBeforeLoop() {
        this.background = (Image)AppController.getInstance().getPreparedResources().getResource("titleBackground");
        if (!AppController.getInstance().getDeviceTraits().isSmallHeap()) {
            this.invertedBackground = Bitmaps.alphaBlend(128, -1, this.background);
        }
        this.titleHeader = new TitleHeader(this.canvas);
        this.rightArrow = new Sprite("arrow-right", true);
        this.rightArrow.setX(this.canvas.getWidth() - this.rightArrow.getWidth() - 3);
        this.rightArrow.setY(this.canvas.getHeight() - this.rightArrow.getHeight() - 6);
        this.defaultFont = (AppFont)AppController.getInstance().getPreparedResources().getResource("defaultFont");
        this.languageLabel = new Label("", this.defaultFont, this.canvas.getGraphics());
        this.updateLanguageLabel();
    }

    private void updateLanguageLabel() {
        this.languageLabel.updateText(AppController.getInstance().getActiveLanguage().getNativeName(), this.canvas.getGraphics());
        this.languageLabel.setX(5.0f);
        this.languageLabel.setY(this.canvas.getHeight() - this.languageLabel.getFont().getDescent() - 5);
    }

    public void doBeforeLeaving() {
        super.doBeforeLeaving();
        PreparedResources resources = AppController.getInstance().getPreparedResources();
        resources.releaseResource("titleBackground");
        resources.releaseResource("titleHeader");
    }

    protected void executeRedraw(Graphics graphics, Timing timing) {
        this.clearScreen(graphics);
        if (this.invertedBackground == null || !this.titleHeader.isLightingTime()) {
            graphics.drawImage(this.background, (this.canvas.getWidth() - this.background.getWidth()) / 2, 0, 0);
        } else {
            graphics.drawImage(this.invertedBackground, (this.canvas.getWidth() - this.invertedBackground.getWidth()) / 2, 0, 0);
        }
        this.titleHeader.blit(graphics);
        this.languageLabel.blit(graphics);
        this.rightArrow.blit(graphics);
    }

    protected void afterFlush(Timing timing) {
        float delta = timing.calculateDelta(this.arrowVelocity);
        this.arrowDistance += delta;
        if (this.arrowDistance <= -3.0f && this.arrowVelocity < 0.0f || this.arrowDistance >= 3.0f && this.arrowVelocity > 0.0f) {
            this.arrowVelocity = -this.arrowVelocity;
        }
        this.rightArrow.moveY(delta);
        this.titleHeader.updatePosition(timing);
    }

    public void handleActiveLanguageChanged(Language newActiveLanguage) {
        super.handleActiveLanguageChanged(newActiveLanguage);
        this.updateLanguageLabel();
    }

    public void handleKeyPressed(int keyCode) {
        super.handleKeyPressed(keyCode);
        DeviceTraits deviceTraits = AppController.getInstance().getDeviceTraits();
        if (deviceTraits.isLeftSoftKeyCode(keyCode) || keyCode == 42) {
            AppController.getInstance().cycleActiveLanguage();
        } else {
            AppController.getInstance().saveActiveLanguage();
            AppController.getInstance().handleGoToMenu();
        }
    }
}

