/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.model;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.framework.Log;
import com.foxmobile.ghostcamera.framework.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Settings {
    private static final String TAG;
    private int language = 0;
    private int transparency = 50;
    private int defaultGhost = 0;
    private int defaultPosition = 1;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.foxmobile.ghostcamera.model.Settings");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TAG = Log.tag(clazz);
    }

    public final int getLanguage() {
        return this.language;
    }

    public final void setLanguage(int language) {
        this.language = language;
    }

    public final int getTransparency() {
        return this.transparency;
    }

    public final int cycleTransparency() {
        this.transparency *= 2;
        if (this.transparency > 100) {
            this.transparency = 25;
        }
        return this.transparency;
    }

    public final int getDefaultGhost() {
        return this.defaultGhost;
    }

    public final int cycleDefaultGhost() {
        ++this.defaultGhost;
        if (this.defaultGhost >= 5) {
            this.defaultGhost = 0;
        }
        return this.defaultGhost;
    }

    public final int getDefaultPosition() {
        return this.defaultPosition;
    }

    public final String getDefaultPositionName() {
        switch (this.defaultPosition) {
            case 0: {
                return AppController.getInstance().getString("LEFTPOSITIONITEM");
            }
            case 2: {
                return AppController.getInstance().getString("RIGHTPOSITIONITEM");
            }
            case 1: {
                return AppController.getInstance().getString("CENTERPOSITIONITEM");
            }
        }
        Log.log(TAG, "Failed to find the position name for {0}", new Integer(this.defaultPosition));
        return AppController.getInstance().getString("LEFTPOSITIONITEM");
    }

    public final int cycleDefaultPosition() {
        this.defaultPosition = (this.defaultPosition + 1) % 3;
        return this.defaultPosition;
    }

    public final byte[] serialize() {
        byte[] byArray;
        ByteArrayOutputStream byteStream = null;
        DataOutputStream stream = null;
        try {
            byteStream = new ByteArrayOutputStream();
            stream = new DataOutputStream(byteStream);
            stream.writeByte(this.language);
            stream.writeByte(this.transparency);
            stream.writeByte(this.defaultGhost);
            stream.writeByte(this.defaultPosition);
            stream.flush();
            byArray = byteStream.toByteArray();
        }
        catch (IOException e) {
            try {
                AppController.getInstance().handleFatalError(e);
                throw new RuntimeException(e.getMessage());
            }
            catch (Throwable throwable) {
                Streams.close(stream);
                Streams.close(byteStream);
                throw throwable;
            }
        }
        Streams.close(stream);
        Streams.close(byteStream);
        return byArray;
    }

    public static Settings deserialize(byte[] bytes) {
        Settings result = new Settings();
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        DataInputStream stream = new DataInputStream(byteStream);
        try {
            try {
                result.language = stream.readByte();
                result.transparency = stream.readByte();
                result.defaultGhost = stream.readByte();
                result.defaultPosition = stream.readByte();
            }
            catch (IOException e) {
                Log.log(TAG, "Failed to read settings from the store: {0}", e);
                Streams.close(stream);
                Streams.close(byteStream);
            }
        }
        finally {
            Streams.close(stream);
            Streams.close(byteStream);
        }
        return result;
    }
}

