/*
 * Decompiled with CFR 0.152.
 */
package com.foxmobile.ghostcamera.controller.state;

import com.foxmobile.ghostcamera.controller.AppController;
import com.foxmobile.ghostcamera.controller.state.AbstractCanvasState;
import com.foxmobile.ghostcamera.framework.Timing;
import com.foxmobile.ghostcamera.framework.graphics.Bitmaps;
import com.foxmobile.ghostcamera.framework.resources.ResourceProvider;
import com.foxmobile.ghostcamera.graphics.Canvas;
import com.foxmobile.ghostcamera.graphics.LoopProcedure;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class LogoState
extends AbstractCanvasState
implements LoopProcedure {
    private int[] sourceLogoBytes;
    private int[] blendedLogoBytes;
    private int logoWidth;
    private int logoHeight;
    private boolean fadingIn = true;
    private boolean waiting = false;
    private long waitStartInstance;
    private float alpha = 0.0f;

    public LogoState(Canvas canvas) {
        super(canvas);
    }

    public void doBeforeLoop() {
        Image logoImage = ResourceProvider.getInstance().loadBitmap("fox-logo");
        this.logoWidth = logoImage.getWidth();
        this.logoHeight = logoImage.getHeight();
        this.sourceLogoBytes = new int[this.logoWidth * this.logoHeight];
        logoImage.getRGB(this.sourceLogoBytes, 0, this.logoWidth, 0, 0, this.logoWidth, this.logoHeight);
        this.blendedLogoBytes = new int[this.sourceLogoBytes.length];
    }

    public void doBeforeLeaving() {
        super.doBeforeLeaving();
    }

    private void animateLogo(Timing timing) {
        if (this.fadingIn) {
            Bitmaps.alphaBlend((int)this.alpha, 0xFFFFFF, this.sourceLogoBytes, this.blendedLogoBytes);
            this.alpha += timing.calculateDelta(127.5f);
            if (this.alpha >= 255.0f) {
                this.fadingIn = false;
                this.waiting = true;
            }
        } else if (this.waiting) {
            if (this.waitStartInstance == 0L) {
                this.waitStartInstance = System.currentTimeMillis();
            } else if (System.currentTimeMillis() - this.waitStartInstance >= 1000L) {
                this.waiting = false;
                this.handleAnimationFinished();
            }
        }
    }

    private void handleAnimationFinished() {
        AppController.getInstance().startPreparingResources();
    }

    public void executeRedraw(Graphics graphics, Timing timing) {
        this.animateLogo(timing);
        if (this.fadingIn) {
            this.clearScreen(graphics);
            int x = (this.canvas.getWidth() - this.logoWidth) / 2;
            int y = (this.canvas.getHeight() - this.logoHeight) / 2;
            graphics.drawRGB(this.blendedLogoBytes, 0, this.logoWidth, x, y, this.logoWidth, this.logoHeight, false);
        }
    }
}

