/*
 * Decompiled with CFR 0.152.
 */
package com.zenops.gts;

import com.zenops.gts.Base;
import com.zenops.gts.Effect;
import com.zenops.gts.Floor;
import com.zenops.gts.Game;
import com.zenops.gts.Moveable;
import com.zenops.gts.Placeable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

class Character
extends Moveable {
    private static byte[] HAND_OFFSET_X = new byte[]{16, 15, 27, 27};
    private static byte[] HAND_OFFSET_Y = new byte[]{40, 36, 40, 40};
    private static final int[] WALK_CONST = new int[]{0x101D00, 0x101D00, 1152000, 1152000};
    static final int[] SPEED = new int[]{14336, 17152, 10496, 14336, 17152, 10496, 10496, 10496, 10496, 10496, 10496, 10496, 10496, 10496, 10496, 10496, 10496};
    static final int FLYING_SPEED = 38400;
    static int COLLISION_RADIUS = 8;
    static byte[] STARTING_HEALTH = new byte[]{Game.FULL_HEALTH, Game.FULL_HEALTH, 3, 4, 5, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    static byte[] POWER = new byte[]{1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int PHONE_TIME = 2000;
    static boolean processCollisions = true;
    static boolean processPhysics = true;
    static boolean AICanShoot = true;
    static boolean enableCrossBowDrawing = true;
    static final byte TYPE_MAX = 0;
    static final byte TYPE_AGENT99 = 1;
    static final byte TYPE_WEAK_ENEMY = 2;
    static final byte TYPE_MEDIUM_ENEMY = 3;
    static final byte TYPE_STRONG_ENEMY = 4;
    static final byte TYPE_GUARD = 5;
    static final byte TYPE_KRSTIC = 6;
    static final byte TYPE_DALIP = 7;
    static final byte TYPE_SIEGFRIED = 8;
    static final byte TYPE_AGENT23 = 9;
    static final byte TYPE_AGENT91 = 10;
    static final byte TYPE_LARABEE = 11;
    static final byte TYPE_CHIEF = 12;
    static final byte TYPE_GOVERNOR = 13;
    static final byte TYPE_BRUCE = 14;
    static final byte TYPE_LLOYD = 15;
    static final byte TYPE_RAT = 16;
    static final byte AI_NONE = 0;
    static final byte AI_GUARD = 1;
    static final byte AI_REACTIVE = 2;
    static final byte AI_INVICIBLE = 3;
    static final byte[] AI_TYPE = new byte[]{0, 0, 2, 2, 2, 1, 1, 1, 1, 3, 3, 3, 3, 3, 3, 3, 3};
    static final byte SPRITE_MAX = 0;
    static final byte SPRITE_AGENT99 = 1;
    static final byte SPRITE_GRUNT = 2;
    static final byte SPRITE_AGENT23 = 3;
    static final byte SPRITE_BRUCE = 4;
    static final byte SPRITE_CHIEF = 5;
    static final byte SPRITE_GOVERNOR = 6;
    static final byte SPRITE_LARABEE = 7;
    static final byte SPRITE_LLOYD = 8;
    static final byte SPRITE_SIEGFRIED = 9;
    static final byte SPRITE_KRSTIC = 10;
    static final byte SPRITE_GUARD = 11;
    static final byte SPRITE_AGENT91 = 12;
    static final byte SPRITE_DALIP = 13;
    static final byte SPRITE_RAT = 14;
    static final byte SPRITE_NB = 15;
    static final byte SHAPE_MAX = 0;
    static final byte SHAPE_AGENT99 = 1;
    static final byte SHAPE_GRUNT = 2;
    static final byte SHAPE_RAT = 3;
    static final byte[] SPRITESET_TO_SHAPE = new byte[]{0, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3};
    static final byte[] TYPE_TO_SPRITESET = new byte[]{0, 1, 2, 2, 2, 11, 10, 13, 9, 3, 12, 7, 5, 6, 4, 8, 14};
    private static byte[] ANIM_SHIFT = new byte[]{0, 17, 26, 49};
    static final byte ANIM_STAND = 0;
    static final byte ANIM_WALK = 1;
    static final byte ANIM_SHOOT = 2;
    static final byte ANIM_PUNCH = 3;
    static final byte ANIM_HIT = 4;
    static final byte ANIM_OPEN_DOOR = 5;
    static final byte ANIM_DEATH = 6;
    static final byte ANIM_SURPRISED = 8;
    static final byte ANIM_MOON_WALK = 9;
    static final byte ANIM_STEALTH = 6;
    static final byte ANIM_HRD = 7;
    static final byte ANIM_007 = 10;
    static final byte ANIM_PHONE = 11;
    static final byte ANIM_HACK = 12;
    static final byte ANIM_007_END = 13;
    static final byte ANIM_FIRE = 14;
    static final byte ANIM_FLY = 15;
    static final byte ANIM_PHONE_NO_KEY = 16;
    static final byte ANIM_KISS = 7;
    static final byte ANIM_IDLE = 8;
    static final byte ANIM_STUNNED = 5;
    static final byte ANIM_SPLASH = 7;
    static final byte ANIM_DECEPTION = 10;
    static final byte ANIM_LAUGH = 11;
    static final byte ANIM_SHOT = 12;
    static final byte ANIM_CRY = 6;
    static final byte ANIM_INSULT = 7;
    static int[][][] ANIM_OFFSET;
    boolean isAlarmSpawn = false;
    byte health;
    private static final byte[][] ANIM_SEQUENCE;
    private static final int[][] ANIM_TIME;
    private static final boolean[] ANIM_LOOP;
    static final byte[] ANIM_ACTION;
    byte againstObstacle;
    boolean isAgainstBorder;
    private int startChangingPlanePosX;
    byte punctuationPoint = (byte)-1;

    Character(byte type, Floor floor, int tile, int plane) {
        this.init((byte)5, type, floor, tile, plane);
        this.construct();
    }

    Character(Character character) {
        super(character);
        this.construct();
        this.initWayPointValue(0, true, true);
    }

    private void construct() {
        this.posX = this.tile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
        this.posY = Floor.getCharacterPosY(this.plane) << 8;
        this.health = STARTING_HEALTH[this.type];
    }

    int getHandOffsetX() {
        return HAND_OFFSET_X[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]];
    }

    int getHandOffsetY() {
        return HAND_OFFSET_Y[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]];
    }

    private int changePosition(int timeDelta, int speed) {
        int oldPosX = this.posX;
        int move = this.movingDir * (speed * timeDelta >> 10);
        int collisionTile = -1;
        for (int i = this.floor.getTileX((this.posX >> 8) + this.movingDir * COLLISION_RADIUS); i != this.floor.getTileX((this.posX + move >> 8) + this.movingDir * COLLISION_RADIUS) + this.movingDir; i += this.movingDir) {
            if (this.floor.checkPassThrough(i, this.plane, false)) continue;
            collisionTile = i;
            break;
        }
        if (this.posX + move <= COLLISION_RADIUS << 8 || this.posX + move >= this.floor.length * Floor.TILE_SIZE - COLLISION_RADIUS << 8) {
            this.isAgainstBorder = true;
            this.posX = Math.max(COLLISION_RADIUS << 8, Math.min(this.floor.length * Floor.TILE_SIZE - COLLISION_RADIUS << 8, this.posX + move));
        } else {
            this.posX += move;
        }
        if (collisionTile != -1) {
            byte collisionDir = Game.sign(collisionTile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) - (oldPosX >> 8), true);
            int diff = this.posX - (this.posX >> 8 << 8);
            this.posX = collisionTile * Floor.TILE_SIZE - collisionDir * COLLISION_RADIUS + this.floor.getTilePosMaxX(collisionTile, this.plane, collisionDir, (this.posX >> 8) + collisionDir * COLLISION_RADIUS, this.posY >> 8, this, false) << 8;
            this.posX += diff;
        } else {
            this.againstObstacle = 0;
        }
        return collisionTile;
    }

    void simulate(int timeDelta) {
        int debug = 0;
        try {
            debug = 1;
            int collisionTile = -1;
            this.isAgainstBorder = false;
            if (AI_TYPE[this.type] != 0) {
                if (this.checkForWait() == 7 && this.type != 7) {
                    if (this.animType != 5) {
                        Game.increaseInsult(1);
                    }
                    this.setAnim((byte)5, false, true);
                }
                if (processAI) {
                    this.processAI(timeDelta);
                    if (this.getAIStep() == 3) {
                        Game.onAlert |= true;
                    }
                }
            }
            debug = 2;
            if (this.isChangingPlane && ANIM_ACTION[this.getAnimIndex()] != 0) {
                debug = 21;
                int nextPlanePos = Floor.getCharacterPosY(this.nextPlaneIndex) << 8;
                debug = 22;
                int deltaY = Game.sign(nextPlanePos - this.posY, false) * Math.min(Math.abs(nextPlanePos - this.posY), Math.abs(SPEED[this.type] * timeDelta >> 10));
                debug = 3;
                this.posY += deltaY;
                debug = 4;
                if (processCollisions) {
                    collisionTile = this.positionAgainstObstacle(collisionTile, COLLISION_RADIUS);
                    collisionTile = this.positionAgainstObstacle(collisionTile, -COLLISION_RADIUS);
                }
                debug = 5;
                if (this.nextPlaneIndex == 3) {
                    int finalPosX = Game.activeLift.tile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
                    int deltaX = Game.sign(finalPosX - this.posX, false) * Math.min(Math.abs(finalPosX - this.posX), Math.max(1, Math.abs(SPEED[this.type] * timeDelta >> 10)));
                    this.posX += deltaX;
                }
                debug = 6;
                if (this.posY >> 8 == nextPlanePos >> 8) {
                    this.posY = nextPlanePos;
                    this.isChangingPlane = false;
                    if (this.againstObstacle != 0) {
                        if (this.type == 0) {
                            if (this.againstObstacle == 1) {
                                System.out.println("LOOKING SLIDE DIR");
                                byte sign = Game.sign(this.startChangingPlanePosX - this.posX, false);
                                System.out.println(this.startChangingPlanePosX + " " + this.posX + " " + sign);
                                if (sign != 0) {
                                    this.lookingDir = sign;
                                    System.out.println("LOOKING DIR : " + this.lookingDir);
                                }
                                System.out.println("looking dir : " + this.lookingDir);
                            }
                            if (this.isMoving && this.movingDir != this.lookingDir) {
                                this.lookingDir = this.movingDir;
                                this.againstObstacle = 0;
                            }
                        } else {
                            this.againstObstacle = 0;
                        }
                    }
                    this.planeDir = 0;
                } else {
                    this.againstObstacle = 0;
                }
                debug = 7;
                this.plane = (byte)this.floor.getTileY(this.posY >> 8);
                debug = 8;
            } else if (this.isMoving) {
                collisionTile = this.changePosition(timeDelta, SPEED[this.type]);
            } else if (this.isFlying && this.type == 0) {
                collisionTile = this.changePosition(timeDelta, 38400);
                if (this.againstObstacle != 0) {
                    Game.crossBowState = 0;
                    this.resumeAnim();
                }
            }
            this.tile = (byte)this.floor.getTileX(this.posX >> 8);
            debug = 14;
            if (this.againstObstacle == 1 && this.type == 0 && !Game.oldAlert && ANIM_ACTION[this.getAnimIndex()] != 0) {
                this.animate((byte)6, timeDelta, false);
            } else if ((this.isFlying || this.isMoving || this.isChangingPlane && ANIM_ACTION[this.getAnimIndex()] != 0) && !this.isAgainstBorder && this.againstObstacle == 0) {
                if (this.isFlying) {
                    this.animate((byte)15, timeDelta, false);
                } else if (this.movingDir != -this.lookingDir) {
                    this.animate((byte)1, timeDelta, false);
                } else {
                    this.animate((byte)9, timeDelta, false);
                }
            } else if (ANIM_ACTION[this.getAnimIndex()] == 2 && ANIM_TIME[this.getAnimIndex()][this.animFrame] != -1) {
                this.animate((byte)0, timeDelta, false);
            } else {
                this.animate(this.animType, timeDelta, false);
            }
            debug = 15;
            this.computeDisplayPriority();
            debug = 16;
            this.isFlying = false;
            this.isMoving = false;
            this.movingDir = 0;
        }
        catch (Exception e) {
            System.out.println("DEBUG : " + debug + " " + this.nextPlaneIndex);
            e.printStackTrace();
        }
    }

    void draw(Graphics g, int x, int y) {
        if (ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame] == -1) {
            return;
        }
        Image img = Game.imgCharacter[TYPE_TO_SPRITESET[this.type]][ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame]];
        g.drawImage(Game.imgObject[0], Floor.getScreenX(x, this.posX >> 8), Floor.getScreenY(y, this.posY >> 8), 3);
        if (this.lookingDir > 0) {
            g.drawImage(img, Floor.getScreenX(x, this.posX >> 8) + this.getAnimOffsetX(false), Floor.getScreenY(y, this.posY >> 8) + this.getAnimOffsetY(false), 33);
        } else {
            Base.zenDrawImageNokia(g, img, 2, Floor.getScreenX(x, this.posX >> 8) - this.getAnimOffsetX(true), Floor.getScreenY(y, this.posY >> 8) + this.getAnimOffsetY(false), 33);
        }
        if (this.type == 0) {
            Game.drawCrossBow(g, x, y);
            Game.drawFlameThrower(g, x, y);
        }
        img = null;
        if (processAI && AI_TYPE[this.type] == 2 && this.animType != 7 && this.animType != 5) {
            switch (this.getAIStep()) {
                case 2: 
                case 5: 
                case 6: {
                    img = Game.imgAI[1];
                    break;
                }
                case 3: {
                    img = Game.imgAI[0];
                }
            }
        }
        if (this.punctuationPoint >= 0) {
            img = Game.imgAI[this.punctuationPoint];
        }
        if (img != null) {
            g.drawImage(img, Floor.getScreenX(x, this.posX >> 8), Floor.getScreenY(y, this.posY >> 8) - (Floor.TILE_SIZE << 1), 33);
        }
    }

    void move(int sens, boolean updateLook) {
        if (ANIM_ACTION[this.getAnimIndex()] == 0) {
            return;
        }
        if (this.isFlying) {
            return;
        }
        this.isMoving = true;
        if (this.isChangingPlane) {
            return;
        }
        this.movingDir = Game.sign(sens, true);
        if (updateLook) {
            this.lookingDir = this.movingDir;
        }
    }

    boolean changePlane(int sens, boolean checkCollisions) {
        System.out.println("changePlane " + sens + " / " + this.plane);
        if (ANIM_ACTION[this.getAnimIndex()] == 0) {
            return false;
        }
        if (this.isFlying) {
            return false;
        }
        if (AI_TYPE[this.type] == 0) {
            for (int i = 0; i < Game.displayBuffer[0].size(); ++i) {
                Placeable placeable = Game.get(Game.displayBuffer[0], i);
                if (placeable.tile != this.tile || placeable.plane != this.plane + sens || this.plane != Floor.FIRST_ACTION_PLANE && this.plane != Floor.SECOND_ACTION_PLANE) continue;
                switch (placeable.category << 8 | placeable.type) {
                    case 1027: 
                    case 1028: 
                    case 1029: {
                        return false;
                    }
                }
            }
        }
        if (!(this.isChangingPlane || checkCollisions && !this.floor.checkChangingPlanePath(this.tile, sens))) {
            this.startChangingPlanePosX = this.posX;
            this.nextPlaneIndex = this.plane + sens;
            this.isChangingPlane = true;
            this.planeDir = (byte)sens;
            return true;
        }
        return false;
    }

    boolean attack() {
        Character moveable;
        int enemy;
        if (this.type == 0 && this.animType == 6) {
            return false;
        }
        if (this.isFlying) {
            return false;
        }
        int n = enemy = AI_TYPE[this.type] != 0 ? (int)Game.player.type : -1;
        if ((this.type != 0 || Game.currentWeapon != 2 || Game.petrol <= 0) && (moveable = Game.getCharacter(Game.currentMoveableList, enemy, -1, this.tile, this.plane, this.lookingDir < 0 ? 1 : 0, this.lookingDir >= 0 ? 1 : 0, this)) != null) {
            return this.kick(moveable);
        }
        if (this.type != 0) {
            return this.shoot();
        }
        switch (Game.currentWeapon) {
            case 0: {
                return this.shoot();
            }
            case 1: {
                if (ANIM_ACTION[this.getAnimIndex()] == 0 || this.isMoving || this.isChangingPlane) {
                    return false;
                }
                Game.crossBowMissed = Game.getNextInt(10) == 0;
                Game.crossBowState = 1;
                Game.crossBowCurrentX = this.posX + this.lookingDir * (this.getHandOffsetX() << 8);
                this.setAnim((byte)14, true, true);
                break;
            }
            case 2: {
                if (ANIM_ACTION[this.getAnimIndex()] == 0 || this.isMoving || this.isChangingPlane) {
                    return false;
                }
                if (Game.petrol <= 0) {
                    return false;
                }
                this.setAnim((byte)14, true, true);
                Game.flameThrowerTimer = 0;
                Game.currentEffectList.addElement(new Effect(this.lookingDir > 0 ? (byte)10 : 11, this.floor, this.tile, this.plane, (this.posX >> 8) + this.lookingDir * this.getHandOffsetX(), (this.posY >> 8) - this.getHandOffsetY()));
                Game.petrol = (byte)(Game.petrol - 1);
                Game.repaintHudDown = true;
                for (int i = 0; i < Game.displayBuffer[0].size(); ++i) {
                    boolean spawnFlames = false;
                    Placeable placeable = Game.get(Game.displayBuffer[0], i);
                    if (placeable.plane != this.plane || placeable.tile != this.tile && placeable.tile != this.tile + this.lookingDir && placeable.tile != this.tile + (this.lookingDir << 1)) continue;
                    switch (placeable.category) {
                        case 1: {
                            Game.destroyBreakable(placeable);
                            spawnFlames = true;
                            break;
                        }
                        case 5: {
                            if (AI_TYPE[placeable.type] == 0 || ((Character)placeable).health <= 0) break;
                            ((Character)placeable).isBeingHit(0, false, 2, this, 100);
                            spawnFlames = true;
                        }
                    }
                    if (!spawnFlames) continue;
                    for (int j = 0; j < 2; ++j) {
                        Game.currentEffectList.addElement(new Effect(8, placeable.floor, placeable.tile, placeable.plane, (placeable.posX >> 8) + Game.getNextInt(Floor.TILE_SIZE) - (Floor.TILE_SIZE >> 1), (placeable.posY >> 8) - Game.getNextInt(Floor.TILE_SIZE)));
                    }
                    Game.currentEffectList.addElement(new Effect(7, placeable.floor, placeable.tile, placeable.plane, placeable.posX >> 8, (placeable.posY >> 8) - (Floor.TILE_SIZE >> 1)));
                }
                break;
            }
        }
        return false;
    }

    private boolean kick(Character character) {
        if (ANIM_ACTION[this.getAnimIndex()] == 0 || this.isMoving || this.isChangingPlane) {
            return false;
        }
        if (this.animType == 3 && ANIM_TIME[this.getAnimIndex()][this.animFrame] != -1) {
            return false;
        }
        if (character.health > 0) {
            this.animate((byte)3, 0, true);
            if (AI_TYPE[this.type] != 0) {
                character.isBeingHit(Game.sign(this.tile - character.tile, true), true, 0, this, POWER[this.type]);
                int shotX = character.posX >> 8;
                int shotY = Floor.getCharacterPosY(this.plane) - this.getHandOffsetY();
                Game.currentEffectList.addElement(new Effect(3, character.floor, character.tile, character.plane, shotX += Game.getNextInt(10) - 5, shotY += Game.getNextInt(10) - 5));
            } else {
                Game.currentPlaceable = character;
            }
            return true;
        }
        return false;
    }

    private boolean shoot() {
        int collisionTile;
        if (ANIM_ACTION[this.getAnimIndex()] == 0 || this.isMoving || this.isChangingPlane) {
            return false;
        }
        if (this.animType == 2 && ANIM_TIME[this.getAnimIndex()][this.animFrame] != -1) {
            return false;
        }
        if (AI_TYPE[this.type] == 0 && Game.ammo <= 0) {
            return false;
        }
        Game.noiseTile = this.tile;
        if (AI_TYPE[this.type] == 0) {
            Game.ammo = (byte)(Game.ammo - 1);
            Game.repaintHudDown = true;
        }
        this.animate((byte)2, 0, true);
        int[] shot = new int[2];
        int impactType = -1;
        if (this.lookingDir > 0) {
            shot[0] = this.floor.length * Floor.TILE_SIZE;
            for (collisionTile = this.tile + 1; collisionTile <= Math.min(this.tile + 5, this.floor.length - 1) && (impactType = (int)this.determineImpact(collisionTile, this.lookingDir, shot)) == -1; ++collisionTile) {
            }
        } else {
            shot[0] = 0;
            for (collisionTile = this.tile - 1; collisionTile >= Math.max(this.tile - 5, 0) && (impactType = (int)this.determineImpact(collisionTile, this.lookingDir, shot)) == -1; --collisionTile) {
            }
        }
        if (impactType == -1) {
            return true;
        }
        shot[1] = Floor.getCharacterPosY(this.plane) - this.getHandOffsetY();
        shot[0] = shot[0] + (Game.getNextInt(10) - 5);
        shot[1] = shot[1] + (Game.getNextInt(10) - 5);
        if (impactType == 2) {
            Game.currentEffectList.addElement(new Effect(3, this.floor, collisionTile, this.plane, shot[0], shot[1]));
        } else {
            if (this.lookingDir > 0 && impactType == 1) {
                Game.currentEffectList.addElement(new Effect(2, this.floor, collisionTile, this.plane, shot[0], shot[1]));
            }
            Game.currentEffectList.addElement(new Effect(0, this.floor, collisionTile, this.plane, shot[0], shot[1]));
        }
        return true;
    }

    void isBeingHit(int sens, boolean launchInsult, int increaseInsult, Moveable attacker, int power) {
        if (Game.checkForSpecialScripts(this)) {
            return;
        }
        if (this.type == 0) {
            if (launchInsult && Game.currentLevel >= 3 && Game.insult >= Game.FULL_INSULT) {
                Game.currentPlaceable = attacker;
                Game.phaseNext = (byte)8;
            }
            if (Game.crossBowState != 0) {
                Game.crossBowState = 0;
            }
            Game.flameThrowerTimer = -1;
        }
        if (AI_TYPE[this.type] == 0) {
            Game.playVibra(200);
            Game.repaintHudUp = true;
        }
        if (AI_TYPE[this.type] == 2 && (this.animType == 5 || this.animType == 7)) {
            this.health = 0;
        } else if (AI_TYPE[this.type] == 2 && this.getAIStep() != 3 && this.getAIStep() != 6 && this.animType != 7) {
            if (increaseInsult > 0) {
                Game.increaseInsult(increaseInsult);
            }
            this.health = 0;
        } else {
            this.health = (byte)(this.health - power);
        }
        if (this.health > 0) {
            this.setAnim((byte)4, true, true);
            this.nextAIStep = (byte)(sens << 4 & 0xF0 | 2);
        } else {
            this.health = 0;
            if (AI_TYPE[this.type] == 0) {
                if (this.type == 0) {
                    this.setAnim((byte)11, true, true);
                } else if (this.type == 1) {
                    this.setAnim((byte)6, true, true);
                }
                Game.phaseNext = (byte)13;
            } else {
                this.setAnim((byte)6, true, true);
                this.value = 0;
            }
        }
    }

    private byte determineImpact(int impactTile, int dir, int[] shot) {
        int impact = -1;
        if (!this.floor.checkPassThrough(impactTile, this.plane, true)) {
            shot[0] = impactTile * Floor.TILE_SIZE + this.floor.getTilePosMaxX(impactTile, this.plane, this.lookingDir, (impactTile + 1) * Floor.TILE_SIZE, Floor.getCharacterPosY(this.plane), null, false);
            impact = 1;
        }
        for (int i = 0; i < Game.currentMoveableList.size(); ++i) {
            Moveable moveable = (Moveable)Game.get(Game.currentMoveableList, i);
            if (moveable.category != 5 || moveable.plane != this.plane || moveable.tile != impactTile || ((Character)moveable).health <= 0 || impact == 1 && Game.sign(Floor.getXPosInTile(impactTile, moveable.posX >> 8) - (Floor.TILE_SIZE >> 1), false) == dir) continue;
            shot[0] = moveable.posX >> 8;
            ((Character)moveable).isBeingHit(dir, true, 3, this, POWER[this.type]);
            return 2;
        }
        if (impact != -1) {
            return 1;
        }
        return (byte)(impactTile == 0 || impactTile == this.floor.length - 1 ? 0 : -1);
    }

    private int positionAgainstObstacle(int tile, int delta) {
        int oldTile;
        do {
            oldTile = tile;
            tile = this.floor.getTileX((this.posX >> 8) + delta);
            this.posX = tile * Floor.TILE_SIZE - delta + this.floor.getTilePosMaxX(tile, this.plane, this.floor.getSlideDir(tile, this.plane, this.planeDir, this.posX >> 8), (this.posX >> 8) + delta, this.posY >> 8, this, true) << 8;
        } while (tile != oldTile);
        return tile;
    }

    void goBackToWayPoint() {
        this.initAIValue(4);
        this.nextAIStep = (byte)4;
        this.lookingDir = Game.sign((Game.getBits(this.value, 15, 8) * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8) - this.posX, true);
        this.processAI(0);
    }

    private boolean checkIsInSight(int tile, int plane) {
        int delta = Game.player.tile - tile;
        if (Math.abs(delta) > AISight) {
            return false;
        }
        if (delta != 0 && Game.sign(delta, true) != this.lookingDir) {
            return false;
        }
        if (tile == Game.player.tile && plane != Game.player.plane && !this.floor.checkChangingPlanePath(tile, Game.sign(Game.player.plane - plane, false))) {
            return false;
        }
        for (int i = tile; i != Game.player.tile; i += Game.sign(delta, true)) {
            if (!this.floor.checkPassThrough(i, plane, true)) {
                return false;
            }
            if (Game.player.plane == plane || this.floor.checkPassThrough(i, Game.player.plane, true)) continue;
            return false;
        }
        return Game.player.type != 0 || Game.player.animType != 6 || Game.player.lookingDir == this.lookingDir;
    }

    private void checkForAIOpeningDoors() {
        Placeable obj;
        if (this.againstObstacle == 3 && (obj = Game.get(this.floor.objectList, 0, -1, this.tile + (this.lookingDir == -1 ? -2 : 0), this.plane)) != null && obj.animFrame == 0 && (obj.type == 4 || obj.type == 5 && obj.value >> 16 == -1)) {
            Game.openCurrentDoor(obj, this);
        }
    }

    private void processAI(int timeDelta) {
        if (this.wayPoints == null) {
            return;
        }
        if (AI_TYPE[this.type] == 2) {
            if (this.animType == 5) {
                this.initAIValue(5);
                this.nextAIStep = (byte)5;
            } else if (this.checkIsInSight(this.tile, this.plane)) {
                switch (this.getAIStep()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        this.nextAIStep = (byte)3;
                        break;
                    }
                    default: {
                        this.nextAIStep = (byte)6;
                        break;
                    }
                }
            } else if (Game.noiseTile != -1 && Math.abs(Game.noiseTile - this.tile) <= 6) {
                switch (this.getAIStep()) {
                    case 2: 
                    case 3: 
                    case 5: {
                        this.nextAIStep = (byte)(Game.sign(Game.noiseTile - this.tile, true) << 4 & 0xF0 | 2);
                        break;
                    }
                    default: {
                        this.nextAIStep = (byte)6;
                    }
                }
            }
        }
        if (ANIM_ACTION[this.getAnimIndex()] == 0) {
            return;
        }
        int currentWayPoint = Game.getBits(this.value, 23, 6);
        int nextTile = Game.getBits(this.value, 15, 8);
        int nextPlane = Game.getBits(this.value, 29, 1);
        if (this.getAIStep() == 2 && (this.nextAIStep & 0xF) == 2 && this.lookingDir != this.nextAIStep >> 4) {
            this.lookingDir = (byte)(this.nextAIStep >> 4);
        }
        if ((this.nextAIStep & 0xF) != this.getAIStep()) {
            switch (this.nextAIStep & 0xF) {
                case 2: 
                case 3: 
                case 6: {
                    this.initAIValue(this.nextAIStep);
                    if ((this.nextAIStep & 0xF) == 2) {
                        this.lookingDir = (byte)(this.nextAIStep >> 4);
                    } else if ((this.nextAIStep & 0xF) == 6) {
                        this.setAnim((byte)8, true, true);
                    }
                    this.nextAIStep = (byte)-1;
                }
            }
        }
        switch (this.getAIStep()) {
            case 0: {
                boolean changeStep = false;
                if ((this.wayPoints[currentWayPoint] & 0x80) != 0) {
                    changeStep = !this.isChangingPlane;
                } else {
                    int delta = Floor.getXPosInTile(nextTile, this.posX >> 8) - (Floor.TILE_SIZE >> 1);
                    if (delta != 0 && Game.sign(delta, true) != this.lookingDir) {
                        this.move(this.lookingDir, false);
                    } else {
                        changeStep = true;
                        this.posX = nextTile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
                    }
                }
                if (changeStep) {
                    this.initAIValue(1);
                    this.processAI(0);
                    break;
                }
                this.checkForAIOpeningDoors();
                break;
            }
            case 1: {
                if (!this.incrementTime(timeDelta, WAYPOINT_WAIT_TIMES[Game.getBits(this.wayPoints[currentWayPoint], 4, 2)])) break;
                ++currentWayPoint;
                this.initWayPointValue(currentWayPoint %= this.wayPoints.length, true, false);
                if (this.wayPoints.length <= 1) break;
                this.processAI(0);
                break;
            }
            case 2: {
                this.checkForAIOpeningDoors();
                if (this.againstObstacle != 0) {
                    if (!this.changePlane((1 - (this.plane - Floor.SECOND_ACTION_PLANE) << 1) - 1, true) && !this.isChangingPlane) {
                        this.move(this.lookingDir, false);
                    }
                } else {
                    this.move(this.lookingDir, false);
                }
                if (!this.incrementTime(timeDelta, 4000)) break;
                this.initAIValue(5);
                this.processAI(0);
                break;
            }
            case 3: {
                this.lookingDir = Game.sign(Game.player.posX - this.posX, true);
                if (this.checkIsInSight(this.tile, this.plane)) {
                    this.checkForAIOpeningDoors();
                    if (AICanShoot) {
                        if (Game.player.plane == this.plane) {
                            this.attack();
                            break;
                        }
                        if (Game.player.plane != this.plane && this.checkIsInSight(this.tile, Game.player.plane)) {
                            if (this.changePlane(Game.player.plane - this.plane, true) || this.isChangingPlane) break;
                            this.move(this.lookingDir, true);
                            break;
                        }
                        this.move(this.lookingDir, true);
                        break;
                    }
                    if (Game.player.plane == this.plane && Math.abs(Game.player.tile - this.tile) <= 1) {
                        this.attack();
                        break;
                    }
                    if (this.tile == Game.player.tile) {
                        this.changePlane(Game.player.plane - this.plane, true);
                        break;
                    }
                    if (this.againstObstacle == 0) {
                        this.move(this.lookingDir, true);
                        break;
                    }
                    if (this.isChangingPlane) break;
                    this.changePlane((1 - (this.plane - Floor.SECOND_ACTION_PLANE) << 1) - 1, true);
                    break;
                }
                this.nextAIStep = (byte)(this.lookingDir << 4 & 0xF0 | 2);
                this.processAI(0);
                break;
            }
            case 4: {
                int delta = Floor.getXPosInTile(nextTile, this.posX >> 8) - (Floor.TILE_SIZE >> 1);
                this.checkForAIOpeningDoors();
                System.out.println(nextTile + " " + nextPlane + " " + delta);
                if (this.againstObstacle != 0) {
                    this.changePlane((1 - (this.plane - Floor.SECOND_ACTION_PLANE) << 1) - 1, true);
                    break;
                }
                if (delta != 0 && Game.sign(delta, true) != this.lookingDir) {
                    this.move(this.lookingDir, false);
                    break;
                }
                if (this.plane != nextPlane + Floor.SECOND_ACTION_PLANE) {
                    this.changePlane((1 - (this.plane - Floor.SECOND_ACTION_PLANE) << 1) - 1, true);
                    break;
                }
                if (this.isChangingPlane) break;
                this.posX = nextTile * Floor.TILE_SIZE + (Floor.TILE_SIZE >> 1) << 8;
                this.initWayPointValue(currentWayPoint, false, false);
                this.processAI(0);
                break;
            }
            case 5: {
                if (!this.incrementTime(timeDelta, 2000)) break;
                this.goBackToWayPoint();
                break;
            }
            case 6: {
                this.lookingDir = Game.sign(Game.player.posX - this.posX, true);
                if (!this.incrementTime(timeDelta, 500)) break;
                this.initAIValue(3);
                this.resumeAnim();
                this.processAI(0);
            }
        }
    }

    int getAnimIndex() {
        return this.animType + ANIM_SHIFT[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]];
    }

    static void readAnimOffsets(byte[] offsets, int type) {
        int nb = ((offsets[0] & 0xFF) << 8) + (offsets[1] & 0xFF);
        Character.ANIM_OFFSET[type] = new int[nb][2];
        int pos = 2;
        for (int i = 0; i < nb; ++i) {
            int j = 0;
            while (j < 2) {
                if ((offsets[pos] & 0x80) != 0) {
                    Character.ANIM_OFFSET[type][i][j] = -65536;
                }
                int[] nArray = ANIM_OFFSET[type][i];
                int n = j++;
                nArray[n] = nArray[n] + ((offsets[pos] & 0xFF00) + (offsets[pos + 1] & 0xFF));
                pos += 2;
            }
        }
    }

    private int getAnimOffsetX(boolean approx) {
        return ANIM_OFFSET[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]][ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame]][0] + (approx && (Game.imgCharacter[TYPE_TO_SPRITESET[this.type]][ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame]].getWidth() & 1) != 0 ? 1 : 0);
    }

    private int getAnimOffsetY(boolean approx) {
        return ANIM_OFFSET[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]][ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame]][1] + (approx && (Game.imgCharacter[TYPE_TO_SPRITESET[this.type]][ANIM_SEQUENCE[this.getAnimIndex()][this.animFrame]].getHeight() & 1) != 0 ? 1 : 0);
    }

    byte checkForWait() {
        if (ANIM_TIME[this.getAnimIndex()][this.animFrame] == -1) {
            return this.animType;
        }
        return -1;
    }

    void resumeAnim() {
        if (ANIM_TIME[this.getAnimIndex()][this.animFrame] != -1) {
            return;
        }
        this.goToNextFrame();
    }

    void setAnim(byte anim, boolean init, boolean override) {
        if (ANIM_ACTION[this.getAnimIndex()] == 0 && !override) {
            return;
        }
        if (AI_TYPE[this.type] != 0 && anim != 6 && this.health <= 0) {
            return;
        }
        this.animate(anim, 0, init);
    }

    private void animate(byte animType, int timeDelta, boolean init) {
        this.animTimer += timeDelta;
        if (this.animType != animType || init) {
            this.animType = animType;
            this.animFrame = 0;
            this.animTimer = 0;
        }
        if (animType == 1 || animType == 9) {
            Character.ANIM_TIME[this.getAnimIndex()][this.animFrame] = WALK_CONST[SPRITESET_TO_SHAPE[TYPE_TO_SPRITESET[this.type]]] / SPEED[this.type];
        }
        if (this.animTimer >= ANIM_TIME[this.getAnimIndex()][this.animFrame] && ANIM_TIME[this.getAnimIndex()][this.animFrame] != -1) {
            this.goToNextFrame();
        }
    }

    private void goToNextFrame() {
        this.animFrame = (byte)(this.animFrame + 1);
        if (this.animFrame == ANIM_SEQUENCE[this.getAnimIndex()].length) {
            this.animFrame = 0;
            if (!ANIM_LOOP[this.getAnimIndex()]) {
                this.animate((byte)0, 0, false);
            }
        }
        this.animTimer = 0;
        if (AI_TYPE[this.type] == 0 && this.animType == 0 && this.animFrame == 0) {
            Character.ANIM_TIME[this.getAnimIndex()][0] = Game.getNextInt(1500) + 500;
        }
    }

    static {
        ANIM_SEQUENCE = new byte[][]{{0, 1, 2, 1}, {3, 4, 5, 6, 7, 8, 9, 10}, {11, 12, 13, 14, 11}, {15, 16, 17, 17, 18, 15}, {19, 20, 21}, {27, 27, 27}, {22, 23, 24, 25, 26}, {31, 32, 33, 34, 35, 34, 33, 32, 31, 31}, {20, 20}, {10, 9, 8, 7, 6, 5, 4, 3}, {36, 37, 38, 39, 38, 37, 36, 36}, {40, 41, 42, 43, 44, 43, 42, 41, 40}, {28, 29, 30, 29, 28, 27, 0}, {36, 37, 38, 39}, {11}, {45}, {40, 41, 42, 43, 44, 43, 42, 41, 40}, {0, 1, 2, 1}, {3, 4, 5, 6, 7, 8, 9, 10, 11}, {15, 12, 13, 14, 15}, {16, 17, 17, 18, 19, 20}, {21, 22, 23}, {24, 24, 24}, {28, 29, 30, 31, 32, 32}, {24, 25, 26, 27, 27, 26, 25, 24}, {33, 34, 34}, {0}, {1, 2, 3, 4, 5, 6, 7, 8}, {12, 9, 10, 11, 12}, {13, 14, 15, 16}, {17, 18, 19}, {20, 21, 22, 21, 20, 21, 22, 21, 20, 21, 22, 21, 20, 21, 22, 21}, {24, 25, 26, 27, -1, 27, -1, 27, -1, 27, -1, 27, -1, 27, -1}, {28, 28}, {19, 19}, {8, 7, 6, 5, 4, 3, 2, 1}, {20}, {23, 24, 23, 24, 23}, {24, 25, 26, 27}, {0}, {1, 2, 3, 4, 5, 6, 7, 8}, new byte[0], {9, 10, 11, 12}, {13, 14, 15}, {13, 14, 15}, {19, 20, 19, 20, 19}, {16, 17, 18, 17, 16}, {19, 20, 19, 20, 19}, {8, 7, 6, 5, 4, 3, 2, 1}, {0}, {0, 1}};
        ANIM_TIME = new int[][]{{1000, 100, 800, 100}, {0, 0, 0, 0, 0, 0, 0, 0}, {80, 80, 80, 80, -1}, {80, 80, -1, 80, 150, 80}, {80, 80, 80}, {100, -1, 100}, {80, 80, 80, 80, -1}, {80, 80, 80, 150, 600, 80, 80, 80, 80, -1}, {500, -1}, {0, 0, 0, 0, 0, 0, 0, 0}, {80, 80, 80, 350, 80, 80, 80, -1}, {150, 150, 150, 150, -1, 150, 150, 150, 150}, {80, 80, 500, 80, 80, 80, -1}, {80, 80, 80, -1}, {-1}, {0}, {150, 150, 150, 150, 2000, 150, 150, 150, 150}, {1000, 100, 800, 100}, {0, 0, 0, 0, 0, 0, 0, 0, 0}, {50, 50, 50, 50, -1}, {50, -1, 80, 50, 50, 50}, {80, 80, 80}, {100, -1, 100}, {150, 150, 150, 150, 500, -1}, {80, 80, 80, 150, -1, 80, 80, 80}, {80, 500, -1}, {-1}, {0, 0, 0, 0, 0, 0, 0, 0}, {80, 80, 80, 80, 1000, -1}, {80, 80, 80, 1000}, {80, 80, 80}, {250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250, 250}, {80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, 80, -1}, {1000, -1}, {500, -1}, {0, 0, 0, 0, 0, 0, 0, 0}, {0}, {120, 100, 120, 100, 100}, {80, 80, 80, -1}, {-1}, {0, 0, 0, 0, 0, 0, 0, 0}, new int[0], {80, 80, 80, 80}, {80, 80, 80}, {80, 80, 80}, {80, 80, 80, 80, 80}, {80, 80, -1, 80, 80}, {80, 80, 80, 80, 80}, {0, 0, 0, 0, 0, 0, 0, 0}, {-1}, {0, 0}};
        ANIM_LOOP = new boolean[]{true, true, false, false, false, false, false, false, false, true, false, false, false, false, false, true, false, true, true, false, false, false, false, false, false, false, true, true, false, false, false, false, false, false, false, true, true, true, false, true, true, false, false, false, false, false, false, false, true, true, true};
        ANIM_ACTION = new byte[]{2, 2, 1, 0, 0, 0, 2, 0, 1, 2, 0, 0, 0, 0, 0, 2, 0, 2, 2, 1, 0, 0, 0, 0, 0, 0, 2, 2, 1, 0, 0, 0, 0, 0, 1, 2, 1, 1, 0, 2, 2, 1, 0, 0, 0, 0, 0, 1, 2, 2, 2};
    }
}

