/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Hashtable;

public class ResourceMaster {
    private static DataInputStream dis;
    private static int[] fileOffset;
    private static int[] fileLength;
    private static int disPosition;
    private static int currentPak;
    private static Hashtable resourceCache;

    public static byte[] getResource(int n) {
        if (n == -1) {
            return null;
        }
        int n2 = n & 0xFFFF;
        int n3 = n >> 16 & 0xFFFF;
        byte[] byArray = null;
        try {
            if (n3 == 0) {
                byArray = ResourceMaster.getResourceFromJar(n2 + ".res", true);
            } else {
                if (currentPak != n3) {
                    ResourceMaster.initPak(n3);
                }
                int n4 = fileOffset[n2];
                int n5 = fileLength[n2];
                if (dis == null || disPosition > n4) {
                    dis.close();
                    dis = null;
                    dis = new DataInputStream(Shell.sInstance.getClass().getResourceAsStream("/" + n3 + ".pak"));
                    dis.skipBytes(n4);
                } else if (disPosition <= n4) {
                    dis.skip(n4 - disPosition);
                }
                byArray = new byte[n5];
                dis.readFully(byArray);
                disPosition = n4 + n5;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    public static byte[] getResourceFromJar(String string) {
        return ResourceMaster.getResourceFromJar(string, false);
    }

    public static byte[] getResourceFromJar(String string, boolean bl) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            InputStream inputStream = Shell.sInstance.getClass().getResourceAsStream("/" + string);
            if (bl) {
                inputStream.skip(4L);
            }
            int n = 0;
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
            inputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static void closeResource() {
        currentPak = -1;
        fileOffset = null;
        fileLength = null;
        try {
            if (dis != null) {
                dis.close();
                dis = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void initPak(int n) {
        if (currentPak != -1) {
            ResourceMaster.closeResource();
        }
        currentPak = n;
        dis = new DataInputStream(Shell.sInstance.getClass().getResourceAsStream("/" + n + ".pak"));
        try {
            int n2 = dis.readShort();
            fileOffset = new int[n2];
            fileLength = new int[n2];
            for (int i = 0; i < n2; ++i) {
                dis.readInt();
                ResourceMaster.fileOffset[i] = dis.readInt();
                ResourceMaster.fileLength[i] = dis.readInt();
            }
            disPosition = n2 * 12 + 2;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        currentPak = -1;
    }
}

