import java.io.*;

import java.lang.*;

import java.util.*;

import javax.microedition.io.*;
import javax.microedition.lcdui.*;
import javax.microedition.midlet.*;
import javax.microedition.rms.*;


class Game implements GameConstants, DontpullConstants {
    private GameCanvas main;
    private int mode;
    byte[][] field = new byte[12 + 2][10 + 2];
    int[][] chara;
    int[] afield;
    byte[] lineNum;
    int[][][] line;

    private boolean Afield(int j, int i, int a) {
        int ix = ((j * ((5 * 2) + 10 + 2)) + i) / 32;
        int mk = 1 << (((j * ((5 * 2) + 10 + 2)) + i) % 32);

        if(a < 0) {
            return (afield[ix] & mk) != 0;
        }

        if(a == 0) {
            afield[ix] &= ~mk;
        } else if(a == 1) {
            afield[ix] |= mk;
        }

        return true;
    }

    static final int FPS = 12;
    private int[][] work;
    private int stimer = -1;
    int Gametimer = -1;
    private int result_time = FPS * 1;

    Game(GameCanvas main, int mode) {
        this.main = main;
        this.mode = mode;
        System.out.println("GAME CANVAS");
    }

    void init() {
        System.out.println("GAME INIT");

        work = new int[3][];
        work[0] = new int[45];
        work[2] = new int[5];
        chara = new int[50][];

        afield = new int[((((5 * 2) + 12 + 2) * ((5 * 2) + 10 + 2)) + 31) / 32];

        lineNum = new byte[(5 * 2) + 12 + 2];

        line = new int[lineNum.length][50][];

        byte[] d = null;

        while(true)

            try {
                DataInputStream in = new DataInputStream(getClass().getResourceAsStream("/ST.dat"));

                in.readShort();

                for(int k = 0; k < main.stageNo; k++) {
                    int size = in.readShort();
                    in.skip(size);
                }

                int size = in.readShort();
                d = new byte[size];
                in.read(d, 0, size);
                in.close();
                in = null;

                break;
            } catch(Throwable t) {
                d = null;
                System.gc();
            }

        work[1] = null;

        work[0][6] = 0;

        int k = 0;

        for(int j = 1; j < (12 + 1); j++) {
            for(int i = 1; i < (10 + 1); i += 2) {
                int aa = d[k++];
                int a = (aa & 0xf);
                this.field[j][i] = (byte)a;

                if(a == KB_BLOCK) {
                    work[0][7]++;
                }

                a = ((aa >> 4) & 0xf);
                this.field[j][i + 1] = (byte)a;

                if(a == KB_BLOCK) {
                    work[0][7]++;
                }
            }
        }

        {
            short[][] img_block = {
                    { 104, 105, 99, },
                    { 111, 112, 106, },
                    { 118, 119, 113, },
                    { 125, 126, 120, },
                };
            int a = d[k++];
            ImageData[KB_GND] = img_block[a][0];
            ImageData[K_OUT] = img_block[a][1];
            ImageData[KB_BLOCK] = img_block[a][2];
        }

        int HeartListIdx = 0;

        int eid = 1;

        for(; k < d.length; k += 5) {
            int i = addChara(d[k + 0], d[k + 1], PRI_BASE, (d[k + 2] * 24) + (24 * 2), (d[k + 3] * 20) + (20 * 2), d[k + 4]);

            if(i >= 0) {
                int[] p = chara[i];

                if(p[CH_KIND] == KM_PULL) {
                    p[CH_PRI] = PRI_0;
                    work[1] = p;
                } else if(p[CH_KIND] == KM_ROCK) {
                    p[CH_IMG] = ImageData[p[CH_KIND]];
                } else if(p[CH_KIND] == KB_HOLE) {
                    int a = getField(p[CH_X], p[CH_Y], 0);

                    if(a <= KB_GND) {
                        getField(p[CH_X], p[CH_Y], p[CH_KIND]);
                    }

                    p[CH_PRI] = PRI_M1;
                    p[CH_ACT_CNT] = (FPS * 3) + (FPS / 2);

                    int fr = p[CH_DIR];
                    p[CH_DIR] = DIR_D;
                    p[CH_W0] = fr;

                    p[CH_W4] = eid++;

                    if((main.deadEnemyList & (1 << p[CH_W4])) != 0) {
                        getField(p[CH_X], p[CH_Y], a);
                        p[CH_KIND] = 0;

                        continue;
                    }

                    work[0][6]++;
                } else if(p[CH_KIND] == KB_HEART) {
                    if(main.heartList > 0) {
                        int ix = ((main.heartList >> (HeartListIdx * 8)) & 0xf);
                        int iy = ((main.heartList >> ((HeartListIdx * 8) + 4)) & 0xf);
                        p[CH_X] = (ix * 24) + (24 * 2);
                        p[CH_Y] = (iy * 20) + (20 * 2);
                        HeartListIdx++;
                    }

                    getField(p[CH_X], p[CH_Y], KB_HEART);
                    p[CH_KIND] = 0;
                }

                if((p[CH_KIND] > KM_PULL) && (p[CH_KIND] < KM_ROCK)) {
                    p[CH_W4] = eid++;

                    if((main.deadEnemyList & (1 << p[CH_W4])) != 0) {
                        p[CH_KIND] = 0;

                        continue;
                    }

                    work[0][6]++;
                    work[0][10]++;
                }
            }
        }

        if(((main.heartList >> (8 * 3)) & 1) != 0) {
            work[0][24] = 1;
        }

        work[0][13] = work[0][6];
        main.restEnemyNum = work[0][6];

        try {
            DataInputStream res = new DataInputStream(getClass().getResourceAsStream("/SD.dat"));
            int d_num = res.readShort();
            int ix = (main.stageNo % 8) % d_num;

            for(int i = 0; i < ix; i++) {
                int iy = res.readByte();
                res.skip(iy);
            }

            int[] dx = new int[res.readByte()];

            for(int i = 0; i < dx.length; i++) {
                dx[i] = res.readByte();
            }

            res.close();
            res = null;
            ShowtimeData = dx;

            int Tempo = ShowtimeTempoData[ix % ShowtimeTempoData.length];
            ShowtimeTempoCnt = (((FPS * 60) + (Tempo / 2)) / Tempo);
        } catch(Throwable t) {
        }

        gameBgmNo = 2 + (main.stageNo % 4);
        danceBgmNo = 6 + (main.stageNo % 8);

        System.out.println("------------------------PLAY SOUND--------------------------------------------------");

        if(!main.Snd.isload(gameBgmNo)) {
            main.Snd.load(gameBgmNo);
        }

        if(!main.Snd.isload(17)) {
            main.Snd.load(17);
        }

        check_2heart();

        System.gc();

        bgmNo = 0x1000;
    }

    void restart() {
    }

    private int key;
    private int bgmNo = -1;
    private int gameBgmNo = 2;
    private int danceBgmNo = 6;

    int move(int key) {
        this.key = key;

        if(work[0][41] == 0) {
            if(work[0][43] > 0) {
                work[0][42] = FPS / 2;

                work[0][42] = FPS * 2;

                {
                    main.bgmStop();

                    int ba = 18;

                    if(!main.Snd.isload(ba)) {
                        main.Snd.load(ba);
                    }

                    main.sePlay(ba);
                }

                work[0][43] = 0;
            }
        }

        if(work[0][42] == 0) {
            int a = gameBgmNo;

            if(work[1][CH_DMG] >= 0xffff) {
                a = 16;
            } else if(work[0][23] != 0) {
                a = danceBgmNo;

                if((ShowtimeStep <= 0) || (work[0][41] != 0)) {
                    a = 18;
                }
            } else if(work[0][29] != 0) {
                a = 0;
            } else if(work[0][20] != 0) {
                a = 1;

                if(work[0][21] > 0) {
                    work[0][21]--;
                }

                if(work[0][22] != 0) {
                    if(!main.Snd.isPlay(0) && main.Snd.IsUse()) {
                        bgmNo = -1;
                    }
                } else {
                    if(!main.Snd.isPlay(0) && (work[0][21] == 0)) {
                        work[0][20] = 0;
                    }
                }
            }

            if(bgmNo != a) {
                bgmNo = a;

                if(!main.Snd.isload(bgmNo)) {
                    main.Snd.load(bgmNo);
                }

                if((bgmNo <= 5) && (bgmNo != 1)) {
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");

                    System.out.println("--bgmNo1 " + bgmNo + " -- ");

                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");

                    main.bgmPlay(bgmNo, 2);
                } else {
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("--bgmNo2 " + bgmNo + " -- ");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    System.out.println("IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII");
                    main.bgmPlay(bgmNo, 3);
                }

                if(bgmNo != 0) {
                    main.Snd.unload(0);
                }

                if(bgmNo != 1) {
                    main.Snd.unload(1);
                }

                if(bgmNo != danceBgmNo) {
                    main.Snd.unload(danceBgmNo);
                }

                if(bgmNo != 14) {
                    main.Snd.unload(14);
                }

                if(bgmNo != 18) {
                    main.Snd.unload(18);
                }

                System.gc();
            }
        }

        if((work[0][26] == 0) && (gFlushMode == 0)) {
            if(work[0][42] > 0) {
                work[0][42]--;

                if(work[0][42] == 0) {
                    if(bgmNo != 18) {
                        bgmNo = -1;
                    }
                }

                return 0;
            }
        }

        if(work[0][41] != 0) {
            for(int i = 0; i < chara.length; i++) {
                int[] p = chara[i];

                if(p == null) {
                    break;
                }

                switch(p[0]) {
                case 53:
                    Heart_fly(p);

                    break;
                }
            }

            return 0;
        }

        stimer++;

        if(work[0][10] == 1) {
            if(work[0][23] == 0) {
                if(++work[0][28] > (FPS * 10)) {
                    work[0][29] = 1;
                }
            }
        } else {
            work[0][28] = 0;
        }

        if(work[0][36] > 0) {
            if(--work[0][36] <= 0) {
                addPoint(work[0][35], work[0][38], work[0][39]);
                work[0][35] = 0;
                work[0][37] = 0;
            }
        }

        if(work[0][23] == 0) {
            if(++Gametimer > (210 * FPS)) {
                int[] pp = work[1];

                if(pp[13] < 0xffff) {
                    pp[13] = 0x10000 + FPS;
                }
            }
        } else {
            work[0][23]--;
            ShowtimeCom = 0;

            if(work[0][41] == 0) {
                if(work[0][26] == 0) {
                    if((work[0][23] % ShowtimeTempoCnt) == 0) {
                        if(++ShowtimeStep >= ShowtimeData.length) {
                            work[0][23] = 0;
                            Showtime_end();
                        } else {
                            int a = ShowtimeData[ShowtimeStep];

                            if(a == 16) {
                                work[0][23] = 0;
                                Showtime_end();
                            } else if(a == 17) {
                                ShowtimeStep = -1;
                            } else {
                                ShowtimeCom = a;
                            }
                        }
                    }
                }
            }
        }

        if(work[0][25] > 0) {
            work[0][25]--;
        }

        work[0][31] = 0;
        work[0][30] = 0;

        if(work[0][25] == 0) {
            if(work[0][29] == 0) {
                if(work[0][23] == 0) {
                    if((Gametimer % (FPS * 30)) == ((FPS * 30) - 1)) {
                        work[0][31] = 1;
                    }
                }
            }
        }

        if(work[0][32] == 0) {
            if(work[0][31] != 0) {
                work[0][30] = 1;
            }
        }

        work[0][32] = work[0][31];

        Hole_control();
        work[0][16] = 0;
        work[0][17] = 0;

        FcharaPtr = 0;

        for(int i = 0; i < chara.length; i++) {
            int[] p = chara[i];

            if(p == null) {
                break;
            }

            if(p[0] > 0) {
                MoveIdx = i;

                switch(p[0]) {
                case 41:
                    Pull_move(p);

                    break;

                case 42:
                case 43:
                case 44:
                case 45:

                    if(work[0][3] == 0) {
                        Slime_move(p);
                    }

                    break;

                case 46:
                case 47:

                    if(work[0][3] == 0) {
                        Dragon_move(p);
                    }

                    break;

                case 48:

                    if(work[0][3] == 0) {
                        Rock_move(p);
                    }

                    break;

                case 49:
                    Fire_move(p);

                    break;

                case 5:
                    Block_move(p);

                    break;

                case 3:
                    Hole_move(p);

                    break;

                case 6:
                    Star_move(p);

                    break;

                case 7:
                    Heart_move(p);

                    break;

                case 8:
                    Heart_flush(p);

                    break;

                case 9:
                    Bomb_move(p);

                    break;

                case 36:
                case 37:
                case 38:
                case 39:
                case 40:
                    AFruit_move(p);

                    break;

                case 50:
                    None_move(p);

                    break;

                case 51:
                    Scatter_move(p);

                    break;

                case 52:
                    Appear_move(p);

                    break;

                case 53:
                    Heart_fly(p);

                    break;

                case 54:
                    Fruit_move(p);

                    break;
                }
            }
        }

        MoveIdx = 0;

        for(int i = 0; i < FcharaPtr; i++) {
            int[] p = Fchara[i];

            if(p[0] > 0) {
                switch(p[0]) {
                case 41:
                    Pull_move(p);

                    break;

                case 42:
                case 43:
                case 44:
                case 45:

                    if(work[0][3] == 0) {
                        Slime_move(p);
                    }

                    break;

                case 46:
                case 47:

                    if(work[0][3] == 0) {
                        Dragon_move(p);
                    }

                    break;

                case 48:

                    if(work[0][3] == 0) {
                        Rock_move(p);
                    }

                    break;

                case 49:
                    Fire_move(p);

                    break;

                case 5:
                    Block_move(p);

                    break;

                case 3:
                    Hole_move(p);

                    break;

                case 6:
                    Star_move(p);

                    break;

                case 7:
                    Heart_move(p);

                    break;

                case 8:
                    Heart_flush(p);

                    break;

                case 9:
                    Bomb_move(p);

                    break;

                case 36:
                case 37:
                case 38:
                case 39:
                case 40:
                    AFruit_move(p);

                    break;

                case 50:
                    None_move(p);

                    break;

                case 51:
                    Scatter_move(p);

                    break;

                case 52:
                    Appear_move(p);

                    break;

                case 53:
                    Heart_fly(p);

                    break;

                case 54:
                    Fruit_move(p);

                    break;
                }
            }
        }

        work[0][14] = work[0][16] + work[0][17];
        work[0][15] = work[0][17];

        main.restEnemyNum = work[0][6] - work[0][14];

        if((main.restEnemyNum * 2) <= work[0][13]) {
            if(work[0][33] == 0) {
                work[0][30] = 1;
                work[0][33] = 1;
            }
        }

        if((main.restEnemyNum <= 0) || (work[0][7] <= 0)) {
            if(work[0][3] == 0) {
                work[0][3] = 2;
            }
        }

        return ((result_time <= 0) ? work[0][3] : 0);
    }

    private int MoveIdx;
    private int[][] Fchara = new int[50][];
    private int FcharaPtr = 0;

    private int addChara(int kind, int opt, int pri, int x, int y, int dir) {
        for(int i = 0; i < chara.length; i++) {
            int[] p = chara[i];

            if(p == null) {
                p = chara[i] = new int[19];
            }

            if(p[0] == 0) {
                if(i <= MoveIdx) {
                    Fchara[FcharaPtr++] = p;
                }

                p[0] = kind;
                p[1] = opt;
                p[2] = -1;
                p[3] = pri;
                p[5] = x;
                p[6] = y;
                p[7] = dir;
                p[8] = 0;
                p[9] = 0;
                p[10] = 0;
                p[11] = 0;
                p[12] = 0;
                p[13] = 0;

                p[14] = 0;
                p[15] = 0;
                p[16] = 0;
                p[17] = 0;

                return i;
            }
        }

        return -1;
    }

    private int addNone(int x, int y, int img, int pri, int cnt) {
        int i = addChara(50, 0, pri, x, y, 0);

        if(i >= 0) {
            int[] p = chara[i];
            p[2] = img;
            p[9] = cnt;
        }

        return i;
    }

    private void setClip(int x, int y, int w, int h) {
        main.setClip(x / 2, y / 2, w / 2, h / 2);
    }

    private void setColor(int col) {
        main.setColor(col);
    }

    private void DrawImage(int no, int x, int y) {
        main._DrawImage(no, x, y);
    }

    private void DrawImageB(int no, int x, int y) {
        main._DrawImageB(no, x, y);
    }

    private void DrawImageC(int no, int x, int y) {
        main._DrawImageC(no, x, y);
    }

    private void fillRect(int x, int y, int w, int h) {
        main.fillRect(x / 2, y / 2, w / 2, h / 2);
    }

    private void DrawFontC(String Str, int x, int y, int mode) {
        main.DrawFontC(Str, x / 2, y / 2, mode);
    }

    private Graphics g;
    private int gFlushMode;

    void draw(Graphics _g, int mode) {
        this.g = _g;

        Game g = this;

        int x0 = 0;
        int y0 = 6;

        y0 = 12;

        //        g.setClip(0, 0, 120 * 2, 120 * 2);
        g.setClip(0, 0, 120 * 2, 270);

        if(mode == 0) {
            for(int j = 1; j < (field.length - 1); j++)
                for(int i = 1; i < (field[j].length - 1); i++) {
                    Afield(5 + j, 5 + i, 0);
                }
        }

        for(int j = 0; j < lineNum.length; j++) {
            lineNum[j] = 0;
        }

        for(int i = 0; i < chara.length; i++) {
            int[] p = chara[i];

            if(p == null) {
                break;
            }

            if(p[0] > 0) {
                if(p[2] >= 0) {
                    if(p[3] < 6) {
                        int j = ((p[6] + p[12]) - 2) / 20;

                        if(lineNum[5 + j] < line[0].length) {
                            line[5 + j][lineNum[5 + j]++] = p;
                        }

                        p[4] = p[6] + p[12] + ((p[3] * 20) / 2);
                    }
                }
            }
        }

        for(int j = 0; j < lineNum.length; j++)
            for(int i = 0; i < lineNum[j]; i++) {
                int[] p = line[j][i];

                for(int ii = 0; ii < i; ii++) {
                    int[] pp = line[j][ii];

                    if(pp[4] >= p[4]) {
                        for(int iii = i; iii > ii; iii--) {
                            line[j][iii] = line[j][iii - 1];
                        }

                        line[j][ii] = p;

                        break;
                    }
                }
            }

        for(int j = 1; j < (field.length - 1 + 2); j++) {
            int Y = y0 + ((j - 1) * 20);

            {
                int YY = Y + 20;

                if(YY > (120 * 2)) {
                    YY = 120 * 2;
                }

                g.setClip(0, 6 * 2, 120 * 2, YY - (6 * 2));
            }

            if(j < (field.length - 1)) {
                for(int i = 1; i < (field[j].length - 1); i++) {
                    if(!Afield(5 + j, 5 + i, -1)) {
                        int a = field[j][i];
                        int no = ImageData[2];

                        if(a == 1) {
                            no = ImageData[1];
                        }

                        int x = x0 + ((i - 1) * 24);
                        int y = Y;
                        g.DrawImage(no, x, y);

                        if(a > 2) {
                            no = ImageData[a];
                            g.DrawImageB(no, x + (24 / 2), (y + 20) - 1);
                        }
                    }
                }
            }

            for(int i = 0; i < lineNum[5 + j]; i++) {
                int[] p = line[5 + j][i];

                {
                    int x = (x0 + p[5] + p[11]) - (24 / 2) - 24;
                    int y = (y0 + p[6] + p[12]) - 20 - 1;

                    g.DrawImageB(p[2], x, y);

                    if(j < (field.length - 1)) {
                        x = (p[5] + p[11]) - (24 / 2);

                        int nx = main.getImgWidth(p[2]);

                        nx *= 2;

                        for(int ix = (x - (nx / 2)) / 24; ix < (((x + 24) - 1 + (nx / 2)) / 24); ix++) {
                            Afield(5 + j, 5 + ix, 0);
                        }
                    }
                }
            }

            if(j < (field.length - 1)) {
                for(int i = 1; i < (field[j].length - 1); i++) {
                    if(!Afield(5 + j, 5 + i, -1)) {
                        if(Afield(5 + j + 1, 5 + i, -1)) {
                            int a = field[j + 1][i];

                            if(a > 2) {
                                int x = x0 + ((i - 1) * 24);
                                int y = Y + 20;

                                int no = ImageData[a];
                                g.DrawImageB(no, x + (24 / 2), (y + 20) - 1);
                            }
                        }

                        Afield(5 + j, 5 + i, 1);
                    }
                }
            }
        }

        for(int i = 0; i < chara.length; i++) {
            int[] p = chara[i];

            if(p == null) {
                break;
            }

            if(p[0] > 0) {
                if(p[3] >= 6) {
                    if(p[2] >= 0) {
                        int x = (x0 + p[5] + p[11]) - (24 / 2) - 24;
                        int y = (y0 + p[6] + p[12]) - 20 - 1;

                        if(p[2] == 42) {
                            g.setColor(0xffffff);

                            int n = ("" + p[1]).length();
                            int nx = (6 * n) + 2;
                            int ny = 6 + 2;
                            int dy = 1;

                            nx *= 2;
                            ny *= 2;
                            dy *= 2;

                            g.fillRect(x - (nx / 2), y - ny, nx, ny);
                            g.DrawFontC("" + p[1], x, y - ny + dy, 1);
                        } else {
                            g.DrawImageB(p[2], x, y);
                        }
                    }
                }
            }
        }

        if(work[0][26] != 0) {
            if((work[0][26] < 0) || ((work[0][26] & 1) != 0)) {
                g.setColor(0xffffff);

                int a = work[0][27];

                g.fillRect((24 * 5) - a, (20 * 6) - a, a * 2, a * 2);

                if(work[0][26] > 0) {
                    for(int j = 1; j < (field.length - 1); j++)
                        for(int i = 1; i < (field[j].length - 1); i++) {
                            Afield(5 + j, 5 + i, 0);
                        }
                }
            }

            gFlushMode = 1;

            if(work[0][26] > 0) {
                work[0][26]--;
            } else {
                work[0][26]++;
                gFlushMode = -1;
            }
        } else if(gFlushMode != 0) {
            {
                g.setColor(0xffffff);

                int a = work[0][27];

                g.fillRect((24 * 5) - a, (20 * 6) - a, a * 2, a * 2);
            }

            for(int j = 1; j < (field.length - 1); j++)
                for(int i = 1; i < (field[j].length - 1); i++) {
                    Afield(5 + j, 5 + i, 0);
                }

            gFlushMode = 0;
        }

        {
            int X = 12 * 5;
            int Y = (10 * 6) - 10;

            X *= 2;
            Y *= 2;

            if((work[0][23] > 0) && (gFlushMode < 0)) {
                g.DrawFontC("SHOWTIME", X, Y, 0);

                if(work[0][40] > 0) {
                    g.DrawFontC("" + work[0][40], X, Y + (20 * 2), 0);
                }

                work[2][1] = 1;
            } else if(work[2][1] != 0) {
                g.DrawFontC("SHOWTIME", X, Y, 0);

                if(work[0][40] > 0) {
                    g.DrawFontC("" + work[0][40], X, Y + (20 * 2), 0);
                }

                int x = 10;
                int y = Y;
                int i = ((x - x0) / 24) + 1;
                int j = ((y - y0) / 20) + 1;

                for(int iy = 0; iy < (((20 + 10) - 1) / 10); iy++)
                    for(int ix = 0; ix < (((100 + 12) - 1) / 12); ix++) {
                        Afield(5 + iy + j, 5 + ix + i, 0);
                    }

                work[0][40] = 0;
                work[2][1] = 0;
            }

            if((work[0][29] != 0) && (work[0][23] == 0) && ((Gametimer % FPS) > (FPS / 3)) && (work[0][3] == 0)) {
                g.DrawFontC("ESCAPE", X, Y, 0);

                work[2][2] = 1;
            } else if(work[2][2] != 0) {
                g.DrawFontC("ESCAPE", X, Y, 0);

                int x = 10;
                int y = Y;
                int i = ((x - x0) / 24) + 1;
                int j = ((y - y0) / 20) + 1;

                for(int iy = 0; iy < (((20 + 10) - 1) / 10); iy++)
                    for(int ix = 0; ix < (((100 + 12) - 1) / 12); ix++) {
                        Afield(5 + iy + j, 5 + ix + i, 0);
                    }

                work[2][2] = 0;
            }

            if((Gametimer > (180 * FPS)) && (work[2][2] == 0) && (work[0][23] == 0) &&
                    ((Gametimer < ((180 + 5) * FPS)) || (Gametimer > (210 * FPS)) || ((Gametimer % FPS) >= (FPS - (FPS / 3)))) &&
                    (Gametimer != (210 * FPS)) && (result_time > 0)) {
                if(Gametimer > (210 * FPS)) {
                    g.DrawFontC("TIME OVER", X, Y, 0);
                } else if(Gametimer > ((210 - 10) * FPS)) {
                    g.DrawImageC(344, X, Y);
                } else if(Gametimer > ((180 + 5) * FPS)) {
                    int sec = 210 - (((Gametimer + FPS) - 1) / FPS);

                    g.DrawFontC("" + sec + "SEC", X, Y, 0);
                } else {
                    g.DrawFontC("HURRY UP!", X, Y, 0);
                }

                work[2][3] = 1;
            } else if(work[2][3] != 0) {
                if(Gametimer > (210 * FPS)) {
                    g.DrawFontC("TIME OVER", X, Y, 0);
                } else if(Gametimer > ((210 - 10) * FPS)) {
                    g.DrawImageC(344, X, Y);
                } else if(Gametimer > ((180 + 5) * FPS)) {
                    int sec = 210 - (((Gametimer + FPS) - 1) / FPS);

                    g.DrawFontC("" + sec + "SEC", X, Y, 0);
                } else {
                    g.DrawFontC("HURRY UP!", X, Y, 0);
                }

                int j = ((Y - y0) / 20) + 1;

                for(int iy = 0; iy < (((20 + 10) - 1) / 10); iy++)
                    for(int ix = 0; ix <= (120 / 12); ix++) {
                        Afield(5 + iy + j, 5 + ix, 0);
                    }

                work[2][3] = 0;
            }

            if(work[0][42] > 0) {
                g.DrawFontC("1UP!", X, Y, 0);

                if(work[0][42] == 1) {
                    int j = ((Y - y0) / 20) + 1;

                    for(int iy = 0; iy < (((20 + 10) - 1) / 10); iy++)
                        for(int ix = 0; ix <= (120 / 12); ix++) {
                            Afield(5 + iy + j, 5 + ix, 0);
                        }
                }
            }
        }

        for(int i = 0; i < chara.length; i++) {
            int[] p = chara[i];

            if(p == null) {
                break;
            }

            if(p[0] > 0) {
                if(p[2] >= 0) {
                    int x = (p[5] + p[11]) - (24 / 2);
                    int y = (p[6] + p[12]) - 1;

                    int nx = main.getImgWidth(p[2]);
                    int ny = main.getImgHeight(p[2]);

                    if(p[2] == 42) {
                        int n = ("" + p[1]).length();
                        nx = (nx * n) + 2;
                        ny += 2;
                    }

                    nx *= 2;
                    ny *= 2;

                    for(int iy = (y - ny) / 20; iy <= ((y) / 20); iy++)
                        for(int ix = (x - (nx / 2)) / 24; ix < (((x + 24) - 1 + (nx / 2)) / 24); ix++) {
                            Afield(5 + iy, 5 + ix, 0);
                        }
                }
            }
        }
    }

    private static final byte[][] WalkTbl = {
            { 0, -1, },
            { 1, 0, },
            { 0, 1, },
            { -1, 0, },
        };

    private int getField(int x, int y, int block) {
        int iy = (y - 1) / 20;
        int ix = (x - (24 / 2)) / 24;

        try {
            int a = field[iy][ix];

            if(a > 1) {
                if(block > 0) {
                    field[iy][ix] = (byte)block;

                    if((a >= 5) || (block >= 5)) {
                        Afield((5 + iy) - 1, 5 + ix, 0);
                    }

                    Afield(5 + iy, 5 + ix, 0);
                }
            }

            return a;
        } catch(ArrayIndexOutOfBoundsException e) {
            return 0;
        }
    }

    private int CharaPosX;
    private int CharaPosY;

    private void getCharaPos(int ix, int iy) {
        CharaPosX = (ix * 24) + (24 / 2);
        CharaPosY = (iy * 20) + 1;
    }

    void Pull_move(int[] p) {
        p[2] = p[17];

        if(work[0][3] != 0) {
            if(getField(p[5], p[6], 0) == 3) {
                getField(p[5], p[6], 2);

                work[0][17]++;
            }

            if(work[0][3] == 2) {
                p[16]++;

                if(p[16] <= 1) {
                    p[12] = -1 * 2;
                    p[2] = 10;
                } else if(p[16] == ((FPS + 3) / 4)) {
                    addNone(p[5], p[6] - (4 * 2), 139, 2, 4);
                    p[12] = (-1 - 4) * 2;
                    p[2] = 11;
                } else if(p[16] == (FPS / 2)) {
                    p[16] = 0;
                }
            }

            p[17] = p[2];
            p[2] = p[17] + 127;

            if(result_time == (FPS / 2)) {
                if(work[0][3] == 2) {
                    if(work[0][15] > 0) {
                        addPoint(5000, p[5], p[6]);
                    }
                }
            }

            result_time--;

            if(result_time <= 0) {
                main.heartList = 0;

                for(int j = 0; j < field.length; j++)
                    for(int i = 0; i < field[j].length; i++) {
                        if((field[j][i] == 7) || (field[j][i] == 8)) {
                            main.heartList <<= 8;
                            main.heartList |= (((i - 1) & 0xf) + (((j - 1) & 0xf) << 4));
                        }
                    }

                if(work[0][24] != 0) {
                    main.heartList |= (1 << (8 * 3));
                }
            }

            return;
        } else if(p[13] >= 0x50000) {
            p[13]--;

            if(p[13] < 0x50000) {
                p[13] = 0;
            }
        } else if(p[13] != 0) {
            if(p[13] == 0xffff) {
                main.playerNum--;

                work[0][3] = 1;
            } else {
                if(p[13] > 0xffff) {
                    int a = (p[13] - 0xffff) / (FPS / 4);

                    if(a > 2) {
                        a = 2;
                    }

                    if((p[2] >= 7) && (p[2] <= 9)) {
                        p[2] = 9 - a;
                    } else {
                        p[2] = 6 - a;
                    }

                    if(a == 0) {
                        p[3] = 5;
                    }
                }

                p[13]--;
            }

            p[17] = p[2];
            p[2] = p[17] + 127;

            return;
        }

        if(p[9] == 0) {
            {
                work[0][22] = 0;

                int a = getField(p[5], p[6], 0);

                if(FruitUp(a, p)) {
                    getField(p[5], p[6], 2);
                } else if(a == 1) {
                    work[0][22] = 1;

                    if(work[0][23] == 0) {
                        if(work[0][20] == 0) {
                            work[0][20] = 1;
                            work[0][21] = FPS * 4;
                        }
                    }
                } else if(a == 3) {
                    getField(p[5], p[6], 2);

                    work[0][17]++;
                }
            }

            if(key > 4) {
                int dir = key - 4 - 1;
                int x = p[5] + (WalkTbl[p[7]][0] * 24);
                int y = p[6] + (WalkTbl[p[7]][1] * 20);
                int a = getField(x, y, 0);

                if((p[7] == dir) && (a >= 5) && (a <= 9)) {
                    key = 4;
                } else {
                    key = dir;
                }
            }

            if((key >= 0) && (key < 4) && (p[10] != key)) {
                p[10] = key;
                p[7] = p[10];

                p[8] = 0;
                p[12] = -1 * 2;
                p[2] = Pull_motion[p[7]] + 0;
            } else if((key >= 0) && (key < 4)) {
                int x = p[5] + (WalkTbl[key][0] * 24);
                int y = p[6] + (WalkTbl[key][1] * 20);
                int a = getField(x, y, 0);

                if(((a >= 1) && (a <= 4)) || (a == 10) || (a >= 11)) {
                    p[10] = key;

                    p[9] = 3;
                    p[7] = p[10];

                    if(p[8] == 1) {
                        p[8] = 2;
                    } else {
                        p[8] = 1;
                    }
                } else {
                    p[7] = key;
                    p[8] = 0;
                }
            } else if(key == 4) {
                int x = p[5] + (WalkTbl[p[7]][0] * 24);
                int y = p[6] + (WalkTbl[p[7]][1] * 20);
                int a = getField(x, y, 0);

                if((a >= 5) && (a <= 9)) {
                    if(a == 8) {
                        a = 7;
                    }

                    getField(x, y, 2);
                    addChara(a, 0, 3, x, y, p[7]);

                    p[10] = p[7];

                    p[9] = 3;

                    main.sePlay(20);
                } else {
                    p[2] = Pull_motion[p[7]] + 3;
                }

                p[8] = 8;
            } else {
                p[8] = 0;
                p[12] = -1 * 2;
                p[2] = Pull_motion[p[7]] + 0;
            }
        }

        if(p[9] == (3 - 1)) {
            if(p[8] == 8) {
                p[9]++;

                int nx;
                int ny;

                if(3 == 4) {
                    int i = (p[9] - 1) & 1;
                    nx = ((24 / 2) + i) / 2;
                    ny = ((20 / 2) + i) / 2;
                } else if(3 == 3) {
                    int i = p[9] - 1;
                    nx = 24 / 3;
                    ny = (20 + i) / 3;
                } else {
                    nx = 24 / 2;
                    ny = 20 / 2;
                }

                p[5] -= (WalkTbl[p[10]][0] * nx);
                p[6] -= (WalkTbl[p[10]][1] * ny);
                p[9] = 0;
            }
        }

        if(p[9] != 0) {
            int nx;
            int ny;

            if(3 == 4) {
                int i = (p[9] - 1) & 1;
                nx = ((24 / 2) + i) / 2;
                ny = ((20 / 2) + i) / 2;
            } else if(3 == 3) {
                int i = p[9] - 1;
                nx = 24 / 3;
                ny = (20 + i) / 3;
            } else {
                nx = 24 / 2;
                ny = 20 / 2;
            }

            p[5] += (WalkTbl[p[10]][0] * nx);
            p[6] += (WalkTbl[p[10]][1] * ny);

            if(p[8] == 8) {
                p[2] = Pull_motion[p[7]] + 3;
            } else {
                int a = Pull_motion[p[7]] + 1;

                if(p[17] == a) {
                    a++;
                }

                p[2] = a;
            }

            p[9]--;
        }

        p[17] = p[2];

        if((p[13] >= 0x50000) && ((stimer & 1) == 0)) {
            p[2] = -1;
        } else {
            p[2] = p[17] + 127;
        }
    }

    void Slime_move(int[] p) {
        int setImg = 1;
        int stomp = 0;

        int shad = 0;

        if(p[14] == 0) {
            p[14] = 1 + addNone(p[5], p[6], -1, 1, -1);
        } else {
            chara[p[14] - 1][2] = -1;
        }

        p[2] = p[17];
        p[3] = 3;

        if(p[8] == 10) {
            p[2] = 0;

            p[12] -= 2;

            if(p[12] <= ((-1 - 4) * 2)) {
                p[12] = -1 * 2;
                p[8] = 0;
            }

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            return;
        } else if(p[13] != 0) {
            if(p[8] == 9) {
                p[8] = 0;
                p[9] = 0;
            }

            if(work[0][3] != 1) {
                if(p[13] == 0xffff) {
                    main.deadEnemyList |= (1 << p[18]);

                    work[0][6]--;
                    work[0][10]--;
                    work[0][35] += ((1 << work[0][37]) * 1000);
                    work[0][37]++;
                    work[0][36] = 2;
                    work[0][38] = p[5];
                    work[0][39] = p[6];

                    if(p[14] > 0) {
                        chara[p[14] - 1][0] = 0;
                    }

                    p[0] = 0;

                    return;
                } else {
                    if(p[13] > 0xffff) {
                        if(p[13] == (0x10000 + 4)) {
                            p[2] = 0;
                        } else {
                            p[2] = Slime_out_motion[p[7]];
                        }

                        if(p[12] < ((-1 - 2) * 2)) {
                            p[12] = (-1 - 2) * 2;
                        }
                    } else {
                        int a = getField(p[5], p[6], 0);

                        if((a >= 5) && (a <= 9)) {
                            p[12] = (-1 - 4) * 2;
                            p[3] = 6;
                        } else if(p[12] < ((-1 - 2) * 2)) {
                            p[12] = (-1 - 2) * 2;
                        }
                    }

                    p[13]--;
                }
            }

            p[17] = p[2];

            if(p[13] < 0xffff) {
                p[2] = 3;

                if(p[13] < (FPS * 6)) {
                    p[2] = 6;

                    if(p[13] > (FPS * 2)) {
                        if((p[13] % (FPS / 2)) < (FPS / 4)) {
                            p[2] = 7;
                        }
                    }
                }

                p[17] = p[2];

                if(p[13] <= (FPS * 2)) {
                    if((stimer & 2) == 0) {
                        p[2] = -1;

                        return;
                    }
                }
            }

            p[2] = p[17] + ImageData[p[0]];

            return;
        } else if(p[8] == 9) {
            if((++p[9] % (FPS / 3)) == 1) {
                addNone(p[5], p[6] - 20, 293, 6, (FPS / 4) + 1);
            }

            if(p[9] < FPS) {
                p[2] = 4;

                if(p[9] > (FPS / 2)) {
                    p[2] = 5;
                }
            } else {
                if(p[9] == FPS) {
                    if(p[0] < 45) {
                        p[0]++;
                    }
                }

                p[2] = 4;
            }

            if(p[9] > (FPS + (FPS / 2))) {
                p[9] = 0;
                p[8] = 0;
            }

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            if(0 == 0) {
                int[] pp = work[1];

                {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                            if(work[0][23] == 0) {
                                if(pp[13] < 0xffff) {
                                    pp[13] = 0x10000 + FPS;
                                }
                            }
                        }
                    }
                }
            }

            return;
        } else if(work[0][23] > 0) {
            int dir = Showtime_move(p);

            if((dir >= 0) && (dir < 4)) {
                if(p[9] == 0) {
                    int nx = (24);
                    int ny = (20);
                    int x = p[5] + (WalkTbl[dir][0] * nx);
                    int y = p[6] + (WalkTbl[dir][1] * ny);

                    if(getField(x, y, 0) == 0) {
                        dir = (dir + 2) % 4;
                    }

                    p[9] = 4 - 1;
                    p[10] = dir;
                    p[7] = p[10];
                }
            }

            if(dir == 4) {
                setImg = 0;
                p[2] = 8;
            }

            if(dir == 1000) {
                stomp = 1;
            }
        } else if(work[0][25] > 0) {
            p[2] = 3;

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            if((work[0][25] & 1) == 0) {
                p[2] = -1;
            }

            return;
        }

        if(work[0][30] != 0) {
            if(p[8] < 8) {
                p[8] = 8;
            }
        }

        if(p[9] == 0) {
            if(p[8] == 8) {
                p[8] = 9;
            }
        }

        if(work[0][29] != 0) {
            if(p[9] == 0) {
                if(work[0][23] == 0) {
                    if(p[8] != 9) {
                        int dir = p[7] = ((p[5] < (24 * 5)) ? 3 : 1);
                        int nx = (24);
                        int ny = (20);
                        int x = p[5] + (WalkTbl[dir][0] * nx);
                        int y = p[6] + (WalkTbl[dir][1] * ny);

                        if(getField(p[5], p[6], 0) == 0) {
                            main.deadEnemyList |= (1 << p[18]);

                            work[0][6]--;
                            work[0][10]--;

                            if(p[14] > 0) {
                                chara[p[14] - 1][0] = 0;
                            }

                            p[0] = 0;

                            return;
                        }

                        if((getField(x, y, 0) != 0) || (((stimer / 4) % FPS) == (FPS / 2))) {
                            if((stimer % (2 + (4 / 2))) == 1) {
                                p[9] = 4 - 1;
                            }
                        } else {
                            setImg = 0;
                            p[2] = 8;
                        }
                    }
                }
            }
        } else if(p[9] == 0) {
            if(work[0][23] == 0) {
                if(p[8] != 9) {
                    if((stimer % (14 - p[16])) == 1) {
                        int[] t = { 0, 1, 3, 2, };
                        int aa = -1;

                        if(((stimer / (14 - p[16])) % 23) == 6) {
                            p[15] = 5 + 1;
                        }

                        if(0 == 0) {
                            for(int i = 0; i < 4; i++) {
                                int dir = (p[7] + t[i]) % 4;
                                int nx = (24);
                                int ny = (20);
                                int x = p[5] + (WalkTbl[dir][0] * nx);
                                int y = p[6] + (WalkTbl[dir][1] * ny);

                                int a = getField(x, y, 0);

                                if((a == 2) || (a == 3) || (a == (p[15] - 1)) || ((work[0][22] != 0) && (a == 1))) {
                                    if(a > aa) {
                                        p[9] = 4 - 1;
                                        p[7] = dir;
                                        p[15] = a + 1;

                                        if((a != 1) || (work[0][22] != 0)) {
                                            break;
                                        }

                                        aa = a;
                                    }
                                }
                            }
                        }

                        if(0 == 0) {
                            if(p[9] == 0) {
                                if(((stimer / (14 - p[16])) % 10) == 6) {
                                    p[7] = (main.rnd.nextInt() & 0xffff) % 4;
                                }

                                int[] kyoro = { 0, 9, 9, 10, 11, 10, 11, };

                                if(((stimer / (14 - p[16])) % 23) < kyoro.length) {
                                    setImg = 0;

                                    p[2] = kyoro[(stimer / (14 - p[16])) % kyoro.length];
                                } else {
                                    if((p[2] == 9) || (p[2] == 10) || (p[2] == 11)) {
                                        p[2] = 0;
                                    }

                                    stomp = 1;
                                }
                            } else {
                                if((p[2] == 9) || (p[2] == 10) || (p[2] == 11)) {
                                    p[2] = 0;
                                }
                            }
                        }

                        if(5 >= 4) {
                            p[16] = (8 - 5) + ((p[0] - 42) * 2) + work[0][20];
                        } else {
                            p[16] = 6 + (p[0] - 42) + work[0][20];
                        }
                    } else if((stimer % (14 - p[16])) == (4 + 1)) {
                        int[][] dd = {
                                { 0, 1, 3, 2, },
                                { 0, 3, 1, 2, },
                                { 1, 0, 3, 2, },
                                { 3, 0, 1, 2, },
                            };

                        int[] t = dd[((stimer >> 5) + p[0]) & 3];

                        if(((stimer / 14) % 10) == 9) {
                            t = dd[main.rnd.nextInt() & 3];
                        }

                        int aa = -1;

                        for(int i = 0; i < 4; i++) {
                            int dir = (p[7] + t[i]) % 4;
                            int nx = (24);
                            int ny = (20);
                            int x = p[5] + (WalkTbl[dir][0] * nx);
                            int y = p[6] + (WalkTbl[dir][1] * ny);

                            int a = getField(x, y, 0);

                            if((a == 2) || (a == 3) || (a == (p[15] - 1)) || ((work[0][22] != 0) && (a == 1))) {
                                if(a > aa) {
                                    p[7] = dir;

                                    if((a != 1) || (work[0][22] != 0)) {
                                        break;
                                    }

                                    aa = a;
                                }
                            }
                        }
                    }
                }
            }
        }

        if(0 == 0) {
            int[] pp = work[1];

            {
                int ax = pp[5] - p[5];
                int ay = pp[6] - p[6];

                if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                    if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                        if(work[0][23] == 0) {
                            if(pp[13] < 0xffff) {
                                pp[13] = 0x10000 + FPS;
                            }
                        }
                    }
                }
            }
        }

        if((p[2] == 9) || (p[2] == 10) || (p[2] == 11)) {
            ;
        } else if(setImg != 0) {
            p[2] = Slime_motion[p[7]] + 0;
        }

        if(p[9] > 0) {
            int nx;
            int ny;

            if((4 - 1) == 4) {
                int i = (p[9] - 1) & 1;
                nx = ((24 / 2) + i) / 2;
                ny = ((20 / 2) + i) / 2;
            } else if((4 - 1) == 3) {
                int i = p[9] - 1;
                nx = 24 / 3;
                ny = (20 + i) / 3;
            } else {
                nx = 24 / 2;
                ny = 20 / 2;
            }

            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);

            if(p[9] > 1) {
                p[2] = Slime_motion[p[7]] + 1;
                shad = 1;
            }

            p[9]--;

            if(0 == 0) {
                int[] pp = work[1];

                {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                            if(work[0][23] == 0) {
                                if(pp[13] < 0xffff) {
                                    pp[13] = 0x10000 + FPS;
                                }
                            }
                        }
                    }
                }
            }
        } else if(stomp > 0) {
            int a = Slime_motion[p[7]] + 1;
            shad = 1;

            if(p[17] == a) {
                a = Slime_motion[p[7]] + 0;
                shad = 0;
            }

            p[2] = a;
        }

        {
            int a = getField(p[5], p[6], 0);

            if((a >= 5) && (a <= 9)) {
                p[12] = (-1 - 4) * 2;
                p[3] = 6;
            } else {
                p[12] = -1 * 2;
            }
        }

        if(shad != 0) {
            if(p[14] > 0) {
                if(p[12] >= (-1 * 2)) {
                    chara[p[14] - 1][2] = 292;
                    chara[p[14] - 1][5] = p[5];
                    chara[p[14] - 1][6] = p[6];
                }
            }

            if(p[9] == (4 - 4)) {
                p[12] -= (2 * 2);
            } else if(p[9] > (4 - 4)) {
                p[12] -= (6 * 2);
            }
        }

        p[17] = p[2];
        p[2] = p[17] + ImageData[p[0]];
    }

    void Dragon_move(int[] p) {
        int setImg = 1;
        int stomp = 0;

        p[2] = p[17];
        p[3] = 3;

        if(p[8] == 10) {
            p[2] = 24;

            p[12] -= 2;

            if(p[12] <= ((-1 - 4) * 2)) {
                p[12] = -1 * 2;
                p[8] = 0;
            }

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            return;
        } else if(p[13] != 0) {
            if(p[8] == 9) {
                p[8] = 0;
                p[9] = 0;
            }

            if(work[0][3] != 1) {
                if(p[13] == 0xffff) {
                    main.deadEnemyList |= (1 << p[18]);

                    work[0][6]--;
                    work[0][10]--;
                    work[0][35] += ((1 << work[0][37]) * 1000);
                    work[0][37]++;
                    work[0][36] = 2;
                    work[0][38] = p[5];
                    work[0][39] = p[6];
                    p[0] = 0;

                    return;
                } else {
                    if(p[13] > 0xffff) {
                        if(p[13] == (0x10000 + 4)) {
                            p[2] = 0;
                        } else {
                            p[2] = Dragon_out_motion[p[7]];
                        }

                        if(p[12] < ((-1 - 2) * 2)) {
                            p[12] = (-1 - 2) * 2;
                        }
                    } else {
                        int a = getField(p[5], p[6], 0);

                        if((a >= 5) && (a <= 9)) {
                            p[12] = (-1 - 4) * 2;
                            p[3] = 6;
                        } else if(p[12] < ((-1 - 2) * 2)) {
                            p[12] = (-1 - 2) * 2;
                        }
                    }

                    p[13]--;
                }
            }

            p[17] = p[2];

            if(p[13] < 0xffff) {
                p[2] = 4;

                if(p[13] < (FPS * 6)) {
                    p[2] = 7;

                    if(p[13] > (FPS * 2)) {
                        if((p[13] % (FPS / 2)) < (FPS / 4)) {
                            p[2] = 8;
                        }
                    }
                }

                p[17] = p[2];

                if(p[13] <= (FPS * 2)) {
                    if((stimer & 2) == 0) {
                        p[2] = -1;

                        return;
                    }
                }
            }

            p[2] = p[17] + ImageData[p[0]];

            return;
        } else if(p[8] == 9) {
            if((++p[9] % (FPS / 3)) == 1) {
                addNone(p[5], p[6] - 20 - (20 / 2), 293, 6, (FPS / 4) + 1);
            }

            if(p[9] < FPS) {
                p[2] = 5;

                if(p[9] > (FPS / 2)) {
                    p[2] = 6;
                }
            } else {
                if(p[9] == FPS) {
                    if(p[0] < 47) {
                        p[0]++;
                    }
                }

                p[2] = 5;
            }

            if(p[9] > (FPS + (FPS / 2))) {
                p[9] = 0;
                p[8] = 0;
            }

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            if(0 == 0) {
                int[] pp = work[1];

                {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                            if(work[0][23] == 0) {
                                if(pp[13] < 0xffff) {
                                    pp[13] = 0x10000 + FPS;
                                }
                            }
                        }
                    }
                }
            }

            return;
        } else if(work[0][23] > 0) {
            int dir = Showtime_move(p);

            if((dir >= 0) && (dir < 4)) {
                if(p[9] == 0) {
                    int nx = (24);
                    int ny = (20);
                    int x = p[5] + (WalkTbl[dir][0] * nx);
                    int y = p[6] + (WalkTbl[dir][1] * ny);

                    if(getField(x, y, 0) == 0) {
                        dir = (dir + 2) % 4;
                    }

                    p[9] = 4;
                    p[10] = dir;
                    p[7] = p[10];
                }
            }

            if(dir == 4) {
                setImg = 0;
                p[2] = 9;
            }

            if(dir == 1000) {
                stomp = 1;
            }

            p[14] = 0;
        } else if(work[0][25] > 0) {
            p[2] = 4;

            p[17] = p[2];
            p[2] = p[17] + ImageData[p[0]];

            if((work[0][25] & 1) == 0) {
                p[2] = -1;
            }

            return;
        }

        if(work[0][30] != 0) {
            if(p[8] < 8) {
                p[8] = 8;
            }
        }

        if(p[9] == 0) {
            if(p[8] == 8) {
                p[8] = 9;
            }
        }

        if(work[0][29] != 0) {
            if(p[9] == 0) {
                if(work[0][23] == 0) {
                    if(p[8] != 9) {
                        int dir = p[7] = p[10] = ((p[5] < (24 * 5)) ? 3 : 1);
                        int nx = (24);
                        int ny = (20);
                        int x = p[5] + (WalkTbl[dir][0] * nx);
                        int y = p[6] + (WalkTbl[dir][1] * ny);

                        if(getField(p[5], p[6], 0) == 0) {
                            main.deadEnemyList |= (1 << p[18]);

                            work[0][6]--;
                            work[0][10]--;
                            p[0] = 0;

                            return;
                        }

                        if((getField(x, y, 0) != 0) || (((stimer / 4) % FPS) == (FPS - 1))) {
                            if((stimer % (2 + (4 / 2))) == 2) {
                                p[9] = 4;
                            }
                        } else {
                            setImg = 0;
                            p[2] = 9;
                        }
                    }
                }
            }
        } else if(p[9] == 0) {
            if(work[0][23] == 0) {
                if(p[8] != 9) {
                    if((p[14] == 0) || (p[15] > (2 + 1))) {
                        if((stimer % (14 - p[16])) == 2) {
                            int[] pp = work[1];
                            int ax = pp[5] - p[5];
                            int bx = ax;
                            int ay = pp[6] - p[6];
                            int by = ay;

                            if(ax < 0) {
                                ax = -ax;
                            }

                            if(ay < 0) {
                                ay = -ay;
                            }

                            int d = 0;

                            if(ax >= ay) {
                                d = ((bx >= 0) ? 1 : 3);
                            } else {
                                d = ((by >= 0) ? 2 : 0);
                            }

                            int[][] dd = {
                                    { -1, 0, 1, 3, 2, },
                                    { -1, 0, 3, 1, 2, },
                                    { 1, 0, 3, 2, },
                                    { 3, 0, 1, 2, },
                                };
                            dd[0][0] = d - p[7];
                            dd[1][0] = d - p[7];

                            int[] t = dd[((stimer >> 4) + p[0]) & 3];

                            if(((stimer / 14) % 10) == 6) {
                                t = dd[main.rnd.nextInt() & 3];
                            }

                            int aa = -1;

                            if(((stimer / (14 - p[16])) % 23) == 1) {
                                p[15] = 5 + 1;
                            }

                            if(0 == 0) {
                                for(int i = 0; i < t.length; i++) {
                                    int dir = (p[7] + t[i]) % 4;
                                    int nx = (24);
                                    int ny = (20);
                                    int x = p[5] + (WalkTbl[dir][0] * nx);
                                    int y = p[6] + (WalkTbl[dir][1] * ny);

                                    int a = getField(x, y, 0);

                                    if((a == 2) || (a == 3) || (a == (p[15] - 1)) || ((work[0][22] != 0) && (a == 1))) {
                                        if(a > aa) {
                                            p[9] = 4;
                                            p[10] = dir;
                                            p[7] = p[10];
                                            p[15] = a + 1;

                                            if((a != 1) || (work[0][22] != 0)) {
                                                break;
                                            }

                                            aa = a;
                                        }
                                    }
                                }
                            }

                            if(0 == 0) {
                                if(p[9] == 0) {
                                    if(((stimer / (14 - p[16])) % 10) == 6) {
                                        p[7] = (main.rnd.nextInt() & 0xffff) % 4;
                                    }

                                    stomp = 1;
                                }
                            }

                            if(5 >= 4) {
                                p[16] = (8 - 5) + ((p[0] - 46) * 2) + work[0][20];
                            } else {
                                p[16] = 6 + (p[0] - 46) + work[0][20];
                            }
                        }
                    }
                }
            }
        }

        if(0 == 0) {
            int[] pp = work[1];

            {
                int ax = pp[5] - p[5];
                int ay = pp[6] - p[6];

                if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                    if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                        if(work[0][23] == 0) {
                            if(pp[13] < 0xffff) {
                                pp[13] = 0x10000 + FPS;
                            }
                        }
                    }
                }
            }
        }

        int FireId = -1;

        if(setImg != 0) {
            p[2] = Dragon_motion[p[7]] + 0;
        }

        int FIRE_TIME = FPS * 4;

        if(p[14] > 0) {
            if(p[9] == 0) {
                if(p[15] <= (2 + 1)) {
                    p[14]--;
                    p[7] |= 1;

                    if(p[14] <= 1) {
                        p[2] = ((p[7] == 1) ? 13 : 19);
                    } else if(p[14] > (FIRE_TIME - 4)) {
                        p[2] = ((p[7] == 1) ? 16 : 22);
                    } else {
                        int id = addChara(49, p[0] - 46, 4, p[5], p[6], p[7]);

                        if(id >= 0) {
                            int[] pp = chara[id];
                            pp[9] = -1;
                            FireId = id;
                        }

                        int a = ((p[7] == 1) ? 17 : 23);

                        p[2] = a;
                    }
                }
            }
        } else if((stimer % (FPS * 16)) == (FPS * 9)) {
            if(work[0][23] == 0) {
                if(work[0][29] == 0) {
                    p[14] = FIRE_TIME;
                }
            }
        }

        if(p[9] > 0) {
            int nx;
            int ny;

            if(4 == 4) {
                int i = (p[9] - 1) & 1;
                nx = ((24 / 2) + i) / 2;
                ny = ((20 / 2) + i) / 2;
            } else if(4 == 3) {
                int i = p[9] - 1;
                nx = 24 / 3;
                ny = (20 + i) / 3;
            } else {
                nx = 24 / 2;
                ny = 20 / 2;
            }

            p[5] += (WalkTbl[p[10]][0] * nx);
            p[6] += (WalkTbl[p[10]][1] * ny);

            int a = Dragon_motion[p[7]] + 1;

            if(p[17] == a) {
                a++;
            }

            p[2] = a;

            p[9]--;

            if(0 == 0) {
                int[] pp = work[1];

                {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax <= (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay <= (20 / 2)) && (ay >= (-20 / 2))) {
                            if(work[0][23] == 0) {
                                if(pp[13] < 0xffff) {
                                    pp[13] = 0x10000 + FPS;
                                }
                            }
                        }
                    }
                }
            }
        } else if(stomp > 0) {
            int a = Dragon_motion[p[7]] + 1;

            if(p[17] == a) {
                a++;
            }

            p[2] = a;
        }

        {
            int a = getField(p[5], p[6], 0);

            if((a >= 5) && (a <= 9)) {
                p[12] = (-1 - 4) * 2;
                p[3] = 6;
            } else {
                p[12] = -1 * 2;
            }

            if(FireId >= 0) {
                int[] pp = chara[FireId];
                pp[12] = p[12] - 2;
            }
        }

        p[17] = p[2];
        p[2] = p[17] + ImageData[p[0]];
    }

    void Rock_move(int[] p) {
        if(p[9] == -1) {
            int[] pp = work[1];

            if(pp[13] == 0) {
                p[9] = 0;
            }
        }

        if(work[0][23] > 0) {
            int a = ImageData[p[0]];

            if(p[2] == a) {
                p[2]++;
            } else {
                p[2] = a;
            }

            return;
        }

        if(p[9] == 0) {
            if(p[16] > 0) {
                p[7] = p[16] - 1;
                p[16] = 0;

                if(p[1] != 0) {
                    p[1] ^= 3;
                }
            }
        }

        if(p[9] == 0) {
            if(work[0][23] == 0) {
                byte[][] ddt = {
                        { 0, 1, 3, 2, },
                        { 1, 0, 3, 2, },
                        { 3, 0, 1, 2, },
                    };
                byte[] dd = ddt[p[1]];
                int nx = (24);
                int ny = (20);

                int dir2 = (p[7] + 2) % 4;
                int dx2 = WalkTbl[dir2][0] * nx;
                int dy2 = WalkTbl[dir2][1] * ny;

                if(0 == 0) {
                    for(int i = 0; i < 4; i++) {
                        int dir = (p[7] + dd[i]) % 4;

                        int x = p[5] + (WalkTbl[dir][0] * nx);
                        int y = p[6] + (WalkTbl[dir][1] * ny);

                        if(getField(x, y, 0) == 1) {
                            if((p[1] == 0) || (i > 0) || (getField(x + dx2, y + dy2, 0) != 1)) {
                                int t = Gametimer / (50 * FPS);
                                t += (3 - (FPS / 5));

                                if(t > 5) {
                                    t = 5;
                                }

                                p[9] = 6 - t;
                                p[14] = t;
                                p[15] = 0;
                                p[7] = dir;

                                break;
                            }
                        }
                    }
                }
            }
        }

        if(0 == 0) {
            int[] pp = work[1];

            {
                int ax = pp[5] - p[5];
                int ay = pp[6] - p[6];

                if((ax < (24 / 2)) && (ax >= (-24 / 2))) {
                    if((ay < (20 / 2)) && (ay >= (-20 / 2))) {
                        if(pp[13] < 0xffff) {
                            pp[13] = 0x10000 + FPS;
                        }

                        p[9] = -1;
                    }
                }
            }
        }

        if(p[9] > 0) {
            byte[][] nxy = {
                    { 4, 4, 4, 4, 4, 4, },
                    { 4, 3, 3, 4, 3, 3, },
                    { 5, 5, 5, 5, 4, },
                    { 4, 4, 4, 4, 4, },
                    { 6, 6, 6, 6, },
                    { 5, 5, 5, 5, },
                    { 8, 8, 8, },
                    { 7, 7, 6, },
                    { 12, 12, },
                    { 10, 10, },
                    { 24, },
                    { 20, },
                };
            int nx = nxy[p[14] * 2][p[15]];
            int ny = nxy[(p[14] * 2) + 1][p[15]++];
            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);
            p[9]--;

            if(0 == 0) {
                int[] pp = work[1];

                {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax < (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay < (20 / 2)) && (ay >= (-20 / 2))) {
                            if(pp[13] < 0xffff) {
                                pp[13] = 0x10000 + FPS;
                            }

                            p[9] = -1;
                        }
                    }
                }
            }

            int a = ImageData[p[0]];

            if(p[2] == a) {
                p[2]++;
            } else {
                p[2] = a;
            }

            for(int i = 0; i < chara.length; i++) {
                int[] pp = chara[i];

                if(pp == null) {
                    break;
                }

                if((pp[0] > 41) && (pp[0] < 48)) {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax < (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay < (20 / 2)) && (ay >= (-20 / 2))) {
                            if((ax * WalkTbl[p[7]][0]) >= 0) {
                                if((ay * WalkTbl[p[7]][1]) >= 0) {
                                    pp[13] = 0x10000 + 4;
                                    pp[5] += (WalkTbl[p[7]][0] * nx);
                                    pp[6] += (WalkTbl[p[7]][1] * ny);
                                    pp[7] = p[7];

                                    p[16] = ((p[7] + 2) % 4) + 1;
                                }
                            }
                        }
                    }
                } else if(pp[0] == 54) {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax < (24 / 2)) && (ax >= (-24 / 2))) {
                        if((ay < (20 / 2)) && (ay >= (-20 / 2))) {
                            if(pp[14] > 0) {
                                if(pp[14] > 0) {
                                    main.deadEnemyList |= (1 << pp[18]);

                                    work[0][6]--;

                                    if(pp[14] < 800) {
                                        work[0][12]--;
                                    }
                                }

                                pp[0] = 0;

                                p[16] = ((p[7] + 2) % 4) + 1;
                            }
                        }
                    }
                }
            }
        }
    }

    void Fire_move(int[] p) {
        if(++p[9] >= (1 + fa_img[p[1]].length)) {
            p[0] = 0;

            return;
        }

        if(p[9] <= 0) {
            return;
        }

        if(0 == 0) {
            int[] pp = work[1];

            {
                int a = pp[5] - p[5];

                if(pp[6] == p[6]) {
                    if((a <= ((24 * 2) / 3)) && (a >= ((-24 * 2) / 3))) {
                        if(pp[13] < 0xffff) {
                            pp[13] = 0x10000 + FPS;
                            pp[17] = 7;
                        }
                    }
                }
            }
        }

        {
            int t = p[9] - 1;
            int nx = (24 * 2) / 3;

            p[5] += (WalkTbl[p[7]][0] * nx);

            if(p[9] > 1) {
                p[12] += (2 * 2);

                if(p[12] > (-2 * 2)) {
                    p[12] = -2 * 2;
                }
            }

            p[2] = fa_img[p[1]][t];

            if(p[7] == 3) {
                p[2] += (284 - 278);
            }

            if((stimer & ((FPS >= 8) ? 2 : 1)) != 0) {
                p[2]++;
            }
        }
    }

    private static final int[][] fa_img = {
            { 278, 280, 280, 280, 282, },
            { 278, 280, 280, 280, 280, 282, },
        };

    void Block_move(int[] p) {
        int killF = 0;
        int MovedF = 0;

        if(p[9] == 0) {
            if(work[0][3] != 0) {
                p[14] = 1;
            }

            int nx = (24);
            int ny = (20);
            int x = p[5] + (WalkTbl[p[7]][0] * nx);
            int y = p[6] + (WalkTbl[p[7]][1] * ny);

            int a0 = getField(x, y, 0);

            if((a0 >= 2) && (a0 <= 4) && (work[0][3] == 0)) {
                if(p[14] == 0) {
                    work[0][9]++;
                    MovedF = 1;
                }

                p[9] = 2;
                p[14] = 1;
                p[2] = ImageData[p[0]];
                work[0][8]++;
            } else if(p[14] != 0) {
                int a = getField(p[5], p[6], p[0]);

                killF = 1;
            } else {
                work[0][9]++;
                MovedF = 1;
                work[0][7]--;
                main.point += 10;

                p[2] = ImageData[p[0]];

                addChara(51, 5, 5, p[5], p[6], 0);
                addChara(51, 5, 5, p[5], p[6], 1);
                addChara(51, 5, 5, p[5], p[6], 2);
                addChara(51, 5, 5, p[5], p[6], 3);

                main.sePlay(21);

                killF = 1;
            }
        }

        if(p[9] != 0) {
            int nx = (24 / 2);
            int ny = (20 / 2);

            Block_attack_enemy(p, 0);

            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);
            p[9]--;

            if(getField(p[5], p[6], 0) == 3) {
                getField(p[5], p[6], 2);
            }
        }

        if(p[14] != 0) {
            Block_attack_enemy(p, 1);
        }

        if(work[0][34] == 0) {
            if(MovedF != 0) {
                if(work[0][9] >= 15) {
                    int af = 36 + 1 + ((main.rnd.nextInt() & 0xfffff) % (41 - 36 - 1));

                    {
                        int k = 0;

                        for(int j = 1; j < (field.length - 2); j++)
                            for(int i = 1; i < (field[j].length - 2); i++) {
                                if(field[j][i] == 2) {
                                    if(field[j][i + 1] == 2) {
                                        if(field[j + 1][i] == 2) {
                                            if(field[j + 1][i + 1] == 2) {
                                                k++;
                                            }
                                        }
                                    }
                                }
                            }

                        if(k > 0) {
                            k = (main.rnd.nextInt() & 0xfffff) % k;
                        }

                        for(int j = 1; j < (field.length - 2); j++)
                            for(int i = 1; i < (field[j].length - 2); i++) {
                                if(field[j][i] == 2) {
                                    if(field[j][i + 1] == 2) {
                                        if(field[j + 1][i] == 2) {
                                            if(field[j + 1][i + 1] == 2) {
                                                if(--k < 0) {
                                                    getCharaPos(i, j);

                                                    int xx = CharaPosX;
                                                    int yy = CharaPosY;

                                                    int id = addChara(af, 0, 2, xx + 24, yy + 20, 0);

                                                    if(id >= 0) {
                                                        int[] pp = chara[id];
                                                        pp[2] = ImageData[pp[0]];
                                                    }

                                                    i = j = 1000;

                                                    break;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                    }

                    work[0][34] = 1;
                }
            }
        }

        if(killF != 0) {
            p[0] = 0;
        }
    }

    void Block_attack_enemy(int[] p, int mode) {
        if(true) {
            int nx = (24 / 2);
            int ny = (20 / 2);

            for(int i = 0; i < chara.length; i++) {
                int[] pp = chara[i];

                if(pp == null) {
                    break;
                }

                if((pp[0] > 41) && (pp[0] < 48)) {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if(pp[13] != (0x10000 + 4)) {
                        if(pp[3] < 6) {
                            if((ax < (24 / 2)) && (ax > (-24 / 2))) {
                                if((ay < (20 / 2)) && (ay > (-20 / 2))) {
                                    pp[13] = 0x10000 + 4;
                                    pp[5] += (WalkTbl[p[7]][0] * nx);
                                    pp[6] += (WalkTbl[p[7]][1] * ny);
                                    pp[7] = p[7];
                                }
                            }
                        }
                    }

                    if(pp[13] != (0x10000 + 4)) {
                        if(pp[9] != 0) {
                            ax += ((WalkTbl[pp[7]][0] * 24) / 2);
                            ay += ((WalkTbl[pp[7]][1] * 20) / 2);

                            if(pp[3] < 6) {
                                if((ax < (24 / 2)) && (ax > (-24 / 2))) {
                                    if((ay < (20 / 2)) && (ay > (-20 / 2))) {
                                        pp[13] = 0x10000 + 4;
                                        pp[5] += (WalkTbl[p[7]][0] * nx);
                                        pp[6] += (WalkTbl[p[7]][1] * ny);
                                        pp[7] = p[7];
                                    }
                                }
                            }
                        }
                    }
                } else if((pp[0] == 54) && (mode != 0)) {
                    int ax = pp[5] - p[5];
                    int ay = pp[6] - p[6];

                    if((ax < (24 / 2)) && (ax > (-24 / 2))) {
                        if((ay < (20 / 2)) && (ay > (-20 / 2))) {
                            FruitUp(pp[1], pp);

                            if(pp[14] > 0) {
                                main.deadEnemyList |= (1 << pp[18]);

                                work[0][6]--;

                                if(pp[14] < 800) {
                                    work[0][12]--;
                                }
                            }

                            pp[0] = 0;
                        }
                    }
                }
            }
        }
    }

    void Hole_move(int[] p) {
        if(p[8] != 0) {
            if(p[8] == 1) {
                int i = addChara(p[1], p[14], 3, p[5], p[6], p[7]);

                if(i >= 0) {
                    int[] pp = chara[i];
                    pp[8] = 10;

                    pp[18] = p[18];

                    work[0][10]++;
                }

                p[8] = 2;
                p[2] = -1;

                int a2 = getField(p[5], p[6], 4);
            }

            if(--p[9] <= (FPS - 4)) {
                if(getField(p[5], p[6], 0) == 4) {
                    getField(p[5], p[6], 2);
                }

                if(p[17] > 0) {
                    p[17] = 0;
                    work[0][11]--;
                }

                p[16] = 0;
                p[0] = 0;
            }

            return;
        } else {
            if(MoveIdx > 0) {
                Fchara[FcharaPtr++] = p;

                return;
            }

            int a = getField(p[5], p[6], 0);

            if(a == 2) {
                getField(p[5], p[6], 3);

                if(p[9] < (FPS * 10)) {
                    p[9] = FPS * 10;
                }

                if(p[17] > 0) {
                    p[17] = 0;
                    work[0][11]--;
                }

                p[16] = 0;
                p[2] = -1;
            } else if(a != 3) {
                if(p[9] < (FPS * 5)) {
                    p[9] = FPS * 5;
                }

                if(p[17] > 0) {
                    p[17] = 0;
                    work[0][11]--;
                }

                work[0][16]++;

                if(result_time == (FPS / 2)) {
                    if(work[0][3] == 2) {
                        addPoint(1000, p[5], p[6]);
                    }
                }

                p[16] = 0;
                p[2] = -1;
            }

            if(p[16] > 0) {
            } else if(--p[9] == (FPS * 1)) {
                if(work[0][3] != 0) {
                    p[0] = 0;

                    return;
                }

                p[8] = 1;
            } else if(p[9] == (FPS * 3)) {
                if(work[0][3] != 0) {
                    return;
                }

                p[16] = ++LookingEnemyPtr;
                p[2] = -1;
            } else if(p[9] == ((FPS * 3) - 1)) {
                if(work[0][3] != 0) {
                    return;
                }

                if(p[17] == 0) {
                    p[17] = ++work[0][11];
                }

                p[2] = p[1] - 42 + 298;
            }
        }
    }

    private int Hole_change_Fruit(int[] p) {
        if(p[8] == 0) {
            int a = getField(p[5], p[6], 0);

            if(a != 3) {
            } else {
                if(p[17] > 0) {
                    p[17] = 0;
                    work[0][11]--;
                }

                getField(p[5], p[6], 2);

                return 1;
            }
        }

        return 0;
    }

    private int LookingEnemyPtr;

    void Hole_control() {
        if((stimer % 7) == 4) {
            if((work[0][11] + work[0][10] + work[0][12]) < 4) {
                int aa = 100000;
                int ai = -1;

                for(int i = 0; i < chara.length; i++) {
                    int[] pp = chara[i];

                    if(pp == null) {
                        break;
                    }

                    if(pp[0] == 3) {
                        if((pp[16] > 0) && (pp[16] < 4)) {
                            pp[16] = -1;
                        } else if(pp[16] > 0) {
                            if(pp[16] < aa) {
                                aa = pp[16];
                                ai = i;
                            }
                        }
                    }
                }

                if(ai >= 0) {
                    int[] pp = chara[ai];
                    pp[16] = -1;
                }
            }
        }
    }

    void Star_move(int[] p) {
        if(p[9] == 0) {
            if(work[0][3] != 0) {
                return;
            }

            int nx = (24);
            int ny = (20);
            int x = p[5] + (WalkTbl[p[7]][0] * nx);
            int y = p[6] + (WalkTbl[p[7]][1] * ny);

            int a0 = getField(x, y, 0);

            if((a0 >= 2) && (a0 <= 4)) {
                p[9] = 2;
                p[14] = 1;
                p[2] = ImageData[p[0]];
            } else {
                p[2] = ImageData[p[0]];

                int a = (main.rnd.nextInt() & 0xffffff) % (36 - 11);

                addChara(52, ((a == 0) ? 10 : (11 + a)), 2, p[5], p[6], 0);

                addChara(51, 6, 5, p[5], p[6], 0);
                addChara(51, 6, 5, p[5], p[6], 1);
                addChara(51, 6, 5, p[5], p[6], 2);
                addChara(51, 6, 5, p[5], p[6], 3);

                main.sePlay(21);

                p[0] = 0;
            }
        }

        if(p[9] != 0) {
            int nx = (24 / 2);
            int ny = (20 / 2);

            Block_attack_enemy(p, 0);

            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);
            p[9]--;

            if(getField(p[5], p[6], 0) == 3) {
                getField(p[5], p[6], 2);
            }
        }

        if(p[14] != 0) {
            Block_attack_enemy(p, 1);
        }
    }

    void Heart_move(int[] p) {
        if((work[0][42] == 0) && (work[0][43] == 0)) {
            if(p[9] == 0) {
                int nx = (24);
                int ny = (20);
                int x = p[5] + (WalkTbl[p[7]][0] * nx);
                int y = p[6] + (WalkTbl[p[7]][1] * ny);

                int a0 = getField(x, y, 0);

                if((a0 >= 2) && (a0 <= 4) && (work[0][3] == 0)) {
                    p[9] = 2;
                    p[14] = 1;
                    p[2] = ImageData[p[0]];
                } else {
                    int a = getField(p[5], p[6], p[0]);

                    if(work[0][3] == 0) {
                        if(work[0][24] == 0) {
                            int kick = 0;

                            {
                                byte[][] ofs = {
                                        { 24, 0, -24, 0, -1, 0, },
                                        { 0, 20, 0, -20, -1, 1, },
                                        

                                        { 24, 0, 24 * 2, 0, 0, 0, },
                                        { -24, 0, -24 * 2, 0, 0, 0, },
                                        

                                        { 0, 20, 0, 20 * 2, 0, 1, },
                                        { 0, -20, 0, -20 * 2, 0, 1, },
                                    };

                                for(int i = 0; i < ofs.length; i++) {
                                    int a1 = getField(p[5] + ofs[i][0], p[6] + ofs[i][1], 0);
                                    int a2 = getField(p[5] + ofs[i][2], p[6] + ofs[i][3], 0);

                                    if((a1 == 7) || (a1 == 8)) {
                                        if((a2 == 7) || (a2 == 8)) {
                                            if(ofs[i][4] < 0) {
                                                addChara(53, 1, 7, p[5], p[6], 0);
                                            } else {
                                                addChara(53, 1, 7, p[5] + ofs[i][0], p[6] + ofs[i][1], 0);
                                            }

                                            work[0][24] = 1;

                                            work[0][23] = FPS * (20 + 10);
                                            ShowtimeStep = 0;
                                            ShowtimeCom = 0;

                                            ShowtimeOpt = 2;

                                            kick = 1;

                                            work[0][20] = 0;
                                            work[0][21] = 0;

                                            bgmNo = -1;

                                            main.sePlay(17);

                                            int bonus = 10000;

                                            if(ofs[i][5] == 0) {
                                                bonus = 5000;
                                                ShowtimeOpt = 1;
                                            }

                                            for(int k = 0; k < 4; k++) {
                                                int dx = WalkTbl[k][0] * 24;
                                                int dy = WalkTbl[k][1] * 20;

                                                if((getField(p[5] + dx, p[6] + dy, 0) <= 1) ||
                                                        (getField(p[5] + ofs[i][0] + dx, p[6] + ofs[i][1] + dy, 0) <= 1) ||
                                                        (getField(p[5] + ofs[i][2] + dx, p[6] + ofs[i][3] + dy, 0) <= 1)) {
                                                    bonus = 2000;
                                                    ShowtimeOpt = 0;

                                                    break;
                                                }
                                            }

                                            work[0][40] = bonus;
                                            main.point += bonus;

                                            break;
                                        }
                                    }
                                }
                            }

                            if(kick == 0) {
                                check_2heart();
                            }
                        }
                    }

                    p[0] = 0;
                }
            }
        }

        if(p[9] != 0) {
            int nx = (24 / 2);
            int ny = (20 / 2);

            Block_attack_enemy(p, 0);

            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);
            p[9]--;

            if(getField(p[5], p[6], 0) == 3) {
                getField(p[5], p[6], 2);
            }
        }

        if(p[14] != 0) {
            Block_attack_enemy(p, 1);
        }
    }

    void check_2heart() {
        if(work[0][24] == 0) {
            for(int i = 0; i < chara.length; i++) {
                int[] pp = chara[i];

                if(pp == null) {
                    break;
                }

                if(pp[0] == 8) {
                    int aa = getField(pp[5], pp[6], 0);

                    if(aa == 8) {
                        getField(pp[5], pp[6], 7);
                    }

                    pp[0] = 0;
                }
            }

            for(int iy = 0; iy < (20 * 14); iy += 20)
                for(int ix = 0; ix < (24 * 12); ix += 24) {
                    int a1 = getField(ix, iy, 0);

                    if((a1 == 7) || (a1 == 8)) {
                        for(int i = 0; i < 4; i++) {
                            int a2 = getField(ix + (WalkTbl[i][0] * 24), iy + (WalkTbl[i][1] * 20), 0);

                            if((a2 == 7) || (a2 == 8)) {
                                addChara(8, 0, 1, ix, iy, 0);
                            }
                        }
                    }
                }
        }
    }

    void Heart_flush(int[] p) {
        int a = getField(p[5], p[6], 0);

        if(work[0][23] > 0) {
            if(a == 8) {
                getField(p[5], p[6], 7);
            }

            p[0] = 0;

            return;
        } else if((a == 7) || (a == 8)) {
            getField(p[5], p[6], 7 + ((stimer >> 1) & 1));
        } else {
            for(int i = 0; i < chara.length; i++) {
                int[] pp = chara[i];

                if(pp == null) {
                    break;
                }

                if(pp[0] == 8) {
                    int aa = getField(pp[5], pp[6], 0);

                    if(aa == 8) {
                        getField(pp[5], pp[6], 7);
                    }

                    pp[0] = 0;
                }
            }

            p[0] = 0;

            return;
        }
    }

    void Heart_fly(int[] p) {
        if(p[9] == 0) {
            p[14] = p[5];
            p[15] = p[6];
        }

        if(p[1] > 0) {
            work[0][41] = 1;

            if(p[9] > (FPS * 2)) {
                work[0][26] = -2;

                int a = (p[9] - (FPS * 2)) * 8;

                if(a > (24 * 5)) {
                    a = 24 * 5;
                }

                work[0][27] = a;
            }
        }

        if((++p[9] < (FPS * 3)) || (work[0][27] < (24 * 5))) {
            int len = (p[9] * 2);
            int ang = (p[9] * 12) & 0xff;
            int x = p[5] = p[14] + ((sin(ang) * len) >> 12);
            int y = p[6] = p[15] + ((-cos(ang) * len) >> 12);

            if((x > 0) && (x < (24 * 11)) && (y > 0) && (y < (20 * 12))) {
                p[2] = 294;
            } else {
                p[2] = -1;
            }
        } else {
            if(p[1] > -4) {
                p[1]--;
            } else {
                work[0][41] = 0;
                p[0] = 0;
            }
        }
    }

    void Bomb_move(int[] p) {
        if(p[8] == 1) {
            if(++p[9] < (FPS * 1)) {
                int id = p[9] / (((FPS * 1) + 3) / 4);

                if(id > 0) {
                    p[12] = 15 * 2;
                }

                if(id >= 3) {
                    id = 1;
                }

                p[3] = 6;
                p[2] = 90 + id;

                for(int i = 0; i < chara.length; i++) {
                    int[] pp = chara[i];

                    if(pp == null) {
                        break;
                    }

                    if((pp[0] > 41) && (pp[0] < 48)) {
                        int a = pp[5] - p[5];
                        int b = pp[6] - p[6];

                        if(((a * a) + (b * b)) < ((24 * 3) * (24 * 3))) {
                            int t = FPS * 10;

                            if(pp[13] < t) {
                                pp[13] = t;
                            }
                        }
                    }
                }
            } else {
                p[0] = 0;
            }

            return;
        }

        if(p[9] == 0) {
            if(work[0][3] != 0) {
                return;
            }

            int nx = (24);
            int ny = (20);
            int x = p[5] + (WalkTbl[p[7]][0] * nx);
            int y = p[6] + (WalkTbl[p[7]][1] * ny);

            int a0 = getField(x, y, 0);

            if((a0 >= 2) && (a0 <= 4)) {
                p[9] = 2;
                p[14] = 1;
                p[2] = ImageData[p[0]];
            } else {
                p[8] = 1;

                main.sePlay(22);
            }
        }

        if(p[9] != 0) {
            int nx = (24 / 2);
            int ny = (20 / 2);

            Block_attack_enemy(p, 0);

            p[5] += (WalkTbl[p[7]][0] * nx);
            p[6] += (WalkTbl[p[7]][1] * ny);
            p[9]--;

            if(getField(p[5], p[6], 0) == 3) {
                getField(p[5], p[6], 2);
            }
        }

        if(p[14] != 0) {
            Block_attack_enemy(p, 1);
        }
    }

    void AFruit_move(int[] p) {
        int hitOn = 0;

        {
            int[] pp = work[1];

            {
                int ax = pp[5] - p[5];
                int ay = pp[6] - p[6];

                if((ax < 24) && (ax > -24)) {
                    if((ay < (20 / 2)) && (ay >= (-20 * 2))) {
                        if(ay < (-20 / 2)) {
                            if(ax < 0) {
                                hitOn |= 1;
                            } else {
                                hitOn |= 2;
                            }
                        } else {
                            if(ax < 0) {
                                hitOn |= 4;
                            } else {
                                hitOn |= 8;
                            }
                        }
                    }
                }
            }
        }

        if(hitOn != 0) {
            if(p[14] != hitOn) {
                if(p[15] < 4) {
                    addPoint(afruit_point[p[0] - 36 - 1][p[15]], p[5], p[6]);
                    FruitUp(p[0], p);

                    if(++p[15] < 4) {
                        p[2] = ImageData[p[0]] + p[15];
                    } else {
                        p[0] = 0;

                        return;
                    }
                }
            }
        }

        p[14] = hitOn;

        if(++p[9] > (FPS * 12)) {
            p[0] = 0;

            return;
        } else if(p[9] > (FPS * 8)) {
            if((p[9] & 2) == 0) {
                p[2] = -1;
            } else {
                p[2] = ImageData[p[0]] + p[15];
            }
        }
    }

    void Fruit_move(int[] p) {
        p[3] = 2;

        {
            int[] pp = work[1];

            {
                int ax = pp[5] - p[5];
                int ay = pp[6] - p[6];

                if((ax < (24 / 2)) && (ax > (-24 / 2))) {
                    if((ay < (20 / 2)) && (ay > (-20 / 2))) {
                        FruitUp(p[1], p);

                        if(p[14] > 0) {
                            main.deadEnemyList |= (1 << p[18]);

                            work[0][6]--;

                            if(p[14] < 800) {
                                work[0][12]--;
                            }
                        }

                        p[0] = 0;

                        return;
                    }
                }
            }
        }

        p[2] = ImageData[p[1]];

        if(++p[9] > (FPS * 12)) {
            if(p[14] > 0) {
                p[5] = (((p[5] + (24 * 10) + (24 / 2)) / 24) - 10) * 24;
                p[6] = (((p[6] + (20 * 10) + (20 / 2)) / 20) - 10) * 20;

                if(p[14] >= 800) {
                    int ix = addChara(3, p[14] - 800, 3, p[5], p[6], 2);

                    if(ix >= 0) {
                        work[0][6]++;

                        int[] pp = chara[ix];
                        pp[14] = p[1];

                        pp[18] = p[18];

                        pp[9] = FPS * 5;
                    }

                    work[0][6]--;
                } else {
                    int ix = addChara(p[14], p[1], 3, p[5], p[6], 2);

                    if(ix >= 0) {
                        work[0][6]++;
                        work[0][10]++;
                        work[0][12]--;

                        int[] pp = chara[ix];
                        pp[18] = p[18];
                    }

                    work[0][6]--;
                }
            }

            p[0] = 0;

            return;
        } else if(p[9] > (FPS * 8)) {
            if((p[9] & 2) == 0) {
                p[2] = -1;
            }
        }

        {
            int a = getField(p[5], p[6], 0);

            if(((a >= 5) && (a <= 9)) || (p[15] > 0)) {
                p[12] = (-1 - 4) * 2;
                p[3] = 6;
            } else {
                p[12] = -1 * 2;
            }

            if((a >= 5) && (a <= 9)) {
                p[15] = 1;
            } else {
                p[15] = 0;
            }
        }
    }

    private boolean FruitUp(int a, int[] p) {
        if(a == 10) {
            work[0][25] = FPS * 5;
            work[0][26] = 3;

            work[0][27] = 24 * 5;

            main.sePlay(22);

            return true;
        } else if((a >= 11) && (a < 41)) {
            main.fruitNum++;

            if(a < 36) {
                int aa = a - 11;

                addPoint(fruit_point[aa], p[5], p[6]);
            }

            if(main.fruitNum >= main.norma) {
                main.playerNum++;
                main.fruitNum = 0;
                main.normaLev++;

                work[0][43] = 1;

                main.norma = (main.normaLev * 10) + 10;

                if(main.norma > 99) {
                    main.norma = 99;
                }
            }

            return true;
        }

        return false;
    }

    void None_move(int[] p) {
        if(p[9] > 0) {
            p[9]--;
        }

        if(p[9] == 0) {
            p[0] = 0;
        }
    }

    void Scatter_move(int[] p) {
        int id = p[7];

        if(id == 0) {
            if(p[9] == 2) {
                addNone(p[5], p[6] - (2 * 2), 98, 3, ((FPS / 2) - 1));
            }
        }

        int[][] WalkTbl = {
                { -1, -1, },
                { 1, -1, },
                { 1, 1, },
                { -1, 1, },
            };

        if(p[9] == 0) {
            p[11] = (WalkTbl[id][0] * 24) / 4;
            p[12] = (WalkTbl[id][1] * (20 + 3)) / 4;
            p[12] += (-4 * 2);
        } else if(p[9] < 2) {
            p[11] += (WalkTbl[id][0] * 2);
            p[12] += (WalkTbl[id][1] * 2);
        }

        if(++p[9] > (FPS / 2)) {
            p[0] = 0;
        }

        p[2] = ImageData[p[1]] + (100 - 99) + id;
    }

    void Appear_move(int[] p) {
        if(p[9] == 0) {
            p[12] += (-1 * 2);
        }

        if(p[9] > 12) {
            int ix = addChara(54, p[1], 2, p[5], p[6], 0);

            p[0] = 0;
        } else {
            int cnt = ++p[9] - 4;

            if(cnt >= 0) {
                int dy = (((cnt - 4) < 0) ? (-1) : 1) * 2;
                p[12] += dy;

                if(p[12] > 0) {
                    p[12] = 0;
                }

                p[2] = ImageData[p[1]];
            }
        }
    }

    void addPoint(int num, int x, int y) {
        main.point += num;

        int n = ("" + num).length();
        int nx = (6 * n) + 2;

        nx *= 2;

        if((x - (nx / 2)) < (24 + (24 / 2))) {
            x = 24 + (24 / 2) + (nx / 2);
        }

        if((x + (nx / 2)) > ((24 * 11) + (24 / 2))) {
            x = ((24 * 11) + (24 / 2)) - (nx / 2);
        }

        if(y < (20 + 20)) {
            y = 20 + 20;
        } else if(y > ((20 * 12) + (20 / 2))) {
            y = (20 * 12) + (20 / 2);
        }

        int ix = addNone(x, y, 42, 6, FPS);

        if(ix >= 0) {
            chara[ix][1] = num;
        }
    }

    private int[] ShowtimeData = { 0, };
    private static int ShowtimeTempoCnt = 1;
    private static final int[] ShowtimeTempoData = { 170, 158, 250, 170, 156, 110, 158, 132, };
    private int ShowtimeStep;
    private int ShowtimeCom;
    private int ShowtimeOpt;

    int Showtime_move(int[] p) {
        int dir = -1;

        switch(ShowtimeCom) {
        case 0:
            dir = 1000;

        default:
            break;

        case 1:
            break;

        case 2:

            if(p[5] > (24 * 8)) {
                dir = 1;
            } else if(p[5] < (24 * 8)) {
                dir = 3;
            }

            break;

        case 3:

            if(p[5] > (24 * 8)) {
                dir = 3;
            } else if(p[5] < (24 * 8)) {
                dir = 1;
            }

            break;

        case 4:

            if(p[5] > (20 * 5)) {
                dir = 2;
            } else if(p[5] < (20 * 5)) {
                dir = 0;
            }

            break;

        case 5:

            if(p[5] > (20 * 5)) {
                dir = 0;
            } else if(p[5] < (20 * 5)) {
                dir = 2;
            }

            break;

        case 6:
        case 8:
        case 7:
        case 9:
            dir = 0 - 6 + ShowtimeCom;

            break;

        case 10:
        case 12:
        case 11:
        case 13:
            p[7] = 0 - 10 + ShowtimeCom;

            break;

        case 14:
            dir = (main.rnd.nextInt() & 0xffffff) % 4;

            break;

        case 15:
            dir = 4;

            break;
        }

        return dir;
    }

    void Showtime_end() {
        if(ShowtimeOpt != 0) {
            for(int i = 0; i < chara.length; i++) {
                int[] p = chara[i];

                if(p == null) {
                    break;
                }

                if((p[0] > 41) && (p[0] < 48)) {
                    int ix = addChara(54, p[1], 2, p[5], p[6], 0);

                    if(ix >= 0) {
                        int[] pp = chara[ix];
                        pp[14] = p[0];

                        pp[18] = p[18];

                        pp[12] = p[12];
                        work[0][12]++;
                    } else {
                        work[0][6]--;
                    }

                    work[0][10]--;

                    if((p[0] >= 42) && (p[0] <= 45)) {
                        if(p[14] > 0) {
                            chara[p[14] - 1][0] = 0;
                        }
                    }

                    p[0] = 0;
                } else if((p[0] == 3) && (ShowtimeOpt >= 2)) {
                    if(Hole_change_Fruit(p) != 0) {
                        int ix = addChara(54, p[14], 2, p[5], p[6], 0);

                        if(ix >= 0) {
                            int[] pp = chara[ix];
                            pp[14] = 800 + p[1];

                            pp[18] = p[18];
                        }

                        p[0] = 0;
                    }
                }
            }
        }

        ShowtimeOpt = 0;
    }

    static short[] ImageData = {
            105, 105,
            
            104,
            
            295, 296,
            
            99, 93, 86, 87, 88, 327,
            
            304, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 312, 314, 315, 316, 317, 318, 319, 320, 321, 322, 323, 324, 325, 326,
            
            340, 340, 336, 332, 328,
            
            127, 152, 171, 190, 209, 228, 253,
            
            290, 278,
            
            90, 90, 90,
            
            86, 304,
        };
    static final short[] Pull_motion = { 13, 17, 0, 21, };
    static final short[] Slime_motion = { 12, 14, 0, 17, };
    static final short[] Slime_out_motion = { 2, 16, 2, 16, };
    static final short[] Dragon_motion = { 10, 13, 0, 19, };
    static final short[] Dragon_out_motion = { 3, 18, 3, 18, };
    static final int[] fruit_point = {
            0, 100000, 90000, 80000, 70000, 60000, 50000, 45000, 40000, 35000, 30000, 25000, 20000, 15000, 10000, 9000, 8000, 7000, 6000,
            5000, 4000, 3000, 2000, 1000, 500,
            
            0, 6000, 5000, 1000, 500,
        };
    static final int[][] afruit_point = {
            { 6000, 7000, 8000, 10000, },
            { 5000, 6000, 7000, 8000, },
            { 1000, 2000, 3000, 4000, },
            { 500, 1000, 2000, 3000, },
        };

    public static final int sin(int angle) {
        int a = angle & 0xff;

        if(a >= 0x40) {
            if(a >= 0xc0) {
                a = a - 0x100;
            } else {
                a = 0x80 - a;
            }
        }

        if(a >= 0) {
            return sin_table[a];
        }

        return -sin_table[-a];
    }

    public static final int cos(int angle) {
        int a = angle & 0xff;

        if(a > 0x80) {
            a = 0x100 - a;
        }

        if(a <= 0x40) {
            return sin_table[0x40 - a];
        }

        return -sin_table[a - 0x40];
    }

    private static final short[] sin_table = {
            0, 100, 200, 301, 401, 501, 601, 700, 799, 897, 995, 1092, 1189, 1284, 1379, 1474, 1567, 1659, 1751, 1841, 1930, 2018, 2105,
            2191, 2275, 2358, 2439, 2519, 2598, 2675, 2750, 2824, 2896, 2966, 3034, 3101, 3166, 3229, 3289, 3348, 3405, 3460, 3513, 3563,
            3612, 3658, 3702, 3744, 3784, 3821, 3856, 3889, 3919, 3947, 3973, 3996, 4017, 4035, 4051, 4065, 4076, 4084, 4091, 4094, 4096,
        };
}
