/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class C2DArena {
    private MyCanvas m_Canvas;
    private int m_rgbSkyColor;
    private int m_rgbFloorColor;
    private Image skyImg01;
    private int skyScrollX;
    private int skyScrollY;
    private int crowdScrollX;
    private int crowdScrollY;
    private int railScrollX;
    private int railScrollY;
    private int treeScrollX;
    private int treeScrollY;
    private static int IMAGE_RAIL_START_POS;
    private static int IMAGE_CROWD_START_POS;
    private static int IMAGE_TREE_START_POS;
    private Image[] buffer;
    private int imageFlag;
    private int imageFlagIni;
    private int scrollX;
    private int scrollY;
    private int m_bullJumpState;
    private int m_bullSpinState;
    private static final int WEAK = 0;
    private static final int MEDIUM = 1;
    private static final int STRONG = 2;
    private static final int COLOSSAL = 3;
    private static final int RAIL_FRAME_WEAK_Y_SKIP = 10;
    private static final int RAIL_FRAME_MEDIUM_Y_SKIP = 12;
    private static final int RAIL_FRAME_STRONG_Y_SKIP = 14;
    private static final int RAIL_FRAME_COLOSSAL_Y_SKIP = 16;
    private static final int RAIL_FRAME_WEAK_X_SKIP = 12;
    private static final int RAIL_FRAME_MEDIUM_X_SKIP = 14;
    private static final int RAIL_FRAME_STRONG_X_SKIP = 16;
    private static final int RAIL_FRAME_COLOSSAL_X_SKIP = 18;
    private static final int CROWD_FRAME_WEAK_Y_SKIP = 8;
    private static final int CROWD_FRAME_MEDIUM_Y_SKIP = 10;
    private static final int CROWD_FRAME_STRONG_Y_SKIP = 12;
    private static final int CROWD_FRAME_COLOSSAL_Y_SKIP = 14;
    private static final int CROWD_FRAME_WEAK_X_SKIP = 10;
    private static final int CROWD_FRAME_MEDIUM_X_SKIP = 12;
    private static final int CROWD_FRAME_STRONG_X_SKIP = 14;
    private static final int CROWD_FRAME_COLOSSAL_X_SKIP = 16;
    private static final int TREE_FRAME_WEAK_Y_SKIP = 6;
    private static final int TREE_FRAME_MEDIUM_Y_SKIP = 8;
    private static final int TREE_FRAME_STRONG_Y_SKIP = 10;
    private static final int TREE_FRAME_COLOSSAL_Y_SKIP = 12;
    private static final int TREE_FRAME_WEAK_X_SKIP = 7;
    private static final int TREE_FRAME_MEDIUM_X_SKIP = 9;
    private static final int TREE_FRAME_STRONG_X_SKIP = 11;
    private static final int TREE_FRAME_COLOSSAL_X_SKIP = 13;
    private static final int SKY_FRAME_WEAK_Y_SKIP = 1;
    private static final int SKY_FRAME_MEDIUM_Y_SKIP = 2;
    private static final int SKY_FRAME_STRONG_Y_SKIP = 3;
    private static final int SKY_FRAME_COLOSSAL_Y_SKIP = 4;
    private static final int SKY_FRAME_WEAK_X_SKIP = 2;
    private static final int SKY_FRAME_MEDIUM_X_SKIP = 3;
    private static final int SKY_FRAME_STRONG_X_SKIP = 4;
    private static final int SKY_FRAME_COLOSSAL_X_SKIP = 5;

    public C2DArena(MyCanvas a_MyCanvas) {
        this.m_Canvas = a_MyCanvas;
        this.m_rgbSkyColor = 12447743;
        this.m_rgbFloorColor = 11567125;
        this.skyImg01 = Utils.loadImage("clouds.png");
        this.buffer = new Image[3];
        this.buffer[0] = Utils.loadImage("arenaRail.png");
        this.buffer[1] = Utils.loadImage("arenaCrowd.png");
        this.buffer[2] = Utils.loadImage("arenaTrees.png");
        IMAGE_TREE_START_POS = this.m_Canvas.getHeight() * 3 / 100;
        IMAGE_CROWD_START_POS = IMAGE_TREE_START_POS + (this.buffer[2].getHeight() - this.buffer[1].getHeight() - 7);
        IMAGE_RAIL_START_POS = IMAGE_TREE_START_POS + (this.buffer[2].getHeight() - this.buffer[0].getHeight() - 7);
        this.skyScrollX = -this.skyImg01.getWidth();
        this.skyScrollY = -this.skyImg01.getHeight();
        this.railScrollX = -this.buffer[0].getWidth();
        this.railScrollY = IMAGE_RAIL_START_POS;
        this.crowdScrollX = -this.buffer[1].getWidth();
        this.crowdScrollY = IMAGE_CROWD_START_POS;
        this.treeScrollX = -this.buffer[2].getWidth();
        this.treeScrollY = IMAGE_TREE_START_POS;
    }

    public void Draw() {
        this.DrawSkyRectParallax();
        this.DrawArenaParallax();
    }

    public void DrawSkyRectParallax() {
        for (int i = this.skyScrollX; i <= this.m_Canvas.getWidth(); i += this.skyImg01.getWidth()) {
            for (int j = this.skyScrollY; j <= this.m_Canvas.getWidth(); j += this.skyImg01.getHeight()) {
                Utils.DrawImage(this.skyImg01, i, j, 0);
            }
        }
    }

    public void DrawSkyRect() {
        Utils.SetColor(this.m_rgbSkyColor);
        Utils.FillRect(0, 0, this.m_Canvas.getWidth(), this.scrollY);
    }

    public void DrawFloorRect() {
        Utils.SetColor(this.m_rgbFloorColor);
        Utils.FillRect(0, this.crowdScrollY + this.buffer[1].getHeight(), this.m_Canvas.getWidth(), this.m_Canvas.getHeight());
    }

    public void DrawArenaParallax() {
        int i;
        for (i = this.treeScrollX; i <= this.m_Canvas.getWidth(); i += this.buffer[2].getWidth()) {
            Utils.DrawImage(this.buffer[2], i, this.treeScrollY, 0);
        }
        this.DrawFloorRect();
        for (i = this.crowdScrollX; i <= this.m_Canvas.getWidth(); i += this.buffer[1].getWidth()) {
            Utils.DrawImage(this.buffer[1], i, this.crowdScrollY, 0);
        }
        for (i = this.railScrollX; i <= this.m_Canvas.getWidth(); i += this.buffer[0].getWidth()) {
            Utils.DrawImage(this.buffer[0], i, this.railScrollY, 0);
        }
    }

    public void DrawArena() {
        if (this.imageFlagIni > 7) {
            this.imageFlagIni = 0;
        } else if (this.imageFlagIni < 0) {
            this.imageFlagIni = 7;
        }
        this.imageFlag = this.imageFlagIni;
        for (int i = this.scrollX; i <= this.m_Canvas.getWidth(); i += this.buffer[0].getWidth()) {
            if (this.imageFlag > 7) {
                this.imageFlag = 0;
            }
            Utils.DrawImage(this.buffer[this.imageFlag], i, this.scrollY - 5, 0);
            ++this.imageFlag;
        }
    }

    public void Update() {
        this.m_bullJumpState = CRidingLogic.m_iJumpState;
        this.m_bullSpinState = CRidingLogic.m_iSpinState;
        if (CRidingLogic.bullState == 2) {
            switch (this.m_bullJumpState) {
                case 1: {
                    this.ScrollUp(CRidingLogic.m_iJumpStrenght);
                    break;
                }
                case 3: {
                    this.ScrollDown(CRidingLogic.m_iJumpStrenght);
                    break;
                }
                case 0: {
                    this.railScrollY = IMAGE_RAIL_START_POS;
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
            }
        } else if (CRidingLogic.bullState == 3 || CRidingLogic.bullState == 4 || this.m_bullSpinState == 0) {
            switch (this.m_bullSpinState) {
                case 2: {
                    this.ScrollLeft(CRidingLogic.m_iJumpStrenght);
                    this.ScrollUp(CRidingLogic.m_iJumpStrenght);
                    break;
                }
                case 9: {
                    this.ScrollRight(CRidingLogic.m_iJumpStrenght);
                    this.ScrollUp(CRidingLogic.m_iJumpStrenght);
                    break;
                }
                case 6: {
                    this.ScrollDown(CRidingLogic.m_iJumpStrenght);
                    if (CRidingLogic.m_fBullSpinSide == 0) {
                        this.ScrollLeft(CRidingLogic.m_iJumpStrenght);
                        break;
                    }
                    this.ScrollRight(CRidingLogic.m_iJumpStrenght);
                    break;
                }
                case 0: {
                    this.railScrollY = IMAGE_RAIL_START_POS;
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
            }
        }
    }

    public void ScrollRight(int strength) {
        switch (strength) {
            case 0: {
                this.skyScrollX -= 2;
                this.treeScrollX -= 7;
                this.crowdScrollX -= 10;
                this.railScrollX -= 12;
                if (this.skyScrollX < -this.skyImg01.getWidth() << 1) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX < -this.buffer[2].getWidth() << 1) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX < -this.buffer[1].getWidth() << 1) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX >= -this.buffer[0].getWidth() << 1) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 1: {
                this.skyScrollX -= 3;
                this.treeScrollX -= 9;
                this.crowdScrollX -= 12;
                this.railScrollX -= 14;
                if (this.skyScrollX < -this.skyImg01.getWidth() << 1) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX < -this.buffer[2].getWidth() << 1) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX < -this.buffer[1].getWidth() << 1) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX >= -this.buffer[0].getWidth() << 1) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 2: {
                this.skyScrollX -= 4;
                this.treeScrollX -= 11;
                this.crowdScrollX -= 14;
                this.railScrollX -= 16;
                if (this.skyScrollX < -this.skyImg01.getWidth() << 1) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX < -this.buffer[2].getWidth() << 1) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX < -this.buffer[1].getWidth() << 1) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX >= -this.buffer[0].getWidth() << 1) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 3: {
                this.skyScrollX -= 5;
                this.treeScrollX -= 13;
                this.crowdScrollX -= 16;
                this.railScrollX -= 18;
                if (this.skyScrollX < -this.skyImg01.getWidth() << 1) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX < -this.buffer[2].getWidth() << 1) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX < -this.buffer[1].getWidth() << 1) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX >= -this.buffer[0].getWidth() << 1) break;
                this.railScrollX = -this.buffer[0].getWidth();
            }
        }
    }

    public void ScrollLeft(int strength) {
        switch (strength) {
            case 0: {
                this.skyScrollX += 2;
                this.treeScrollX += 7;
                this.crowdScrollX += 10;
                this.railScrollX += 12;
                if (this.skyScrollX > 0) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX > 0) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX > 0) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX <= 0) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 1: {
                this.skyScrollX += 3;
                this.treeScrollX += 9;
                this.crowdScrollX += 12;
                this.railScrollX += 14;
                if (this.skyScrollX > 0) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX > 0) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX > 0) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX <= 0) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 2: {
                this.skyScrollX += 4;
                this.treeScrollX += 11;
                this.crowdScrollX += 14;
                this.railScrollX += 16;
                if (this.skyScrollX > 0) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX > 0) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX > 0) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX <= 0) break;
                this.railScrollX = -this.buffer[0].getWidth();
                break;
            }
            case 3: {
                this.skyScrollX += 5;
                this.treeScrollX += 13;
                this.crowdScrollX += 16;
                this.railScrollX += 18;
                if (this.skyScrollX > 0) {
                    this.skyScrollX = -this.skyImg01.getWidth();
                }
                if (this.treeScrollX > 0) {
                    this.treeScrollX = -this.buffer[2].getWidth();
                }
                if (this.crowdScrollX > 0) {
                    this.crowdScrollX = -this.buffer[1].getWidth();
                }
                if (this.railScrollX <= 0) break;
                this.railScrollX = -this.buffer[0].getWidth();
            }
        }
    }

    public void ScrollUp(int strength) {
        switch (strength) {
            case 0: {
                ++this.skyScrollY;
                this.treeScrollY += 6;
                this.crowdScrollY += 8;
                this.railScrollY += 10;
                if (this.skyScrollY < 0) break;
                this.skyScrollY = -this.skyImg01.getHeight();
                break;
            }
            case 1: {
                this.skyScrollY += 2;
                this.treeScrollY += 8;
                this.crowdScrollY += 10;
                this.railScrollY += 12;
                if (this.skyScrollY < 0) break;
                this.skyScrollY = -this.skyImg01.getHeight();
                break;
            }
            case 2: {
                this.skyScrollY += 3;
                this.treeScrollY += 10;
                this.crowdScrollY += 12;
                this.railScrollY += 14;
                if (this.skyScrollY < 0) break;
                this.skyScrollY = -this.skyImg01.getHeight();
                break;
            }
            case 3: {
                this.skyScrollY += 4;
                this.treeScrollY += 12;
                this.crowdScrollY += 14;
                this.railScrollY += 16;
                if (this.skyScrollY < 0) break;
                this.skyScrollY = -this.skyImg01.getHeight();
            }
        }
    }

    public void ScrollDown(int strength) {
        switch (strength) {
            case 0: {
                --this.skyScrollY;
                this.treeScrollY -= 6;
                this.crowdScrollY -= 8;
                this.railScrollY -= 10;
                if (this.treeScrollY <= IMAGE_TREE_START_POS) {
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
                if (this.crowdScrollY <= IMAGE_CROWD_START_POS) {
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                }
                if (this.railScrollY > IMAGE_RAIL_START_POS) break;
                this.railScrollY = IMAGE_RAIL_START_POS;
                break;
            }
            case 1: {
                this.skyScrollY -= 2;
                this.treeScrollY -= 8;
                this.crowdScrollY -= 10;
                this.railScrollY -= 12;
                if (this.treeScrollY <= IMAGE_TREE_START_POS) {
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
                if (this.crowdScrollY <= IMAGE_CROWD_START_POS) {
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                }
                if (this.railScrollY > IMAGE_RAIL_START_POS) break;
                this.railScrollY = IMAGE_RAIL_START_POS;
                break;
            }
            case 2: {
                this.skyScrollY -= 3;
                this.treeScrollY -= 10;
                this.crowdScrollY -= 12;
                this.railScrollY -= 14;
                if (this.treeScrollY <= IMAGE_TREE_START_POS) {
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
                if (this.crowdScrollY <= IMAGE_CROWD_START_POS) {
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                }
                if (this.railScrollY > IMAGE_RAIL_START_POS) break;
                this.railScrollY = IMAGE_RAIL_START_POS;
                break;
            }
            case 3: {
                this.skyScrollY -= 4;
                this.treeScrollY -= 12;
                this.crowdScrollY -= 14;
                this.railScrollY -= 16;
                if (this.treeScrollY <= IMAGE_TREE_START_POS) {
                    this.treeScrollY = IMAGE_TREE_START_POS;
                }
                if (this.crowdScrollY <= IMAGE_CROWD_START_POS) {
                    this.crowdScrollY = IMAGE_CROWD_START_POS;
                }
                if (this.railScrollY > IMAGE_RAIL_START_POS) break;
                this.railScrollY = IMAGE_RAIL_START_POS;
            }
        }
    }
}

