/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Image;

public class CMenuCharacterController
extends CMenuDefaultController {
    private static int firstLinePosX = -1;
    private static int firstLineNamePosCentralX;
    private static int firstLineRightArrowPosX;
    private static int firstLinePosY;
    private static int firstLineArrowPosY;
    private static int interLineSpacing;
    private static final int OFF_RIGHT_ARROW = 0;
    private static final int OFF_NAME = 0;
    private int imagePosX;
    private int m_iCharacterType;
    private Image characterImage;
    private int numberOfCharacters;
    private int characterImageSingleWidth;
    private String characterNameTxt;
    private String characterFirstQualityTxt;
    private String characterSecondQualityTxt;
    private String characterThirdQualityTxt;
    private int characterSecondQualityPoints;
    private int characterThirdQualityPoints;
    private int characterImageOffset;
    private int m_iSelectedCharacter;

    public CMenuCharacterController(MyCanvas a_MyCanvas, CMainController a_MainController, CConfigFile a_ConfigFile, int a_iCharacterType, String a_sCharacterString) {
        super(a_MyCanvas, a_MainController, a_ConfigFile, LocalizedText.BACK, LocalizedText.OK, a_sCharacterString, true, true, true, false);
        this.m_iCharacterType = a_iCharacterType;
        this.ResetController(a_sCharacterString);
    }

    public void ResetController(String s_Text) {
        super.ResetController();
        if (firstLinePosX < 0) {
            this.InitStaticVariables();
        }
        this.ReloadController(s_Text);
        this.m_iSelectedCharacter = 0;
        this.ChangeSelectedCharacter();
    }

    public void ReloadController(String s_Text) {
        super.ReloadController(s_Text);
        super.UpdateSoftkeys(LocalizedText.BACK, LocalizedText.OK);
        Utils.getImage((byte)23);
        Utils.getImage((byte)64);
        if (this.m_iCharacterType == 1) {
            if (this.m_iSelectedCharacter < CConfigFile.nextLockedBull) {
                this.characterImageOffset = this.m_iSelectedCharacter;
                super.ActivateRightButton(true);
            } else {
                this.characterImageOffset = LocalizedText.BULLS_NAMES.length - 1;
                super.ActivateRightButton(false);
            }
            this.characterNameTxt = LocalizedText.BULLS_NAMES[this.characterImageOffset];
            this.characterImage = Utils.getImage((byte)40);
            this.characterImageSingleWidth = this.characterImage.getWidth() / LocalizedText.BULLS_NAMES.length;
            this.characterSecondQualityTxt = LocalizedText.DEXTERITY + " ";
            this.characterThirdQualityTxt = LocalizedText.RESISTANCE + " ";
            this.numberOfCharacters = LocalizedText.BULLS_NAMES.length - 1;
        } else if (this.m_iCharacterType == 0) {
            if (this.m_iSelectedCharacter < CConfigFile.nextLockedCowboy) {
                this.characterImageOffset = this.m_iSelectedCharacter;
                super.ActivateRightButton(true);
            } else {
                this.characterImageOffset = LocalizedText.COWBOYS_NAMES.length - 1;
                super.ActivateRightButton(false);
            }
            this.characterNameTxt = LocalizedText.COWBOYS_NAMES[this.characterImageOffset];
            this.characterImage = Utils.getImage((byte)44);
            this.characterImageSingleWidth = this.characterImage.getWidth() / LocalizedText.COWBOYS_NAMES.length;
            this.characterSecondQualityTxt = LocalizedText.AGILITY + " ";
            this.characterThirdQualityTxt = LocalizedText.POWER + " ";
            this.numberOfCharacters = LocalizedText.COWBOYS_NAMES.length - 1;
        }
        this.InitStaticVariables();
        this.imagePosX = (CTypes.iCanvasWidth >> 1) + (CTypes.IMAGE_MENU_FRAME_BACKGROUND.getWidth() >> 1) - 19 - this.characterImageSingleWidth;
    }

    private void InitStaticVariables() {
        int width;
        int i;
        Utils.getImage((byte)23);
        int longestNameWidth = 0;
        for (i = 0; i < LocalizedText.BULLS_NAMES.length; ++i) {
            width = Utils.stringWidth(LocalizedText.BULLS_NAMES[i], CTypes.FONT_CHAR_MAP);
            if (width <= longestNameWidth) continue;
            longestNameWidth = width;
        }
        for (i = 0; i < LocalizedText.COWBOYS_NAMES.length; ++i) {
            width = Utils.stringWidth(LocalizedText.COWBOYS_NAMES[i], CTypes.FONT_CHAR_MAP);
            if (width <= longestNameWidth) continue;
            longestNameWidth = width;
        }
        firstLinePosX = (CTypes.iCanvasWidth >> 1) - (CTypes.IMAGE_MENU_FRAME_BACKGROUND.getWidth() >> 1) + 19;
        firstLineNamePosCentralX = firstLinePosX + (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1) + ((longestNameWidth += Utils.stringWidth("  ", CTypes.FONT_CHAR_MAP)) >> 1) - 0;
        firstLineRightArrowPosX = firstLinePosX + (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1) + longestNameWidth - 0;
        firstLinePosY = CTypes.MENU_FRAME_IMG_TOP_Y + 19;
        firstLineArrowPosY = firstLinePosY + 6;
        interLineSpacing = (CTypes.IMAGE_MENU_FRAME_BACKGROUND.getHeight() - 38 - 4 * CTypes.FONT_HEIGHT + 2) / 3;
    }

    private void drawCharacterMenu() {
        int i;
        int oldClipX = Utils.getClipX();
        int oldClipY = Utils.getClipY();
        int oldClipWidth = Utils.getClipWidth();
        int oldClipHeight = Utils.getClipHeight();
        int x = firstLinePosX;
        int y = firstLinePosY;
        int arrowSingleWidth = CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1;
        if (this.m_iSelectedCharacter > 0) {
            Utils.SetClip(x, 0, arrowSingleWidth, CTypes.iCanvasHeight);
            Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK, x, firstLineArrowPosY, 20);
            Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        }
        Utils.drawString(this.characterNameTxt, firstLineNamePosCentralX, y, 17, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
        if (this.m_iSelectedCharacter < this.numberOfCharacters - 1) {
            Utils.SetClip(firstLineRightArrowPosX, 0, arrowSingleWidth, CTypes.iCanvasHeight);
            Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK, firstLineRightArrowPosX - arrowSingleWidth, firstLineArrowPosY, 20);
            Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
        }
        x = firstLinePosX;
        y += CTypes.FONT_HEIGHT + interLineSpacing;
        int rideTimes = 0;
        if (this.m_iCharacterType == 0) {
            rideTimes = this.m_ConfigFile.GetCowboyRide(this.m_iSelectedCharacter);
        } else if (this.m_iCharacterType == 1) {
            rideTimes = this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 1) + this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 2) + this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 3);
        }
        this.characterFirstQualityTxt = LocalizedText.TIMES_PLAYED + " " + rideTimes;
        Utils.drawString(this.characterFirstQualityTxt, x, y, 20, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
        x = firstLinePosX;
        x += Utils.drawString(this.characterSecondQualityTxt, x, y += CTypes.FONT_HEIGHT + interLineSpacing, 20, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
        int starY = y + (CTypes.FONT_HEIGHT - CTypes.IMAGE_STAR.getHeight() + 1 >> 1);
        for (i = 0; i < this.characterSecondQualityPoints; ++i) {
            Utils.DrawImage(CTypes.IMAGE_STAR, x, starY, 20);
            x += CTypes.IMAGE_STAR.getWidth();
        }
        x = firstLinePosX;
        x += Utils.drawString(this.characterThirdQualityTxt, x, y += CTypes.FONT_HEIGHT + interLineSpacing, 20, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
        starY = y + (CTypes.FONT_HEIGHT - CTypes.IMAGE_STAR.getHeight() + 1 >> 1);
        for (i = 0; i < this.characterThirdQualityPoints; ++i) {
            Utils.DrawImage(CTypes.IMAGE_STAR, x, starY, 20);
            x += CTypes.IMAGE_STAR.getWidth();
        }
        if (this.m_iSelectedCharacter == 1) {
            Utils.SetClip(this.imagePosX, 0, this.characterImageSingleWidth, CTypes.iCanvasHeight);
        } else {
            Utils.SetClip(this.imagePosX, 0, this.characterImageSingleWidth, CTypes.iCanvasHeight);
        }
        Utils.DrawImage(this.characterImage, this.imagePosX - this.characterImageOffset * this.characterImageSingleWidth, firstLinePosY, 20);
        Utils.SetClip(oldClipX, oldClipY, oldClipWidth, oldClipHeight);
    }

    protected void HandleDirecionalRightPressed() {
        this.NextCharacter();
    }

    protected void HandleDirecionalLeftPressed() {
        this.PreviousCharacter();
    }

    private void NextCharacter() {
        if (this.m_iSelectedCharacter < this.numberOfCharacters - 1) {
            ++this.m_iSelectedCharacter;
            this.ChangeSelectedCharacter();
        }
    }

    private void PreviousCharacter() {
        if (this.m_iSelectedCharacter > 0) {
            --this.m_iSelectedCharacter;
            this.ChangeSelectedCharacter();
        }
    }

    private void ChangeSelectedCharacter() {
        if (this.m_iCharacterType == 0) {
            if (this.m_iSelectedCharacter < CConfigFile.nextLockedCowboy) {
                this.characterImageOffset = this.m_iSelectedCharacter;
                super.ActivateRightButton(true);
            } else {
                this.characterImageOffset = LocalizedText.COWBOYS_NAMES.length - 1;
                super.ActivateRightButton(false);
            }
            this.characterNameTxt = LocalizedText.COWBOYS_NAMES[this.characterImageOffset];
            int rideTimes = this.m_ConfigFile.GetCowboyRide(this.m_iSelectedCharacter);
            int a_ShowableNumber = 9999;
            if (rideTimes > a_ShowableNumber) {
                rideTimes = a_ShowableNumber;
            }
            this.characterFirstQualityTxt = LocalizedText.TIMES_PLAYED + " " + rideTimes;
            this.characterSecondQualityPoints = CTypes.COWBOY_DEXTERITY[this.m_iSelectedCharacter];
            this.characterThirdQualityPoints = CTypes.COWBOY_RESISTANCE[this.m_iSelectedCharacter];
        } else if (this.m_iCharacterType == 1) {
            if (this.m_iSelectedCharacter < CConfigFile.nextLockedBull) {
                this.characterImageOffset = this.m_iSelectedCharacter;
                super.ActivateRightButton(true);
            } else {
                this.characterImageOffset = LocalizedText.BULLS_NAMES.length - 1;
                super.ActivateRightButton(false);
            }
            this.characterNameTxt = LocalizedText.BULLS_NAMES[this.characterImageOffset];
            int rideTimes = this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 1) + this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 2) + this.m_ConfigFile.GetBullRides(this.m_iSelectedCharacter, 3);
            int a_ShowableNumber = 9999;
            if (rideTimes > a_ShowableNumber) {
                rideTimes = a_ShowableNumber;
            }
            this.characterFirstQualityTxt = LocalizedText.TIMES_PLAYED + " " + rideTimes;
            this.characterSecondQualityPoints = CTypes.BULL_STRENGTH[this.m_iSelectedCharacter];
            this.characterThirdQualityPoints = CTypes.BULL_AGILITY[this.m_iSelectedCharacter];
        }
    }

    protected void BottomLeftButtonReleased() {
        switch (this.m_iCharacterType) {
            case 0: {
                m_MainController.SetInternalEvent(5);
                if (CConfigFile.gameMode == 0) break;
                CConfigFile.gameMode = CConfigFile.isChampionshipRound;
                break;
            }
            case 1: {
                m_MainController.SetInternalEvent(3);
            }
        }
    }

    protected void BottomRightButtonReleased() {
        this.CharacterSelected();
    }

    protected void HandleSelectReleased() {
        this.CharacterSelected();
    }

    private void CharacterSelected() {
        switch (this.m_iCharacterType) {
            case 0: {
                int l_iNextCharacterLocked = CConfigFile.nextLockedCowboy;
                if (this.m_iSelectedCharacter >= l_iNextCharacterLocked) break;
                if (CConfigFile.gameMode == 0) {
                    CConfigFile.trainingCowboy = this.m_iSelectedCharacter;
                } else {
                    CConfigFile.currentCowboy = this.m_iSelectedCharacter;
                }
                if (CConfigFile.gameMode == 1) {
                    CConfigFile.currentBull = 0;
                    CConfigFile.multiplexerState = 8;
                    this.m_ConfigFile.save(2);
                    m_MainController.SetInternalEvent(8);
                    break;
                }
                m_MainController.SetInternalEvent(7);
                break;
            }
            case 1: {
                int l_iNextCharacterLocked = CConfigFile.nextLockedBull;
                if (this.m_iSelectedCharacter >= l_iNextCharacterLocked) break;
                if (CConfigFile.gameMode == 0) {
                    CConfigFile.trainingBull = this.m_iSelectedCharacter;
                } else {
                    CConfigFile.currentBull = this.m_iSelectedCharacter;
                    this.m_ConfigFile.save(2);
                }
                m_MainController.SetInternalEvent(8);
            }
        }
    }

    protected void HandleDirecionalUpReleased() {
    }

    protected void HandleDirecionalDownReleased() {
    }

    protected void HandleKeyEvent() {
        if (CTypes.KEY_SOFT1) {
            this.BottomLeftButtonReleased();
            return;
        }
        if (CTypes.KEY_SOFT2) {
            this.BottomRightButtonReleased();
            return;
        }
        if (CTypes.KEY_LEFT) {
            this.HandleDirecionalLeftPressed();
            return;
        }
        if (CTypes.KEY_RIGHT) {
            this.HandleDirecionalRightPressed();
            return;
        }
        if (CTypes.KEY_SELECT) {
            this.HandleSelectReleased();
            return;
        }
    }

    protected int Run() {
        super.Run();
        this.drawCharacterMenu();
        return 0;
    }
}

