/*
 * Decompiled with CFR 0.152.
 */
public class CMenuConfigController
extends CMenuDefaultController {
    public static final byte VOLUME_MAX = 5;
    private static final byte NUMBER_OF_OPTIONS = 3;
    private static final int LANG_NUMBER = 3;
    private static int optionLabelPosX = -1;
    private static int optionPosCentralX;
    private static int[] optionLabelPosY;
    private static String[] optionLabelText;
    private static int[] optionPosY;
    private static int optionArrowLeftPosX;
    private static int optionArrowRightPosX;
    private static int[] optionArrowPosY;
    private static String[] optionText;
    private static int[] optionValue;
    public static int currentOption;
    private boolean isPaused = false;

    public CMenuConfigController(MyCanvas a_MyCanvas, CMainController a_MainController, CConfigFile a_ConfigFile, boolean isPausedMenu) {
        super(a_MyCanvas, a_MainController, a_ConfigFile, "", "", "", true, true, true, false);
        this.ResetController(isPausedMenu);
    }

    public void ResetController(boolean isPausedMenu) {
        super.ResetController();
        if (optionLabelPosX < 0) {
            this.InitStaticVariables();
        }
        this.ReloadController(isPausedMenu);
    }

    public void ReloadController(boolean isPausedMenu) {
        super.ReloadController(null);
        Utils.getImage((byte)64);
        Utils.getImage((byte)55);
        Utils.getImage((byte)59);
        Utils.getImage((byte)57);
        Utils.getImage((byte)23);
        Utils.getImage((byte)58);
        Utils.getImage((byte)24);
        Utils.getImage((byte)46);
        Utils.getImage((byte)61);
        CMenuConfigController.optionLabelText[0] = LocalizedText.VIBRATION;
        CMenuConfigController.optionLabelText[1] = LocalizedText.VOLUME;
        CMenuConfigController.optionLabelText[2] = LocalizedText.LANGUAGE;
        int currentVolume = CConfigFile.volume * 5 / CSFX.MAX_VOLUME;
        int currentVibration = CConfigFile.vibrate ? 1 : 0;
        int currentLanguage = CConfigFile.language;
        for (int i = 0; i < 3; ++i) {
            CMenuConfigController.optionValue[i] = optionLabelText[i].compareTo(LocalizedText.VIBRATION) == 0 ? currentVibration : (optionLabelText[i].compareTo(LocalizedText.LANGUAGE) == 0 ? currentLanguage : currentVolume);
            CMenuConfigController.optionText[i] = this.getOptionText(optionLabelText[i], optionValue[i]);
        }
        if (isPausedMenu) {
            this.SetPaused();
        } else {
            this.SetUnpaused();
        }
    }

    private void InitStaticVariables() {
        Utils.getImage((byte)64);
        Utils.getImage((byte)55);
        Utils.getImage((byte)59);
        Utils.getImage((byte)57);
        Utils.getImage((byte)23);
        Utils.getImage((byte)58);
        Utils.getImage((byte)24);
        Utils.getImage((byte)46);
        Utils.getImage((byte)61);
        optionLabelPosX = (CTypes.iCanvasWidth - CTypes.MENU_FRAME_IMG_WIDTH_USABLE >> 1) + CTypes.IMAGE_STAR.getWidth() + (CTypes.IMAGE_STAR.getWidth() >> 1);
        optionPosCentralX = (CTypes.iCanvasWidth >> 1) + (CTypes.MENU_FRAME_IMG_WIDTH_USABLE >> 2);
        optionArrowLeftPosX = CTypes.iCanvasWidth >> 1;
        optionArrowRightPosX = CTypes.iCanvasWidth + CTypes.MENU_FRAME_IMG_WIDTH_USABLE - CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1;
        CMenuConfigController.optionLabelPosY[0] = CTypes.MENU_FRAME_IMG_TOP_Y + CTypes.IMAGE_MENU_FRAME_BACKGROUND.getHeight() / 4 - CTypes.FONT_HEIGHT;
        CMenuConfigController.optionPosY[0] = optionLabelPosY[0];
        CMenuConfigController.optionLabelPosY[1] = CTypes.MENU_FRAME_IMG_TOP_Y + CTypes.IMAGE_MENU_FRAME_BACKGROUND.getHeight() / 2 - (CTypes.FONT_HEIGHT >> 1);
        CMenuConfigController.optionPosY[1] = optionLabelPosY[1];
        CMenuConfigController.optionLabelPosY[2] = CTypes.MENU_FRAME_IMG_TOP_Y + CTypes.IMAGE_MENU_FRAME_BACKGROUND.getHeight() - CTypes.IMAGE_MENU_FRAME_BACKGROUND.getHeight() / 4 - (CTypes.FONT_HEIGHT >> 2);
        CMenuConfigController.optionPosY[2] = optionLabelPosY[2];
        CMenuConfigController.optionLabelText[0] = LocalizedText.VIBRATION;
        CMenuConfigController.optionLabelText[1] = LocalizedText.VOLUME;
        CMenuConfigController.optionLabelText[2] = LocalizedText.LANGUAGE;
        switch (3) {
            case 1: {
                CMenuConfigController.optionArrowPosY[0] = optionLabelPosY[0] + 6;
                break;
            }
            case 2: {
                CMenuConfigController.optionArrowPosY[0] = optionLabelPosY[0] + 6;
                CMenuConfigController.optionArrowPosY[1] = optionLabelPosY[1] + 6;
                break;
            }
            case 3: {
                CMenuConfigController.optionArrowPosY[0] = optionLabelPosY[0] + 6;
                CMenuConfigController.optionArrowPosY[1] = optionLabelPosY[1] + 6;
                CMenuConfigController.optionArrowPosY[2] = optionLabelPosY[2] + 6;
            }
        }
    }

    public void SetPaused() {
        this.isPaused = true;
        this.topBarString = LocalizedText.PAUSED;
        this.leftSoftKeyText = LocalizedText.BACK;
        super.ActivateLeftButton(true);
        this.rightSoftKeyText = LocalizedText.EXIT;
        super.ActivateRightButton(true);
    }

    public void SetUnpaused() {
        this.isPaused = false;
        this.topBarString = LocalizedText.OPTIONS_MENU;
        this.leftSoftKeyText = LocalizedText.BACK;
        super.ActivateLeftButton(true);
        this.rightSoftKeyText = "";
        super.ActivateRightButton(false);
    }

    private String getOptionText(String optionLabel, int optionValue) {
        if (optionLabel.compareTo(LocalizedText.VIBRATION) == 0) {
            if (optionValue == 0) {
                return LocalizedText.OFF_FEMALE;
            }
            return LocalizedText.ON_FEMALE;
        }
        if (optionLabel.compareTo(LocalizedText.SOUND) == 0) {
            if (optionValue == 0) {
                return LocalizedText.OFF;
            }
            return LocalizedText.ON;
        }
        if (optionLabel.compareTo(LocalizedText.VOLUME) == 0) {
            if (optionValue == 0) {
                return LocalizedText.OFF;
            }
            return null;
        }
        if (optionLabel.compareTo(LocalizedText.LANGUAGE) == 0) {
            if (optionValue == 0) {
                return LocalizedText.L_PT;
            }
            if (optionValue == 1) {
                return LocalizedText.L_SP;
            }
            if (optionValue == 2) {
                return LocalizedText.L_EN;
            }
            return LocalizedText.L_PT;
        }
        return null;
    }

    protected void HandleSelectReleased() {
        this.BottomRightButtonReleased();
    }

    protected void BottomRightButtonReleased() {
        if (CConfigFile.language == 0) {
            LocalizedText.changeLang("pt");
        } else if (CConfigFile.language == 1) {
            LocalizedText.changeLang("sp");
        } else if (CConfigFile.language == 2) {
            LocalizedText.changeLang("en");
        }
        CConfigFile.firstLoad = false;
        CConfigFile.firstLoadingScreen = false;
        this.m_ConfigFile.save(0);
        if (this.isPaused && CConfigFile.gameMode != 0) {
            CConfigFile.saved = false;
            m_MainController.SetInternalEvent(20);
        } else if (this.isPaused && CConfigFile.gameMode == 0) {
            CConfigFile.saved = false;
            m_MainController.SetInternalEvent(5);
        } else {
            CConfigFile.gameMode = CConfigFile.isChampionshipRound;
            CConfigFile.multiplexerState = 8;
            m_MainController.SetInternalEvent(5);
        }
    }

    protected void BottomLeftButtonReleased() {
        if (CConfigFile.language == 0) {
            LocalizedText.changeLang("pt");
        } else if (CConfigFile.language == 1) {
            LocalizedText.changeLang("sp");
        } else if (CConfigFile.language == 2) {
            LocalizedText.changeLang("en");
        }
        CConfigFile.firstLoad = false;
        CConfigFile.firstLoadingScreen = false;
        this.m_ConfigFile.save(0);
        if (this.isPaused) {
            CConfigFile.saved = false;
            if (CConfigFile.gameMode != 0) {
                CConfigFile.gameMode = CConfigFile.isChampionshipRound;
            }
            if (CMainController.currentGameState == 4) {
                MyCanvas.pMainController.StopSound();
            }
            m_MainController.SetInternalEvent(51);
        } else {
            CConfigFile.gameMode = CConfigFile.isChampionshipRound;
            CConfigFile.multiplexerState = 8;
            m_MainController.SetInternalEvent(5);
        }
    }

    protected void HandleDirecionalUpReleased() {
        if (currentOption > 0) {
            --currentOption;
        }
    }

    protected void HandleDirecionalDownReleased() {
        if (currentOption < 2) {
            ++currentOption;
        }
    }

    protected void HandleDirecionalRightPressed() {
        int volume = -1;
        if (optionLabelText[currentOption].compareTo(LocalizedText.VIBRATION) == 0) {
            if (optionValue[currentOption] == 0) {
                int n = currentOption;
                optionValue[n] = optionValue[n] + 1;
                CConfigFile.vibrate = true;
                CMainController.Vibrate(500);
            }
        } else if (optionLabelText[currentOption].compareTo(LocalizedText.SOUND) == 0) {
            if (optionValue[currentOption] == 0) {
                CConfigFile.soundOn = true;
                if (!CSFX.playerCreated) {
                    if (CMainController.currentGameState == 1) {
                        MyCanvas.pMainController.PlaySound(1);
                    } else {
                        MyCanvas.pMainController.PlaySound(4);
                    }
                }
                CMenuConfigController.optionValue[CMenuConfigController.currentOption] = 1;
            }
            volume = CSFX.MAX_VOLUME;
        } else if (optionLabelText[currentOption].compareTo(LocalizedText.VOLUME) == 0) {
            if (optionValue[currentOption] < 5) {
                CConfigFile.soundOn = true;
                if (optionValue[currentOption] == 0 && CMainController.currentGameState == 1 && !CSFX.playerCreated) {
                    if (CMainController.currentGameState == 1) {
                        MyCanvas.pMainController.PlaySound(1);
                    } else {
                        MyCanvas.pMainController.PlaySound(4);
                    }
                }
                int n = currentOption;
                optionValue[n] = optionValue[n] + 1;
            }
            volume = CSFX.MAX_VOLUME * optionValue[currentOption] / 5;
        } else if (optionLabelText[currentOption].compareTo(LocalizedText.LANGUAGE) == 0 && optionValue[currentOption] < 2) {
            int n = currentOption;
            optionValue[n] = optionValue[n] + 1;
            if (optionValue[currentOption] == 0) {
                CConfigFile.language = 0;
            } else if (optionValue[currentOption] == 1) {
                CConfigFile.language = 1;
            } else if (optionValue[currentOption] == 2) {
                CConfigFile.language = 2;
            }
        }
        if (volume >= 0) {
            if (MyCanvas.pMainController.sfx != null) {
                MyCanvas.pMainController.sfx.setSoundVolume(volume);
            } else {
                MyCanvas.pMainController.sfx.setSoundVolume(volume);
                MyCanvas.pMainController.m_bSoundMenuStarted = true;
            }
            CConfigFile.volume = volume;
        }
        CMenuConfigController.optionText[CMenuConfigController.currentOption] = this.getOptionText(optionLabelText[currentOption], optionValue[currentOption]);
    }

    protected void HandleDirecionalLeftPressed() {
        if (optionValue[currentOption] > 0) {
            if (optionLabelText[currentOption].compareTo(LocalizedText.VIBRATION) == 0) {
                int n = currentOption;
                optionValue[n] = optionValue[n] - 1;
                CConfigFile.vibrate = false;
            } else if (optionLabelText[currentOption].compareTo(LocalizedText.SOUND) == 0 || optionLabelText[currentOption].compareTo(LocalizedText.VOLUME) == 0) {
                int n = currentOption;
                optionValue[n] = optionValue[n] - 1;
                int volume = CSFX.MAX_VOLUME * optionValue[currentOption] / 5;
                if (MyCanvas.pMainController.sfx != null) {
                    MyCanvas.pMainController.sfx.setSoundVolume(volume);
                }
                if ((CConfigFile.volume = volume) == 0 && CMenuConfigController.m_MainController.sfx != null) {
                    CMenuConfigController.m_MainController.sfx.stopSound();
                    CSFX cfr_ignored_0 = CMenuConfigController.m_MainController.sfx;
                    CSFX.player = null;
                    CSFX.playerCreated = false;
                    CConfigFile.soundOn = false;
                    System.gc();
                    CMenuConfigController.m_MainController.m_bSoundMenuStarted = false;
                }
            } else if (optionLabelText[currentOption].compareTo(LocalizedText.LANGUAGE) == 0) {
                int n = currentOption;
                optionValue[n] = optionValue[n] - 1;
                if (optionValue[currentOption] == 0) {
                    CConfigFile.language = 0;
                } else if (optionValue[currentOption] == 1) {
                    CConfigFile.language = 1;
                } else if (optionValue[currentOption] == 2) {
                    CConfigFile.language = 2;
                }
            }
        }
        CMenuConfigController.optionText[CMenuConfigController.currentOption] = this.getOptionText(optionLabelText[currentOption], optionValue[currentOption]);
    }

    protected void HandleKeyEvent() {
        if (CTypes.KEY_SOFT1) {
            this.BottomLeftButtonReleased();
            return;
        }
        if (CTypes.KEY_SOFT2) {
            this.BottomRightButtonReleased();
            return;
        }
        if (CTypes.KEY_SELECT) {
            this.HandleSelectReleased();
            return;
        }
        if (CTypes.KEY_UP) {
            this.HandleDirecionalUpReleased();
            return;
        }
        if (CTypes.KEY_DOWN) {
            this.HandleDirecionalDownReleased();
            return;
        }
        if (CTypes.KEY_LEFT) {
            this.HandleDirecionalLeftPressed();
            return;
        }
        if (CTypes.KEY_RIGHT) {
            this.HandleDirecionalRightPressed();
            return;
        }
    }

    protected int Run() {
        super.Run();
        this.DrawOptions();
        return 0;
    }

    private void DrawOptions() {
        Utils.DrawImage(CTypes.IMAGE_STAR, optionLabelPosX - (CTypes.IMAGE_STAR.getWidth() >> 1), optionLabelPosY[currentOption] + (CTypes.FONT_HEIGHT >> 1), 10);
        for (int i = 0; i < 3; ++i) {
            Utils.drawString(optionLabelText[i], optionLabelPosX, optionLabelPosY[i], 20, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
            if (currentOption == i) {
                if (optionLabelText[i].compareTo(LocalizedText.VOLUME) != 0 && optionValue[i] == 0 || optionLabelText[i].compareTo(LocalizedText.VOLUME) == 0 && optionValue[i] < 5 || optionLabelText[i].compareTo(LocalizedText.LANGUAGE) == 0 && optionValue[i] < 2) {
                    Utils.SetClip(optionArrowRightPosX, 0, CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1, CTypes.iCanvasHeight);
                    Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK, optionArrowRightPosX - (CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1), optionArrowPosY[i], 20);
                }
                if (optionValue[i] > 0) {
                    Utils.SetClip(optionArrowLeftPosX, 0, CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK.getWidth() >> 1, CTypes.iCanvasHeight);
                    Utils.DrawImage(CTypes.IMAGE_ARROWS_SIDE_SCROLLING_BLACK, optionArrowLeftPosX, optionArrowPosY[i], 20);
                }
                Utils.SetClip(0, 0, CTypes.iCanvasWidth, CTypes.iCanvasHeight);
            }
            if (optionText[i] != null) {
                Utils.drawString(optionText[i], optionPosCentralX, optionPosY[i], 17, CTypes.IMAGE_FONT_BLACK, CTypes.FONT_CHAR_MAP, CTypes.FONT_HEIGHT);
                continue;
            }
            int x = optionPosCentralX - (CTypes.IMAGE_SOUND_VOLUME.getWidth() >> 1);
            int y = optionPosY[i] + CTypes.FONT_HEIGHT - CTypes.IMAGE_SOUND_VOLUME.getHeight();
            Utils.SetClip(x, 0, CTypes.IMAGE_SOUND_VOLUME.getWidth() / 5 * optionValue[i], CTypes.iCanvasHeight);
            Utils.DrawImage(CTypes.IMAGE_SOUND_VOLUME, x, y, 20);
            Utils.SetClip(0, 0, CTypes.iCanvasWidth, CTypes.iCanvasHeight);
        }
    }

    static {
        optionLabelPosY = new int[3];
        optionLabelText = new String[3];
        optionPosY = new int[3];
        optionArrowPosY = new int[3];
        optionText = new String[3];
        optionValue = new int[3];
        currentOption = 0;
    }
}

