/*
 * Decompiled with CFR 0.152.
 */
class CRC {
    private static long[] crc_table = null;

    CRC() {
        if (crc_table == null) {
            crc_table = new long[256];
            for (int i = 0; i < 256; ++i) {
                long l = i;
                for (int j = 0; j < 8; ++j) {
                    if ((l & 1L) != 0L) {
                        l = 0xEDB88320L ^ l >> 1;
                        continue;
                    }
                    l >>= 1;
                }
                CRC.crc_table[i] = l;
            }
        }
    }

    private long getCrc(byte[] data, int pos, int length) {
        long l = 0xFFFFFFFFL;
        for (int j = 0; j < length; ++j) {
            l = crc_table[(int)((l ^ (long)data[pos + j]) & 0xFFL) & 0xFF] ^ l >> 8;
        }
        return l ^ 0xFFFFFFFFL;
    }

    public void update_CRC(byte[] fileAsByteArray, int pos) {
        int length = (fileAsByteArray[pos - 8] & 0xFF) << 24 | (fileAsByteArray[pos - 7] & 0xFF) << 16 | (fileAsByteArray[pos - 6] & 0xFF) << 8 | fileAsByteArray[pos - 5] & 0xFF;
        long newCrc = this.getCrc(fileAsByteArray, pos - 4, length + 4);
        fileAsByteArray[pos + length] = (byte)(newCrc >>> 24 & 0xFFL);
        fileAsByteArray[pos + length + 1] = (byte)(newCrc >>> 16 & 0xFFL);
        fileAsByteArray[pos + length + 2] = (byte)(newCrc >>> 8 & 0xFFL);
        fileAsByteArray[pos + length + 3] = (byte)(newCrc & 0xFFL);
    }
}

