/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class DavinciUtilities {
    private static int[] smCrcTable;
    private static int[] smImageHandles;
    private static int smImageHandlesSize;
    public static int smCurrentLoadingStep;
    private static Vector smImages;
    private static short[] smImageReferences;
    private static int[] smImageIDs;
    private static byte[] smPaletteIndices;
    private static short[] smImageTransformation;
    private static int[][] smPalettes;
    private static int[] smSinTable;
    private static Vector smSpriteObjectCache;
    private static short[] smSpriteObjectReference;
    private static int[] smSpriteObjectID;

    public static void initialize() {
        byte[] byArray = Toolkit.getResourceBytes(524482);
        int n = byArray.length >> 2;
        smPalettes = new int[n][];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            int n3 = byArray[n2++] << 24 | (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            byte[] byArray2 = Toolkit.getResourceBytes(n3);
            int n4 = byArray2.length / 3;
            DavinciUtilities.smPalettes[i] = new int[n4];
            while (--n4 >= 0) {
                DavinciUtilities.smPalettes[i][n4] = byArray2[n4 * 3] << 16 | (byArray2[n4 * 3 + 1] & 0xFF) << 8 | byArray2[n4 * 3 + 2] & 0xFF | 0xFF000000;
            }
            DavinciUtilities.smPalettes[i][0] = 0;
        }
    }

    public static void resetLoading() {
        smCurrentLoadingStep = 0;
    }

    public static Animation loadAnimation(int n, boolean bl) {
        if (!bl) {
            DavinciUtilities.resetLoading();
        }
        Animation animation = new Animation(n, bl);
        return animation;
    }

    public static Animation loadAnimation(int n) {
        return DavinciUtilities.loadAnimation(n, false);
    }

    public static Animation[] loadAnimations(int[] nArray, boolean bl) {
        Animation[] animationArray = new Animation[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            animationArray[i] = DavinciUtilities.loadAnimation(nArray[i], bl);
        }
        return animationArray;
    }

    public static Animation[] loadAnimations(int[] nArray) {
        return DavinciUtilities.loadAnimations(nArray, false);
    }

    public static Image getImage(int n) {
        return DavinciUtilities.getImage(n, 0, 1024);
    }

    public static Image getImage(int n, int n2, int n3) {
        Image image = null;
        if (n != -1) {
            byte[] byArray = Toolkit.getResourceBytes(n);
            int n4 = ((byArray[0] & 0xFF) >> 4) + 1;
            int n5 = byArray[1] << 24 | (byArray[2] & 0xFF) << 16 | (byArray[3] & 0xFF) << 8 | byArray[4] & 0xFF;
            int n6 = byArray[5] & 0xFF;
            image = DavinciUtilities.getImage(n5, n6, n2, n3 * n4);
        }
        return image;
    }

    private static void addImageToLoadList(int n, int n2, int n3, int n4, int n5) {
        int n6;
        if (smImageHandles == null) {
            smImageHandles = new int[3045];
        }
        if ((n6 = smImageHandlesSize * 5) == smImageHandles.length) {
            int[] nArray = new int[smImageHandles.length << 1];
            System.arraycopy(smImageHandles, 0, nArray, 0, n6);
            smImageHandles = nArray;
        }
        DavinciUtilities.smImageHandles[n6] = n;
        DavinciUtilities.smImageHandles[n6 + 1] = n2;
        DavinciUtilities.smImageHandles[n6 + 2] = n3;
        DavinciUtilities.smImageHandles[n6 + 3] = n4;
        DavinciUtilities.smImageHandles[n6 + 4] = n5;
        ++smImageHandlesSize;
        while (n6 > 0 && smImageHandles[n6 + 1] < smImageHandles[n6 + 1 - 5]) {
            DavinciUtilities.swap(smImageHandles, n6, n6 - 5, 5);
            n6 -= 5;
        }
    }

    public static void loadImageIntoCache(int n, int n2, int n3, int n4, boolean bl, int[] nArray) {
        int n5;
        int n6;
        boolean bl2 = true;
        int n7 = 0;
        nArray[1] = 0;
        if (n2 == 255) {
            n7 = n3;
            bl2 = false;
        }
        if ((n6 = DavinciUtilities.findIndex(n, n2, n5 = n4 - 1 << 8 | n7)) == -1) {
            n6 = DavinciUtilities.findIndex(-1, 0, 0);
            if (n6 == -1) {
                n6 = smImages.size();
                if (n6 == smImageIDs.length) {
                    int[] nArray2 = new int[n6 << 1];
                    byte[] byArray = new byte[n6 << 1];
                    short[] sArray = new short[n6 << 1];
                    short[] sArray2 = new short[n6 << 1];
                    System.arraycopy(smImageIDs, 0, nArray2, 0, n6);
                    System.arraycopy(smPaletteIndices, 0, byArray, 0, n6);
                    System.arraycopy(smImageReferences, 0, sArray, 0, n6);
                    System.arraycopy(smImageTransformation, 0, sArray2, 0, n6);
                    smImageIDs = nArray2;
                    smPaletteIndices = byArray;
                    smImageReferences = sArray;
                    smImageTransformation = sArray2;
                }
                DavinciUtilities.smImageReferences[n6] = 0;
            }
        } else {
            nArray[0] = n6;
            if (bl2) {
                nArray[1] = n3;
            }
            return;
        }
        DavinciUtilities.smImageIDs[n6] = n;
        DavinciUtilities.smPaletteIndices[n6] = (byte)n2;
        DavinciUtilities.smImageTransformation[n6] = (short)n5;
        if (n6 == smImages.size()) {
            smImages.addElement(null);
        }
        if (bl) {
            smImages.setElementAt(DavinciUtilities.getImage(n, n2, n7, n4 << 10), n6);
        } else {
            DavinciUtilities.addImageToLoadList(n6, n, n2, n7, n4);
        }
        nArray[0] = n6;
        if (bl2) {
            nArray[1] = n3;
        }
    }

    public static int getAdditionalLoadingCount() {
        return smImageHandlesSize;
    }

    public static void loadNext() {
        int n;
        int n2 = smCurrentLoadingStep * 5;
        if (DavinciUtilities.getImageFromCache(n = smImageHandles[n2++]) == null) {
            int n3 = smImageHandles[n2++];
            int n4 = smImageHandles[n2++];
            int n5 = smImageHandles[n2++];
            int n6 = smImageHandles[n2];
            smImages.setElementAt(DavinciUtilities.getImage(n3, n4, n5, n6 << 10), n);
        }
        if (++smCurrentLoadingStep == smImageHandlesSize) {
            DavinciUtilities.clearImageLoadingList();
        }
    }

    private static void clearImageLoadingList() {
        smImageHandles = null;
        smCurrentLoadingStep = 0;
        smImageHandlesSize = 0;
    }

    public static void swap(int[] nArray, int n, int n2, int n3) {
        while (--n3 >= 0) {
            int n4 = nArray[n];
            nArray[n] = nArray[n2];
            nArray[n2] = n4;
            ++n;
            ++n2;
        }
    }

    private static Image getImage(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        if (n2 == 253) {
            return Toolkit.getImage(n);
        }
        byte[] byArray = Toolkit.getResourceBytes(n);
        int n8 = byArray[0] << 8 | byArray[1] & 0xFF;
        int[] nArray = null;
        if (n2 == 254 || n2 == 255) {
            n7 = n2;
            n6 = 2;
            n5 = (byArray.length - n6) / n8;
            n5 = n2 == 254 ? (n5 /= 3) : (n5 >>= 2);
        } else {
            n6 = 10;
            n5 = (byArray.length - n6) / n8;
            nArray = smPalettes[n2];
            n7 = -1;
        }
        byte[] byArray2 = DavinciUtilities.createPng(nArray, byArray, n8, n5, n7, n6, n3, n4);
        Image image = Image.createImage((byte[])byArray2, (int)0, (int)byArray2.length);
        return image;
    }

    public static void transformBuffer(int[] nArray, int n, int n2, int n3) {
        if (n3 == 0) {
            return;
        }
        if ((n3 & 3) == 3) {
            int n4 = 0;
            int n5 = n * n2;
            int n6 = n5 >> 1;
            int n7 = n5 - 1;
            while (n7 >= n6) {
                int n8 = nArray[n7];
                nArray[n7--] = nArray[n4];
                nArray[n4++] = n8;
            }
        } else if ((n3 & 1) != 0) {
            int n9 = n >> 1;
            int n10 = 0;
            int n11 = n2;
            while (--n11 >= 0) {
                int n12 = n10 + n - 1;
                int n13 = n10 + n9;
                while (n10 < n13) {
                    int n14 = nArray[n10];
                    nArray[n10++] = nArray[n12];
                    nArray[n12--] = n14;
                }
                n10 += n - n9;
            }
        } else {
            int n15 = (n2 - 1) * n;
            int n16 = (n2 >> 1) * n;
            int n17 = n;
            while (--n17 >= 0) {
                int n18 = n17;
                int n19 = n15 + n17;
                int n20 = n18 + n16;
                while (n18 < n20) {
                    int n21 = nArray[n18];
                    nArray[n18] = nArray[n19];
                    nArray[n19] = n21;
                    n18 += n;
                    n19 -= n;
                }
            }
        }
    }

    public static void modRefCounters(Animation animation, int n) {
        if (animation != null) {
            int n2 = animation.getFrameCount();
            while (--n2 >= 0) {
                if (animation.isFrameReference(n2)) continue;
                AnimationFrame animationFrame = animation.getFrame(n2);
                int[][] nArray = animationFrame.getRenderables();
                int n3 = nArray.length;
                while (--n3 >= 0) {
                    int n4;
                    int[] nArray2 = nArray[n3];
                    int n5 = nArray2[0];
                    if (n5 == 1) {
                        n4 = nArray2[3];
                        int n6 = smImageReferences[n4] + n;
                        if (n6 < 0) {
                            n6 = 0;
                        }
                        DavinciUtilities.smImageReferences[n4] = (short)n6;
                        continue;
                    }
                    if (n5 != 9) continue;
                    int n7 = n4 = nArray2[4];
                    smSpriteObjectReference[n7] = (short)(smSpriteObjectReference[n7] + n);
                    if (smSpriteObjectReference[n4] > 0) continue;
                    DavinciUtilities.smSpriteObjectReference[n4] = 0;
                    SpriteObject spriteObject = DavinciUtilities.getSpriteObjectFromCache(n4);
                    if (spriteObject == null) continue;
                    spriteObject.freeResources();
                    smSpriteObjectCache.setElementAt(null, n4);
                }
            }
        }
    }

    private static int findIndex(int n, int n2, int n3) {
        int n4 = smImages.size();
        while (--n4 >= 0) {
            if (smImageIDs[n4] != n || n != -1 && (n2 != (smPaletteIndices[n4] & 0xFF) || n3 != smImageTransformation[n4])) continue;
            return n4;
        }
        return -1;
    }

    public static byte[] createPng(int[] nArray, byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        boolean bl = (n5 & 1) != 0;
        boolean bl2 = (n5 & 2) != 0;
        boolean bl3 = n3 == -1 && n4 != 0;
        int n9 = 4;
        int n10 = 4;
        int n11 = 0;
        if (n3 == -1) {
            n9 = 1;
            n10 = 1;
            n11 = 3 * nArray.length + 4 + 4 + 4 + 1 + 4 + 4 + 4;
        } else if (n3 == 254) {
            n10 = 3;
        }
        int n12 = n;
        n = n * n6 >> 10;
        n = n > 0 ? n : 1;
        n2 = n2 * n6 >> 10;
        n2 = n2 > 0 ? n2 : 1;
        int n13 = 65531;
        n13 -= n13 % (n * n9 + 1);
        int n14 = n * n2 * n9 + n2;
        int n15 = (n14 - 1) / n13 + 1;
        int n16 = 6 + n14 + n15 * 5;
        byte[] byArray2 = new byte[57 + n16 + n11];
        byArray2[0] = -119;
        byArray2[1] = 80;
        byArray2[2] = 78;
        byArray2[3] = 71;
        byArray2[4] = 13;
        byArray2[5] = 10;
        byArray2[6] = 26;
        byArray2[7] = 10;
        byArray2[11] = 13;
        byArray2[12] = 73;
        byArray2[13] = 72;
        byArray2[14] = 68;
        byArray2[15] = 82;
        byArray2[18] = (byte)(n >> 8);
        byArray2[19] = (byte)n;
        byArray2[22] = (byte)(n2 >> 8);
        byArray2[23] = (byte)n2;
        byArray2[24] = 8;
        byArray2[25] = (byte)(n3 == -1 ? 3 : 6);
        int n17 = DavinciUtilities.crc32(byArray2, 12, 17);
        byArray2[29] = (byte)(n17 >> 24);
        byArray2[30] = (byte)(n17 >> 16);
        byArray2[31] = (byte)(n17 >> 8);
        byArray2[32] = (byte)n17;
        int n18 = 33;
        if (n3 == -1) {
            n8 = nArray.length * 3;
            byArray2[35] = (byte)(n8 >> 8);
            byArray2[36] = (byte)n8;
            byArray2[37] = 80;
            byArray2[38] = 76;
            byArray2[39] = 84;
            byArray2[40] = 69;
            n18 = 41;
            for (n7 = 0; n7 < nArray.length; ++n7) {
                byArray2[n18++] = (byte)(nArray[n7] >> 16);
                byArray2[n18++] = (byte)(nArray[n7] >> 8);
                byArray2[n18++] = (byte)nArray[n7];
            }
            n17 = DavinciUtilities.crc32(byArray2, n18 - n8 - 4, n8 + 4);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
            n18 += 3;
            byArray2[n18++] = 1;
            byArray2[n18++] = 116;
            byArray2[n18++] = 82;
            byArray2[n18++] = 78;
            byArray2[n18++] = 83;
            n17 = DavinciUtilities.crc32(byArray2, ++n18 - 5, 5);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18++] = (byte)n17;
        }
        byArray2[n18++] = (byte)(n16 >> 24);
        byArray2[n18++] = (byte)(n16 >> 16);
        byArray2[n18++] = (byte)(n16 >> 8);
        byArray2[n18++] = (byte)n16;
        n8 = n18;
        byArray2[n18++] = 73;
        byArray2[n18++] = 68;
        byArray2[n18++] = 65;
        byArray2[n18++] = 84;
        byArray2[n18++] = 120;
        byArray2[n18++] = 1;
        n7 = 1;
        int n19 = n13;
        int n20 = 0;
        boolean bl4 = n6 == 1024 && n5 == 0 && bl3;
        n9 *= n;
        for (int i = 0; i < n15; ++i) {
            if (i == n15 - 1) {
                byArray2[n18] = 1;
                n19 = (n14 - 1) % n13 + 1;
            }
            int n21 = ++n18;
            byArray2[n21] = (byte)n19;
            int n22 = ++n18;
            byArray2[n22] = (byte)(n19 >> 8);
            int n23 = n19 ^ 0xFFFF;
            int n24 = ++n18;
            byArray2[n24] = (byte)n23;
            int n25 = ++n18;
            ++n18;
            byArray2[n25] = (byte)(n23 >> 8);
            for (int j = 0; n20 < n2 && j < n19; j += n9, ++n20) {
                int n26;
                int n27;
                int n28;
                ++j;
                ++n18;
                int n29 = n28 = bl2 ? n2 - n20 - 1 : n20;
                if (n6 != 1024) {
                    n28 = (n28 << 10) / n6;
                }
                n28 *= n12 * n10;
                n28 += n4;
                if (n3 == -1 && n6 == 1024) {
                    if (bl) {
                        n27 = n28 + n - 1;
                        n26 = n;
                        while (--n26 >= 0) {
                            byArray2[n18++] = byArray[n27--];
                        }
                        continue;
                    }
                    n27 = n28;
                    n26 = n;
                    while (--n26 >= 0) {
                        byArray2[n18++] = byArray[n27++];
                    }
                    continue;
                }
                for (n27 = 0; n27 < n; ++n27) {
                    int n30 = n26 = bl ? n - n27 - 1 : n27;
                    if (n6 != 1024) {
                        n26 = (n26 << 10) / n6;
                    }
                    int n31 = n28 + n26 * n10;
                    byArray2[n18++] = byArray[n31];
                    if (n3 == -1) continue;
                    byArray2[n18++] = byArray[++n31];
                    byArray2[n18++] = byArray[++n31];
                    byArray2[n18++] = n3 == 255 ? byArray[++n31] : -1;
                }
            }
            if (bl4) continue;
            n7 = DavinciUtilities.adler32(byArray2, n18 - n19, n19, n7);
        }
        if (bl4) {
            byArray2[n18++] = byArray[2];
            byArray2[n18++] = byArray[3];
            byArray2[n18++] = byArray[4];
            byArray2[n18++] = byArray[5];
            byArray2[n18++] = byArray[6];
            byArray2[n18++] = byArray[7];
            byArray2[n18++] = byArray[8];
            byArray2[n18] = byArray[9];
        } else {
            byArray2[n18++] = (byte)(n7 >>> 24);
            byArray2[n18++] = (byte)(n7 >>> 16);
            byArray2[n18++] = (byte)(n7 >>> 8);
            byArray2[n18++] = (byte)n7;
            n17 = DavinciUtilities.crc32(byArray2, n8, n18 - n8);
            byArray2[n18++] = (byte)(n17 >>> 24);
            byArray2[n18++] = (byte)(n17 >>> 16);
            byArray2[n18++] = (byte)(n17 >>> 8);
            byArray2[n18] = (byte)n17;
        }
        n18 += 5;
        byArray2[n18++] = 73;
        byArray2[n18++] = 69;
        byArray2[n18++] = 78;
        byArray2[n18++] = 68;
        byArray2[n18++] = -82;
        byArray2[n18++] = 66;
        byArray2[n18++] = 96;
        byArray2[n18] = -126;
        return byArray2;
    }

    private static int adler32(byte[] byArray, int n, int n2, int n3) {
        int n4 = n3 >>> 16;
        int n5 = n3 & 0xFFFF;
        n2 += n;
        while (n < n2) {
            n5 = (n5 + (byArray[n] & 0xFF)) % 65521;
            n4 = (n4 + n5) % 65521;
            ++n;
        }
        return (n4 << 16) + n5;
    }

    private static int crc32(byte[] byArray, int n, int n2) {
        int n3;
        if (smCrcTable == null) {
            smCrcTable = new int[256];
            for (int i = 0; i < 256; ++i) {
                n3 = i;
                for (int j = 0; j < 8; ++j) {
                    n3 = (n3 & 1) != 0 ? 0xEDB88320 ^ n3 >>> 1 : (n3 >>>= 1);
                    DavinciUtilities.smCrcTable[i] = n3;
                }
            }
        }
        n3 = -1;
        n2 += n;
        while (n < n2) {
            n3 = smCrcTable[(n3 ^ byArray[n]) & 0xFF] ^ n3 >>> 8;
            ++n;
        }
        return ~n3;
    }

    public static void releaseUnreferencedImages() {
        int n = smImages.size();
        while (--n >= 0) {
            if (smImageReferences[n] != 0 || DavinciUtilities.getImageFromCache(n) == null) continue;
            smImages.setElementAt(null, n);
            DavinciUtilities.smImageIDs[n] = -1;
        }
    }

    private static void precalcSinTable() {
        int n;
        smSinTable = new int[256];
        int n2 = 0;
        int n3 = 32768;
        for (n = 0; n < 64; ++n) {
            DavinciUtilities.smSinTable[n] = n2;
            n2 += (n3 -= n2 * 804 >> 15) * 804 >> 15;
        }
        DavinciUtilities.smSinTable[n++] = 32768;
        while (n <= 128) {
            DavinciUtilities.smSinTable[n] = smSinTable[64 - (n - 64)];
            ++n;
        }
        while (n < 256) {
            DavinciUtilities.smSinTable[n] = -smSinTable[n - 128];
            ++n;
        }
    }

    public static final int sin(int n) {
        if (smSinTable == null) {
            DavinciUtilities.precalcSinTable();
        }
        int n2 = n & 0xFF;
        return smSinTable[(n >>= 8) + 1 & 0xFF] * n2 + smSinTable[n & 0xFF] * (256 - n2) >> 8;
    }

    public static final int cos(int n) {
        return DavinciUtilities.sin(n + 16384);
    }

    public static int loadAnimationIntoCache(int n) {
        int n2;
        if (smSpriteObjectID == null) {
            smSpriteObjectID = new int[609];
            smSpriteObjectReference = new short[609];
            smSpriteObjectCache = new Vector(609);
        }
        int n3 = smSpriteObjectCache.size();
        for (n2 = 0; n2 < n3; ++n2) {
            if (n != smSpriteObjectID[n2] || DavinciUtilities.getSpriteObjectFromCache(n2) == null) continue;
            return n2;
        }
        for (n2 = 0; n2 < n3 && DavinciUtilities.getSpriteObjectFromCache(n2) != null; ++n2) {
        }
        if (n2 >= smSpriteObjectID.length) {
            int n4 = smSpriteObjectID.length << 1;
            short[] sArray = new short[n4];
            int[] nArray = new int[n4];
            System.arraycopy(smSpriteObjectReference, 0, sArray, 0, n4);
            System.arraycopy(smSpriteObjectID, 0, nArray, 0, n4);
            smSpriteObjectReference = sArray;
            smSpriteObjectID = nArray;
        }
        if (n2 == n3) {
            smSpriteObjectCache.addElement(null);
        }
        smSpriteObjectCache.setElementAt(new SpriteObject(), n2);
        DavinciUtilities.smSpriteObjectID[n2] = n;
        Animation animation = DavinciUtilities.loadAnimation(n);
        smSpriteObjectCache.setElementAt(new SpriteObject(animation), n2);
        return n2;
    }

    public static Image getImageFromCache(int n) {
        return (Image)smImages.elementAt(n);
    }

    public static SpriteObject getSpriteObjectFromCache(int n) {
        return (SpriteObject)smSpriteObjectCache.elementAt(n);
    }

    public static int interpolateColor(int n, int n2, int n3, int n4) {
        int n5 = DavinciUtilities.interpolateValue(n >>> 24, n2 >>> 24, n3, n4);
        int n6 = DavinciUtilities.interpolateValue(n >> 16 & 0xFF, n2 >> 16 & 0xFF, n3, n4);
        int n7 = DavinciUtilities.interpolateValue(n & 0xFF00, n2 & 0xFF00, n3, n4);
        int n8 = DavinciUtilities.interpolateValue(n & 0xFF, n2 & 0xFF, n3, n4);
        return n5 << 24 | n6 << 16 | n7 & 0xFF00 | n8;
    }

    public static int interpolateValue(int n, int n2, int n3, int n4) {
        return n + (n2 - n) * n3 / n4;
    }

    public static final int bilinearFilter(int[] nArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        int n9 = n >> 8;
        int n10 = n2 >> 8;
        int n11 = n10 * n3 + n9;
        if (n9 != -1 && n10 != -1) {
            n8 = nArray[n11];
            n7 = n9 < n3 - 1 ? nArray[n11 + 1] : n8 & 0xFFFFFF;
            n6 = n7 & 0xFFFFFF;
            n5 = n8 & 0xFFFFFF;
            if (n10 < n4 - 1) {
                n11 += n3;
                if (n9 < n3 - 1) {
                    n6 = nArray[n11 + 1];
                }
                n5 = nArray[n11];
            }
        } else if (n9 == -1) {
            ++n11;
            if (n10 == -1) {
                n6 = nArray[n11 + n3];
                n7 = n5 = n6 & 0xFFFFFF;
                n8 = n5;
            } else {
                n7 = nArray[n11];
                n8 = n6 = n7 & 0xFFFFFF;
                if (n10 < n4 - 1) {
                    n6 = nArray[n11 + n3];
                }
                n5 = n6 & 0xFFFFFF;
            }
        } else {
            n5 = nArray[n11 += n3];
            n8 = n6 = n5 & 0xFFFFFF;
            if (n9 < n3 - 1) {
                n6 = nArray[n11 + 1];
            }
            n7 = n6 & 0xFFFFFF;
        }
        n10 = n2 & 0xFF;
        n9 = n & 0xFF;
        int n12 = n8 >>> 24;
        int n13 = n12 + (((n5 >>> 24) - n12) * n10 >> 8);
        n12 = n7 >>> 24;
        int n14 = n12 + (((n6 >>> 24) - n12) * n10 >> 8);
        int n15 = n13 + ((n14 - n13) * n9 >> 8) << 24;
        n12 = n8 & 0xFF00FF;
        n13 = n12 + (((n5 & 0xFF00FF) - n12) * n10 >> 8) & 0xFF00FF;
        n12 = n7 & 0xFF00FF;
        n14 = n12 + (((n6 & 0xFF00FF) - n12) * n10 >> 8) & 0xFF00FF;
        n15 |= n13 + ((n14 - n13) * n9 >> 8) & 0xFF00FF;
        n12 = n8 & 0xFF00;
        n13 = n12 + (((n5 & 0xFF00) - n12) * n10 >> 8);
        n12 = n7 & 0xFF00;
        n14 = n12 + (((n6 & 0xFF00) - n12) * n10 >> 8);
        return n15 |= n13 + ((n14 - n13) * n9 >> 8) & 0xFF00;
    }

    static {
        smImages = new Vector(609, 609);
        smImageReferences = new short[609];
        smImageIDs = new int[609];
        smPaletteIndices = new byte[609];
        smImageTransformation = new short[609];
    }
}

