/*
 * Decompiled with CFR 0.152.
 */
package GameEngine;

import GameEngine.ImageResizer;
import java.io.IOException;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Layer;
import javax.microedition.lcdui.game.LayerManager;
import javax.microedition.lcdui.game.Sprite;

public class LevelLoader {
    private ImageResizer resizer;
    private int iHeight;
    private int iWidth;
    private int iBackgroundWidth;

    public LevelLoader(int _width, int _height) {
        this.resizer = new ImageResizer(_width, _height);
        this.iHeight = _height;
        this.iWidth = _width;
    }

    public LayerManager getLevel() {
        LayerManager lm = new LayerManager();
        try {
            int[] frameSequence = new int[]{0, 1};
            Sprite spr = null;
            int offset = (this.iWidth - this.iBackgroundWidth) / 2;
            spr = this.resizer.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/bearSprite.png"), 2);
            spr.defineReferencePixel(spr.getWidth() / 2, spr.getHeight() / 2);
            spr.setRefPixelPosition(offset + spr.getWidth() / 2 + this.iBackgroundWidth / 50, this.iHeight / 2);
            spr.setFrameSequence(frameSequence);
            lm.append((Layer)spr);
            spr = this.resizer.scaleAnimatedSpriteInAutoRatioToScreen(Image.createImage((String)"/resGFX/bearSprite.png"), 2);
            spr.defineReferencePixel(spr.getWidth() / 2, spr.getHeight() / 2);
            spr.setRefPixelPosition(this.iWidth - offset - spr.getWidth() / 2 - this.iBackgroundWidth / 50, this.iHeight / 2);
            spr.setFrameSequence(frameSequence);
            lm.append((Layer)spr);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return lm;
    }

    public Sprite getGameBackground() {
        Sprite gameBackground = null;
        try {
            gameBackground = new Sprite(this.resizer.fixBackgroundImageToScreen(Image.createImage((String)"/resGFX/screen.png")));
            this.iBackgroundWidth = this.resizer.getBackgroundWidth();
            gameBackground.defineReferencePixel(gameBackground.getWidth() / 2, gameBackground.getHeight() / 2);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return gameBackground;
    }
}

