/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.RaycastTerrain;

public class Interpolants {
    public static final int INTERPOLANTS_SHIFT = 10 - RaycastTerrain.PATCH_SHIFT_SCREEN + 1;
    int h0;
    int h1;
    int h2;
    int h3;
    int h4;
    int h5;
    int h6;
    int h7;
    int dx0;
    int dx1;
    int dx2;
    int dx3;
    int dx4;
    int dy0;
    int dy1;
    int dy2;
    int cx;
    int cy;
    int rx;
    int ry;
    int hx0;
    int hx1;
    int height;
    int heightLeft;
    int heightBottom;
    byte[] hm;
    int hmw;
    int hmh;
    int hmo;

    public void setMap(byte[] byArray, int n, int n2) {
        this.hm = byArray;
        this.hmw = n;
        this.hmh = n2;
    }

    public void setupInterpolantsX(int n, int n2) {
        this.cx = n >> RaycastTerrain.PATCH_SHIFT_SCREEN;
        this.rx = (n & 0x1F) >> 1;
        if (this.cx > this.hmw - 3) {
            this.cx = this.hmw - 3;
            this.rx = 31;
        }
        this.cy = n2 >> RaycastTerrain.PATCH_SHIFT_SCREEN;
        this.ry = (n2 & 0x1F) >> 1;
        this.hmo = this.cx + this.cy * this.hmw;
        this.h0 = this.hm[this.hmo];
        this.h1 = this.hm[this.hmo + 1];
        this.h3 = this.hm[this.hmo + this.hmw];
        this.h4 = this.hm[this.hmo + this.hmw + 1];
        this.dx0 = this.h1 - this.h0 << INTERPOLANTS_SHIFT;
        this.dx1 = this.h4 - this.h3 << INTERPOLANTS_SHIFT;
        this.hx0 = (this.h0 << 10) + this.rx * this.dx0;
        this.hx1 = (this.h3 << 10) + this.rx * this.dx1;
        this.dy0 = this.hx1 - this.hx0 >> RaycastTerrain.STEPS_PER_PATCH_SHIFT;
        this.height = this.hx0 + this.ry * this.dy0;
    }

    public void setupInterpolantsY() {
        this.h2 = this.hm[this.hmo + 2];
        this.h5 = this.hm[this.hmo + this.hmw + 2];
        this.h6 = this.hm[this.hmo + this.hmw + this.hmw];
        this.h7 = this.hm[this.hmo + this.hmw + this.hmw + 1];
        this.dx2 = this.h7 - this.h6 << INTERPOLANTS_SHIFT;
        this.dx3 = this.h2 - this.h1 << INTERPOLANTS_SHIFT;
        this.dx4 = this.h5 - this.h4 << INTERPOLANTS_SHIFT;
        this.hx0 = (this.h1 << 10) + this.rx * this.dx3;
        this.hx1 = (this.h4 << 10) + this.rx * this.dx4;
        this.dy1 = this.hx1 - this.hx0 >> RaycastTerrain.STEPS_PER_PATCH_SHIFT;
        this.heightLeft = this.hx0 + this.ry * this.dy1;
        this.hx0 = (this.h3 << 10) + this.rx * this.dx1;
        this.hx1 = (this.h6 << 10) + this.rx * this.dx2;
        this.dy2 = this.hx1 - this.hx0 >> RaycastTerrain.STEPS_PER_PATCH_SHIFT;
        this.heightBottom = this.hx0 + this.ry * this.dy2;
    }

    public boolean stepY() {
        this.height += this.dy0;
        this.heightLeft += this.dy1;
        this.heightBottom += this.dy2;
        ++this.ry;
        if (this.ry >= RaycastTerrain.STEPS_PER_PATCH) {
            this.ry -= RaycastTerrain.STEPS_PER_PATCH;
            ++this.cy;
            if (this.cy >= this.hmh - 2) {
                return false;
            }
            this.hmo += this.hmw;
            this.h0 = this.hm[this.hmo];
            this.h1 = this.hm[this.hmo + 1];
            this.h3 = this.hm[this.hmo + this.hmw];
            this.h4 = this.hm[this.hmo + this.hmw + 1];
            this.dx0 = this.h1 - this.h0 << INTERPOLANTS_SHIFT;
            this.dx1 = this.h4 - this.h3 << INTERPOLANTS_SHIFT;
            this.hx0 = (this.h0 << 10) + this.rx * this.dx0;
            this.hx1 = (this.h3 << 10) + this.rx * this.dx1;
            this.dy0 = this.hx1 - this.hx0 >> RaycastTerrain.STEPS_PER_PATCH_SHIFT;
            this.height = this.hx0 + this.ry * this.dy0;
            this.setupInterpolantsY();
        }
        return true;
    }
}

