/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Game;
import javax.microedition.lcdui.Graphics;
import tinbrain.GCanvas;
import tinbrain.RM;
import tinbrain.math3D.M3D;
import tinbrain.math3D.Point2D;
import tinbrain.util.GL;

public class Bee {
    private int worldPositionX;
    private int worldPositionY;
    private Point2D mCurrentVelocity;
    private int mCurrentRotation;
    public int mScreenPosX;
    public int mScreenPosY;
    private int worldPositionOldX;
    private int worldPositionOldY;
    private int[] worldBounds = new int[4];
    private int[] estimatedScreenBounds = new int[4];
    private int score;
    private boolean mFirePressed;
    private static int mSwarmSineIndex = 0;
    private static int[] sSwarmBuffer = new int[2];
    private int mPollinationTarget = -1;
    private int mOrbitAngle = -1;
    private int mOrbitStep = 0;
    private int mOrbitStepDirection = 0;
    private int mOrbitRadius = 1024;
    private boolean mOrbitHasHarvested = false;
    private int mOrbitStart = -1;
    private int mOrbitPosX = 0;
    private int mOrbitPosY = 0;
    private int mOrbitStartPosX = 0;
    private int mOrbitStartPosY = 0;
    boolean mOrbitting = false;

    public Bee() {
        this.mCurrentVelocity = new Point2D();
    }

    public void reset() {
        RM.getImage(48);
        this.score = 0;
        int[] nArray = Game.carBounds;
        int n = nArray[0];
        int n2 = nArray[2];
        int n3 = nArray[1];
        int n4 = nArray[3];
        this.worldPositionX = GCanvas.getRandom(n, n2);
        this.worldPositionY = GCanvas.getRandom(n3, n4);
        while (Game.obstacleToPlayerCollide(this)) {
            this.worldPositionX = GCanvas.getRandom(n, n2);
            this.worldPositionY = GCanvas.getRandom(n3, n4);
        }
        this.mCurrentVelocity.set(0, 0);
        this.mOrbitting = false;
        this.mCurrentRotation = 0;
        this.mFirePressed = false;
    }

    public void initSystem() {
        this.postStep(0);
        this.mOrbitting = false;
        this.mCurrentVelocity.set(0, 0);
        this.mCurrentRotation = 0;
    }

    public final void castShadow(Graphics graphics) {
        int n = this.worldPositionX >> 10;
        int n2 = this.worldPositionY >> 10;
        n += 0;
        n2 += 80;
        n2 >>= 1;
        GCanvas.drawSprite(4, n >>= 0, n2 >>= 0, 0);
    }

    private void doSwarm() {
        int n = 1024 - (int)(((long)this.mCurrentVelocity.length() << 10) / 14336L);
        if (this.mOrbitting) {
            n = 0;
        }
        Bee.sSwarmBuffer[0] = 10 * n * GCanvas.sin(mSwarmSineIndex >> 1) >> 10;
        Bee.sSwarmBuffer[1] = 10 * n * GCanvas.cos(mSwarmSineIndex * 3) >> 10;
        mSwarmSineIndex += 20;
    }

    private final int getFrameFromAngle(int n, int n2) {
        int n3 = GCanvas.cos(n += 64);
        int n4 = GCanvas.sin(n);
        n3 >>= 8;
        n4 >>= 8;
        n3 = GCanvas.clamp(n3, -3, 3);
        n4 = GCanvas.clamp(n4, -3, 3);
        int n5 = 0;
        if (n4 < 0) {
            n5 = 4 - n3;
        } else if (n4 > 0) {
            n5 = 12 + n3;
        } else {
            int n6 = n5 = n3 < 0 ? 8 : 0;
        }
        if (n2 == 8) {
            n5 >>= 1;
        } else if (n2 == 4) {
            n5 >>= 2;
        }
        return n5;
    }

    public final void onDraw(Graphics graphics) {
        int n = 0;
        n = this.mOrbitting ? (this.mOrbitStep < 0 ? this.mOrbitAngle + 512 : this.mOrbitAngle) : 512 - this.mCurrentRotation + 256;
        int n2 = 0;
        n2 = this.getFrameFromAngle(n, 16);
        this.doSwarm();
        int n3 = this.worldPositionX + sSwarmBuffer[0];
        int n4 = this.worldPositionY + sSwarmBuffer[1];
        int n5 = Game.getScreenXFromWorldPosX(n3);
        int n6 = Game.getScreenYFromWorldPos(n3, n4);
        this.mScreenPosX = Game.getScreenXFromWorldPosX(this.worldPositionX);
        this.mScreenPosY = Game.getScreenYFromWorldPos(this.worldPositionX, this.worldPositionY);
        GCanvas.drawSprite(12, n5, n6, n2);
        if ((GCanvas.getGlobalFrameCount() & 1) == 1) {
            GCanvas.drawSprite(13, n5, n6, n2);
        }
    }

    public void steer(int n, int n2) {
        int n3 = -n;
        int n4 = -n2;
        int n5 = 750;
        this.mCurrentVelocity.x += n5 * n3;
        this.mCurrentVelocity.y += n5 * n4;
        int n6 = this.mCurrentVelocity.length();
        if (n6 > 0) {
            this.mCurrentRotation = GL.mathAtan2Unit((this.mCurrentVelocity.x << 10) / n6, (this.mCurrentVelocity.y << 10) / n6);
        }
        this.mCurrentVelocity.capLength(14336);
    }

    public final void step() {
        if (this.mOrbitting) {
            this.doOrbitting();
        } else {
            this.mCurrentVelocity.scale(1018);
            this.worldPositionX -= this.mCurrentVelocity.x;
            this.worldPositionY += this.mCurrentVelocity.y;
        }
    }

    public final void postStep(int n) {
        int n2 = this.worldPositionX - this.worldPositionOldX;
        int n3 = this.worldPositionY - this.worldPositionOldY;
        if (this.mOrbitting) {
            this.worldPositionOldX = this.mOrbitPosX;
            this.worldPositionOldY = this.mOrbitPosY;
        } else {
            this.worldPositionOldX = this.worldPositionX;
            this.worldPositionOldY = this.worldPositionY;
        }
        RM.setRectEmpty(this.worldBounds);
        RM.expandRect(this.worldBounds, this.worldPositionX, this.worldPositionY);
        RM.shiftRight(this.worldBounds, 10);
        RM.inflateRect(this.worldBounds, 2);
        this.estimatedScreenBounds[0] = this.worldBounds[0];
        this.estimatedScreenBounds[2] = this.worldBounds[2];
        this.estimatedScreenBounds[1] = this.worldBounds[1] >> 1;
        this.estimatedScreenBounds[3] = this.worldBounds[3] >> 1;
        RM.shiftRight(this.estimatedScreenBounds, 0);
    }

    public Point2D getVelocityVector() {
        return this.mCurrentVelocity;
    }

    public final void satisfy(boolean bl) {
        Game.obstacleToPlayerCollide(this);
        int[] nArray = Game.carBounds;
        int n = nArray[0];
        int n2 = nArray[2];
        int n3 = nArray[1];
        int n4 = nArray[3];
        if (this.worldPositionX < n) {
            this.worldPositionX = n;
            this.mCurrentVelocity.x = -this.mCurrentVelocity.x;
            this.mCurrentVelocity.scale(512);
        }
        if (this.worldPositionX > n2) {
            this.worldPositionX = n2;
            this.mCurrentVelocity.x = -this.mCurrentVelocity.x;
            this.mCurrentVelocity.scale(512);
        }
        if (this.worldPositionY < n3) {
            this.worldPositionY = n3;
            this.mCurrentVelocity.y = -this.mCurrentVelocity.y;
            this.mCurrentVelocity.scale(512);
        }
        if (this.worldPositionY > n4) {
            this.worldPositionY = n4;
            this.mCurrentVelocity.y = -this.mCurrentVelocity.y;
            this.mCurrentVelocity.scale(512);
        }
    }

    public final void deflectVel(Point2D point2D) {
        point2D.x *= 1000;
        point2D.y *= 1000;
        point2D.unit();
        this.mCurrentVelocity.set(-2 * ((this.mCurrentVelocity.x * point2D.x >> 10) * point2D.x >> 10) + this.mCurrentVelocity.x, -2 * ((this.mCurrentVelocity.y * point2D.y >> 10) * point2D.y >> 10) + this.mCurrentVelocity.y);
        this.mCurrentVelocity.scale(512);
    }

    public final void negateMoveBack() {
        this.worldPositionX += this.mCurrentVelocity.x * 2000 >> 10;
        this.worldPositionY -= this.mCurrentVelocity.y * 2000 >> 10;
    }

    public int[] getEstimatedScreenBounds() {
        return this.estimatedScreenBounds;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int n) {
        this.score = n;
    }

    public int getWorldPositionX() {
        return this.worldPositionX;
    }

    public int getWorldPositionY() {
        return this.worldPositionY;
    }

    public int getWorldPositionZ() {
        return Game.getTerrainHeight(this.worldPositionX, this.worldPositionY);
    }

    public int getWorldPositionOldX() {
        return this.worldPositionOldX;
    }

    public int getWorldPositionOldY() {
        return this.worldPositionOldY;
    }

    public int getWorldPositionOldZ() {
        return Game.getTerrainHeight(this.worldPositionOldX, this.worldPositionOldY);
    }

    private void closestPointOnLine(Point2D point2D, Point2D point2D2, Point2D point2D3, Point2D point2D4) {
        Point2D point2D5 = M3D.locPoint2D(point2D2);
        Point2D point2D6 = M3D.locPoint2D();
        point2D6.setDiff(point2D3, point2D);
        int n = point2D5.length();
        if (n == 0) {
            point2D4.set(point2D);
            M3D.locFree(point2D6);
            M3D.locFree(point2D5);
            return;
        }
        point2D5.div(n);
        int n2 = point2D5.dot(point2D6);
        point2D4.set(point2D);
        point2D4.addScaled(point2D5, n2);
        M3D.locFree(point2D6);
        M3D.locFree(point2D5);
    }

    public void startOrbitting() {
        this.mPollinationTarget = Game.flowerQueryClosestInRange(this.worldPositionX, this.worldPositionY, 51200);
        if (this.mPollinationTarget != -1) {
            int n;
            int n2;
            int n3 = Game.flowerGetWorldPosX(this.mPollinationTarget);
            int n4 = n3 - this.worldPositionX;
            int n5 = n4 * n4 + (n2 = (n = Game.flowerGetWorldPosY(this.mPollinationTarget)) - this.worldPositionY) * n2 >> 10;
            if (n5 > 0) {
                n5 = GCanvas.sqrt(n5);
                n4 = (n4 << 10) / n5;
                n2 = (n2 << 10) / n5;
            }
            Point2D point2D = M3D.locPoint2D();
            Point2D point2D2 = M3D.locPoint2D();
            Point2D point2D3 = M3D.locPoint2D(this.worldPositionX, this.worldPositionY);
            Point2D point2D4 = M3D.locPoint2D(n3, n);
            this.closestPointOnLine(point2D3, this.mCurrentVelocity, point2D4, point2D2);
            point2D.setDiff(point2D2, point2D4);
            int n6 = point2D.length();
            if (n6 > 0) {
                point2D.div(n6);
            }
            this.mOrbitAngle = GL.mathAtan2Unit(point2D.x, point2D.y);
            this.mOrbitStep = 60;
            this.mOrbitStepDirection = point2D.dot(this.mCurrentVelocity.y, -this.mCurrentVelocity.x) > 0 ? 1 : -1;
            M3D.locFree(point2D4);
            M3D.locFree(point2D3);
            M3D.locFree(point2D2);
            M3D.locFree(point2D);
            this.mOrbitRadius = 30720;
            this.mOrbitStart = GCanvas.getGlobalFrameCount();
            this.mOrbitPosX = n3;
            this.mOrbitStartPosX = this.worldPositionX;
            this.mOrbitPosY = n;
            this.mOrbitStartPosY = this.worldPositionY;
            this.mOrbitHasHarvested = false;
            this.mOrbitting = true;
        }
    }

    public void endOrbitting() {
        this.mOrbitting = false;
        this.mCurrentRotation = this.mOrbitStepDirection < 0 ? this.mOrbitAngle + 512 : this.mOrbitAngle;
        this.mPollinationTarget = -1;
    }

    public void doOrbitting() {
        int n = GCanvas.getGlobalFrameCount() - this.mOrbitStart;
        int n2 = 20;
        if (!this.mOrbitHasHarvested && n > n2) {
            Game.flowerOnHarvest(this.mPollinationTarget, this);
            this.mOrbitHasHarvested = true;
        }
        int n3 = this.mOrbitPosX + (GCanvas.sin(this.mOrbitAngle) * this.mOrbitRadius >> 10);
        int n4 = this.mOrbitPosY + (GCanvas.cos(this.mOrbitAngle) * this.mOrbitRadius >> 10);
        int n5 = (n << 10 << 10) / 153600;
        n5 = GL.mathClamp(n5, 0, 1024);
        this.mOrbitStep = 60;
        this.mOrbitStep += -20 * n5 >> 10;
        this.mOrbitStep *= this.mOrbitStepDirection;
        this.mOrbitAngle += this.mOrbitStep;
        this.mCurrentVelocity.set(n3, n4);
        this.mCurrentVelocity.sub(this.worldPositionX, this.worldPositionY);
        this.mCurrentVelocity.x = -this.mCurrentVelocity.x;
        int n6 = 14336;
        this.mCurrentVelocity.setLength(n6 += -4096 * n5 >> 10);
        if (this.mOrbitStart + 20 > GCanvas.getGlobalFrameCount()) {
            int n7 = GCanvas.getGlobalFrameCount() - this.mOrbitStart;
            int n8 = (n7 << 10) / 20;
            this.worldPositionX = GCanvas.mul(n3 - this.mOrbitStartPosX, n8) + this.mOrbitStartPosX;
            this.worldPositionY = GCanvas.mul(n4 - this.mOrbitStartPosY, n8) + this.mOrbitStartPosY;
        } else {
            this.worldPositionX = n3;
            this.worldPositionY = n4;
        }
    }

    public boolean isOrbitting() {
        return this.mOrbitting;
    }

    public int getOrbittingCenterX() {
        return this.mOrbitPosX;
    }

    public int getOrbittingCenterY() {
        return this.mOrbitPosY;
    }

    public void setFirePressed(boolean bl) {
        boolean bl2 = this.mFirePressed;
        this.mFirePressed = bl;
        if (this.mFirePressed && !bl2) {
            this.startOrbitting();
        } else if (!this.mFirePressed && bl2) {
            this.endOrbitting();
        }
        if (!this.mFirePressed) {
            this.mOrbitting = false;
        }
    }

    public int getPollinationTarget() {
        return this.mPollinationTarget;
    }
}

