/*
 * Decompiled with CFR 0.152.
 */
package mirl;

import com.tinyline.tiny2d.Tiny2D;
import com.tinyline.tiny2d.TinyBitmap;
import com.tinyline.tiny2d.TinyColor;
import com.tinyline.tiny2d.TinyMatrix;
import com.tinyline.tiny2d.TinyPixbuf;
import javax.microedition.lcdui.Image;

public class Mirl {
    public static Tiny2D getTiny(int width, int height) {
        Tiny2D tiny2d = new Tiny2D(new TinyPixbuf(width, height));
        tiny2d.invalidate();
        tiny2d.matrix = new TinyMatrix();
        tiny2d.fillRule = 2;
        tiny2d.fillColor = new TinyColor(-16777216);
        tiny2d.fillAlpha = 255;
        tiny2d.strokeColor = TinyColor.NONE;
        tiny2d.strokeAlpha = 255;
        tiny2d.dashArray = null;
        tiny2d.dashPhase = 0;
        tiny2d.strokeWidth = 256;
        tiny2d.capStyle = 1;
        tiny2d.joinStyle = 1;
        tiny2d.miterLimit = 1024;
        tiny2d.globalAlpha = 255;
        tiny2d.devClip = tiny2d.getClip();
        tiny2d.antialias = true;
        return tiny2d;
    }

    public static Image rotateImage(Image orig, int rotDeg) {
        return Mirl.rotateImage(orig, rotDeg, orig.getWidth() / 2, orig.getHeight() / 2);
    }

    public static Image rotateImage(Image img, int rotDeg, int midX, int midY) {
        Tiny2D tiny = Mirl.getTiny(img.getWidth(), img.getHeight());
        TinyMatrix matrix = new TinyMatrix();
        matrix.rotate(rotDeg << 8, midX << 8, midY << 8);
        tiny.matrix = matrix;
        TinyColor color = new TinyColor(3, new TinyMatrix());
        color.bitmap = new Bitmap(img);
        tiny.fillColor = color;
        tiny.drawRect(0, 0, img.getWidth() << 8, img.getHeight() << 8);
        return Image.createRGBImage((int[])tiny.getPixelBuffer().pixels32, (int)tiny.getPixelBuffer().width, (int)tiny.getPixelBuffer().height, (boolean)true);
    }

    public static class Bitmap
    extends TinyBitmap {
        public Bitmap(Image image) {
            this.width = image.getWidth();
            this.height = image.getHeight();
            this.pixels32 = new int[image.getWidth() * image.getHeight()];
            image.getRGB(this.pixels32, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        }
    }
}

