/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.ImageBank;
import game.MainMenu;
import game.Menu;
import game.SoccerCanvas;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class HiscoreTable
extends Menu {
    private static int[] scores = new int[]{2500, 2000, 1500, 1000, 500, 400, 300, -20};
    private static String[] names = new String[]{"Pong", "Pong", "Pong", "Pong", "Pong", "Pong", "Pong", "Pong"};
    private static int maxScores = -1;
    private static int maxChars = -1;

    public HiscoreTable(SoccerCanvas canvas) {
        super(canvas, ImageBank.getImage("/highscore.jpg"), 1);
        HiscoreTable.readScores();
    }

    public void paint(Graphics gr) {
        int x = this.canvas.getWidth() / 2 - this.menuImage.getWidth() / 2;
        int y = this.canvas.getHeight() / 2 - this.menuImage.getHeight() / 2;
        gr.drawImage(this.menuImage, x, y, 0);
        y += ImageBank.getHeaderHeight();
        Font font = this.canvas.getScoreFont();
        gr.setFont(font);
        int i = 0;
        while (i < HiscoreTable.getMaxScores()) {
            gr.setColor(255, 255 - i * 12, 255 - i * 20);
            gr.drawString(names[i], x + 4, y + font.getHeight() * i, 20);
            gr.drawString("" + scores[i], x + this.menuImage.getWidth() - font.stringWidth(new String("" + scores[i])) - 4, y + font.getHeight() * i, 20);
            ++i;
        }
    }

    private static int getMaxScores() {
        if (maxScores < 0) {
            int height = ImageBank.getImage("/highscore.jpg").getHeight();
            int fontHeight = SoccerCanvas.getInstance().getScoreFont().getHeight();
            maxScores = (height - ImageBank.getHeaderHeight()) / fontHeight;
        }
        return maxScores;
    }

    public void makeSelection(int selection) {
        this.canvas.removeEnt(this);
        this.canvas.setMenu(new MainMenu(this.canvas));
    }

    public static int getMaxChars() {
        if (maxChars < 0) {
            int width = ImageBank.getImage("/highscore.jpg").getWidth();
            int fontWidth = SoccerCanvas.getInstance().getScoreFont().charWidth('W');
            maxChars = Math.max((width - 4) / fontWidth - 5, 4);
        }
        return maxChars;
    }

    public static int getLowestScore() {
        HiscoreTable.readScores();
        return scores[HiscoreTable.getMaxScores() - 1];
    }

    private static void readScores() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"hiscores", (boolean)true);
            if (rs.getNumRecords() < HiscoreTable.getMaxScores()) {
                rs.closeRecordStore();
                HiscoreTable.writeScores();
                rs = RecordStore.openRecordStore((String)"hiscores", (boolean)true);
            }
            int i = 0;
            while (i < HiscoreTable.getMaxScores()) {
                byte[] score = rs.getRecord(i * 2 + 1);
                byte[] name = rs.getRecord(i * 2 + 2);
                HiscoreTable.scores[i] = Integer.parseInt(new String(score));
                HiscoreTable.names[i] = new String(name);
                ++i;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e2) {
            e2.printStackTrace();
        }
    }

    private static void writeScores() {
        try {
            try {
                RecordStore.deleteRecordStore((String)"hiscores");
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            RecordStore rs = RecordStore.openRecordStore((String)"hiscores", (boolean)true);
            int i = 0;
            while (i < HiscoreTable.getMaxScores()) {
                byte[] score = new String("" + scores[i]).getBytes();
                byte[] name = names[i].getBytes();
                rs.addRecord(score, 0, score.length);
                rs.addRecord(name, 0, name.length);
                ++i;
            }
            rs.closeRecordStore();
        }
        catch (RecordStoreException e2) {
            e2.printStackTrace();
        }
    }

    public static void addScore(String name, int score) {
        HiscoreTable.readScores();
        int offset = -1;
        int i = 0;
        while (i < HiscoreTable.getMaxScores()) {
            if (score > scores[i]) {
                offset = i;
                break;
            }
            ++i;
        }
        if (offset > -1) {
            i = HiscoreTable.getMaxScores() - 1;
            while (i > offset) {
                HiscoreTable.scores[i] = scores[i - 1];
                HiscoreTable.names[i] = names[i - 1];
                --i;
            }
            HiscoreTable.scores[offset] = score;
            HiscoreTable.names[offset] = name;
            HiscoreTable.writeScores();
        }
    }
}

