/*
 * Decompiled with CFR 0.152.
 */
package com.tinyline.tiny2d;

import com.tinyline.tiny2d.Tiny2DProducer;
import com.tinyline.tiny2d.TinyColor;
import com.tinyline.tiny2d.TinyFont;
import com.tinyline.tiny2d.TinyGlyph;
import com.tinyline.tiny2d.TinyMatrix;
import com.tinyline.tiny2d.TinyNumber;
import com.tinyline.tiny2d.TinyPath;
import com.tinyline.tiny2d.TinyPixbuf;
import com.tinyline.tiny2d.TinyPoint;
import com.tinyline.tiny2d.TinyRect;
import com.tinyline.tiny2d.TinyVector;
import com.tinyline.tiny2d.g;

public final class Tiny2D {
    private g a;
    private Tiny2DProducer b;
    private TinyRect c;
    private TinyPixbuf d;
    public int bg;
    public boolean antialias;
    public TinyMatrix matrix;
    public TinyRect devClip;
    public TinyRect devBounds;
    public int fillRule;
    public TinyColor fillColor;
    public TinyColor strokeColor;
    public int[] dashArray;
    public int dashPhase;
    public int strokeWidth;
    public int capStyle;
    public int joinStyle;
    public int miterLimit;
    public int globalAlpha;
    public int strokeAlpha;
    public int fillAlpha;
    public static final int MIN_VALUE = Integer.MIN_VALUE;
    public static final int MAX_VALUE = Integer.MAX_VALUE;
    public static final int FIX_BITS = 8;
    public static final int FIX = 256;
    public static final int DFIX_BITS = 16;
    public static final int DFIX = 65536;
    private static final int[] e = new int[]{0, 1143, 2287, 3429, 4571, 5711, 6850, 7986, 9120, 10252, 11380, 12504, 13625, 14742, 15854, 16961, 18064, 19160, 20251, 21336, 22414, 23486, 24550, 25606, 26655, 27696, 28729, 29752, 30767, 31772, Short.MAX_VALUE, 33753, 34728, 35693, 36647, 37589, 38521, 39440, 40347, 41243, 42125, 42995, 43852, 44695, 45525, 46340, 47142, 47929, 48702, 49460, 50203, 50931, 51643, 52339, 53019, 53683, 54331, 54963, 55577, 56175, 56755, 57319, 57864, 58393, 58903, 59395, 59870, 60326, 60763, 61183, 61583, 61965, 62328, 62672, 62997, 63302, 63589, 63856, 64103, 64331, 64540, 64729, 64898, 65047, 65176, 65286, 65376, 65446, 65496, 65526, 65536};
    private static final int[] f = new int[]{0, 0, 256, 512, 768, 1024, 1280, 1536, 1792, 2048, 2048, 2304, 2560, 2816, 3072, 3328, 3584, 3584, 3840, 4096, 4352, 4608, 4608, 4864, 5120, 5376, 5632, 5632, 5888, 6144, 6400, 6400, 6656, 6912, 6912, 7168, 7424, 7680, 7680, 7936, 8192, 8192, 8448, 8448, 8704, 8960, 8960, 9216, 9216, 9472, 9472, 9728, 9984, 9984, 10240, 10240, 10496, 10496, 10752, 10752, 11008, 11008, 11264, 11264, 11264};
    private static final int[] g = new int[]{0x40000000, 1073872888, 1074265984, 1074920825, 1075836932, 1077013639, 1078450093, 1080145258, 1082097918, 1084306681, 1086769986, 1089486107, 1092453157, 1095669100, 1099131748, 1102838780, 1106787739, 1110976045, 1115401003, 1120059807, 1124949552, 1130067241, 1135409791, 1140974043, 1146756771, 1152754686, 1158964447, 1165382668, 1172005924, 1178830760, 1185853694, 1193071229, 1200479854, 1208076055, 1215856315, 1223817123, 1231954981, 1240266402, 1248747921, 1257396097, 1266207514, 1275178788, 1284306569, 1293587545, 1303018442, 1312596028, 1322317116, 1332178565, 0x50000000, 1352310217, 1362574382, 1372966831, 1383484673, 1394125071, 1404885240, 1415762448, 1426754019, 1437857331, 1449069814, 1460388955, 1471812291, 1483337417, 1494961978, 1506683672, 1518500250, 1518500250};
    public static final int FILL_STYLE_WIND = 1;
    public static final int FILL_STYLE_EO = 2;
    public static final int JOIN_MITER = 1;
    public static final int JOIN_ROUND = 2;
    public static final int JOIN_BEVEL = 3;
    public static final int CAP_BUTT = 1;
    public static final int CAP_ROUND = 2;
    public static final int CAP_SQUARE = 3;
    public static final int TEXT_ANCHOR_START = 1;
    public static final int TEXT_ANCHOR_MIDDLE = 2;
    public static final int TEXT_ANCHOR_END = 3;

    public Tiny2D(TinyPixbuf tinyPixbuf) {
        this.d = tinyPixbuf;
        this.bg = -1;
        this.fillAlpha = 255;
        this.strokeAlpha = 255;
        this.globalAlpha = 255;
        this.c = new TinyRect();
        this.a = new g();
        this.a.a(tinyPixbuf.width, tinyPixbuf.height, tinyPixbuf.pixels32);
    }

    public final void flush() {
        if (this.a != null) {
            this.a.a();
            this.a = null;
        }
    }

    public final TinyPixbuf getPixelBuffer() {
        return this.d;
    }

    public final void setTiny2DProducer(Tiny2DProducer tiny2DProducer) {
        this.b = tiny2DProducer;
    }

    public final Tiny2DProducer getTiny2DProducer() {
        return this.b;
    }

    public final void sendPixels() {
        if (!this.c.isEmpty() && this.b != null && this.b.hasConsumer()) {
            this.b.sendPixels();
            this.b.imageComplete();
        }
    }

    public final void invalidate() {
        this.c.ymin = 0;
        this.c.xmin = 0;
        this.c.xmax = this.d.width;
        this.c.ymax = this.d.height;
    }

    public final void setClip(TinyRect tinyRect) {
        this.c.xmin = tinyRect.xmin - 2;
        this.c.xmax = tinyRect.xmax + 2;
        this.c.ymin = tinyRect.ymin - 2;
        this.c.ymax = tinyRect.ymax + 2;
        this.c.xmin = Tiny2D.max(this.c.xmin, 0);
        this.c.xmax = Tiny2D.min(this.c.xmax, this.d.width);
        this.c.ymin = Tiny2D.max(this.c.ymin, 0);
        this.c.ymax = Tiny2D.min(this.c.ymax, this.d.height);
        if (this.c.xmin >= this.c.xmax || this.c.ymin >= this.c.ymax) {
            this.c.setEmpty();
        }
    }

    public final TinyRect getClip() {
        return this.c;
    }

    public final void clearRect(TinyRect tinyRect) {
        this.a.n = this.bg;
        this.a.a(tinyRect);
    }

    public final TinyRect getDevBounds(TinyMatrix tinyMatrix, int n, TinyRect tinyRect) {
        new TinyRect();
        TinyPoint tinyPoint = new TinyPoint();
        TinyRect tinyRect2 = tinyMatrix.transformToDev(tinyRect);
        com.tinyline.tiny2d.g.a(tinyPoint, n, tinyMatrix);
        if (tinyPoint.x != 0) {
            tinyRect2 = tinyRect2.grow(Tiny2D.round(tinyPoint.x) + 1, Tiny2D.round(tinyPoint.y) + 1);
        }
        return tinyRect2;
    }

    public final void drawPath(TinyPath tinyPath, TinyRect tinyRect, TinyMatrix tinyMatrix) {
        this.a.n = this.bg;
        this.a.m = this.antialias;
        this.a.a = this.matrix;
        this.a.l = this.devClip;
        this.a.b = this.devBounds;
        this.a.c = this.fillRule;
        this.a.d = this.fillColor;
        this.a.e = this.strokeColor;
        this.a.j = this.dashArray;
        this.a.k = this.dashPhase;
        this.a.f = this.strokeWidth;
        this.a.g = this.capStyle;
        this.a.h = this.joinStyle;
        this.a.i = this.miterLimit;
        this.a.q = this.globalAlpha;
        this.a.p = this.strokeAlpha;
        this.a.o = this.fillAlpha;
        TinyColor tinyColor = this.fillColor;
        TinyColor tinyColor2 = this.strokeColor;
        if (tinyRect == null) {
            tinyRect = tinyPath.getBBox();
        }
        if (tinyColor.fillType != 0 || tinyColor2.fillType != 0) {
            TinyMatrix tinyMatrix2 = this.a.a;
            if (tinyColor.fillType != 0) {
                tinyColor.setCoords(tinyMatrix2, tinyRect);
            }
            if (tinyColor2.fillType != 0) {
                tinyColor2.setCoords(tinyMatrix2, tinyRect);
            }
        }
        if (tinyMatrix != null) {
            TinyMatrix tinyMatrix3 = new TinyMatrix(this.a.a);
            int n = this.a.f;
            this.a.f = Tiny2D.div(n, tinyMatrix.a);
            this.a.a.preConcatenate(tinyMatrix);
            this.a.b = this.getDevBounds(this.a.a, this.a.f, tinyRect);
            this.a.a(tinyPath.a, tinyPath.b, tinyPath.c, tinyPath.d);
            this.a.a = tinyMatrix3;
            this.a.f = n;
            return;
        }
        this.a.b = this.getDevBounds(this.a.a, this.a.f, tinyRect);
        this.a.a(tinyPath.a, tinyPath.b, tinyPath.c, tinyPath.d);
    }

    public final void drawPath(TinyPath tinyPath) {
        this.drawPath(tinyPath, null, null);
    }

    public final void drawPath(TinyPath tinyPath, TinyRect tinyRect) {
        this.drawPath(tinyPath, tinyRect, null);
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        this.fillColor = TinyColor.NONE;
        this.drawPath(Tiny2D.lineToPath(n, n2, n3, n4), null, null);
    }

    public final void drawRect(int n, int n2, int n3, int n4) {
        this.fillRule = 2;
        this.drawPath(Tiny2D.rectToPath(n, n2, n + n3, n2 + n4), null, null);
    }

    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.fillRule = 2;
        this.drawPath(Tiny2D.roundRectToPath(n, n2, n3, n4, n5, n6), null, null);
    }

    public final void drawOval(int n, int n2, int n3, int n4) {
        this.fillRule = 2;
        this.drawPath(Tiny2D.ovalToPath(n, n2, n3, n4), null, null);
    }

    public final void drawPolyline(TinyVector tinyVector) {
        TinyPath tinyPath = Tiny2D.pointsToPath(tinyVector);
        if (tinyPath == null) {
            return;
        }
        this.drawPath(tinyPath, null, null);
    }

    public final void drawPolygon(TinyVector tinyVector) {
        TinyPath tinyPath = Tiny2D.pointsToPath(tinyVector);
        if (tinyPath == null) {
            return;
        }
        tinyPath.closePath();
        this.drawPath(tinyPath, null, null);
    }

    public final void drawChars(TinyFont tinyFont, int n, char[] cArray, int n2, int n3, int n4, int n5, int n6) {
        if (tinyFont == null || cArray == null) {
            return;
        }
        TinyPath tinyPath = Tiny2D.charsToPath(tinyFont, cArray, n2, n3);
        if (tinyPath == null) {
            return;
        }
        TinyMatrix tinyMatrix = Tiny2D.charToUserTransform(tinyPath, tinyFont, n, n4, n5, n6);
        if (tinyMatrix == null) {
            return;
        }
        this.fillRule = 2;
        this.drawPath(tinyPath, tinyPath.getBBox(), tinyMatrix);
    }

    public static final TinyMatrix charToUserTransform(TinyPath tinyPath, TinyFont tinyFont, int n, int n2, int n3, int n4) {
        if (tinyPath == null || tinyFont == null) {
            return null;
        }
        TinyMatrix tinyMatrix = new TinyMatrix();
        tinyMatrix.translate(n2, n3);
        TinyMatrix tinyMatrix2 = new TinyMatrix();
        new TinyMatrix().a = (n << 8) / tinyFont.unitsPerEm;
        tinyMatrix2.d = -tinyMatrix2.a;
        tinyMatrix2.concatenate(tinyMatrix);
        TinyRect tinyRect = tinyPath.getBBox();
        if (n4 != 1) {
            int n5 = tinyRect.xmax - tinyRect.xmin;
            if (n4 == 2) {
                n5 /= 2;
            }
            tinyMatrix.translate(-n5, 0);
            tinyMatrix2.preConcatenate(tinyMatrix);
        }
        return tinyMatrix2;
    }

    public static final TinyPath lineToPath(int n, int n2, int n3, int n4) {
        TinyPath tinyPath = new TinyPath(4);
        tinyPath.moveTo(n, n2);
        tinyPath.lineTo(n3, n4);
        return tinyPath;
    }

    public static final TinyPath rectToPath(int n, int n2, int n3, int n4) {
        TinyPath tinyPath = new TinyPath(6);
        tinyPath.moveTo(n, n2);
        tinyPath.lineTo(n3, n2);
        tinyPath.lineTo(n3, n4);
        tinyPath.lineTo(n, n4);
        tinyPath.closePath();
        return tinyPath;
    }

    public static final TinyPath ovalToPath(int n, int n2, int n3, int n4) {
        return Tiny2D.roundRectToPath(n, n2, n3, n4, n3 / 2, n4 / 2);
    }

    public static final TinyPath roundRectToPath(int n, int n2, int n3, int n4, int n5, int n6) {
        TinyPath tinyPath = new TinyPath(18);
        int n7 = Tiny2D.min(n3 / 2, n5);
        int n8 = Tiny2D.min(n4 / 2, n6);
        int n9 = n + n3;
        int n10 = n2 + n4;
        if (n7 == 0 || n8 == 0) {
            tinyPath.moveTo(n, n2);
            tinyPath.lineTo(n9, n2);
            tinyPath.lineTo(n9, n10);
            tinyPath.lineTo(n, n10);
        } else {
            int n11 = Tiny2D.mul(29341, n7);
            int n12 = Tiny2D.mul(29341, n8);
            tinyPath.moveTo(n9 - n7, n2);
            tinyPath.curveToCubic(n9 - n11, n2, n9, n2 + n12, n9, n2 + n8);
            tinyPath.lineTo(n9, n10 - n8);
            tinyPath.curveToCubic(n9, n10 - n12, n9 - n11, n10, n9 - n7, n10);
            tinyPath.lineTo(n + n7, n10);
            tinyPath.curveToCubic(n + n11, n10, n, n10 - n12, n, n10 - n8);
            tinyPath.lineTo(n, n2 + n8);
            tinyPath.curveToCubic(n, n2 + n12, n + n11, n2, n + n7, n2);
        }
        tinyPath.closePath();
        return tinyPath;
    }

    public static final TinyPath charsToPath(TinyFont tinyFont, char[] cArray, int n, int n2) {
        if (tinyFont == null || cArray == null) {
            return null;
        }
        TinyPath tinyPath = new TinyPath(20);
        int n3 = 0;
        TinyNumber tinyNumber = new TinyNumber(0);
        for (int i = n; i < n2; ++i) {
            int n4;
            int n5;
            tinyNumber.val = cArray[i];
            TinyGlyph tinyGlyph = (TinyGlyph)tinyFont.glyphs.get(tinyNumber);
            if (tinyGlyph == null) {
                tinyGlyph = tinyFont.missing_glyph;
            }
            if (tinyGlyph == null) {
                n5 = n3;
                n4 = tinyFont.horizAdvX;
            } else {
                if (tinyGlyph.path != null) {
                    int n6 = tinyGlyph.path.numPoints();
                    for (int j = 0; j < n6; ++j) {
                        tinyPath.addPoint(tinyGlyph.path.getX(j) + n3 << 8, tinyGlyph.path.getY(j) << 8, tinyGlyph.path.getType(j));
                    }
                }
                n5 = n3;
                n4 = tinyGlyph.horizAdvX;
            }
            n3 = n5 + n4;
        }
        tinyPath.compact();
        return tinyPath;
    }

    public static final TinyPath pointsToPath(TinyVector tinyVector) {
        if (tinyVector == null || tinyVector.count == 0) {
            return null;
        }
        TinyPath tinyPath = new TinyPath(20);
        int n = 0;
        TinyPoint tinyPoint = (TinyPoint)tinyVector.data[0];
        if (tinyPoint == null) {
            return null;
        }
        tinyPath.moveTo(tinyPoint.x, tinyPoint.y);
        ++n;
        while (n < tinyVector.count) {
            tinyPoint = (TinyPoint)tinyVector.data[n];
            if (tinyPoint != null) {
                tinyPath.lineTo(tinyPoint.x, tinyPoint.y);
            }
            ++n;
        }
        tinyPath.compact();
        return tinyPath;
    }

    public static final TinyVector pathToPoints(TinyPath tinyPath) {
        TinyVector tinyVector = new TinyVector(10);
        com.tinyline.tiny2d.g.a(tinyPath.a, tinyPath.b, tinyPath.c, tinyPath.d, tinyVector);
        return tinyVector;
    }

    public static final int abs(int n) {
        if (n < 0) {
            return -n;
        }
        return n;
    }

    public static final int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    public static final int min(int n, int n2) {
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    public static final int mul(int n, int n2) {
        return (int)((long)n * (long)n2 + 32768L >> 16);
    }

    public static final int fastDistance(int n, int n2) {
        n = Tiny2D.abs(n);
        n2 = Tiny2D.abs(n2);
        return n + n2 - (Tiny2D.min(n, n2) >> 1);
    }

    static final int a(int n, int n2) {
        int n3;
        int n4;
        int n5 = Tiny2D.abs(n);
        if (n5 > (n4 = Tiny2D.abs(n2))) {
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        if (n4 == 0) {
            return 0;
        }
        n3 = Tiny2D.div(n5, n4);
        int n6 = n3 >> 10;
        int n7 = (n3 & 0x3FF) << 6;
        n3 = Tiny2D.mul(65536 - n7, g[n6]) + Tiny2D.mul(n7, g[n6 + 1]);
        return Tiny2D.mul(n4, n3 >>= 14);
    }

    public static final int div(int n, int n2) {
        int n3;
        int n4 = 1;
        if (n < 0) {
            n = -n;
            n4 = -1;
        }
        if (n2 < 0) {
            n2 = -n2;
            n4 = -n4;
        }
        int n5 = n3 = n2 == 0 ? Integer.MAX_VALUE : (int)(((long)n << 16) / (long)n2);
        if (n4 < 0) {
            return -n3;
        }
        return n3;
    }

    public static final int round(int n) {
        if (n < 0) {
            return (n - 32768) / 65536;
        }
        return (n + 32768) / 65536;
    }

    public static int sin(int n) {
        boolean bl = false;
        if (n < 0) {
            n = -n;
            bl = true;
        }
        if (n > 92160) {
            while (n > 92160) {
                n -= 92160;
            }
        }
        if (n > 46080) {
            n = 92160 - n;
            boolean bl2 = bl = !bl;
        }
        if (n > 23040) {
            n = 46080 - n;
        }
        int n2 = e[n >> 8];
        if (bl) {
            return -n2;
        }
        return n2;
    }

    public static int cos(int n) {
        return Tiny2D.sin(23040 - n);
    }

    public static int tan(int n) {
        return Tiny2D.div(Tiny2D.sin(n), Tiny2D.cos(n));
    }

    public static int atan2(int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 > 0 && n >= 0) {
            n6 = 0;
        } else if (n2 <= 0 && n > 0) {
            n5 = -n2;
            n2 = n;
            n = n5;
            n6 = 23040;
        } else if (n2 < 0 && n <= 0) {
            n2 = -n2;
            n = -n;
            n6 = 46080;
        } else if (n2 >= 0 && n < 0) {
            n5 = n2;
            n2 = -n;
            n = n5;
            n6 = 69120;
        } else {
            return 0;
        }
        if (n2 >= n) {
            n5 = Tiny2D.div(n, n2) >> 10;
            n4 = n6;
            n3 = f[n5];
        } else {
            n5 = Tiny2D.div(n2, n) >> 10;
            n4 = n6;
            n3 = 23040 - f[n5];
        }
        n6 = n4 + n3;
        return n6;
    }
}

