/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Anim;
import game.Ball;
import game.Entity;
import game.GameOverAnim;
import game.Goal;
import game.ImageBank;
import game.MainMenu;
import game.Menu;
import game.PauseMenu;
import game.Player;
import game.SoccerGame;
import game.SoundBank;
import java.util.Random;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.midlet.MIDlet;

public class SoccerCanvas
extends GameCanvas {
    private static SoccerCanvas instance;
    private SoccerGame game;
    private boolean fireJammed;
    private Font scoreFont = Font.getFont((int)32, (int)0, (int)0);
    private Timer timer;
    private boolean shutdown = false;
    private Image background;
    private Vector ents = new Vector();
    private Vector addEnts = new Vector();
    private Vector removeEnts = new Vector();
    private Player player;
    private Ball ball;
    private Goal goal;
    private Menu menu;
    private int level = 1;
    private int posX;
    private int posY;
    private long frame = 0L;
    private long levelStartFrame = 0L;
    private boolean paused = false;
    private int score = 0;
    private int goals = 0;
    private int lives = 0;
    private int posthits = 0;
    private Random rnd = new Random();

    public static SoccerCanvas getInstance() {
        return instance;
    }

    public SoccerCanvas(SoccerGame game) {
        super(true);
        instance = this;
        this.setFullScreenMode(true);
        this.game = game;
        this.background = ImageBank.getImage("/bg.jpg");
        this.posX = (this.getWidth() - this.background.getWidth()) / 2;
        this.posY = (this.getHeight() - this.background.getHeight()) / 2;
        this.timer = new Timer();
        this.setMenu(new MainMenu(this));
    }

    public synchronized void addEnt(Entity ent) {
        this.addEnts.addElement(ent);
    }

    public synchronized void removeEnt(Entity ent) {
        this.removeEnts.addElement(ent);
        if (ent.equals(this.menu)) {
            this.setMenu(null);
        }
    }

    public int getFieldMidX() {
        return this.getWidth() / 2;
    }

    public int getFieldMidY() {
        return this.getHeight() / 2;
    }

    public int getFieldSize() {
        return (int)((double)this.background.getWidth() * 0.75 / 2.0);
    }

    public boolean isFireJammed() {
        return this.fireJammed;
    }

    public Font getScoreFont() {
        return this.scoreFont;
    }

    public SoccerGame getGame() {
        return this.game;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getScore() {
        return this.score;
    }

    public Ball getBall() {
        return this.ball;
    }

    public Goal getGoal() {
        return this.goal;
    }

    public int getLevel() {
        return this.level;
    }

    public long getFrame() {
        return this.frame;
    }

    public long getLevelStartFrame() {
        return this.levelStartFrame;
    }

    public void pause(boolean paused) {
        this.paused = paused;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this.game);
    }

    public void setMenu(Menu menu) {
        this.menu = menu;
        if (menu == null) {
            this.pause(false);
        } else {
            this.pause(true);
        }
    }

    private void nextLevel() {
        ++this.level;
        if (this.level > 99) {
            this.level = 99;
        }
        this.levelStartFrame = this.frame;
    }

    public void newGame() {
        if (this.player == null) {
            this.player = new Player(this);
            this.ents.addElement(this.player);
            this.goal = new Goal(this);
            this.ball = new Ball(this);
            this.ents.addElement(this.ball);
            this.ents.addElement(this.goal);
        }
        this.lives = 3;
        this.level = 0;
        this.score = 0;
        this.goals = 0;
        this.posthits = 0;
        this.nextLevel();
        this.goal.newGoal();
        this.ball.newBall();
    }

    public void addScore(int addScore) {
        SoundBank.playSound("/goal");
        this.goal.stopMove();
        ++this.goals;
        this.score += addScore;
        this.addEnt(new Anim(this, "goal", true, 4));
        int gpl = Math.min(1 + this.level, 4);
        if (this.goals % gpl == 0) {
            this.goals = 0;
            this.nextLevel();
        }
    }

    private boolean loseLife() {
        --this.lives;
        if (this.lives < 1) {
            this.addEnt(new GameOverAnim(this));
            return false;
        }
        return true;
    }

    public void addMiss() {
        this.goal.stopMove();
        if (this.loseLife()) {
            SoundBank.playSound("/boo");
            this.addEnt(new Anim(this, "miss", false, 1));
        }
    }

    public void addTimeOut() {
        this.goal.stopMove();
        if (this.loseLife()) {
            SoundBank.playSound("/boo");
            this.addEnt(new Anim(this, "time_up", false, 1));
        }
    }

    public void addPostHit() {
        SoundBank.playSound("/post");
        ++this.posthits;
    }

    private void runFrame() {
        int i;
        int state = this.getKeyStates();
        if (this.menu == null && this.frame > Menu.getMenuFrame() && (state & 0x100) != 0) {
            this.setMenu(new PauseMenu(this));
        }
        ++this.frame;
        if (!this.paused) {
            i = 0;
            while (i < this.ents.size()) {
                ((Entity)this.ents.elementAt(i)).think();
                ++i;
            }
        }
        if (this.menu != null) {
            this.menu.think();
        }
        this.paintCanvas();
        if (this.addEnts.size() > 0) {
            i = 0;
            while (i < this.addEnts.size()) {
                this.ents.addElement(this.addEnts.elementAt(i));
                ++i;
            }
            this.addEnts = new Vector();
        }
        if (this.removeEnts.size() > 0) {
            i = 0;
            while (i < this.removeEnts.size()) {
                Entity re = (Entity)this.removeEnts.elementAt(i);
                this.ents.removeElement(re);
                ++i;
            }
            this.removeEnts = new Vector();
        }
    }

    private void paintCanvas() {
        Graphics gr = this.getGraphics();
        gr.setColor(0);
        gr.fillRect(0, 0, this.getWidth(), this.getHeight());
        gr.drawImage(this.background, this.posX, this.posY, 20);
        gr.setFont(this.scoreFont);
        gr.setColor(0xFFFFFF);
        gr.drawString("Score: " + this.score, this.posX + 10, this.posY + this.background.getHeight() - gr.getFont().getHeight() - 5, 0);
        if (!this.paused && this.frame > this.levelStartFrame + 25L && this.frame < this.levelStartFrame + 60L) {
            Image img = ImageBank.getImage("/level.png");
            int x = this.getWidth() / 2 - img.getWidth();
            int y = this.getHeight() / 2 - img.getHeight();
            gr.drawImage(img, x, y, 0);
            x += img.getWidth() + 4;
            int lvl = this.level;
            if (lvl > 9) {
                int i = lvl / 10;
                lvl -= i * 10;
                img = ImageBank.getImage("/level_" + i + ".png");
                y = this.getHeight() / 2 - img.getHeight();
                gr.drawImage(img, x, y, 0);
                x += img.getWidth() + 2;
            }
            img = ImageBank.getImage("/level_" + lvl + ".png");
            y = this.getHeight() / 2 - img.getHeight();
            gr.drawImage(img, x, y, 0);
        }
        int i = 0;
        while (i < this.ents.size()) {
            ((Entity)this.ents.elementAt(i)).paint(gr);
            ++i;
        }
        if (this.lives > 0) {
            Image img = ImageBank.getImage("/ball/0.0.png");
            int i2 = 1;
            while (i2 <= this.lives) {
                gr.drawImage(img, this.posX + this.background.getWidth() - (img.getWidth() + 4) * i2, this.posY + this.background.getHeight() - img.getHeight() - 2, 0);
                ++i2;
            }
        }
        if (this.menu != null) {
            this.menu.paint(gr);
        }
        this.flushGraphics();
    }

    protected void keyReleased(int keyCode) {
        super.keyReleased(keyCode);
        switch (keyCode) {
            case -37: 
            case -36: {
                if (this.menu != null || !this.paused) break;
                this.pause(false);
            }
        }
    }

    protected void keyPressed(int keyCode) {
        System.out.println(keyCode);
        super.keyPressed(keyCode);
        switch (keyCode) {
            case -8: {
                this.shutdown();
                break;
            }
            case -37: 
            case -36: {
                if (this.menu != null) break;
                this.pause(true);
            }
        }
    }

    public void start() {
        this.timer.schedule((TimerTask)new SoccerTimerTask(), 0L, 50L);
    }

    public void shutdown() {
        this.shutdown = true;
        this.timer.cancel();
        this.game.notifyDestroyed();
    }

    public double random() {
        return this.rnd.nextDouble();
    }

    public int getPosX() {
        return this.posX;
    }

    public int getPosY() {
        return this.posY;
    }

    public class SoccerTimerTask
    extends TimerTask {
        public void run() {
            if (!SoccerCanvas.this.shutdown) {
                SoccerCanvas.this.runFrame();
            }
        }
    }
}

