/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MFont {
    public static final int COUNT_FONTS = 1;
    public static final int FONT_STANDART = 0;
    public static final String FONT_URL = "/f";
    public static final String FONT_EXCHANGE_URL = "/exch";
    public static final String FONT_DESCR_EXPANSION = ".d";
    private static final int LETTERS_TO_EXCHANGE = 0;
    private static final int LETTERS_EXCHANGERS = 1;
    private static Image[] IMAGE_FONT;
    private static String fontsABC;
    private static String[] fontsLetterExchange;
    private static final int fontABCLength = 83;
    private static byte[][] fontX;
    private static byte[][] fontY;
    private static byte[][] fontW;
    private static byte[] fontH;
    private static byte fontSpace;
    private static boolean[] fontLoaded;
    private static int defaultFont;
    private static final int DISTANSE_STANDART = 1;
    private static final int[] distanse_between_letters;
    private static final int FONT_Y_OFFSET_STANDART = 3;
    private static final int[] y_offset;

    private static void init() {
        IMAGE_FONT = new Image[1];
        fontX = new byte[1][];
        fontY = new byte[1][];
        fontW = new byte[1][];
        fontH = new byte[1];
        fontLoaded = new boolean[1];
        for (int i2 = 0; i2 < fontLoaded.length; ++i2) {
            MFont.fontLoaded[i2] = false;
        }
    }

    private static void load() {
        try {
            String string = ReadFileData.getText(FONT_EXCHANGE_URL, 2);
            int n2 = string.indexOf(10);
            int n3 = Integer.valueOf(string.substring(0, n2 - 1));
            fontsLetterExchange = new String[2];
            MFont.fontsLetterExchange[0] = string.substring(++n2, n2 + n3);
            MFont.fontsLetterExchange[1] = string.substring(n2 += n3, n2 + n3);
            fontsABC = string.substring(n2 += n3, n2 + 83);
            string = null;
        }
        catch (Exception exception) {
            System.out.println("Error Loading Font Description." + exception);
        }
        MFont.loadFont(defaultFont);
    }

    public static void loadFont(int n2) {
        if (n2 >= 1) {
            System.out.println("Loading FONT. Does not exist FONT for ID: " + n2);
            return;
        }
        if (fontLoaded[n2]) {
            System.out.println("Font already loaded");
            return;
        }
        try {
            if (IMAGE_FONT[n2] == null) {
                MFont.IMAGE_FONT[n2] = DUtil.getImage((String)(FONT_URL + n2), (boolean)false);
            }
        }
        catch (Exception exception) {
            System.out.println("Exception loading FONT ID:" + n2 + " IMAGE: " + exception);
        }
        try {
            DataInputStream dataInputStream = DUtil.getFile((String)(FONT_URL + n2 + FONT_DESCR_EXPANSION));
            int n3 = dataInputStream.readUnsignedByte();
            MFont.fontX[n2] = new byte[n3];
            MFont.fontY[n2] = new byte[n3];
            MFont.fontW[n2] = new byte[n3];
            dataInputStream.read(fontX[n2]);
            dataInputStream.read(fontY[n2]);
            dataInputStream.read(fontW[n2]);
            MFont.fontH[n2] = (byte)dataInputStream.read();
            MFont.fontLoaded[n2] = true;
            dataInputStream.close();
        }
        catch (Exception exception) {
            System.out.println("Exception loading FONT ID:" + n2 + " Description:" + exception);
        }
        System.gc();
    }

    public static void unloadFont(int n2) {
        if (n2 >= 1) {
            System.out.println("UNLOADING Font. Does not exist FONT for ID: " + n2);
            return;
        }
        if (!fontLoaded[n2]) {
            System.out.println("UNLOADING Font. Font is not loaded ID: " + n2);
            return;
        }
        if (IMAGE_FONT[n2] != null) {
            MFont.IMAGE_FONT[n2] = null;
        }
        MFont.fontX[n2] = null;
        MFont.fontY[n2] = null;
        MFont.fontW[n2] = null;
        MFont.fontH[n2] = -1;
        MFont.fontLoaded[n2] = false;
        System.gc();
    }

    public static int getOffsetY() {
        return MFont.getOffsetY(0);
    }

    public static int getOffsetY(int n2) {
        if (n2 >= 1) {
            System.out.println("getHeight Font. Does not exist FONT for ID: " + n2);
            return -1;
        }
        return y_offset[n2];
    }

    public static int getHeight() {
        return MFont.getHeight(defaultFont);
    }

    public static int getHeight(int n2) {
        if (n2 >= 1) {
            System.out.println("getHeight Font. Does not exist FONT for ID: " + n2);
            return -1;
        }
        if (fontLoaded[n2]) {
            return fontH[n2] - 1;
        }
        return -1;
    }

    public static int stringWidth(String string) {
        return MFont.stringWidth(string, defaultFont);
    }

    public static int stringWidth(String string, int n2) {
        if (n2 >= 1) {
            System.out.println("StringWidth Method. Does not exist FONT for ID: " + n2);
            return -1;
        }
        if (!fontLoaded[n2]) {
            System.out.println("StringWidth Method. Font did not loaded");
            return -1;
        }
        int n3 = 0;
        int n4 = distanse_between_letters[n2];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            try {
                char c2 = string.charAt(i2);
                if (c2 != ' ') {
                    int n5;
                    int n6 = fontsABC.indexOf(c2);
                    if (n6 != -1) {
                        n3 += fontW[n2][n6] + n4;
                        continue;
                    }
                    int n7 = fontsLetterExchange[0].indexOf(c2);
                    if (n7 == -1 || (n5 = fontsABC.indexOf(fontsLetterExchange[1].charAt(n7))) == -1) continue;
                    n3 += fontW[n2][n5] + n4;
                    continue;
                }
                n3 += fontSpace;
                continue;
            }
            catch (Exception exception) {
                System.out.println("StringWidth Method. Exception in calc width: " + exception + "\n Iteration number: " + i2);
            }
        }
        return n3;
    }

    public static void drawString(Graphics graphics, String string, int n2, int n3) {
        MFont.drawString(graphics, string, defaultFont, n2, n3);
    }

    public static void drawString(Graphics graphics, String string, int n2, int n3, int n4) {
        if (n2 >= 1) {
            System.out.println("DrawString Method. Does not exist FONT for ID: " + n2);
            return;
        }
        if (!fontLoaded[n2]) {
            System.out.println("DrawString Method. Font did not loaded");
            return;
        }
        int n5 = 0;
        int n6 = distanse_between_letters[n2];
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            try {
                int n7;
                int n8;
                if (c2 == ' ') {
                    n5 += fontSpace;
                    continue;
                }
                int n9 = -1;
                int n10 = fontsABC.indexOf(c2);
                if (n10 != -1) {
                    n9 = n10;
                } else {
                    n8 = fontsLetterExchange[0].indexOf(c2);
                    if (n8 != -1 && (n7 = fontsABC.indexOf(fontsLetterExchange[1].charAt(n8))) != -1) {
                        n9 = n7;
                    }
                }
                try {
                    if (n9 <= -1) continue;
                    if (IMAGE_FONT[n2] != null) {
                        n8 = fontX[n2][n9];
                        n7 = fontY[n2][n9];
                        if (n8 < 0) {
                            n8 &= 0xFF;
                        }
                        if (n7 < 0) {
                            n7 &= 0xFF;
                        }
                        MGraphics.drawRegion(graphics, IMAGE_FONT[n2], n8, n7, fontW[n2][n9], fontH[n2], 0, n3 + n5, n4 - 3, 0);
                    }
                    n5 += fontW[n2][n9] + n6;
                }
                catch (Exception exception) {
                    System.out.println("MFont 1. DrawString Method. Exception in draw. " + exception);
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("MFont 2. DrawString Method. Exception in method." + exception);
            }
        }
    }

    static {
        fontSpace = (byte)4;
        defaultFont = 0;
        distanse_between_letters = new int[]{1};
        y_offset = new int[]{3};
        MFont.init();
        MFont.load();
    }
}

