/*
 * Decompiled with CFR 0.152.
 */
package Services;

import Services.CFontInfo;

public class CBinaryFile {
    public byte[] data;
    public int pointer;

    public CBinaryFile(byte[] byArray) {
        this.data = byArray;
        this.pointer = 0;
    }

    public void read(byte[] byArray) {
        int n = byArray.length;
        if (this.pointer + n <= this.data.length) {
            for (int i = 0; i < n; ++i) {
                byArray[i] = this.data[this.pointer + i];
            }
            this.pointer += n;
            return;
        }
        for (int i = 0; i < n; ++i) {
            byArray[i] = 0;
        }
    }

    public void skipBytes(int n) {
        if (this.pointer + n <= this.data.length) {
            this.pointer += n;
        }
    }

    public int getFilePointer() {
        return this.pointer;
    }

    public void seek(int n) {
        if (n <= this.data.length) {
            this.pointer = n;
        }
    }

    public byte readByte() {
        if (this.pointer + 1 <= this.data.length) {
            return this.data[this.pointer++];
        }
        return 0;
    }

    public short readShort() {
        if (this.pointer + 2 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            return (short)(n2 * 256 + n);
        }
        return 0;
    }

    public int readInt() {
        if (this.pointer + 4 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            int n3 = this.data[this.pointer++] & 0xFF;
            int n4 = this.data[this.pointer++] & 0xFF;
            return n4 * 0x1000000 + n3 * 65536 + n2 * 256 + n;
        }
        return 0;
    }

    public int readColor() {
        if (this.pointer + 4 <= this.data.length) {
            int n = this.data[this.pointer++] & 0xFF;
            int n2 = this.data[this.pointer++] & 0xFF;
            int n3 = this.data[this.pointer++] & 0xFF;
            ++this.pointer;
            return n * 65536 + n2 * 256 + n3;
        }
        return 0;
    }

    public String readString(int n) {
        byte[] byArray = new byte[n - 1];
        this.read(byArray);
        this.skipBytes(1);
        return new String(byArray);
    }

    public String readString() {
        byte by;
        int n = this.getFilePointer();
        while ((by = this.readByte()) != 0) {
        }
        int n2 = this.getFilePointer();
        this.seek(n);
        if (n2 - n - 1 > 0) {
            byte[] byArray = new byte[n2 - n - 1];
            this.read(byArray);
            this.skipBytes(1);
            return new String(byArray);
        }
        this.skipBytes(1);
        return "";
    }

    public CFontInfo readLogFont() {
        CFontInfo cFontInfo = new CFontInfo();
        cFontInfo.lfHeight = this.readInt();
        if (cFontInfo.lfHeight < 0) {
            cFontInfo.lfHeight = -cFontInfo.lfHeight;
        }
        this.skipBytes(12);
        cFontInfo.lfWeight = this.readInt();
        cFontInfo.lfItalic = this.readByte();
        cFontInfo.lfUnderline = this.readByte();
        cFontInfo.lfStrikeOut = this.readByte();
        this.skipBytes(5);
        int n = this.pointer;
        cFontInfo.lfFaceName = this.readString();
        this.pointer = n + 32;
        return cFontInfo;
    }

    public CFontInfo readLogFont16() {
        CFontInfo cFontInfo = new CFontInfo();
        cFontInfo.lfHeight = this.readShort();
        if (cFontInfo.lfHeight < 0) {
            cFontInfo.lfHeight = -cFontInfo.lfHeight;
        }
        this.skipBytes(6);
        cFontInfo.lfWeight = this.readShort();
        cFontInfo.lfItalic = this.readByte();
        cFontInfo.lfUnderline = this.readByte();
        cFontInfo.lfStrikeOut = this.readByte();
        this.skipBytes(5);
        int n = this.pointer;
        cFontInfo.lfFaceName = this.readString();
        this.pointer = n + 32;
        return cFontInfo;
    }

    public void skipString() {
        byte by;
        while ((by = this.readByte()) != 0) {
        }
    }
}

