/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CRunApp;
import Banks.CMusic;
import javax.microedition.media.Manager;

public class CMusicPlayer {
    public static final int nChannels = 32;
    CRunApp app;
    boolean bOn = true;
    CMusic music = null;
    public boolean bMIDISupported = false;

    public CMusicPlayer(CRunApp cRunApp) {
        this.app = cRunApp;
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("audio/midi")) continue;
            this.bMIDISupported = true;
            break;
        }
    }

    public void play(short s, int n) {
        CMusic cMusic = this.app.musicBank.getMusicFromHandle(s);
        if (cMusic == null) {
            return;
        }
        if (this.music != null) {
            this.music.stop();
            this.music = null;
        }
        this.music = cMusic;
        cMusic.setMediaTime(0);
        cMusic.setLoopCount(n);
        cMusic.start();
    }

    public void stopAllMusics() {
        if (this.music != null) {
            this.music.stop();
            this.music = null;
        }
    }

    public void stop() {
        this.stopAllMusics();
        this.music = null;
    }

    public void keepCurrentMusic() {
        if (this.music != null) {
            this.app.musicBank.setToLoad(this.music.handle);
        }
    }

    public void pause() {
        this.stopAllMusics();
    }

    public void resume() {
        if (this.music != null) {
            this.music.start();
        }
    }

    public boolean isMusicPlaying() {
        return this.music != null && this.music.bPlaying;
    }

    public boolean isMusicPaused() {
        return this.music == null || !this.music.bPlaying;
    }

    public boolean isMusicPlaying(short s) {
        return this.music != null && this.music.handle == s && this.music.bPlaying;
    }

    public void removeSound(CMusic cMusic) {
        if (this.music == cMusic) {
            this.music = null;
        }
    }
}

