/*
 * Decompiled with CFR 0.152.
 */
package Application;

import Application.CRunApp;
import Banks.CSound;
import javax.microedition.media.Manager;

public class CSoundPlayer {
    public static final int nChannels = 32;
    public CRunApp app;
    boolean bOn = true;
    CSound[] channels;
    public boolean bMultipleSounds = true;
    public boolean bWAVSupported = false;

    public CSoundPlayer(CRunApp cRunApp) {
        this.app = cRunApp;
        this.channels = new CSound[32];
        String[] stringArray = Manager.getSupportedContentTypes(null);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equalsIgnoreCase("audio/x-wav")) continue;
            this.bWAVSupported = true;
            break;
        }
    }

    public void play(short s, int n, int n2, boolean bl) {
        int n3;
        if (!this.bOn) {
            return;
        }
        CSound cSound = this.app.soundBank.getSoundFromHandle(s);
        if (cSound == null) {
            return;
        }
        if (!this.bMultipleSounds) {
            n2 = 0;
        }
        for (n3 = 0; n3 < 32; ++n3) {
            if (this.channels[n3] != cSound) continue;
            if (!this.channels[n3].bUninterruptible) {
                cSound.stop();
                this.channels[n3] = null;
                break;
            }
            return;
        }
        if (n2 < 0) {
            for (n3 = 0; n3 < 32 && this.channels[n3] != null; ++n3) {
            }
            if (n3 == 32) {
                for (n3 = 0; n3 < 32; ++n3) {
                    if (this.channels[n3] == null || this.channels[n3].bUninterruptible) continue;
                    this.channels[n3].stop();
                    this.channels[n3] = null;
                }
            }
            n2 = n3;
        }
        if (n2 < 0 || n2 >= 32) {
            return;
        }
        if (this.channels[n2] != null) {
            if (!this.channels[n2].bUninterruptible) {
                this.channels[n2].stop();
            } else {
                return;
            }
        }
        this.channels[n2] = cSound;
        cSound.setMediaTime(0);
        cSound.setUninterruptible(bl);
        cSound.setLoopCount(n);
        cSound.start();
    }

    public void setMultipleSounds(boolean bl) {
        this.bMultipleSounds = bl;
    }

    public void keepCurrentSounds() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || !this.channels[i].bPlaying) continue;
            this.app.soundBank.setToLoad(this.channels[i].handle);
        }
    }

    public void setOnOff(boolean bl) {
        if (bl != this.bOn) {
            this.bOn = bl;
            if (!this.bOn) {
                this.stopAllSounds();
            }
        }
    }

    public boolean getOnOff() {
        return this.bOn;
    }

    public void stopAllSounds() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].stop();
        }
    }

    public void stop(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || this.channels[i].handle != s) continue;
            this.channels[i].stop();
            this.channels[i] = null;
        }
    }

    public boolean isSoundPlaying() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || !this.channels[i].bPlaying) continue;
            return true;
        }
        return false;
    }

    public boolean isSamplePlaying(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || this.channels[i].handle != s || !this.channels[i].bPlaying) continue;
            return true;
        }
        return false;
    }

    public boolean isChannelPlaying(int n) {
        return n > 0 && n < 32 && this.channels[n] != null && this.channels[n].bPlaying;
    }

    public void setPosition(short s, int n) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || this.channels[i].handle != s) continue;
            this.channels[i].setMediaTime(n);
        }
    }

    public void pause(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || this.channels[i].handle != s) continue;
            this.channels[i].stop();
        }
    }

    public void resume(short s) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null || this.channels[i].handle != s) continue;
            this.channels[i].start();
        }
    }

    public void pause() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].stop();
        }
    }

    public void pauseAllChannels() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].stop();
        }
    }

    public void resume() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].start();
        }
    }

    public void resumeAllChannels() {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] == null) continue;
            this.channels[i].start();
        }
    }

    public void pauseChannel(int n) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            this.channels[n].stop();
        }
    }

    public void stopChannel(int n) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            this.channels[n].stop();
            this.channels[n] = null;
        }
    }

    public void resumeChannel(int n) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            this.channels[n].start();
        }
    }

    public void setPositionChannel(int n, int n2) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            this.channels[n].setMediaTime(n2);
        }
    }

    public int getChannelPosition(int n) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            return (int)this.channels[n].player.getMediaTime();
        }
        return 0;
    }

    public int getChannelDuration(int n) {
        if (n >= 0 && n < 32 && this.channels[n] != null) {
            return (int)this.channels[n].player.getDuration();
        }
        return 0;
    }

    public void removeSound(CSound cSound) {
        for (int i = 0; i < 32; ++i) {
            if (this.channels[i] != cSound) continue;
            this.channels[i] = null;
        }
    }
}

