/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Application.CMusicPlayer;
import Services.CServices;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class CMusic
implements PlayerListener {
    public CMusicPlayer musPlayer;
    public Player player = null;
    public short handle;
    public boolean bPlaying;
    public int nLoops;

    public CMusic(CMusicPlayer cMusicPlayer) {
        this.musPlayer = cMusicPlayer;
    }

    public void load(short s) {
        this.handle = s;
        String string = CServices.formatDiscName(s, ".mid");
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream != null) {
                this.player = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                if (this.player != null) {
                    this.player.prefetch();
                    this.player.addPlayerListener((PlayerListener)this);
                    return;
                }
            }
        }
        catch (MediaException mediaException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.player = null;
    }

    public void playerUpdate(Player player, String string, Object object) {
        if (string == "started") {
            this.bPlaying = true;
            return;
        }
        if (string == "stopped") {
            this.bPlaying = false;
            return;
        }
        if (string == "endOfMedia") {
            if (this.nLoops > 0) {
                --this.nLoops;
                if (this.nLoops == 0) {
                    this.stop();
                    this.musPlayer.removeSound(this);
                    this.bPlaying = false;
                    return;
                }
            }
            this.setMediaTime(0);
            this.start();
            return;
        }
    }

    public void setLoopCount(int n) {
        this.nLoops = n;
    }

    public void start() {
        try {
            if (this.player != null) {
                this.player.start();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void stop() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void setMediaTime(int n) {
        try {
            if (this.player != null) {
                this.player.setMediaTime((long)n);
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    public void close() {
        if (this.player != null) {
            this.player.removePlayerListener((PlayerListener)this);
            this.player.close();
        }
    }
}

