/*
 * Decompiled with CFR 0.152.
 */
package Banks;

import Application.CMusicPlayer;
import Banks.CMusic;
import Banks.IEnum;
import Services.CFile;

public class CMusicBank
implements IEnum {
    public CMusic[] musics = null;
    public int nHandlesReel;
    public int nMusics;
    short[] handleToIndex;
    short[] useCount;
    public CMusicPlayer musPlayer;

    public CMusicBank(CMusicPlayer cMusicPlayer) {
        this.musPlayer = cMusicPlayer;
    }

    public void preLoad(CFile cFile) {
        this.nHandlesReel = cFile.readAShort();
        this.handleToIndex = new short[this.nHandlesReel];
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.handleToIndex[i] = -1;
        }
        this.useCount = new short[this.nHandlesReel];
        this.resetToLoad();
        this.nMusics = 0;
        this.musics = null;
    }

    public CMusic getMusicFromHandle(short s) {
        if (this.musics != null && s >= 0 && s < this.nHandlesReel && this.handleToIndex[s] != -1) {
            return this.musics[this.handleToIndex[s]];
        }
        return null;
    }

    public CMusic getMusicFromIndex(short s) {
        if (this.musics != null && s >= 0 && s < this.nMusics) {
            return this.musics[s];
        }
        return null;
    }

    public void resetToLoad() {
        for (int i = 0; i < this.nHandlesReel; ++i) {
            this.useCount[i] = 0;
        }
    }

    public void setToLoad(short s) {
        short s2 = s;
        this.useCount[s2] = (short)(this.useCount[s2] + 1);
    }

    public short enumerate(short s) {
        this.setToLoad(s);
        return -1;
    }

    public void load(CMusicPlayer cMusicPlayer) {
        int n;
        if (this.musics != null) {
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] != 0 || this.handleToIndex[n] == -1 || this.musics[this.handleToIndex[n]] == null) continue;
                this.musics[this.handleToIndex[n]].close();
                this.musics[this.handleToIndex[n]] = null;
                this.handleToIndex[n] = -1;
            }
        }
        if (this.musPlayer.bMIDISupported) {
            this.nMusics = 0;
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] == 0) continue;
                ++this.nMusics;
            }
            CMusic[] cMusicArray = new CMusic[this.nMusics];
            int n2 = 0;
            for (n = 0; n < this.nHandlesReel; ++n) {
                if (this.useCount[n] == 0) continue;
                if (this.musics != null && this.handleToIndex[n] != -1 && this.musics[this.handleToIndex[n]] != null) {
                    cMusicArray[n2] = this.musics[this.handleToIndex[n]];
                    this.handleToIndex[n] = (short)n2;
                } else {
                    cMusicArray[n2] = new CMusic(cMusicPlayer);
                    cMusicArray[n2].load((short)n);
                    this.handleToIndex[n] = (short)n2;
                }
                ++n2;
            }
            this.musics = cMusicArray;
        }
        this.resetToLoad();
    }

    public void closeAllMusics() {
        if (this.musics != null) {
            for (int i = 0; i < this.nHandlesReel; ++i) {
                if (this.handleToIndex[i] == -1 || this.musics[this.handleToIndex[i]] == null) continue;
                this.musics[this.handleToIndex[i]].close();
                this.musics[this.handleToIndex[i]] = null;
                this.handleToIndex[i] = -1;
            }
        }
    }
}

