/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class Sonidos {
    private Player player;
    private String[] sounds = new String[]{"/audio/titulo.mid", "/audio/grito.mid"};
    public static final int NO_CURRENT_SOUND = -2;
    public static final int VIBRATE = -1;
    public static final int INTRO = 0;
    public static final int GRITO = 1;
    public byte[][] soundsByte;
    public int num_sounds;
    private boolean tryNewSound;
    private int indexToPlay;
    private int currentIndex;
    public boolean needLoop;
    boolean fromPlaySound = false;

    public Sonidos() {
        this.loadSonidos();
    }

    public void loadSonidos() {
        this.tryNewSound = false;
        this.num_sounds = this.sounds.length;
        this.loadByteSounds();
    }

    public void loadByteSounds() {
        this.soundsByte = new byte[this.num_sounds][];
        int num_bytes = 40;
        try {
            for (int j = 0; j < this.num_sounds; ++j) {
                InputStream SoundByte = ((Object)((Object)VisionNocturnaMIDlet.myMIDlet)).getClass().getResourceAsStream(this.sounds[j]);
                ByteArrayOutputStream bytesFromSoundFile = new ByteArrayOutputStream();
                byte[] buffer = new byte[num_bytes];
                int bytesReading = 0;
                while (bytesReading != -1) {
                    Thread.yield();
                    for (int i = 0; i < num_bytes; ++i) {
                        buffer[i] = 0;
                    }
                    try {
                        bytesReading = SoundByte.read(buffer, 0, num_bytes);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    if (bytesReading == -1) break;
                    bytesFromSoundFile.write(buffer, 0, bytesReading);
                }
                this.soundsByte[j] = bytesFromSoundFile.toByteArray();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void updateSound() {
        if (this.tryNewSound) {
            this.tryNewSound = false;
            this.realPlaySound(this.indexToPlay);
        }
    }

    public void LoadSound(int id) {
        try {
            ByteArrayInputStream SoundByte = new ByteArrayInputStream(this.soundsByte[id]);
            this.player = Manager.createPlayer((InputStream)SoundByte, (String)"audio/midi");
            this.player.realize();
            if (this.player.getState() != 200) {
                Thread.yield();
            }
            SoundByte.close();
            SoundByte = null;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void PlaySound(int id) {
        this.PlaySound(id, false);
    }

    public void PlaySound(int id, boolean loop) {
        if (id != -1) {
            this.tryNewSound = true;
            this.indexToPlay = id;
            this.needLoop = loop;
        } else {
            this.realVibrate(id);
        }
    }

    public void realVibrate(int id) {
    }

    public void realPlaySound(int id) {
        if (coreGame.sonido == 1 || id < 0 || id >= this.num_sounds) {
            return;
        }
        if (this.player != null) {
            this.stopSound();
        }
        this.LoadSound(id);
        try {
            if (this.player != null) {
                if (id == 0 || this.needLoop) {
                    this.needLoop = false;
                    this.player.setLoopCount(-1);
                }
                if (this.player.getState() != 300) {
                    this.player.prefetch();
                }
                this.player.start();
                this.currentIndex = id;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSound() {
        this.currentIndex = -2;
        if (this.player != null) {
            try {
                if (this.player.getState() == 400) {
                    this.player.stop();
                    if (this.player.getState() != 300) {
                        Thread.yield();
                    }
                }
                if (this.player.getState() == 300) {
                    this.player.deallocate();
                    if (this.player.getState() != 200) {
                        Thread.yield();
                    }
                }
                if (this.player.getState() == 200 || this.player.getState() == 100) {
                    this.player.close();
                    if (this.player.getState() != 0) {
                        Thread.yield();
                    }
                }
            }
            catch (Exception e) {
                if (this.player != null) {
                    this.player.close();
                }
            }
            finally {
                if (this.player != null) {
                    this.player = null;
                }
            }
        }
    }
}

