/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman;

import java.io.IOException;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import ng.games.pacman.Game;
import ng.games.pacman.io.ResourceManager;
import ng.games.pacman.levels.Level;
import ng.games.pacman.media.GameEffects;
import ng.games.pacman.settings.Settings;
import ng.games.pacman.sprites.AIPlayer;
import ng.games.pacman.sprites.HumanPlayer;
import ng.games.pacman.util.image.ImageFramer;

public class GameManager {
    public static final int DIRECTION_LEFT = 0;
    public static final int DIRECTION_UP = 1;
    public static final int DIRECTION_RIGHT = 2;
    public static final int DIRECTION_DOWN = 3;
    private int playerLifes = 3;
    private int score;
    public static final int[][] DIRECTION_INCREMENTS = new int[][]{{-1, 0}, {0, -1}, {1, 0}, {0, 1}};
    private long watchBonusEnd = -1L;
    private long godModeEnd = -1L;
    private static GameManager instance = new GameManager();
    private static Random random = new Random();
    private HumanPlayer humanPlayer;
    private AIPlayer[] monsters;
    private Level currentLevel;
    private int currentLevelIndex = 15;
    private long lastIterationTime;
    private boolean valid = false;
    private int lastKey = 0;
    private boolean gameFinished;
    private Image playerImage;
    private ImageFramer monsterFrame;
    private Image lifeIndicator;
    private ImageFramer bonusImages;
    private boolean paused = false;
    private ImageFramer wallFrame;
    private ResourceManager rm = ResourceManager.getInstance();
    private int difficulty = 0;
    private int tilesInRow;
    private Image wallTiles;

    public static GameManager getInstance() {
        return instance;
    }

    private GameManager() {
    }

    public void loadGameResources() throws IOException {
        Level.loadLevelPack("levels.pak");
        this.wallTiles = ResourceManager.getInstance().getImage("tiles");
        this.tilesInRow = this.wallTiles.getWidth() / 16;
        Game.getInstance().increaseProgress(1);
        this.playerImage = ResourceManager.getInstance().getImage("willy");
        Game.getInstance().increaseProgress(4);
        this.monsterFrame = new ImageFramer(new Image[]{ResourceManager.getInstance().getImage("ghost1"), ResourceManager.getInstance().getImage("ghost2")}, 15, 15);
        Game.getInstance().increaseProgress(1);
        this.bonusImages = new ImageFramer(ResourceManager.getInstance().getImage("bonus"), 5);
        this.humanPlayer = new HumanPlayer(new ImageFramer(this.playerImage, 12), 3, 4, Settings.PLAYER_SPEED[this.difficulty]);
        this.lifeIndicator = ResourceManager.getInstance().getImage("willy_sm");
        Game.getInstance().increaseProgress(1);
    }

    public void startGame(int n) {
        this.currentLevelIndex = n;
        Level level = Level.getLevel(this.currentLevelIndex);
        this.setLevel(level);
        this.lastIterationTime = System.currentTimeMillis();
        this.playerLifes = 3;
        this.watchBonusEnd = -1L;
        this.godModeEnd = -1L;
        this.score = 0;
        this.gameFinished = false;
        this.valid = true;
        this.paused = false;
    }

    private void setLevel(Level level) {
        this.currentLevel = level;
        this.humanPlayer.setLevel(this.currentLevel);
        this.monsters = new AIPlayer[level.getMonstersCount()];
        for (int i = 0; i < this.monsters.length; ++i) {
            this.monsters[i] = new AIPlayer(this.monsterFrame, 3, 4, Settings.MONSTER_SPEED[this.difficulty]);
            this.monsters[i].setLevel(level);
            this.monsters[i].setVictim(this.humanPlayer);
        }
        this.setObjectsPosition(level);
    }

    public int getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(int n) {
        this.difficulty = n;
        if (this.humanPlayer != null) {
            this.humanPlayer.setSpeed(Settings.PLAYER_SPEED[n]);
        }
        if (this.monsters != null) {
            for (int i = 0; i < this.monsters.length; ++i) {
                if (this.monsters[i] == null) continue;
                this.monsters[i].setSpeed(Settings.MONSTER_SPEED[n]);
            }
        }
    }

    private void setObjectsPosition(Level level) {
        this.humanPlayer.setPosition(level.getPlayerX(), level.getPlayerY());
        for (int i = 0; i < this.monsters.length; ++i) {
            this.monsters[i].setIndex(i);
            this.monsters[i].setPosition(level.getMonsterX(i), level.getMonsterY(i));
        }
    }

    public int getCurrentLevelIndex() {
        return this.currentLevelIndex;
    }

    public void paint(Graphics graphics) {
        this.paintFluent(graphics);
    }

    private void paintFluent(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        graphics.setColor(17408);
        graphics.fillRect(0, 0, 128, 160);
        long l = System.currentTimeMillis();
        int n5 = 128;
        int n6 = 160;
        int n7 = this.humanPlayer.getDrawX();
        int n8 = this.humanPlayer.getDrawY();
        int n9 = n7 / 16;
        int n10 = n8 / 16;
        int n11 = 8;
        int n12 = 10;
        int n13 = n9 - n11 / 2 - 1;
        if (n13 < 0) {
            n13 = 0;
        }
        if ((n4 = n9 + n11 / 2 + 1) >= this.currentLevel.getWidth()) {
            n4 = this.currentLevel.getWidth() - 1;
        }
        if ((n3 = n10 - n12 / 2 - 1) < 0) {
            n3 = 0;
        }
        if ((n2 = n10 + n12 / 2 + 1) >= this.currentLevel.getHeight()) {
            n2 = this.currentLevel.getHeight() - 1;
        }
        int n14 = n5 / 2;
        int n15 = n6 / 2;
        for (n = n3; n <= n2; ++n) {
            for (int i = n13; i <= n4; ++i) {
                byte by = this.currentLevel.getObjectAt(i, n);
                if (by < 8) {
                    if (by == 0) continue;
                    this.bonusImages.drawFrame(graphics, by - 1, n14 - (n7 - i * 16), n15 - (n8 - n * 16));
                    continue;
                }
                int n16 = n14 - (n7 - i * 16);
                int n17 = n15 - (n8 - n * 16);
                graphics.setClip(n16, n17, 16, 16);
                int n18 = (by - 8) % this.tilesInRow * 16;
                int n19 = (by - 8) / this.tilesInRow * 16;
                graphics.drawImage(this.wallTiles, n16 - n18, n17 - n19, 20);
            }
        }
        this.humanPlayer.draw(graphics, n14, n15);
        for (n = 0; n < this.monsters.length; ++n) {
            AIPlayer aIPlayer = this.monsters[n];
            aIPlayer.draw(graphics, n14 + (aIPlayer.getXPos() - n7), n15 + (aIPlayer.getYPos() - n8));
        }
        this.drawBonusAndLife(graphics);
        graphics.setColor(255, 255, 255);
    }

    private void drawBonusAndLife(Graphics graphics) {
        for (int i = 0; i < this.playerLifes; ++i) {
            graphics.drawImage(this.lifeIndicator, 5 + i * 15, 5, 20);
        }
        graphics.setColor(255);
        Font font = Font.getFont((int)64, (int)0, (int)8);
        graphics.setFont(font);
        graphics.setColor(0xFFFFFF);
        graphics.drawString(this.score + "", 123, 5, 24);
    }

    public void updateLogic() {
        if (this.lastKey != 0) {
            this.humanPlayer.keyPressed(this.lastKey);
            this.lastKey = 0;
        }
        int n = (int)(System.currentTimeMillis() - this.lastIterationTime);
        this.lastIterationTime = System.currentTimeMillis();
        if (!this.paused) {
            this.humanPlayer.updateLogic(n);
            for (int i = 0; i < this.monsters.length; ++i) {
                AIPlayer aIPlayer = this.monsters[i];
                if (this.watchBonusEnd != -1L && this.watchBonusEnd >= System.currentTimeMillis()) {
                    aIPlayer.updateLogic(n / 2);
                    continue;
                }
                this.watchBonusEnd = -1L;
                aIPlayer.updateLogic(n);
            }
            if (this.godModeEnd != -1L && this.godModeEnd < System.currentTimeMillis()) {
                this.godModeEnd = -1L;
            }
        }
    }

    public void keyPressed(int n) {
        if (this.valid) {
            this.lastKey = n;
        }
    }

    public void playerCatched() {
        if (!this.isInGodMode()) {
            GameEffects.getInstance().playPlayerEaten();
            this.currentLevel.resetObjects();
            this.setObjectsPosition(this.currentLevel);
            if (this.playerLifes > 0) {
                --this.playerLifes;
            } else {
                this.gameFinished = true;
            }
        }
    }

    public void foodEat() {
        this.currentLevel.setFoodCount(this.currentLevel.getFoodCount() - 1);
        if (this.currentLevel.getFoodCount() == 0) {
            GameEffects.getInstance().playLevelComplete();
            ++this.currentLevelIndex;
            if (this.currentLevelIndex >= Level.getLevelsCount()) {
                this.gameFinished = true;
                --this.currentLevelIndex;
                return;
            }
            this.setLevel(Level.getLevel(this.currentLevelIndex));
        }
        this.score += 10;
        GameEffects.getInstance().playEatFood();
    }

    public void bonusTaked(int n) {
        switch (n) {
            case 2: {
                this.watchBonusEnd = System.currentTimeMillis() + 10000L;
                break;
            }
            case 3: {
                this.score += 100;
                break;
            }
            case 4: {
                if (this.playerLifes >= 6) break;
                ++this.playerLifes;
                break;
            }
            case 5: {
                this.godModeEnd = System.currentTimeMillis() + 10000L;
            }
        }
        GameEffects.getInstance().playBonus();
    }

    public boolean isGameFinished() {
        return this.gameFinished;
    }

    public boolean isInGodMode() {
        return this.godModeEnd != -1L;
    }

    public static int randomInt(int n) {
        int n2 = random.nextInt();
        if (n2 < 0) {
            n2 = -n2;
        }
        return n2 % n;
    }

    public int getScore() {
        return this.score;
    }

    public void pause() {
        this.paused = true;
    }

    public void resume() {
        this.lastIterationTime = System.currentTimeMillis();
        this.paused = false;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void stopGame() {
        this.gameFinished = true;
    }

    public int getLevel() {
        return this.currentLevelIndex;
    }

    public void freeResources() {
        instance = null;
    }
}

