/*
 * Decompiled with CFR 0.152.
 */
package ng.games.pacman.sprites;

import ng.games.pacman.GameManager;
import ng.games.pacman.screen.GameScreen;
import ng.games.pacman.sprites.MovableObject;
import ng.games.pacman.util.image.ImageFramer;

public class HumanPlayer
extends MovableObject {
    private int planedTurnDirection = -1;
    private int oldXCell;
    private int oldYCell;

    public HumanPlayer(ImageFramer imageFramer, int n, int n2, int n3) {
        super(imageFramer, n, n2, n3);
    }

    public int getCurrentFrameIndex() {
        return this.getDirection() * this.getFramesCount() + super.getCurrentFrameIndex();
    }

    public void setPosition(int n, int n2) {
        super.setPosition(n, n2);
        this.buildDistanceMatrice();
        this.oldXCell = -1;
        this.oldYCell = -1;
    }

    protected void cellReached(int n, int n2) {
        byte by;
        if (n != this.oldXCell || n2 != this.oldYCell) {
            this.oldXCell = n;
            this.oldYCell = n2;
        }
        if ((by = this.getLevel().getObjectAt(n, n2)) == 1) {
            this.getLevel().setObjectAt(n, n2, (byte)0);
            GameManager.getInstance().foodEat();
        }
        if (by == 3 || by == 2 || by == 4 || by == 5) {
            GameManager.getInstance().bonusTaked(by);
            this.getLevel().setObjectAt(n, n2, (byte)0);
        }
        this.getLevel().setPlayerPosition(n, n2);
    }

    public void keyPressed(int n) {
        int n2 = GameScreen.getGMAction(n);
        switch (n2) {
            case 1: {
                this.planedTurnDirection = 1;
                break;
            }
            case 6: {
                this.planedTurnDirection = 3;
                break;
            }
            case 2: {
                this.planedTurnDirection = 0;
                break;
            }
            case 5: {
                this.planedTurnDirection = 2;
            }
        }
    }

    private void tryToMakeTurn() {
        if (this.planedTurnDirection != -1) {
            if (this.canMove(this.planedTurnDirection)) {
                this.setDirection(this.planedTurnDirection);
            }
            this.planedTurnDirection = -1;
        }
    }

    protected boolean moveToNextCell() {
        this.tryToMakeTurn();
        return super.moveToNextCell();
    }
}

