/*
 * Decompiled with CFR 0.152.
 */
package BubbleCute;

import BubbleCute.Bubble;
import BubbleCute.Canv;
import BubbleCute.Input;
import BubbleCute.Serv;
import BubbleCute.Sound;
import javax.microedition.rms.RecordStore;

public class Game {
    Serv lSer;
    Sound lSnd;
    private Input lInp;
    private int exitTime = 0;
    private String[] messageString;
    private String viewFileName;
    private int syncRate = 100;
    private static final short SCREEN_SIZE_128x128 = 0;
    private static final short SCREEN_SIZE_176x208 = 1;
    private static final short SCREEN_SIZE_240x320 = 2;
    private static final short SCREEN_SIZE_352x416 = 3;
    private static final int START_BUBBLE = 10;
    private static final int START_PARACHUTE = 20;
    private static final int BUBBLE_AVAILABLE = 8;
    private static final int BUBBLE_NUMBER = 4;
    private static final int Y_SPEED_INITIAL = 0;
    private static final int FULL_LIFE = 32;
    private static final int MAX_LEVEL = 40;
    private static final int MAX_TRIES = 3;
    private static final int FIRST_AID_PRICE = 50;
    private static final int FIRST_AID_LIFE = 5;
    private static final int MAX_HIGH_SCORES = 10;
    private static final int PARACHUTE_WIDTH = 45;
    private static final int BUBBLE_ANIMATION_RATE = 5;
    private static final int PARACHUTE_ANIMATION_RATE = 2;
    private static final int EXPLOSION_ANIMATION_RATE = 2;
    private static final int THOUSAND = 1000;
    private static final int MILLION = 1000000;
    private int[][] bubbleExpressions = new int[][]{{0, 9}, {10, 19}, {20, 23}, {24, 33}, {34, 43}, {44, 53}, {54, 63}, {64, 69}, {70, 81}};
    private static final int PARACHUTE_START = 0;
    private static final int PARACHUTE_FULL = 4;
    private static final int PARACHUTE_CLOSE = 7;
    private static final int EXPLOSION_START = 0;
    private static final int EXPLOSION_END = 6;
    private static final int BACKGROUND_HEIGHT = 800;
    private static final int ACCELERATION_GRAVITY = 100;
    private static final int ACCELERATION_OPEN = -200;
    private static final int ACCELERATION_FULL = 10;
    private short screenSize;
    private byte[] imagePalette = new byte[768];
    private Bubble[] bubble;
    private int yStart;
    private int yGround;
    private int hGround;
    private short nChosenBubble = 1;
    private int distbp;
    private int gameLevel;
    private int orderGrounded;
    private boolean gameOver;
    private boolean isLevelShown;
    private int nTries;
    private int[] listOrder;
    private int backgound_flag = 0;
    private int currentBubbleSelect = 0;
    private int[] inc = new int[4];
    private int[] preLife = new int[4];
    private int lifeLostH;
    private int currentScore;
    private boolean isScoreChecked;
    private int iNewHighScore = -1;
    private int explosionFrame = 0;
    private int regularFont;
    private int smallFont;
    private long initTime;
    private long previousTime;
    private long currentTime;
    private int readyToThree;
    private int threeToTwo;
    private int twoToOne;
    private int oneToGo;
    private int goTime;
    private int falseStartPosition;
    private int firstStartFalling;
    private int previousMoney;
    private boolean falseStart;
    public long pauseStart;
    public long timePause;
    private int[] xCloud = new int[4];
    private int[] yCloud = new int[4];
    private int soundType;
    int[] highScores = new int[10];
    private int[] nFlag = new int[10];
    private String[] langs = new String[10];
    int introY = 0;
    int introX = 0;
    int introXVelocity = 1;
    int randomImage;
    int randomImage2;
    private Bubble randomBubble;
    private int currentExpression;
    private int currentFrame;
    private int startFrame;
    private int endFrame;
    private int nLanguages;
    private int BASE_LANGSTEP;
    private int angStep;
    private int[] flagX;
    private int[] flagY;
    private int bit_shift = 1;
    private int ang = 90;
    private int incr;
    private int old_ang;
    private boolean flashFlag;
    private boolean isLoadingDone;
    private int currentPercentage;
    private int loadingFlag;
    private int[] randomBubbles = new int[4];
    private int[] randomParachutes = new int[4];
    private boolean isLaunchStart;
    private boolean isLaunchOver;
    private boolean isReadyOver;
    private boolean repeatLevel;
    private long timeOfLaunchOver;
    int backgroundY;
    int freefallVelocity;
    int backgroundHeight;
    int fallHeight;
    int yIncrement;
    boolean freefall = false;
    boolean soundDropPlayed = false;
    boolean soundGetReadyPlayed = false;
    int glow = 0;
    int glowValueMod = 1;
    private int timeParachuteOpening;
    private int timeOpenMax;
    private int timeFreefall;
    private int vMax;
    private int firstLine;
    private int maxLine;
    private int xScroll;
    private int yScroll;
    private int textHeight;
    private boolean exitFlag;
    private String[] locString;
    private boolean viewVersion;
    String versionNum;
    String recordStoreName = "bubblecute";
    int GAME_RECORD_DIM = 1024;
    int gameRecordID;
    int gameLoaderIndex = 0;
    private int numMenus = 4;
    private int[] numMenuItems = new int[]{5, 3, 2, 4, 1};
    private int[][] menuIndexes = new int[][]{{1, 2, 3, 4, 7}, {15, 16, 17}, {-1, -1}, {11, 2, 3, 7}, {-1}};
    private int[][] menuY = new int[this.numMenus][];
    private int currentMenuIndex;
    private int preCurrentMenuIndex;
    private int currentMenuItem;
    private int[] selectedOption = new int[this.numMenus];

    public Game() {
    }

    public Game(Canv canv) {
        System.out.println("Init Game....");
        this.lSer = new Serv(canv);
        this.lSnd = new Sound(this.lSer);
        this.lInp = canv.lInp;
        this.messageString = new String[150];
        this.initFont();
        this.setScreenSize();
    }

    void initScreenLoop() {
        this.lSer.lCan.prgState = 2;
        this.lSer.lCan.iniState = true;
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        this.lSer.lGra.setColor(0, 0, 0);
        this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
    }

    void introMForumLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.randomBubble = new Bubble();
            this.currentExpression = this.getBubbleExpression(0, 1, 4, 6);
            this.getBubbleExpressionFrame(this.currentExpression);
            this.randomBubble.frame = this.currentFrame;
            this.randomBubble.startFrame = this.startFrame;
            this.randomBubble.endFrame = this.endFrame;
            this.randomBubble.parachuteFrame = 0;
            this.randomBubble.timer = 0;
            this.randomImage = this.lSer.rand(7) + 1;
            this.randomImage2 = this.lSer.rand(7) + 1;
        }
        this.lSer.initSync();
        this.introY = this.introY < this.lSer.maxYH - (this.lSer.maxYH >> 2) ? (this.introY += 3) : (this.introY += 6);
        if (++this.randomBubble.timer > 20) {
            this.randomBubble.timer = 0;
        }
        this.introX += this.introXVelocity;
        if (this.introX > 5) {
            this.introXVelocity = -1;
        }
        if (this.introX < -5) {
            this.introXVelocity = 1;
        }
        if (this.lSer.bob[1] == null) {
            this.lSer.loadBob(1, "/microforum.png", 0);
        }
        if (this.lSer.bob[3] == null) {
            this.lSer.loadBob(3, "/menu.png", 0);
        }
        if (this.lSer.bob[10 + this.randomImage] == null) {
            this.lSer.loadBob(10 + this.randomImage, "/bubble" + this.randomImage + ".png", 0);
            this.randomBubble.w = this.randomBubble.h = this.lSer.bobH(10 + this.randomImage);
        }
        if (this.lSer.bob[20 + this.randomImage2] == null) {
            this.lSer.loadBob(20 + this.randomImage2, "/parachute" + this.randomImage2 + ".png", 0);
            this.randomBubble.parachuteWidth = 45;
            this.randomBubble.parachuteHeight = this.lSer.bobH(20 + this.randomImage2);
        }
        this.drawMenuBackground();
        int px = this.lSer.maxXH + this.introX - (this.randomBubble.parachuteWidth >> 1);
        int py = this.introY;
        if (this.introY < this.lSer.maxYH - (this.lSer.maxYH >> 3)) {
            this.lSer.putBob(1, this.lSer.maxXH + this.introX, this.introY, 3);
        } else {
            if (this.randomBubble.modeParachute == 0) {
                this.randomBubble.modeParachute = 1;
            }
            this.drawImageAnimations(20 + this.randomImage2, this.randomBubble.parachuteFrame, this.randomBubble.parachuteWidth, this.randomBubble.parachuteHeight, px, py);
            this.randomBubble.parachuteFrame = this.updateAnimationFrame(this.randomBubble.parachuteFrame, 3, 4, this.randomBubble.timer, 2);
            this.lSer.putBob(1, this.lSer.maxXH, this.lSer.maxYH - (this.lSer.maxYH >> 3), 3);
        }
        if (this.randomBubble.modeParachute == 1) {
            this.randomBubble.modeParachute = (short)2;
            this.currentExpression = this.getBubbleExpression(2, 6, 7);
            this.getBubbleExpressionFrame(this.currentExpression);
            this.randomBubble.frame = this.currentFrame;
            this.randomBubble.startFrame = this.startFrame;
            this.randomBubble.endFrame = this.endFrame;
        }
        int x = this.lSer.maxXH + this.introX - (this.randomBubble.h >> 1);
        int y = this.introY + this.randomBubble.h;
        this.drawImageAnimations(10 + this.randomImage, this.randomBubble.frame, this.randomBubble.w, this.randomBubble.h, x, y);
        this.randomBubble.frame = this.updateAnimationFrame(this.randomBubble.frame, this.randomBubble.startFrame, this.randomBubble.endFrame, this.randomBubble.timer, 5);
        this.lSer.sync(this.syncRate);
        ++this.exitTime;
        if (this.exitTime > 150 || this.introY > this.lSer.maxY) {
            this.changeState(3, false);
            this.exitTime = 0;
            this.lSer.bob[1] = null;
            this.lSer.bob[10 + this.randomImage] = null;
        }
    }

    void splashLoop() {
        this.lSer.initSync();
        this.lSer.clearIMC();
        if (this.lSer.bob[2] == null) {
            this.lSer.loadBob(2, "/splash.png", 0);
        }
        this.lSer.putBob(2, 0, 0, 20);
        this.lSer.sync(this.syncRate);
        ++this.exitTime;
        if (this.exitTime > 25) {
            this.changeState(4, true);
            this.exitTime = 0;
            this.lSer.bob[2] = null;
            System.gc();
        }
    }

    private void initLanguageLoop() {
        boolean found = true;
        this.lSer.numOfLang = 1;
        while (found) {
            found = this.lSer.openFile("/menu0" + this.lSer.numOfLang + ".txt");
            if (!found) continue;
            this.lSer.closeFile();
            ++this.lSer.numOfLang;
        }
        --this.lSer.numOfLang;
        if (this.lSer.numOfLang < 1) {
            return;
        }
        this.lSer.currLang = 1;
        if (this.lSer.currLang > this.lSer.numOfLang) {
            this.lSer.currLang = 1;
        }
        for (int iLanguage = 1; iLanguage <= this.lSer.numOfLang; ++iLanguage) {
            this.langs[iLanguage] = this.lSer.initStrings("/menu0" + iLanguage + ".txt", 0, 1, this.messageString, 0, 3200);
            this.nFlag[iLanguage] = this.lSer.toInt(this.lSer.initStrings("/menu0" + iLanguage + ".txt", 0, 2, this.messageString, 0, 3200));
        }
    }

    void languageLoop() {
        if (this.lSer.lCan.iniState) {
            this.initLanguageLoop();
            this.lSer.lCan.iniState = false;
            this.BASE_LANGSTEP = this.nLanguages = this.lSer.numOfLang;
            this.angStep = 360 / this.nLanguages;
            this.flagX = new int[this.nLanguages];
            this.flagY = new int[this.nLanguages];
            this.old_ang = this.ang;
            this.exitTime = 0;
            if (this.screenSize == 0) {
                this.bit_shift = 2;
            }
            this.lSer.initSync();
        }
        this.lSer.clearIMC();
        this.ang = (this.ang + 360 + this.incr) % 360;
        if (this.incr != 0 && (this.ang + this.angStep - this.old_ang) % this.angStep == 0) {
            this.incr = 0;
        }
        int currSelLang = this.ang / this.angStep + 1;
        if ((currSelLang = (9 - currSelLang) % this.nLanguages) == 0) {
            currSelLang = this.nLanguages;
        }
        this.lSer.currLang = currSelLang;
        this.drawMenuBackground();
        for (int i = 0; i < this.nLanguages; ++i) {
            int ag = (this.ang + i * this.angStep) % 360;
            this.flagX[i] = this.lSer.maxXH - 10 + (this.lSer.cos(ag) >> this.bit_shift);
            this.flagY[i] = this.lSer.maxYH - 5 + (this.lSer.sin(ag) >> this.bit_shift);
            this.lSer.putFlag(i + 1, this.flagX[i], this.flagY[i], 1);
        }
        if ((this.lInp.isActActivated(3, true) || this.lInp.isActActivated(1, true)) && this.incr == 0) {
            this.incr = -this.BASE_LANGSTEP;
            this.old_ang = this.ang;
        }
        if ((this.lInp.isActActivated(4, true) || this.lInp.isActActivated(2, true)) && this.incr == 0) {
            this.incr = this.BASE_LANGSTEP;
            this.old_ang = this.ang;
        }
        if (this.lInp.isActActivated(5, true) || this.lInp.keyStateGet(-6)) {
            this.lInp.keyStateSet(-6, false);
            this.changeState(5, true);
            this.lSer.initStrings("/menu0" + this.lSer.currLang + ".txt", -1, -1, this.messageString, 0, 640);
            this.loadAllSound();
            this.loadOptions();
            this.lSnd.setVolume(0, this.lSnd.soundVol);
        }
        this.lSer.lGra.setColor(190, 30, 30);
        ++this.exitTime;
        if (this.flashFlag && this.exitTime > 3) {
            this.flashFlag = false;
            if (this.exitTime == 6) {
                this.exitTime = 0;
            }
        } else {
            this.lSer.lGra.drawRect(this.lSer.maxXH - 10, this.lSer.maxYH - 5 + (128 >> this.bit_shift), 15, 10);
            this.flashFlag = true;
        }
        this.lSer.setFont(this.regularFont);
        this.lSer.text(this.langs[currSelLang], this.lSer.maxXH, this.lSer.maxYH, 3);
        this.drawSoftKey("Ok", "");
        this.lSer.sync(this.syncRate);
    }

    void initSoundLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.initSync();
            this.lSer.lCan.iniState = false;
            if (this.lSer.bob[3] == null) {
                this.lSer.loadBob(3, "/menu.png", 0);
            }
            if (this.lSer.bob[4] == null) {
                this.lSer.loadBob(4, "/cursor.png", 0);
            }
        }
        this.lSer.clearIMC();
        this.drawMenuBackground();
        this.lSer.text(this.messageString[2], this.lSer.maxXH, this.lSer.maxYH - (this.lSer.currTextHeight + 3), 3);
        if (this.lInp.isActActivated(1, true)) {
            if (this.lSnd.soundOn) {
                this.lSnd.soundOn = false;
            }
        } else if (this.lInp.isActActivated(2, true)) {
            if (!this.lSnd.soundOn) {
                this.lSnd.soundOn = true;
            }
        } else if (this.lInp.isActActivated(5, true) || this.lInp.keyStateGet(-6)) {
            this.lInp.keyStateSet(-6, false);
            this.currentMenuIndex = 0;
            this.changeState(6, true);
        } else if (this.lInp.keyStateGet(-7)) {
            this.changeState(-1, false);
        }
        int y = this.lSer.maxYH;
        if (this.lSnd.soundOn) {
            int textW = this.lSer.textWidth(this.messageString[13]);
            this.lSer.text(this.messageString[13], this.lSer.maxXH, y, 3);
            this.drawSelectors(textW, y, true, false);
        } else {
            int textW = this.lSer.textWidth(this.messageString[14]);
            this.lSer.text(this.messageString[14], this.lSer.maxXH, y, 3);
            this.drawSelectors(textW, y, false, true);
        }
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        this.drawSoftKey(this.messageString[9], this.messageString[7]);
        this.lSer.sync(this.syncRate);
    }

    void soundLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.currentMenuItem = 0;
            this.lSer.initSync();
        }
        this.lSer.clearIMC();
        this.drawMenuBackground();
        this.lSer.lGra.setColor(190, 30, 30);
        this.drawMenuItems(this.currentMenuIndex);
        if (this.lInp.isActActivated(3, true)) {
            this.currentMenuItem = this.currentMenuItem <= 0 ? this.numMenuItems[this.currentMenuIndex] - 1 : --this.currentMenuItem;
        } else if (this.lInp.isActActivated(4, true)) {
            this.currentMenuItem = this.currentMenuItem >= this.numMenuItems[this.currentMenuIndex] - 1 ? 0 : ++this.currentMenuItem;
        } else if (this.lInp.keyStateGet(-7)) {
            this.lInp.keyStateSet(-7, false);
            this.saveOptions();
            this.currentMenuIndex = this.preCurrentMenuIndex;
            this.changeState(6, false);
        } else if (this.lInp.keyStateGet(-6) || this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(-6, false);
            this.lInp.keyStateSet(5, false);
            if ((this.currentMenuItem == 1 && this.soundType == 0 || this.currentMenuItem == 2 && this.soundType == 1) && this.lSnd.volumeControl && this.lSnd.soundOn) {
                this.changeState(8, true);
            }
            if (this.currentMenuItem == 0) {
                this.lSnd.soundOn = false;
                this.lSnd.stopSound(0);
                this.lSnd.stopSound(1);
            } else if (this.currentMenuItem == 1) {
                if (!this.lSnd.soundOn) {
                    this.lSnd.soundOn = true;
                    this.soundType = 0;
                    this.lSnd.stopSound(1);
                    this.lSnd.playSound(0, this.lSnd.soundVol, 100);
                } else if (this.soundType == 1) {
                    this.lSnd.stopSound(1);
                    this.soundType = 0;
                    this.lSnd.playSound(0, this.lSnd.soundVol, 100);
                }
            } else if (this.currentMenuItem == 2) {
                if (!this.lSnd.soundOn) {
                    this.lSnd.soundOn = true;
                    this.soundType = 1;
                    this.lSnd.stopSound(0);
                    this.lSnd.playSound(1, this.lSnd.soundVol, 1);
                } else if (this.soundType == 0) {
                    this.lSnd.stopSound(0);
                    this.soundType = 1;
                    this.lSnd.playSound(1, this.lSnd.soundVol, 1);
                }
            }
        }
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        if (this.lSnd.soundOn) {
            if (this.currentMenuItem == 0) {
                this.drawSoftKey(this.messageString[5], this.messageString[8]);
            } else if (this.currentMenuItem == 1 && this.soundType == 1 || this.currentMenuItem == 2 && this.soundType == 0) {
                this.drawSoftKey(this.messageString[5], this.messageString[8]);
            } else if (this.lSnd.volumeControl) {
                this.drawSoftKey(this.messageString[18], this.messageString[8]);
            }
        } else if (this.currentMenuItem != 0) {
            this.drawSoftKey(this.messageString[5], this.messageString[8]);
        } else {
            this.drawSoftKey("", this.messageString[8]);
        }
        this.lSer.sync(this.syncRate);
    }

    void volumeLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.initSync();
        }
        this.lSer.clearIMC();
        this.drawMenuBackground();
        this.lSer.text(this.messageString[2], this.lSer.maxXH, this.lSer.maxYH, 3);
        if (this.lInp.isActActivated(1, true)) {
            this.lSnd.soundVol = this.lSnd.soundVol > 10 ? (this.lSnd.soundVol -= 10) : 0;
            this.lSnd.setVolume(0, this.lSnd.soundVol);
        } else if (this.lInp.isActActivated(2, true)) {
            this.lSnd.soundVol = this.lSnd.soundVol <= 90 ? (this.lSnd.soundVol += 10) : 100;
            this.lSnd.setVolume(0, this.lSnd.soundVol);
        } else if (this.lInp.keyStateGet(-7)) {
            this.lInp.keyStateSet(-7, false);
            this.lSnd.resetVolume(this.lSnd.soundVol);
            this.changeState(7, true);
        } else if (this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(5, false);
            this.lSnd.soundVol = this.lSnd.soundVol <= 90 ? (this.lSnd.soundVol += 10) : 0;
            this.lSnd.setVolume(0, this.lSnd.soundVol);
        }
        int y = this.lSer.maxYH + this.lSer.currTextHeight + 3;
        int textW = this.lSer.textWidth("100");
        this.lSer.text("" + this.lSnd.soundVol, this.lSer.maxXH, y, 3);
        if (this.lSnd.soundVol > 0 && this.lSnd.soundVol < 100) {
            this.drawSelectors(textW, y, true, true);
        } else if (this.lSnd.soundVol >= 100) {
            this.drawSelectors(textW, y, true, false);
        } else if (this.lSnd.soundVol <= 0) {
            this.drawSelectors(textW, y, false, true);
        }
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        this.drawSoftKey("", this.messageString[8]);
        this.lSer.sync(this.syncRate);
    }

    void menuLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.initSync();
            this.currentMenuItem = 0;
            this.lSer.lCan.iniState = false;
            if (this.lSer.bob[3] == null) {
                this.lSer.loadBob(3, "/menu.png", 0);
            }
            if (this.lSer.bob[2] == null) {
                this.lSer.loadBob(2, "/title.png", 0);
            }
        }
        if (this.lSnd.soundOn && !this.lSnd.isSoundPlaying(0) && this.soundType == 0) {
            this.lSnd.playSound(0, this.lSnd.soundVol, 100);
        }
        this.lSer.clearIMC();
        this.drawMenuBackground();
        this.drawMenuTitle();
        this.drawMenuItems(this.currentMenuIndex);
        if (this.lInp.isActActivated(3, true)) {
            this.currentMenuItem = this.currentMenuItem <= 0 ? this.numMenuItems[this.currentMenuIndex] - 1 : --this.currentMenuItem;
        } else if (this.lInp.isActActivated(4, true)) {
            this.currentMenuItem = this.currentMenuItem >= this.numMenuItems[this.currentMenuIndex] - 1 ? 0 : ++this.currentMenuItem;
        } else if (this.lInp.isActActivated(5, true) || this.lInp.keyStateGet(-6)) {
            this.lInp.keyStateSet(-6, false);
            if (this.currentMenuIndex == 0) {
                if (this.currentMenuItem == 0) {
                    this.isLoadingDone = false;
                    this.changeState(12, true);
                } else if (this.currentMenuItem == 1) {
                    this.preCurrentMenuIndex = this.currentMenuIndex;
                    this.currentMenuIndex = 1;
                    this.changeState(7, true);
                } else if (this.currentMenuItem == 2) {
                    this.viewFileName = "/help0" + this.lSer.currLang + ".txt";
                    this.changeState(9, true);
                } else if (this.currentMenuItem == 3) {
                    this.viewFileName = "/credits0" + this.lSer.currLang + ".txt";
                    this.viewVersion = true;
                    this.changeState(9, true);
                } else if (this.currentMenuItem == 4) {
                    this.changeState(-1, false);
                }
            } else if (this.currentMenuIndex == 3) {
                this.currentMenuIndex = 3;
                if (this.currentMenuItem == 0) {
                    if (this.soundType == 1) {
                        this.lSnd.stopSound(0);
                    }
                    this.timePause += System.currentTimeMillis() - this.pauseStart;
                    this.changeState(10, false);
                } else if (this.currentMenuItem == 1) {
                    this.currentMenuItem = 0;
                    this.preCurrentMenuIndex = this.currentMenuIndex;
                    this.currentMenuIndex = 1;
                    this.changeState(7, true);
                } else if (this.currentMenuItem == 2) {
                    this.viewFileName = "/help0" + this.lSer.currLang + ".txt";
                    this.changeState(9, true);
                } else if (this.currentMenuItem == 3) {
                    this.changeState(16, true);
                }
            }
        }
        this.drawSoftKey(this.messageString[5], "");
        this.lSer.sync(this.syncRate);
    }

    void loadingLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.lSer.bob[2] = null;
            this.loadingFlag = 0;
            this.randomFourBubbles();
            this.randomFourParachutes();
        }
        this.loadImages(this.loadingFlag);
        if (this.isLoadingDone) {
            if (this.loadingFlag == 0) {
                this.initData();
                this.initBubbles();
                this.checkBackgroundImage();
                this.changeState(14, true);
                this.isLoadingDone = false;
            } else if (this.loadingFlag == 1) {
                this.changeState(10, true);
            }
        }
    }

    void selectingBubbleLoop() {
        int prev;
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.lSer.initSync();
            this.lSer.clearIMC();
            for (int i = 0; i < 4; ++i) {
                if (i == this.currentBubbleSelect) {
                    this.getBubbleExpressionFrame(6);
                    this.initBubbleFrame(i, this.currentFrame, this.startFrame, this.endFrame);
                    continue;
                }
                this.getBubbleExpressionFrame(0);
                this.initBubbleFrame(i, this.lSer.rand(10), this.startFrame, this.endFrame);
            }
        }
        this.drawChooseBubble();
        this.lSer.text(this.messageString[19], this.lSer.maxXH, this.lSer.fontHeight[this.regularFont], 3);
        if (this.lInp.isActActivated(3, true)) {
            prev = this.currentBubbleSelect;
            this.currentBubbleSelect = this.currentBubbleSelect <= 0 ? 3 : --this.currentBubbleSelect;
            this.getBubbleExpressionFrame(6);
            this.initBubbleFrame(this.currentBubbleSelect, this.currentFrame, this.startFrame, this.endFrame);
            this.getBubbleExpressionFrame(0);
            this.initBubbleFrame(prev, this.lSer.rand(10), this.startFrame, this.endFrame);
        } else if (this.lInp.isActActivated(4, true)) {
            prev = this.currentBubbleSelect;
            this.currentBubbleSelect = this.currentBubbleSelect >= 3 ? 0 : ++this.currentBubbleSelect;
            this.getBubbleExpressionFrame(6);
            this.initBubbleFrame(this.currentBubbleSelect, this.currentFrame, this.startFrame, this.endFrame);
            this.getBubbleExpressionFrame(0);
            this.initBubbleFrame(prev, this.lSer.rand(10), this.startFrame, this.endFrame);
        } else if (this.lInp.isActActivated(5, true) || this.lInp.keyStateGet(-6)) {
            this.lInp.keyStateSet(-6, false);
            this.nChosenBubble = (short)this.currentBubbleSelect;
            this.falseStartPosition = this.bubble[this.nChosenBubble].h << 2;
            if (this.soundType == 1) {
                this.lSnd.stopSound(0);
            }
            this.loadingFlag = 1;
            this.changeState(12, false);
        } else if (this.lInp.keyStateGet(-7)) {
            this.lInp.keyStateSet(-7, false);
            this.changeState(6, true);
            this.currentMenuIndex = 0;
            this.unloadImages();
        }
        this.drawSoftKey(this.messageString[5], this.messageString[8]);
        this.lSer.sync(this.syncRate);
    }

    void startGameLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.currentMenuItem = 0;
            this.isLaunchStart = true;
            this.isLaunchOver = false;
            this.isReadyOver = false;
            this.readyToThree = 2000;
            this.threeToTwo = 2500;
            this.twoToOne = 3500 + this.lSer.rand(1000);
            this.oneToGo = this.twoToOne + 1500 + this.lSer.rand(1500);
            this.goTime = 1500;
            this.distbp = 15;
            this.randomBubble.frame = 0;
            this.checkBackgroundImage();
            this.initCloudPosition();
        } else {
            this.lSer.initSync();
            this.lSer.clearIMC();
            if (this.isLaunchOver && this.lInp.isActActivated(5, true)) {
                this.resetData();
                this.resetBubbles();
                if (this.bubble[this.nChosenBubble].isDead) {
                    this.currentMenuIndex = 0;
                    this.changeState(16, true);
                    return;
                }
                this.changeState(11, true);
                return;
            }
            this.playGame();
            if (this.lInp.keyStateGet(-7)) {
                this.lInp.keyStateSet(-7, false);
                this.changeState(6, true);
                this.currentMenuIndex = 3;
                this.pauseStart = System.currentTimeMillis();
            }
            this.drawSoftKey("", this.messageString[10]);
            this.lSer.sync(this.syncRate);
        }
    }

    private void getReady() {
        this.drawBackGround();
        this.drawInformation();
        if (this.lSnd.soundOn && !this.lSnd.isSoundPlaying(4) && !this.soundGetReadyPlayed && this.soundType == 1) {
            this.lSnd.playSound(4, this.lSnd.soundVol, 1);
            this.soundGetReadyPlayed = true;
        }
        int tempY = 0;
        for (int i = 0; i < 4; ++i) {
            this.updateBubbleTimer(i);
            tempY = this.bubble[i].y;
            if (i == this.nChosenBubble && this.falseStart && this.bubble[i].y == this.falseStartPosition && (this.gameLevel % 8 == 1 || this.gameLevel % 8 == 2)) {
                tempY = this.webOscillation(this.bubble[this.nChosenBubble].y);
            }
            if (i != this.nChosenBubble || this.exitTime % 10 < 6) {
                this.drawImageAnimations(10 + i, this.bubble[i].frame, this.bubble[i].w, this.bubble[i].h, this.bubble[i].x - (this.bubble[i].h >> 1), tempY - (this.bubble[i].h >> 1));
            }
            this.bubble[i].frame = this.updateAnimationFrame(this.bubble[i].frame, this.bubble[i].startFrame, this.bubble[i].endFrame, this.bubble[i].timer, 5);
            if (i == this.nChosenBubble && this.falseStart) {
                if (this.bubble[i].y == this.falseStartPosition) {
                    this.drawFalseStart(this.gameLevel, tempY);
                } else {
                    this.drawFalseStart(this.gameLevel, this.falseStartPosition);
                }
            }
            if (i != this.nChosenBubble || !this.falseStart) continue;
            if (this.bubble[i].y < this.falseStartPosition) {
                this.bubble[i].y += 4;
                continue;
            }
            this.bubble[i].y = this.falseStartPosition;
        }
        this.currentTime = System.currentTimeMillis() - this.timePause;
        int x = this.lSer.maxXH - (this.lSer.bobW(5) >> 3);
        int y = this.lSer.maxYH - (this.lSer.bobH(5) >> 1);
        if (this.currentTime - this.initTime < (long)this.readyToThree) {
            this.lSer.text(this.messageString[20], this.lSer.maxXH, this.lSer.maxYH, 3);
        } else if (this.currentTime - this.initTime < (long)this.threeToTwo) {
            this.drawImageAnimations(5, 2, this.lSer.bobW(5) >> 2, this.lSer.bobH(5), x, y);
        } else if (this.currentTime - this.initTime < (long)this.twoToOne) {
            this.drawImageAnimations(5, 1, this.lSer.bobW(5) >> 2, this.lSer.bobH(5), x, y);
        } else if (this.currentTime - this.initTime < (long)this.oneToGo) {
            this.drawImageAnimations(5, 0, this.lSer.bobW(5) >> 2, this.lSer.bobH(5), x, y);
        } else {
            this.isReadyOver = true;
            this.initTime = System.currentTimeMillis() - this.timePause;
        }
        if (this.lInp.isActActivated(5, true)) {
            this.lInp.isActActivated(5, false);
            this.falseStart = true;
            this.currentExpression = this.getBubbleExpression(3, 4, 5);
            this.getBubbleExpressionFrame(this.currentExpression);
            this.initBubbleFrame(this.nChosenBubble, this.currentFrame, this.startFrame, this.endFrame);
        } else {
            Canv cfr_ignored_0 = this.lSer.lCan;
            if (this.lInp.keyStateGet(57)) {
                // empty if block
            }
        }
    }

    private void drawLevel() {
        this.drawBackGround();
        this.lSer.text(this.messageString[21] + " " + this.gameLevel, this.lSer.maxXH, this.lSer.maxYH - 10, 3);
    }

    private void drawGameOver() {
        this.drawMenuBackground();
        this.lSer.text(this.messageString[28], this.lSer.maxXH, this.lSer.maxYH, 3);
    }

    private void drawGameWin() {
        int offset = 15;
        this.drawMenuBackground();
        this.lSer.text(this.messageString[29], this.lSer.maxXH, this.lSer.maxYH - offset, 3);
        this.lSer.text(this.messageString[30], this.lSer.maxXH, this.lSer.maxYH + offset, 3);
    }

    private boolean updateHighScores() {
        return false;
    }

    private void drawInformation() {
        int y = 3;
        int offset = 40;
        int offset2 = 5;
        int offset3 = 6;
        this.lSer.setFont(this.smallFont);
        this.lSer.drawProgressiveBar(1, this.lSer.maxX - offset, offset2, 35, this.bubble[this.nChosenBubble].life, 2, 1);
        this.lSer.putBob(14, this.lSer.maxX - offset - offset2, y, 24);
        this.lSer.putBob(15, offset2, y, 20);
        this.lSer.text("" + this.previousMoney, this.lSer.bobW(15) + offset2 + offset2, y, 20);
        if (this.bubble[this.nChosenBubble].money > this.previousMoney) {
            this.previousMoney += 5;
        }
        if (this.previousMoney > this.bubble[this.nChosenBubble].money) {
            this.previousMoney = this.bubble[this.nChosenBubble].money;
        }
        if (-this.backgroundY >= this.fallHeight / 5 << 2) {
            this.lSer.drawFallHeightBar(1, this.lSer.maxX - 5, this.lSer.maxYH, this.lSer.maxYH >> 2, this.fallHeight - -this.backgroundY >> 3, 1, 1);
        } else if (-this.backgroundY < this.fallHeight / 3) {
            this.lSer.drawFallHeightBar(2, this.lSer.maxX - 5, this.lSer.maxYH, this.lSer.maxYH >> 2, this.fallHeight - -this.backgroundY >> 3, 1, 1);
        } else if (-this.backgroundY < this.fallHeight / 5 << 2) {
            this.lSer.drawFallHeightBar(3, this.lSer.maxX - 5, this.lSer.maxYH, this.lSer.maxYH >> 2, this.fallHeight - -this.backgroundY >> 3, 1, 1);
        }
        this.lSer.setFont(this.regularFont);
    }

    private boolean checkLaunchOver() {
        for (int i = 0; i < 4; ++i) {
            if (this.bubble[i].modeParachute == 0) {
                if (i == this.nChosenBubble && this.falseStart || this.bubble[i].isGrounded) continue;
                return false;
            }
            if (this.inc[i] < this.lifeLostH) {
                return false;
            }
            if (this.backgroundY <= -this.fallHeight) continue;
            return false;
        }
        return true;
    }

    void pointsLoop() {
        int i;
        int length;
        int offset;
        int y;
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        this.drawMenuBackground();
        if (this.lSer.lCan.iniState) {
            this.exitTime = 0;
            this.isLaunchStart = true;
            this.isLaunchOver = false;
            this.isReadyOver = false;
            this.lSer.lCan.iniState = false;
            this.getListOrder();
            this.setBubbleFrame();
        }
        int x = this.lSer.maxX >> 2;
        if (this.screenSize == 1) {
            y = 30;
            offset = 30;
            length = 30;
        } else if (this.screenSize == 2) {
            y = 40;
            offset = 44;
            length = 40;
        } else if (this.screenSize == 3) {
            y = 70;
            offset = 56;
            length = 60;
        } else {
            y = 40;
            offset = 46;
            length = 40;
        }
        this.lSer.text(this.messageString[22], x << 1, y, 33);
        this.lSer.putBob(14, (x << 1) + x, y, 33);
        int lengthH = length >> 1;
        for (i = 0; i < 4; ++i) {
            y += offset;
            this.updateBubbleTimer(i);
            if (this.listOrder[i] != this.nChosenBubble || this.exitTime % 10 < 6) {
                this.drawImageAnimations(10 + this.listOrder[i], this.bubble[this.listOrder[i]].frame, this.bubble[this.listOrder[i]].w, this.bubble[this.listOrder[i]].h, x - (this.bubble[this.listOrder[i]].h >> 1), y - (this.bubble[this.listOrder[i]].h >> 1));
                this.bubble[i].frame = this.updateAnimationFrame(this.bubble[i].frame, this.bubble[i].startFrame, this.bubble[i].endFrame, this.bubble[i].timer, 5);
                if (this.listOrder[i] == this.nChosenBubble) {
                    this.lSer.setColor(190, 30, 30);
                    this.lSer.text("" + this.bubble[this.listOrder[i]].points, x << 1, y, 3);
                    this.lSer.drawProgressiveBar(1, (x << 1) + x - lengthH, y, length, this.bubble[this.listOrder[i]].life, 2, 1);
                }
            }
            if (this.listOrder[i] == this.nChosenBubble) continue;
            this.lSer.setColor(190, 30, 30);
            this.lSer.text("" + this.bubble[this.listOrder[i]].points, x << 1, y, 3);
            this.lSer.drawProgressiveBar(1, (x << 1) + x - lengthH, y, length, this.bubble[this.listOrder[i]].life, 2, 1);
        }
        this.exitTime = this.exitTime < 30 ? ++this.exitTime : 1;
        if (this.lInp.keyStateGet(-6) || this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(-6, false);
            this.lInp.keyStateSet(5, false);
            this.isLoadingDone = true;
            this.exitTime = 0;
            ++this.nTries;
            if (this.nTries == 3) {
                this.nTries = 0;
                if (this.listOrder[0] == this.nChosenBubble) {
                    ++this.gameLevel;
                } else if (this.repeatLevel) {
                    this.repeatLevel = false;
                } else {
                    --this.gameLevel;
                    if (this.gameLevel < 1) {
                        this.gameLevel = 1;
                    }
                    this.repeatLevel = true;
                }
                this.isLevelShown = true;
                if (this.gameLevel > 40) {
                    this.changeState(17, true);
                } else {
                    this.changeState(13, true);
                }
            } else if (this.gameOver) {
                this.currentMenuIndex = 0;
                this.changeState(6, true);
            } else {
                this.changeState(10, true);
                this.initTime = System.currentTimeMillis();
                this.getBubbleExpressionFrame(0);
                for (i = 0; i < 4; ++i) {
                    this.initBubbleFrame(i, this.lSer.rand(10), this.startFrame, this.endFrame);
                }
            }
        }
        this.drawSoftKey(this.messageString[11], "");
        this.lSer.sync(this.syncRate);
    }

    private void updateMoney(int order) {
        int temp = 30;
        int ratio1 = 8;
        int ratio2 = 10;
        if (order == 1) {
            this.bubble[this.nChosenBubble].money += 100 * ratio1 / ratio2;
        } else if (order == 2) {
            this.bubble[this.nChosenBubble].money += 75 * ratio1 / ratio2;
        } else if (order == 3) {
            this.bubble[this.nChosenBubble].money += 50 * ratio1 / ratio2;
        } else if (order == 4) {
            this.bubble[this.nChosenBubble].money += 25 * ratio1 / ratio2;
        }
    }

    private void getListOrder() {
        int i;
        int[] tempArray = new int[4];
        for (i = 0; i < 4; ++i) {
            this.listOrder[i] = i;
            tempArray[i] = this.bubble[i].points;
        }
        for (i = 0; i < 4; ++i) {
            int temp = tempArray[i];
            int order = this.listOrder[i];
            short n = -1;
            boolean isChanged = false;
            for (short j = i + 1; j < 4; ++j) {
                if (temp < tempArray[j]) {
                    temp = tempArray[j];
                    n = j;
                    isChanged = true;
                    continue;
                }
                if (temp != tempArray[j] || j != this.nChosenBubble) continue;
                n = j;
                isChanged = true;
            }
            if (!isChanged) continue;
            this.listOrder[i] = this.listOrder[n];
            this.listOrder[n] = order;
            temp = tempArray[i];
            tempArray[i] = tempArray[n];
            tempArray[n] = temp;
        }
    }

    private void checkBubbleHealth(int i) {
        if (!this.bubble[i].isHealthChecked) {
            int temp = this.bubble[i].life;
            int vTemp = this.bubble[i].yVelocity / 1000;
            int rTemp = 6;
            if (vTemp > this.vMax * rTemp / 10) {
                this.bubble[i].life -= 12;
            } else if (vTemp > this.vMax * (rTemp - 1) / 10 && vTemp <= this.vMax * rTemp / 10) {
                this.bubble[i].life -= 10;
            } else if (vTemp > this.vMax * (rTemp - 2) / 10 && vTemp <= this.vMax * (rTemp - 1) / 10) {
                this.bubble[i].life -= 8;
            } else if (vTemp > this.vMax * (rTemp - 3) / 10 && vTemp <= this.vMax * (rTemp - 2) / 10) {
                this.bubble[i].life -= 6;
            } else if (vTemp > this.vMax * (rTemp - 4) / 10 && vTemp <= this.vMax * (rTemp - 3) / 10) {
                this.bubble[i].life -= 4;
            } else if (vTemp <= this.vMax * (rTemp - 4) / 10) {
                this.bubble[i].life -= 2;
            }
            if (this.bubble[i].modeParachute < 1) {
                this.bubble[i].life = 0;
            }
            if (this.bubble[i].life <= 0) {
                this.bubble[i].life = 0;
                this.bubble[i].isDead = true;
            }
            this.preLife[i] = temp;
            if (i == this.nChosenBubble && this.bubble[i].isDead) {
                this.gameOver = true;
            }
            this.bubble[i].points += 10 - this.orderGrounded * 3;
            ++this.orderGrounded;
            if (i == this.nChosenBubble) {
                this.previousMoney = this.bubble[this.nChosenBubble].money;
                this.updateMoney(this.orderGrounded);
            }
            if (this.gameOver) {
                if (i == this.nChosenBubble) {
                    this.currentExpression = this.getBubbleExpression(3, 4, 5);
                    this.getBubbleExpressionFrame(this.currentExpression);
                    this.initBubbleFrame(this.nChosenBubble, this.currentFrame, this.startFrame, this.endFrame);
                } else {
                    this.setBubbleFrame(i, this.orderGrounded - 1);
                }
            } else {
                this.setBubbleFrame(i, this.orderGrounded);
            }
            this.bubble[i].isHealthChecked = true;
        }
    }

    private void checkCurrentScore(int order) {
        int score = 0;
        if (this.isScoreChecked) {
            return;
        }
        if (!this.bubble[this.nChosenBubble].isGrounded) {
            return;
        }
        score = order == 1 ? 100 : (order == 2 ? 75 : (order == 3 ? 50 : 25));
        this.currentScore += score;
        this.isScoreChecked = true;
    }

    private void checkPlayMessage() {
        if (this.isLaunchOver) {
            if (this.timeOfLaunchOver == 0L) {
                this.timeOfLaunchOver = System.currentTimeMillis();
                this.exitTime = 0;
            }
            if (System.currentTimeMillis() - this.timeOfLaunchOver > 5000L) {
                if (this.exitTime % 14 < 8) {
                    if (this.messageString[34] != null) {
                        this.lSer.text(this.messageString[33], this.lSer.maxXH, this.lSer.maxYH - this.lSer.currTextHeight, 3);
                        this.lSer.text(this.messageString[34], this.lSer.maxXH, this.lSer.maxYH, 3);
                    } else {
                        this.lSer.text(this.messageString[33], this.lSer.maxXH, this.lSer.maxYH, 3);
                    }
                }
                this.exitTime = this.exitTime < 70 ? ++this.exitTime : 1;
            }
        }
    }

    private void sleep(int duration) {
        long initT = System.currentTimeMillis();
        while (System.currentTimeMillis() - initT < (long)duration) {
        }
    }

    private void drawChooseBubble() {
        int offset3;
        int offset2;
        int offset1;
        if (this.screenSize == 1) {
            offset1 = 60;
            offset2 = 60;
            offset3 = 7;
        } else if (this.screenSize == 2) {
            offset1 = 70;
            offset2 = 70;
            offset3 = 10;
        } else if (this.screenSize == 3) {
            offset1 = 100;
            offset2 = 100;
            offset3 = 20;
        } else {
            offset1 = 60;
            offset2 = 60;
            offset3 = 10;
        }
        if (this.glow > 5) {
            this.glowValueMod = -1;
        }
        if (this.glow <= 0) {
            this.glowValueMod = 1;
        }
        this.glow += this.glowValueMod;
        this.drawMenuBackground();
        for (int i = 0; i < 4; ++i) {
            int y = offset1 + i * (this.bubble[i].h + offset3);
            this.updateBubbleTimer(i);
            if (this.currentBubbleSelect == i) {
                this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
                this.lSer.lGra.setColor(0xFF00FF);
                this.lSer.lGra.fillArc(this.lSer.maxXH - (this.bubble[0].w >> 1) - this.glow, y - (this.bubble[0].h >> 1) - this.glow, this.bubble[0].w + 2 * this.glow, this.bubble[0].h + 2 * this.glow, 0, 360);
            }
            this.drawImageAnimations(10 + i, this.bubble[i].frame, this.bubble[i].w, this.bubble[i].h, this.lSer.maxXH - (this.bubble[i].h >> 1), y - (this.bubble[i].h >> 1));
            this.bubble[i].frame = this.currentBubbleSelect == i ? this.updateAnimationFrame(this.bubble[i].frame, this.bubble[i].startFrame, this.bubble[i].endFrame, this.bubble[i].timer, 5) : this.updateAnimationFrame(this.bubble[i].frame, this.bubble[i].startFrame, this.bubble[i].endFrame, this.bubble[i].timer, 5);
        }
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        int y = offset2 + this.currentBubbleSelect * (this.bubble[0].h + offset3);
        this.drawSelectors(this.bubble[0].w, y, true, true);
    }

    private void playGame() {
        if (this.isLevelShown) {
            if (this.initTime == 0L) {
                this.initTime = System.currentTimeMillis() - this.timePause;
            }
            if (this.lSnd.soundOn && !this.lSnd.isSoundPlaying(1) && this.soundType == 1) {
                this.lSnd.playSound(1, this.lSnd.soundVol, 1);
            }
            this.drawLevel();
            this.currentTime = System.currentTimeMillis() - this.timePause;
            if (this.currentTime - this.initTime > 2000L) {
                this.isLevelShown = false;
                this.exitTime = 0;
                this.initTime = System.currentTimeMillis() - this.timePause;
                this.getBubbleExpressionFrame(0);
                for (int i = 0; i < 4; ++i) {
                    this.initBubbleFrame(i, this.lSer.rand(10), this.startFrame, this.endFrame);
                }
            }
            return;
        }
        if (this.isLaunchStart && !this.isLaunchOver && !this.isReadyOver) {
            this.getReady();
            ++this.exitTime;
            return;
        }
        this.isLaunchStart = false;
        if (this.lSnd.soundOn && this.lSnd.currBuffer != 5 && !this.soundDropPlayed && this.soundType == 1) {
            this.lSnd.playSound(5, this.lSnd.soundVol, 1);
            this.soundDropPlayed = true;
            this.exitTime = 0;
        }
        this.drawBackGround();
        this.drawInformation();
        this.previousTime = this.currentTime;
        this.currentTime = System.currentTimeMillis() - this.timePause;
        if (this.currentTime - this.initTime < (long)this.goTime) {
            this.drawImageAnimations(5, 3, this.lSer.bobW(5) >> 2, this.lSer.bobH(5), this.lSer.maxXH - (this.lSer.bobW(5) >> 3), this.lSer.maxYH - (this.lSer.bobH(5) >> 1));
        } else {
            this.initTime = 0L;
        }
        this.checkStartFalling();
        this.checkFreefall();
        this.checkOpenParachute();
        this.updateBubblePosition();
        for (int i = 0; i < 4; ++i) {
            if (!this.bubble[i].isGrounded || this.bubble[i].isHealthChecked) continue;
            this.checkBubbleHealth(i);
            if (!this.lSnd.soundOn || this.soundType != 1) continue;
            this.lSnd.playSound(3, this.lSnd.soundVol, 1);
        }
        this.updateBubbleSpeed();
        this.drawLifeLost();
        this.drawBubbles();
        this.isLaunchOver = this.checkLaunchOver();
        this.checkPlayMessage();
        if (!this.lInp.isActActivated(1, false) && !this.lInp.isActActivated(2, false)) {
            if (this.lInp.isActActivated(5, true)) {
                if (this.falseStart) {
                    return;
                }
                if (!this.bubble[this.nChosenBubble].startFalling) {
                    this.bubble[this.nChosenBubble].startFalling = true;
                    this.bubble[this.nChosenBubble].tStart = this.currentTime;
                    this.bubble[this.nChosenBubble].timer = 0;
                    this.currentExpression = this.excludeBubbleExpression(8);
                    this.getBubbleExpressionFrame(this.currentExpression);
                    this.initBubbleFrame(this.nChosenBubble, this.currentFrame, this.startFrame, this.endFrame);
                    if (this.lSnd.soundOn && this.soundType == 1) {
                        this.lSnd.playSound(2, this.lSnd.soundVol, 1);
                    }
                } else if (this.bubble[this.nChosenBubble].modeParachute == 0 && !this.bubble[this.nChosenBubble].isDead) {
                    this.bubble[this.nChosenBubble].modeParachute = 1;
                    this.bubble[this.nChosenBubble].tOpen = this.currentTime + (long)this.syncRate;
                    this.bubble[this.nChosenBubble].timer = 0;
                    this.bubble[this.nChosenBubble].xp = this.bubble[this.nChosenBubble].x;
                    this.bubble[this.nChosenBubble].yp = this.bubble[this.nChosenBubble].y - this.distbp;
                    this.currentExpression = this.getBubbleExpression(2, 6, 7);
                    this.getBubbleExpressionFrame(this.currentExpression);
                    this.initBubbleFrame(this.nChosenBubble, this.currentFrame, this.startFrame, this.endFrame);
                }
            } else if (!this.lInp.isActActivated(6, true)) {
                Canv cfr_ignored_0 = this.lSer.lCan;
                if (this.lInp.keyStateGet(57)) {
                    // empty if block
                }
            }
        }
    }

    private void checkFreefall() {
        this.freefall = false;
        int ib = -1;
        if (this.falseStart) {
            int yFar = 0;
            for (int i = 0; i < 4; ++i) {
                if (i == this.nChosenBubble || this.bubble[i].y <= yFar) continue;
                yFar = this.bubble[i].y;
                ib = i;
            }
            if (this.bubble[ib].y >= this.lSer.maxYH && this.backgroundY > this.lSer.maxY - this.backgroundHeight) {
                this.freefall = true;
                this.freefallVelocity = this.bubble[ib].yVelocity;
            }
        } else if (this.bubble[this.nChosenBubble].y >= this.lSer.maxYH && this.backgroundY > this.lSer.maxY - this.backgroundHeight) {
            this.freefall = true;
            this.freefallVelocity = this.bubble[this.nChosenBubble].yVelocity;
            ib = this.nChosenBubble;
        }
        if (this.freefall) {
            int temp1 = (int)((long)this.freefallVelocity * (this.currentTime - this.previousTime) / 1000000L);
            int tempA = 0;
            if (this.currentTime < this.bubble[ib].tOpen) {
                tempA = 100;
            } else if (this.currentTime >= this.bubble[ib].tOpen && this.currentTime < this.bubble[ib].tFull) {
                tempA = -200;
            } else if (this.currentTime >= this.bubble[ib].tFull && !this.bubble[ib].isGrounded) {
                tempA = 10;
            }
            int temp2 = (int)((long)tempA * (this.currentTime - this.previousTime) * (this.currentTime - this.previousTime) / 1000000L >> 1);
            this.yIncrement = temp1 - temp2;
            this.backgroundY -= this.yIncrement;
            if (this.backgroundY <= this.lSer.maxY - this.backgroundHeight) {
                this.backgroundY = this.lSer.maxY - this.backgroundHeight;
            }
        }
    }

    private void checkStartFalling() {
        for (int i = 0; i < 4; ++i) {
            if (i == this.nChosenBubble || this.bubble[i].startFalling) continue;
            boolean condition1 = this.lSer.rand(100) > 90 - this.gameLevel;
            boolean condition2 = false;
            if (this.firstStartFalling >= 0) {
                condition2 = this.currentTime - this.bubble[this.firstStartFalling].tStart > (long)(200 + 20 * (40 - this.gameLevel));
            } else if (this.bubble[this.nChosenBubble].startFalling) {
                this.firstStartFalling = this.nChosenBubble;
            }
            if (!condition1 && !condition2) continue;
            this.bubble[i].startFalling = true;
            this.bubble[i].tStart = this.currentTime;
            if (this.firstStartFalling < 0) {
                this.firstStartFalling = i;
            }
            this.bubble[i].timer = 0;
            this.currentExpression = this.excludeBubbleExpression(8);
            this.getBubbleExpressionFrame(this.currentExpression);
            this.initBubbleFrame(i, this.currentFrame, this.startFrame, this.endFrame);
            if (!this.lSnd.soundOn || this.soundType != 1) continue;
            this.lSnd.playSound(2, this.lSnd.soundVol, 1);
        }
    }

    private void checkOpenParachute() {
        for (int i = 0; i < 4; ++i) {
            boolean condition4;
            boolean condition1;
            if (i == this.nChosenBubble || this.bubble[i].modeParachute != 0 || !this.bubble[i].startFalling || this.bubble[i].isGrounded) continue;
            int bubbleLife = 32 - this.bubble[i].life;
            boolean condition2 = false;
            boolean bl = condition1 = (int)(this.currentTime - this.bubble[i].tStart) > this.lSer.abs(this.timeFreefall * 100 / -200);
            condition2 = this.nTries == 0 ? this.lSer.rand(100) > 94 + this.gameLevel / 4 : (this.nTries == 1 ? this.lSer.rand(100) > 67 + this.bubble[i].life + this.gameLevel / 4 : this.lSer.rand(100) > 73 + this.bubble[i].life + this.gameLevel / 4);
            boolean condition3 = this.bubble[i].modeParachute == 0 && this.currentTime - this.bubble[i].tStart >= (long)this.timeFreefall;
            boolean bl2 = condition4 = this.bubble[i].modeParachute == 0 && this.currentTime - this.bubble[i].tStart >= (long)(this.timeOpenMax - (40 - this.gameLevel) * 10);
            if ((!condition1 || !condition2) && !condition3 && !condition4) continue;
            this.bubble[i].modeParachute = 1;
            this.bubble[i].xp = this.bubble[i].x;
            this.bubble[i].yp = this.bubble[i].y - this.distbp;
            this.bubble[i].tOpen = this.currentTime;
            this.bubble[i].timer = 0;
            this.currentExpression = this.excludeBubbleExpression(8);
            this.getBubbleExpressionFrame(this.currentExpression);
            this.initBubbleFrame(i, this.currentFrame, this.startFrame, this.endFrame);
        }
    }

    private void getGameParameters() {
        int h = 800 - this.yStart - this.hGround;
        this.timeFreefall = this.lSer.sqrt(2 * h * 1000000 / 100);
        this.timeParachuteOpening = this.syncRate * 2 * 4;
        this.vMax = this.lSer.sqrt(200 * (this.backgroundHeight - this.yStart - this.hGround));
        int t2 = this.timeParachuteOpening;
        int temp1 = 200 * t2 / 1000 * (200 * t2) / 1000;
        int temp2 = 400 * (-200 * t2 / 1000 * t2 / 1000 - 2 * h);
        int temp3 = this.lSer.sqrt(temp1 - temp2) * 1000 / 200;
        this.timeOpenMax = -t2 + temp3;
    }

    private void updateBubbleSpeed() {
        for (int i = 0; i < 4; ++i) {
            if (this.bubble[i].isGrounded) {
                this.bubble[i].yVelocity = 0;
                continue;
            }
            if (!this.bubble[i].startFalling) continue;
            if (this.bubble[i].modeParachute == 0) {
                this.bubble[i].yVelocity = 100 * (int)(this.currentTime - this.bubble[i].tStart);
                continue;
            }
            if (this.bubble[i].modeParachute == 1) {
                this.bubble[i].yVelocity = 100 * (int)(this.bubble[i].tOpen - this.bubble[i].tStart) + -200 * (int)(this.currentTime - this.bubble[i].tOpen);
                if (this.bubble[i].yVelocity >= 0) continue;
                this.bubble[i].yVelocity = 0;
                continue;
            }
            if (this.bubble[i].modeParachute != 2) continue;
            int v1 = 100 * (int)(this.bubble[i].tOpen - this.bubble[i].tStart);
            int v2 = -200 * (int)(this.bubble[i].tFull - this.bubble[i].tOpen);
            int v3 = 10 * (int)(this.currentTime - this.bubble[i].tFull);
            this.bubble[i].yVelocity = v1 + v2 < 0 ? v3 : v1 + v2 + v3;
        }
    }

    private void updateBubblePosition() {
        for (short i = 0; i < 4; ++i) {
            if (this.bubble[i].x < this.bubble[i].x0 - (this.bubble[i].w >> 2) || this.bubble[i].x > this.bubble[i].x0 + (this.bubble[i].w >> 2)) {
                this.bubble[i].xVelocity = -this.bubble[i].xVelocity;
            }
            if (!this.bubble[i].isGrounded) {
                boolean bl = this.bubble[i].isGrounded = this.bubble[i].y - this.backgroundY >= this.backgroundHeight - this.hGround;
            }
            if (this.bubble[i].startFalling) {
                if (!this.bubble[i].isGrounded) {
                    this.bubble[i].x += this.bubble[i].xVelocity;
                    int temp1 = (int)((long)this.bubble[i].yVelocity * (this.currentTime - this.previousTime) / 1000000L);
                    int tempA = 0;
                    if (this.currentTime < this.bubble[i].tOpen) {
                        tempA = 100;
                    } else if (this.currentTime >= this.bubble[i].tOpen && this.currentTime < this.bubble[i].tFull) {
                        tempA = -200;
                    } else if (this.currentTime >= this.bubble[i].tFull && !this.bubble[i].isGrounded) {
                        tempA = 10;
                    }
                    int temp2 = (int)((long)tempA * (this.currentTime - this.previousTime) * (this.currentTime - this.previousTime) / 1000000L >> 1);
                    if (this.freefall) {
                        this.bubble[i].y += temp1 - temp2 - this.yIncrement;
                    } else {
                        this.bubble[i].y += temp1 - temp2;
                        if (this.bubble[i].y - this.backgroundY > this.backgroundHeight - this.hGround) {
                            this.bubble[i].y = i == this.nChosenBubble ? this.yGround : (this.bubble[i].y > this.backgroundHeight - this.hGround ? this.backgroundHeight - this.hGround : this.yGround);
                        }
                    }
                } else {
                    this.bubble[i].y = this.freefall || this.backgroundY == 0 ? this.backgroundHeight + this.backgroundY - this.yStart + this.hGround : this.yGround;
                }
            }
            if (this.bubble[i].startFalling || !this.freefall) continue;
            this.bubble[i].y -= this.yIncrement;
        }
    }

    private void handleCollision() {
        boolean isCollided = false;
        for (int i = 0; i < 4; ++i) {
            for (int j = i + 1; j < 4; ++j) {
                if (i != j && this.bubble[i].y < this.yGround && this.bubble[j].y < this.yGround) {
                    isCollided = this.checkCollision(this.bubble[i].x, this.bubble[i].y, this.bubble[i].w, this.bubble[i].h, this.bubble[j].x, this.bubble[j].y, this.bubble[j].w, this.bubble[j].h);
                    System.out.println(".........isCollided:" + isCollided);
                }
                if (!isCollided) continue;
                int tempV = this.bubble[i].xVelocity;
                if (this.bubble[i].xVelocity == this.bubble[j].xVelocity && this.bubble[i].y < this.bubble[j].y) {
                    this.bubble[i].xVelocity = -this.bubble[i].xVelocity;
                }
                this.bubble[i].xVelocity = this.bubble[i].xVelocity != 0 ? -this.bubble[i].xVelocity : this.bubble[j].xVelocity;
                this.bubble[j].xVelocity = this.bubble[j].xVelocity != 0 ? -this.bubble[j].xVelocity : tempV;
                isCollided = false;
            }
        }
    }

    private boolean checkCollision(int x1, int y1, int w1, int h1, int x2, int y2, int w2, int h2) {
        int r = this.lSer.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        if (r <= w1) {
            this.debug("r = " + r + "  w1 = " + w1);
        }
        return r <= w1;
    }

    private void drawLifeLost() {
        if (this.falseStart) {
            this.inc[this.nChosenBubble] = this.lifeLostH;
        }
        for (int i = 0; i < 4; ++i) {
            if (!this.bubble[i].isGrounded) continue;
            int n = i;
            this.inc[n] = this.inc[n] + 2;
            if (this.inc[i] >= this.lifeLostH) continue;
            this.lSer.text("" + (this.preLife[i] - this.bubble[i].life) * 10, this.bubble[i].x, this.bubble[i].y - this.bubble[i].h - this.inc[i], 3);
        }
    }

    private void updateBubbleTimer(int i) {
        if (++this.bubble[i].timer > 20) {
            this.bubble[i].timer = 0;
        }
    }

    private void drawBubbles() {
        int offset = 0;
        for (int i = 0; i < 4; ++i) {
            this.updateBubbleTimer(i);
            if (i == this.nChosenBubble) continue;
            if (!this.freefall && this.bubble[i].startFalling && this.backgroundY > -10 && this.bubble[i].y < this.lSer.maxYH / 2) {
                this.lSer.lGra.drawLine(this.bubble[i].x - (this.bubble[i].w >> 2), this.bubble[i].y - this.bubble[i].h, this.bubble[i].x - (this.bubble[i].w >> 2), this.bubble[i].y);
                this.lSer.lGra.drawLine(this.bubble[i].x, this.bubble[i].y - this.bubble[i].h - (this.bubble[i].h >> 1), this.bubble[i].x, this.bubble[i].y);
                this.lSer.lGra.drawLine(this.bubble[i].x + (this.bubble[i].w >> 2), this.bubble[i].y - this.bubble[i].h, this.bubble[i].x + (this.bubble[i].w >> 2), this.bubble[i].y);
            }
            if (this.bubble[i].modeParachute > 0) {
                this.drawImageAnimations(20 + i, this.bubble[i].parachuteFrame, this.bubble[i].parachuteWidth, this.bubble[i].parachuteHeight, this.bubble[i].x - (this.bubble[i].parachuteWidth >> 1), this.bubble[i].y + (this.bubble[i].h >> 1) - this.bubble[i].parachuteHeight + offset);
                if (this.bubble[i].isGrounded) {
                    this.bubble[i].parachuteFrame = this.updateAnimationFrame(this.bubble[i].parachuteFrame, 8, 7, this.bubble[i].timer, 2);
                    if (this.bubble[i].parachuteFrame > 7) {
                        this.bubble[i].modeParachute = 0;
                    }
                } else {
                    this.bubble[i].parachuteFrame = this.updateAnimationFrame(this.bubble[i].parachuteFrame, 3, 4, this.bubble[i].timer, 2);
                    if (this.bubble[i].parachuteFrame == 4) {
                        Bubble cfr_ignored_0 = this.bubble[i];
                        if (this.bubble[i].modeParachute < 2) {
                            Bubble cfr_ignored_1 = this.bubble[i];
                            this.bubble[i].modeParachute = (short)2;
                            this.bubble[i].tFull = this.currentTime;
                        }
                    }
                }
            }
            this.drawImageAnimations(10 + i, this.bubble[i].frame, this.bubble[i].w, this.bubble[i].h, this.bubble[i].x - (this.bubble[i].h >> 1), this.bubble[i].y - (this.bubble[i].h >> 1));
            this.bubble[i].frame = this.updateAnimationFrame(this.bubble[i].frame, this.bubble[i].startFrame, this.bubble[i].endFrame, this.bubble[i].timer, 5);
        }
        if (!this.falseStart && this.bubble[this.nChosenBubble].modeParachute > 0) {
            this.drawImageAnimations(20 + this.nChosenBubble, this.bubble[this.nChosenBubble].parachuteFrame, this.bubble[this.nChosenBubble].parachuteWidth, this.bubble[this.nChosenBubble].parachuteHeight, this.bubble[this.nChosenBubble].x - (this.bubble[this.nChosenBubble].parachuteWidth >> 1), this.bubble[this.nChosenBubble].y + (this.bubble[this.nChosenBubble].h >> 1) - this.bubble[this.nChosenBubble].parachuteHeight + offset);
            if (this.bubble[this.nChosenBubble].isGrounded) {
                this.bubble[this.nChosenBubble].parachuteFrame = this.updateAnimationFrame(this.bubble[this.nChosenBubble].parachuteFrame, 8, 7, this.bubble[this.nChosenBubble].timer, 2);
                if (this.bubble[this.nChosenBubble].parachuteFrame > 7) {
                    this.bubble[this.nChosenBubble].modeParachute = 0;
                }
            } else {
                this.bubble[this.nChosenBubble].parachuteFrame = this.updateAnimationFrame(this.bubble[this.nChosenBubble].parachuteFrame, 3, 4, this.bubble[this.nChosenBubble].timer, 2);
                if (this.bubble[this.nChosenBubble].parachuteFrame == 4) {
                    Bubble cfr_ignored_2 = this.bubble[this.nChosenBubble];
                    if (this.bubble[this.nChosenBubble].modeParachute < 2) {
                        Bubble cfr_ignored_3 = this.bubble[this.nChosenBubble];
                        this.bubble[this.nChosenBubble].modeParachute = (short)2;
                        this.bubble[this.nChosenBubble].tFull = this.currentTime;
                    }
                }
            }
        }
        if (!this.bubble[this.nChosenBubble].isDead) {
            if (!this.freefall && this.bubble[this.nChosenBubble].startFalling && this.backgroundY > -10 && this.bubble[this.nChosenBubble].y < this.lSer.maxYH / 2) {
                this.lSer.lGra.drawLine(this.bubble[this.nChosenBubble].x - (this.bubble[this.nChosenBubble].w >> 2), this.bubble[this.nChosenBubble].y - this.bubble[this.nChosenBubble].h, this.bubble[this.nChosenBubble].x - (this.bubble[this.nChosenBubble].w >> 2), this.bubble[this.nChosenBubble].y);
                this.lSer.lGra.drawLine(this.bubble[this.nChosenBubble].x, this.bubble[this.nChosenBubble].y - this.bubble[this.nChosenBubble].h - (this.bubble[this.nChosenBubble].h >> 1), this.bubble[this.nChosenBubble].x, this.bubble[this.nChosenBubble].y);
                this.lSer.lGra.drawLine(this.bubble[this.nChosenBubble].x + (this.bubble[this.nChosenBubble].w >> 2), this.bubble[this.nChosenBubble].y - this.bubble[this.nChosenBubble].h, this.bubble[this.nChosenBubble].x + (this.bubble[this.nChosenBubble].w >> 2), this.bubble[this.nChosenBubble].y);
            }
            this.drawImageAnimations(10 + this.nChosenBubble, this.bubble[this.nChosenBubble].frame, this.bubble[this.nChosenBubble].w, this.bubble[this.nChosenBubble].h, this.bubble[this.nChosenBubble].x - (this.bubble[this.nChosenBubble].h >> 1), this.bubble[this.nChosenBubble].y - (this.bubble[this.nChosenBubble].h >> 1));
            this.bubble[this.nChosenBubble].frame = this.updateAnimationFrame(this.bubble[this.nChosenBubble].frame, this.bubble[this.nChosenBubble].startFrame, this.bubble[this.nChosenBubble].endFrame, this.bubble[this.nChosenBubble].timer, 5);
        } else {
            this.drawImageAnimations(10 + this.nChosenBubble, this.bubble[this.nChosenBubble].frame, this.bubble[this.nChosenBubble].w, this.bubble[this.nChosenBubble].h, this.bubble[this.nChosenBubble].x - (this.bubble[this.nChosenBubble].h >> 1), this.bubble[this.nChosenBubble].y - (this.bubble[this.nChosenBubble].h >> 1));
            this.bubble[this.nChosenBubble].frame = this.updateAnimationFrame(this.bubble[this.nChosenBubble].frame, this.bubble[this.nChosenBubble].startFrame, this.bubble[this.nChosenBubble].endFrame, this.bubble[this.nChosenBubble].timer, 5);
            if (this.explosionFrame <= 6) {
                this.drawImageAnimations(60, this.explosionFrame, this.lSer.bobH(60), this.lSer.bobH(60), this.bubble[this.nChosenBubble].x - (this.lSer.bobH(60) >> 1), this.bubble[this.nChosenBubble].y - (this.lSer.bobH(60) >> 1));
                this.explosionFrame = this.updateAnimationFrame(this.explosionFrame, 7, 6, this.bubble[this.nChosenBubble].timer, 2);
            }
        }
        if (this.falseStart) {
            int tempY = this.bubble[this.nChosenBubble].y;
            if (this.bubble[this.nChosenBubble].y == this.falseStartPosition && (this.gameLevel % 8 == 1 || this.gameLevel % 8 == 2)) {
                tempY = this.webOscillation(this.bubble[this.nChosenBubble].y);
            }
            this.drawFalseStart(this.gameLevel, tempY);
        }
    }

    private void initData() {
        System.out.println("...initData");
        if (this.screenSize == 1) {
            this.yStart = 40;
            this.hGround = 30;
        } else if (this.screenSize == 2) {
            this.yStart = 50;
            this.hGround = 40;
        } else if (this.screenSize == 3) {
            this.yStart = 60;
            this.hGround = 40;
        }
        this.yGround = this.lSer.maxY - this.hGround;
        this.backgroundHeight = 800;
        this.fallHeight = this.backgroundHeight - this.lSer.maxY;
        this.backgroundY = 0;
        this.falseStart = false;
        this.freefall = false;
        this.soundDropPlayed = false;
        this.soundGetReadyPlayed = false;
        this.exitTime = 0;
        this.gameLevel = 1;
        this.orderGrounded = 0;
        this.backgound_flag = 1;
        this.gameOver = false;
        this.nTries = 0;
        this.isLevelShown = true;
        this.listOrder = new int[4];
        this.lifeLostH = 30;
        this.isScoreChecked = false;
        this.currentScore = 0;
        this.iNewHighScore = -1;
        this.explosionFrame = 0;
        this.firstStartFalling = -1;
        this.repeatLevel = true;
        this.previousMoney = 0;
        this.timePause = 0L;
        this.timeOfLaunchOver = 0L;
        this.initTime = 0L;
        this.getGameParameters();
    }

    private void initBubbles() {
        System.out.println("...initBubbles");
        this.bubble = new Bubble[4];
        int width = 0;
        for (int i = 0; i < 4; ++i) {
            this.bubble[i] = new Bubble();
            this.bubble[i].w = this.bubble[i].h = this.lSer.bobH(10 + i);
            width += this.bubble[i].w;
            this.bubble[i].xVelocity = this.lSer.rand(3) - 1;
            this.bubble[i].yVelocity = 0;
            this.bubble[i].modeParachute = 0;
            this.bubble[i].parachuteFrame = 0;
            this.bubble[i].parachuteWidth = 45;
            this.bubble[i].parachuteHeight = this.lSer.bobH(20 + i);
            this.bubble[i].timer = 0;
            this.bubble[i].life = 32;
            this.bubble[i].isDead = false;
            this.bubble[i].isHealthChecked = false;
            this.bubble[i].startFalling = false;
            this.bubble[i].tEnd = 0L;
            this.bubble[i].tFull = 0L;
            this.bubble[i].tOpen = 0L;
            this.bubble[i].tStart = 0L;
        }
        int space = (this.lSer.maxX - width) / 5;
        for (int i = 0; i < 4; ++i) {
            this.bubble[i].x = i == 0 ? space + (this.bubble[i].w >> 1) : this.bubble[i - 1].x + space + this.bubble[i].w;
            this.bubble[i].x0 = this.bubble[i].x;
            this.bubble[i].y = this.yStart;
        }
    }

    private void resetBubbles() {
        int i;
        System.out.println("...resetBubbles");
        int width = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            width += this.bubble[i2].w;
        }
        int space = (this.lSer.maxX - width) / 5;
        for (i = 0; i < 4; ++i) {
            this.bubble[i].xVelocity = this.lSer.rand(3) - 1;
            this.bubble[i].yVelocity = 0;
            this.bubble[i].x = i == 0 ? space + (this.bubble[i].w >> 1) : this.bubble[i - 1].x + space + this.bubble[i].w;
            this.bubble[i].x0 = this.bubble[i].x;
            this.bubble[i].y = this.yStart;
        }
        for (i = 0; i < 4; ++i) {
            this.bubble[i].isGrounded = false;
            this.bubble[i].modeParachute = 0;
            this.bubble[i].parachuteFrame = 0;
            this.bubble[i].startFalling = false;
            this.bubble[i].isHealthChecked = false;
            this.bubble[i].tEnd = 0L;
            this.bubble[i].tFull = 0L;
            this.bubble[i].tOpen = 0L;
            this.bubble[i].tStart = 0L;
            this.bubble[i].timer = 0;
        }
    }

    private void resetData() {
        System.out.println("...resetData");
        this.backgroundY = 0;
        this.falseStart = false;
        this.freefall = false;
        this.soundDropPlayed = false;
        this.soundGetReadyPlayed = false;
        this.exitTime = 0;
        this.orderGrounded = 0;
        this.isScoreChecked = false;
        this.explosionFrame = 0;
        this.firstStartFalling = -1;
        this.timePause = 0L;
        this.timeOfLaunchOver = 0L;
        for (int i = 0; i < 4; ++i) {
            this.inc[i] = 0;
        }
    }

    private void checkBackgroundImage() {
        int temp = this.gameLevel % 8;
        if (temp > 0 && temp <= 2) {
            this.backgound_flag = 1;
        } else if (temp > 2 && temp <= 4) {
            this.backgound_flag = 2;
        } else if (temp > 4 && temp <= 6) {
            this.backgound_flag = 3;
        } else if (temp > 6 || temp == 0) {
            this.backgound_flag = 4;
        }
    }

    private void resetLife() {
        System.out.println("...resetLife");
        for (int i = 0; i < 4; ++i) {
            this.bubble[i].points = 0;
            if (i == this.nChosenBubble) continue;
            this.bubble[i].life = 32;
        }
    }

    private void loadImages(int flag) {
        if (flag == 0) {
            int i;
            for (i = 0; i < 4; ++i) {
                if (this.lSer.bob[10 + i] != null) continue;
                this.lSer.loadBob(10 + i, "/bubble" + this.randomBubbles[i] + ".png", 0);
                this.updateLoading(6 * i);
                return;
            }
            for (i = 0; i < 4; ++i) {
                if (this.lSer.bob[20 + i] != null) continue;
                this.lSer.loadBob(20 + i, "/parachute" + this.randomParachutes[i] + ".png", 0);
                this.updateLoading(24 + 2 * i);
                return;
            }
        } else if (flag == 1) {
            if (this.lSer.bob[30] == null && this.backgound_flag == 1) {
                this.lSer.loadBob(30, "/spring_b.png", 0);
                this.lSer.loadBob(31, "/spring_f.png", 0);
                this.updateLoading(6);
                return;
            }
            if (this.lSer.bob[38] == null) {
                this.lSer.loadBob(38, "/cloud1.png", 0);
                this.lSer.loadBob(39, "/cloud2.png", 0);
                this.lSer.loadBob(40, "/cloud3.png", 0);
                this.updateLoading(16);
                return;
            }
            if (this.lSer.bob[5] == null) {
                this.lSer.loadBob(5, "/go.png", 0);
            }
            if (this.lSer.bob[6] == null && this.backgound_flag == 1) {
                this.lSer.loadBob(6, "/web.png", 0);
            }
            if (this.lSer.bob[60] == null) {
                this.lSer.loadBob(60, "/explosion.png", 0);
                this.updateLoading(26);
                return;
            }
            if (this.lSer.bob[14] == null) {
                this.lSer.loadBob(14, "/heart.png", 0);
            }
            if (this.lSer.bob[15] == null) {
                this.lSer.loadBob(15, "/coin.png", 0);
                this.updateLoading(32);
                return;
            }
        }
        this.isLoadingDone = true;
    }

    private void unloadImages() {
        for (int i = 0; i < 4; ++i) {
            this.lSer.bob[10 + i] = null;
            this.lSer.bob[20 + i] = null;
        }
        this.lSer.bob[38] = null;
        this.lSer.bob[39] = null;
        this.lSer.bob[40] = null;
        this.lSer.bob[5] = null;
        this.lSer.bob[6] = null;
        this.lSer.bob[60] = null;
        this.lSer.bob[14] = null;
        this.lSer.bob[15] = null;
        if (this.lSer.bob[30] != null) {
            this.lSer.bob[30] = null;
            this.lSer.bob[31] = null;
        }
        if (this.lSer.bob[32] != null) {
            this.lSer.bob[32] = null;
            this.lSer.bob[33] = null;
        }
        if (this.lSer.bob[34] != null) {
            this.lSer.bob[34] = null;
            this.lSer.bob[35] = null;
        }
        if (this.lSer.bob[36] != null) {
            this.lSer.bob[36] = null;
            this.lSer.bob[37] = null;
        }
        System.gc();
    }

    private void updateImages() {
        if (this.lSer.bob[30] != null && this.backgound_flag != 1) {
            this.lSer.bob[30] = null;
            this.lSer.bob[31] = null;
        }
        if (this.lSer.bob[32] != null && this.backgound_flag != 2) {
            this.lSer.bob[32] = null;
            this.lSer.bob[33] = null;
        }
        if (this.lSer.bob[34] != null && this.backgound_flag != 3) {
            this.lSer.bob[34] = null;
            this.lSer.bob[35] = null;
        }
        if (this.lSer.bob[36] != null && this.backgound_flag != 4) {
            this.lSer.bob[36] = null;
            this.lSer.bob[37] = null;
        }
        if (this.lSer.bob[6] != null && this.backgound_flag != 1) {
            this.lSer.bob[6] = null;
        }
        if (this.lSer.bob[7] != null && this.backgound_flag != 2) {
            this.lSer.bob[7] = null;
        }
        if (this.lSer.bob[8] != null && this.backgound_flag != 3) {
            this.lSer.bob[8] = null;
        }
        if (this.lSer.bob[9] != null && this.backgound_flag != 4) {
            this.lSer.bob[9] = null;
        }
        System.gc();
        if (this.lSer.bob[30] == null && this.backgound_flag == 1) {
            this.lSer.loadBob(30, "/spring_b.png", 0);
            this.lSer.loadBob(31, "/spring_f.png", 0);
        }
        if (this.lSer.bob[32] == null && this.backgound_flag == 2) {
            this.lSer.loadBob(32, "/summer_b.png", 0);
            this.lSer.loadBob(33, "/summer_f.png", 0);
        }
        if (this.lSer.bob[34] == null && this.backgound_flag == 3) {
            this.lSer.loadBob(34, "/autumn_b.png", 0);
            this.lSer.loadBob(35, "/autumn_f.png", 0);
        }
        if (this.lSer.bob[36] == null && this.backgound_flag == 4) {
            this.lSer.loadBob(36, "/winter_b.png", 0);
            this.lSer.loadBob(37, "/winter_f.png", 0);
        }
        if (this.lSer.bob[6] == null && this.backgound_flag == 1) {
            this.lSer.loadBob(6, "/web.png", 0);
        }
        if (this.lSer.bob[7] == null && this.backgound_flag == 2) {
            this.lSer.loadBob(7, "/glass.png", 0);
        }
        if (this.lSer.bob[8] == null && this.backgound_flag == 3) {
            this.lSer.loadBob(8, "/jail.png", 0);
        }
        if (this.lSer.bob[9] == null && this.backgound_flag == 4) {
            this.lSer.loadBob(9, "/ice.png", 0);
        }
    }

    private void updateLoading(int percentage) {
        int nBits;
        int nLine;
        this.lSer.initSync();
        int length = this.lSer.maxX - 60;
        int x = this.lSer.maxX - length >> 1;
        int y = this.lSer.maxYH;
        if (this.screenSize <= 1) {
            nLine = 4;
            nBits = 2;
        } else {
            nLine = 8;
            nBits = 3;
        }
        this.drawMenuBackground();
        this.lSer.drawProgressiveBar(3, x, y, length, percentage, nLine, nBits);
        this.lSer.text(this.messageString[12], this.lSer.maxXH, y - (nLine << 2) - 4, 65);
    }

    void firstAidLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            if (this.lSer.bob[16] == null) {
                this.lSer.loadBob(16, "/medikit.png", 0);
            }
        }
        int offset = 8;
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
        this.drawBackGround();
        this.drawInformation();
        this.lSer.putBob(16, this.lSer.maxXH, this.lSer.maxYH + offset, 3);
        this.lSer.text(this.messageString[25], this.lSer.maxXH, this.lSer.maxYH >> 1, 3);
        this.lSer.text(this.messageString[26] + " " + 50 + " " + this.messageString[27], this.lSer.maxXH, (this.lSer.maxYH >> 1) + this.lSer.currTextHeight + 4, 3);
        if (this.lInp.keyStateGet(-6)) {
            this.lInp.keyStateSet(-6, false);
            this.resetLife();
            this.lSer.bob[16] = null;
            this.checkBackgroundImage();
            this.updateImages();
            this.changeState(10, true);
        } else if (this.lInp.keyStateGet(-7)) {
            this.lInp.keyStateSet(-7, false);
            if (this.bubble[this.nChosenBubble].money >= 50) {
                this.bubble[this.nChosenBubble].life += 5;
                if (this.bubble[this.nChosenBubble].life > 32) {
                    this.bubble[this.nChosenBubble].life = 32;
                }
                this.bubble[this.nChosenBubble].money -= 50;
            }
        }
        this.drawSoftKey(this.messageString[11], this.messageString[24]);
        this.lSer.sync(this.syncRate);
    }

    void highScoresLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.backgound_flag = 0;
            this.exitTime = 0;
            this.lSer.initSync();
            this.lSer.clearIMC();
        }
        this.drawMenuBackground();
        this.drawHighScores();
        this.exitTime = this.exitTime < 30 ? ++this.exitTime : 1;
        this.drawSoftKey(this.messageString[6], "");
        if (this.lInp.keyStateGet(-6) || this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(-6, false);
            this.changeState(6, false);
            this.currentMenuIndex = 0;
        }
        this.lSer.sync(this.syncRate);
    }

    void gameOverLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.backgound_flag = 0;
            this.lSer.initSync();
            this.lSer.clearIMC();
        }
        this.drawGameOver();
        this.drawSoftKey(this.messageString[6], "");
        if (this.lInp.keyStateGet(-6) || this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(-6, false);
            this.unloadImages();
            if (this.updateHighScores()) {
                this.changeState(15, true);
            } else {
                this.changeState(6, true);
                this.currentMenuIndex = 0;
            }
        }
        this.lSer.sync(this.syncRate);
    }

    void gameWinLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.backgound_flag = 0;
            this.lSer.initSync();
            this.lSer.clearIMC();
        }
        this.drawGameWin();
        this.drawSoftKey(this.messageString[6], "");
        if (this.lInp.keyStateGet(-6) || this.lInp.isActActivated(5, true)) {
            this.lInp.keyStateSet(-6, false);
            this.unloadImages();
            if (this.updateHighScores()) {
                this.changeState(15, true);
            } else {
                this.changeState(6, true);
                this.currentMenuIndex = 0;
            }
        }
        this.lSer.sync(this.syncRate);
    }

    void explicitPauseLoop() {
        if (this.lSer.lCan.iniState) {
            this.lSer.lCan.iniState = false;
            this.lSnd.stopSound(0);
        }
        this.drawMenuBackground();
        int offset = 15;
        this.lSer.setFont(this.regularFont);
        this.lSer.setColor(190, 30, 30);
        if (this.messageString[32] != null) {
            this.lSer.text(this.messageString[32], this.lSer.maxXH, this.lSer.maxYH - offset, 3);
            this.lSer.text(this.messageString[33], this.lSer.maxXH, this.lSer.maxYH + offset, 3);
        } else {
            this.lSer.text("Game paused", this.lSer.maxXH, this.lSer.maxYH - offset, 3);
            this.lSer.text("Press 5 to continue", this.lSer.maxXH, this.lSer.maxYH + offset, 3);
        }
        if (this.lInp.isActActivated(5, true)) {
            this.changeState(this.lSer.lCan.ex_prgState, false);
            this.loadAllSound();
            if (this.lSnd.soundOn && !this.lSnd.isSoundPlaying(0) && this.soundType == 0) {
                this.lSnd.playSound(0, this.lSnd.soundVol, 100);
            }
            if (this.lSer.lCan.ex_prgState == 10) {
                this.timePause += System.currentTimeMillis() - this.currentTime;
                this.currentTime = System.currentTimeMillis() - this.timePause;
            }
        }
        this.lSer.sync(this.syncRate);
    }

    private void initViewTextLoop() {
        this.locString = new String[150];
        this.lSer.setFont(this.smallFont);
        this.lSer.initStrings(this.viewFileName, -1, -1, this.locString, 0, this.lSer.maxX - 15);
        if (this.viewVersion) {
            this.locString[2] = this.locString[2] + " " + this.versionNum;
        }
        this.firstLine = -5;
        this.yScroll = 0;
        this.xScroll = this.lSer.maxX << 1;
        this.exitFlag = false;
        this.lSer.lGra.setColor(255, 255, 255);
        this.textHeight = this.lSer.currTextHeight;
        this.maxLine = (this.lSer.maxY - 40) / this.textHeight;
        if (this.maxLine < 3) {
            this.maxLine = 3;
        }
        this.lInp.resetAllKeys();
        this.lSer.initSync();
        this.lSer.clearIMC();
    }

    void viewTextLoop() {
        if (this.lSer.lCan.iniState) {
            this.initViewTextLoop();
            this.lSer.lCan.iniState = false;
        }
        this.lSer.setFont(this.smallFont);
        this.drawMenuBackground();
        this.lSer.saveClipArea();
        int iLin = 0;
        int yTitle = 30;
        this.lSer.lGra.setClip(0, yTitle, this.lSer.maxX, this.lSer.maxY - yTitle - (this.textHeight << 1));
        for (int nLin = this.firstLine; nLin < this.firstLine + this.maxLine - 1; ++nLin) {
            ++iLin;
            if (!(nLin >= 0 & nLin < this.lSer.lastNLineRead)) continue;
            this.lSer.text(this.locString[nLin], 8, yTitle + iLin * this.lSer.currTextHeight - this.yScroll, 68);
        }
        this.lSer.loadClipArea();
        this.drawSoftKey("", this.messageString[8]);
        ++this.yScroll;
        if (this.yScroll >= 2 * this.textHeight) {
            this.yScroll -= this.textHeight;
            ++this.firstLine;
            if (this.firstLine > this.lSer.lastNLineRead + 2) {
                this.exitFlag = true;
            }
        } else if (this.yScroll <= -2 * this.textHeight) {
            this.yScroll += this.textHeight;
            --this.firstLine;
        }
        if (this.lInp.isActActivated(3, false)) {
            this.yScroll -= 3;
        } else if (this.lInp.isActActivated(4, false)) {
            this.yScroll += 2;
        } else if (this.lInp.keyStateGet(-7) || this.lInp.isActActivated(5, true)) {
            this.exitFlag = true;
        }
        if (this.exitFlag) {
            this.lInp.resetAllKeys();
            this.locString = null;
            this.viewVersion = false;
            this.lSer.setFont(this.regularFont);
            this.changeState(6, false);
        }
        this.lSer.sync(this.syncRate);
    }

    void debug(String s) {
        System.out.println("here " + s);
    }

    private void drawBackGround() {
        if (this.backgound_flag == 0) {
            this.lSer.lGra.setColor(0xFFFFFF);
            this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
            this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
        } else {
            if (this.backgound_flag == 1) {
                this.lSer.lGra.setColor(27, 167, 255);
                this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
                this.lSer.putBob(30, 0, this.backgroundHeight + this.backgroundY, 36);
                this.drawCloud(1);
                this.lSer.putBob(31, 0, this.backgroundHeight + this.backgroundY, 36);
            }
            if (this.backgound_flag == 2) {
                this.lSer.lGra.setColor(255, 195, 7);
                this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
                this.lSer.putBob(32, 0, this.backgroundHeight + this.backgroundY, 36);
                this.drawCloud(2);
                this.lSer.putBob(33, 0, this.backgroundHeight + this.backgroundY, 36);
            }
            if (this.backgound_flag == 3) {
                this.lSer.lGra.setColor(56, 131, 236);
                this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
                this.lSer.putBob(34, 0, this.backgroundHeight + this.backgroundY, 36);
                this.drawCloud(3);
                this.lSer.putBob(35, 0, this.backgroundHeight + this.backgroundY, 36);
            }
            if (this.backgound_flag == 4) {
                this.lSer.lGra.setColor(134, 184, 233);
                this.lSer.lGra.fillRect(0, 0, this.lSer.maxX, this.lSer.maxY);
                this.lSer.putBob(36, 0, this.backgroundHeight + this.backgroundY, 36);
                this.drawCloud(4);
                this.lSer.putBob(37, 0, this.backgroundHeight + this.backgroundY, 36);
            }
        }
    }

    private void initCloudPosition() {
        int[] temp = new int[]{0, this.lSer.maxXH >> 1, this.lSer.maxXH, (this.lSer.maxXH >> 1) + this.lSer.maxXH};
        this.xCloud[0] = temp[this.lSer.rand(4)];
        if (this.xCloud[0] == temp[0]) {
            this.xCloud[1] = this.xCloud[0] + (this.lSer.maxXH >> 1);
            this.xCloud[2] = this.xCloud[0] + this.lSer.maxXH;
            this.xCloud[3] = this.xCloud[2];
            this.xCloud[0] = (this.lSer.maxXH >> 1) + this.lSer.maxXH;
        } else if (this.xCloud[0] == temp[1]) {
            this.xCloud[1] = this.xCloud[0] + (this.lSer.maxXH >> 1);
            this.xCloud[2] = this.xCloud[0] + this.lSer.maxXH;
            this.xCloud[3] = this.xCloud[1];
        } else if (this.xCloud[0] == temp[2]) {
            this.xCloud[1] = this.xCloud[0] + (this.lSer.maxXH >> 1);
            this.xCloud[2] = this.xCloud[0] - (this.lSer.maxXH >> 1);
            this.xCloud[3] = this.xCloud[0];
        } else {
            this.xCloud[1] = this.xCloud[0] - (this.lSer.maxXH >> 1);
            this.xCloud[2] = this.xCloud[0] - this.lSer.maxXH;
            this.xCloud[3] = this.xCloud[1];
        }
        this.yCloud[0] = this.backgound_flag == 2 ? this.backgroundHeight - this.lSer.bobH(32) : (this.backgound_flag == 3 ? this.backgroundHeight - this.lSer.bobH(34) : (this.backgound_flag == 4 ? this.backgroundHeight - this.lSer.bobH(36) : this.backgroundHeight - this.lSer.bobH(30)));
        int ytemp = (this.yCloud[0] - this.lSer.maxY - this.lSer.bobH(40) - 10) / 3;
        this.yCloud[1] = this.yCloud[0] - ytemp;
        this.yCloud[2] = this.yCloud[1] - ytemp;
        this.yCloud[3] = this.yCloud[2] - ytemp;
    }

    private void drawCloud(int backgound_flag) {
        this.lSer.putBob(40, this.xCloud[3], this.backgroundY + this.yCloud[3], 33);
        this.lSer.putBob(38, this.xCloud[2], this.backgroundY + this.yCloud[2], 33);
        this.lSer.putBob(39, this.xCloud[1], this.backgroundY + this.yCloud[1], 33);
        this.lSer.putBob(40, this.xCloud[0], this.backgroundY + this.yCloud[0], 33);
    }

    private void drawMenuItems(int currentMenu) {
        int y;
        int th = this.lSer.bobH(2);
        int offset1 = currentMenu == 3 ? th : th + 40;
        int offset2 = offset1 - 10;
        for (int i = 0; i < this.numMenuItems[currentMenu]; ++i) {
            y = offset1 + i * (this.lSer.currTextHeight + 5);
            this.lSer.text(this.messageString[this.menuIndexes[currentMenu][i]], this.lSer.maxXH, y, 33);
        }
        int textW = this.lSer.textWidth(this.messageString[this.menuIndexes[currentMenu][this.currentMenuItem]]);
        y = offset2 + this.currentMenuItem * (this.lSer.currTextHeight + 5);
        this.drawSelectors(textW, y, true, true);
    }

    private void drawMenuBackground() {
        this.lSer.putBob(3, this.lSer.maxXH, this.lSer.maxYH, 3);
    }

    private void drawMenuTitle() {
        if (this.currentMenuIndex == 0) {
            this.lSer.putBob(2, this.lSer.maxXH, 0, 17);
        }
    }

    private int webOscillation(int y) {
        int hi = 20;
        int wi = 10;
        int cycle = 18;
        ++this.exitTime;
        if (this.exitTime > cycle) {
            this.exitTime = 0;
        }
        return y += hi * this.lSer.sin(this.exitTime * wi) >> 9;
    }

    private void drawFalseStart(int level, int y) {
        int ima = 6 + (level - 1) % 8 / 2;
        int tempY = level % 8 == 0 || level % 8 == 7 ? y + 5 : y - 7;
        if (this.isReadyOver) {
            this.lSer.putBob(ima, this.bubble[this.nChosenBubble].x, tempY, 3);
        } else {
            this.lSer.putBob(ima, this.bubble[this.nChosenBubble].x, this.backgroundY + tempY, 3);
        }
    }

    private void drawSelectors(int textW, int y, boolean left, boolean right) {
        int textWH = (textW >> 1) + 12;
        int hi = 14;
        int wi = 40;
        int cycle = 18;
        ++this.exitTime;
        if (this.exitTime > cycle) {
            this.exitTime = 0;
        }
        y += hi * this.lSer.sin(this.exitTime * wi) >> 8;
        if (left) {
            this.lSer.putBob(4, this.lSer.maxXH - textWH, y, 3);
        }
        if (right) {
            this.lSer.putBob(4, this.lSer.maxXH + textWH, y, 3);
        }
    }

    private void drawHighScores() {
        int y = 10;
        this.lSer.lGra.setColor(190, 30, 30);
        this.lSer.text(this.messageString[3], this.lSer.maxXH, y, 3);
        int baseY = this.lSer.maxYH / 3;
        int baseX = this.lSer.maxXH / 2;
        int yStep = (this.lSer.maxY - 2 * baseY) / 10;
        int ttt = 0;
        for (int i = 0; i < 10; ++i) {
            String str = Integer.toString(i + 1);
            int lx = baseX - this.lSer.textWidth(str);
            ttt = baseY + i * yStep;
            if (i != this.iNewHighScore) {
                this.lSer.text(str, lx, ttt, 20);
            } else if (this.exitTime % 10 < 6) {
                this.lSer.text(str, lx, ttt, 20);
            }
            str = Integer.toString(this.highScores[i]);
            lx = this.lSer.maxX - baseX - this.lSer.textWidth(str);
            if (i != this.iNewHighScore) {
                this.lSer.text(str, lx, ttt, 20);
                continue;
            }
            if (this.exitTime % 10 >= 6) continue;
            this.lSer.text(str, lx, ttt, 20);
        }
    }

    private void initHighScores() {
        for (int i = 0; i < 10; ++i) {
            this.highScores[i] = 0;
        }
    }

    void loadAllSound() {
        this.lSnd.loadSound(0, "/menu.mid", 0);
        this.lSnd.loadSound(1, "/level.mid", 0);
        this.lSnd.loadSound(2, "/drop.mid", 0);
        this.lSnd.loadSound(3, "/land.wav", 0);
    }

    private void saveOptions() {
        RecordStore gameRecordStore = null;
        byte[] gameRecord = new byte[this.GAME_RECORD_DIM];
        try {
            gameRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)true);
        }
        catch (Exception e) {
            // empty catch block
        }
        int lastIndex = 0;
        lastIndex = this.addIntToRecord(this.soundType, gameRecord, lastIndex);
        lastIndex = this.addIntToRecord(this.lSnd.soundOn ? 1 : 0, gameRecord, lastIndex);
        lastIndex = this.addIntToRecord(this.lSnd.soundVol, gameRecord, lastIndex);
        int first = 0;
        try {
            this.gameRecordID = gameRecordStore.addRecord(gameRecord, first, this.GAME_RECORD_DIM);
            gameRecordStore.setRecord(this.gameRecordID, gameRecord, first, this.GAME_RECORD_DIM);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            gameRecordStore.closeRecordStore();
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    private void loadOptions() {
        RecordStore gameRecordStore = null;
        try {
            gameRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] gameRecord = null;
        try {
            this.gameRecordID = gameRecordStore.getNextRecordID() - 1;
            gameRecord = gameRecordStore.getRecord(this.gameRecordID);
            this.gameLoaderIndex = 0;
            this.soundType = this.extractIntFromRecord(gameRecord);
            this.lSnd.soundOn = this.extractIntFromRecord(gameRecord) == 1;
            this.lSnd.soundVol = this.extractIntFromRecord(gameRecord);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            gameRecordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    int extractIntFromRecord(byte[] record) {
        int i = record[this.gameLoaderIndex + 3] < 0 ? record[this.gameLoaderIndex + 3] + 256 : record[this.gameLoaderIndex + 3];
        i <<= 8;
        i = record[this.gameLoaderIndex + 2] < 0 ? (i += record[this.gameLoaderIndex + 2] + 256) : (i += record[this.gameLoaderIndex + 2]);
        i <<= 8;
        i = record[this.gameLoaderIndex + 1] < 0 ? (i += record[this.gameLoaderIndex + 1] + 256) : (i += record[this.gameLoaderIndex + 1]);
        i <<= 8;
        i = record[this.gameLoaderIndex] < 0 ? (i += record[this.gameLoaderIndex] + 256) : (i += record[this.gameLoaderIndex]);
        this.gameLoaderIndex += 4;
        return i;
    }

    int addIntToRecord(int arg, byte[] record, int first) {
        record[first] = (byte)arg;
        record[first + 1] = (byte)(arg >> 8);
        record[first + 2] = (byte)(arg >> 16);
        record[first + 3] = (byte)(arg >> 24);
        return first + 4;
    }

    boolean doesRecordStoreExist() {
        RecordStore gameRecordStore = null;
        int numRecords = 0;
        try {
            gameRecordStore = RecordStore.openRecordStore((String)this.recordStoreName, (boolean)false);
            numRecords = gameRecordStore.getNumRecords();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (numRecords > 0) {
            try {
                gameRecordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return numRecords > 0;
    }

    private void drawSoftKey(String lSoft, String rSoft) {
        this.lSer.setFont(this.smallFont);
        this.lSer.setColor(190, 30, 30);
        if (!lSoft.equals("")) {
            this.lSer.text(lSoft, 2, this.lSer.maxY - 2, 36);
        }
        if (!rSoft.equals("")) {
            this.lSer.text(rSoft, this.lSer.maxX - 2, this.lSer.maxY - 2, 40);
        }
        this.lSer.setFont(this.regularFont);
    }

    private void initFont() {
        this.lSer.loadFontList();
        this.smallFont = 2;
        this.regularFont = 3;
    }

    private void setScreenSize() {
        this.screenSize = this.lSer.maxX < 176 ? (short)0 : (this.lSer.maxX < 240 ? (short)1 : (this.lSer.maxX < 352 ? (short)2 : (short)3));
    }

    private void changeState(int prgState, boolean iniState) {
        this.lSer.lCan.prgState = prgState;
        this.lSer.lCan.iniState = iniState;
    }

    private void randomFourBubbles() {
        for (int i = 0; i < 4; ++i) {
            boolean flag;
            do {
                flag = false;
                int temp = this.lSer.rand(8) + 1;
                for (int j = 0; j < i; ++j) {
                    if (this.randomBubbles[j] != temp) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.randomBubbles[i] = temp;
            } while (flag);
        }
    }

    private void randomFourParachutes() {
        for (int i = 0; i < 4; ++i) {
            boolean flag;
            do {
                flag = false;
                int temp = this.lSer.rand(8) + 1;
                for (int j = 0; j < i; ++j) {
                    if (this.randomParachutes[j] != temp) continue;
                    flag = true;
                    break;
                }
                if (flag) continue;
                this.randomParachutes[i] = temp;
            } while (flag);
        }
    }

    private void drawImageAnimations(int image, int frame, int width, int height, int x, int y) {
        if (this.lSer.bob[image] == null) {
            return;
        }
        int d = frame * width;
        this.lSer.lGra.setClip(x, y, width, height);
        this.lSer.putBob(image, x - d, y, 20);
        this.lSer.lGra.setClip(0, 0, this.lSer.maxX, this.lSer.maxY);
    }

    private int updateAnimationFrame(int frame, int startFrame, int endFrame, int timer, int rate) {
        if (rate == 1) {
            ++frame;
        } else if (timer % rate == 0) {
            ++frame;
        }
        if (frame > endFrame) {
            frame = startFrame;
        }
        return frame;
    }

    private void initBubbleFrame(int i, int frame, int startFrame, int endFrame) {
        this.bubble[i].frame = frame;
        this.bubble[i].startFrame = startFrame;
        this.bubble[i].endFrame = endFrame;
    }

    private void setBubbleFrame() {
        for (int i = 0; i < 4; ++i) {
            this.setBubbleFrame(this.listOrder[i], i + 1);
        }
    }

    private void setBubbleFrame(int i, int j) {
        switch (j) {
            case 1: {
                this.currentExpression = this.getBubbleExpression(2, 6, 7, 8);
                this.getBubbleExpressionFrame(this.currentExpression);
                break;
            }
            case 2: {
                this.currentExpression = this.lSer.rand(this.bubbleExpressions.length);
                this.getBubbleExpressionFrame(this.currentExpression);
                break;
            }
            case 3: {
                this.currentExpression = this.getBubbleExpression(0, 3, 4, 5);
                this.getBubbleExpressionFrame(this.currentExpression);
                break;
            }
            case 4: {
                this.currentExpression = this.getBubbleExpression(0, 3, 4, 5);
                this.getBubbleExpressionFrame(this.currentExpression);
                break;
            }
        }
        this.initBubbleFrame(i, this.currentFrame, this.startFrame, this.endFrame);
    }

    private void getBubbleExpressionFrame(int i) {
        this.currentFrame = this.bubbleExpressions[i][0];
        this.startFrame = this.bubbleExpressions[i][0];
        this.endFrame = this.bubbleExpressions[i][1];
    }

    private int getBubbleExpression(int i, int j) {
        int num;
        while ((num = this.lSer.rand(this.bubbleExpressions.length)) != i && num != j) {
        }
        return num;
    }

    private int getBubbleExpression(int i, int j, int k) {
        int num;
        while ((num = this.lSer.rand(this.bubbleExpressions.length)) != i && num != j && num != k) {
        }
        return num;
    }

    private int getBubbleExpression(int i, int j, int k, int l) {
        int num;
        while ((num = this.lSer.rand(this.bubbleExpressions.length)) != i && num != j && num != k && num != l) {
        }
        return num;
    }

    private int getBubbleExpression(int i, int j, int k, int l, int m) {
        int num;
        while ((num = this.lSer.rand(this.bubbleExpressions.length)) != i && num != j && num != k && num != l && num != m) {
        }
        return num;
    }

    private int excludeBubbleExpression(int i) {
        int num;
        while ((num = this.lSer.rand(this.bubbleExpressions.length)) == i) {
        }
        return num;
    }
}

