/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.rms.RecordStore;

public class HighscoreHandler {
    private String recordName = "FlippyS60.N";
    public static String[] names = new String[]{"Petey", "Jaydee", "Thomas", "Lars", "Kasper", "Boll", "Muller", "Daniel", "Pop", "Daff"};
    public static String[] values = new String[]{"10000", "9000", "8000", "7000", "6000", "5000", "4000", "3000", "2000", "1000"};
    private int soundState = 0;

    public HighscoreHandler() {
        this.getData();
    }

    private boolean getData() {
        int n;
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)this.recordName, (boolean)false);
        }
        catch (Exception exception) {
            return false;
        }
        try {
            n = recordStore.getNumRecords();
        }
        catch (Exception exception) {
            return false;
        }
        byte[] byArray = new byte[14];
        if (n == values.length) {
            try {
                for (int k = 0; k < n; ++k) {
                    recordStore.getRecord(k + 1, byArray, 0);
                    HighscoreHandler.names[k] = "";
                    for (int i2 = 0; i2 < 8; ++i2) {
                        if (byArray[i2] < 31) continue;
                        int n2 = k;
                        names[n2] = names[n2] + (char)byArray[i2];
                    }
                    HighscoreHandler.values[k] = "" + Integer.parseInt("" + byArray[8] + byArray[9] + byArray[10] + byArray[11] + byArray[12]);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean storeData() {
        int n;
        int n2;
        RecordStore recordStore;
        try {
            RecordStore.deleteRecordStore((String)this.recordName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            recordStore = RecordStore.openRecordStore((String)this.recordName, (boolean)true);
        }
        catch (Exception exception) {
            return false;
        }
        byte[][] byArray = new byte[values.length][13];
        for (n2 = 0; n2 < values.length; ++n2) {
            n = Integer.parseInt(values[n2]);
            for (int k = 0; k < names[n2].length(); ++k) {
                byArray[n2][k] = (byte)names[n2].charAt(k);
            }
            byArray[n2][8] = (byte)(n / 10000);
            byArray[n2][9] = (byte)((n %= 10000) / 1000);
            byArray[n2][10] = (byte)((n %= 1000) / 100);
            byArray[n2][11] = (byte)((n %= 100) / 10);
            byArray[n2][12] = (byte)(n %= 10);
        }
        try {
            n2 = recordStore.getNumRecords();
        }
        catch (Exception exception) {
            return false;
        }
        if (n2 != 0) {
            try {
                for (n = 0; n < byArray.length; ++n) {
                    recordStore.setRecord(n + 1, byArray[n], 0, byArray[n].length);
                }
            }
            catch (Exception exception) {
                return false;
            }
        }
        try {
            for (n = 0; n < byArray.length; ++n) {
                recordStore.addRecord(byArray[n], 0, byArray[n].length);
            }
        }
        catch (Exception exception) {
            return false;
        }
        try {
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean gotHighscore(int n) {
        return n >= Integer.parseInt(values[values.length - 1]);
    }

    public void add(String string, int n) {
        HighscoreHandler.values[HighscoreHandler.values.length - 1] = "" + n;
        HighscoreHandler.names[HighscoreHandler.values.length - 1] = "" + string;
        for (int k = 0; k < values.length; ++k) {
            for (int i2 = k + 1; i2 < values.length; ++i2) {
                if (Integer.parseInt(values[k]) >= Integer.parseInt(values[i2])) continue;
                String string2 = values[k];
                HighscoreHandler.values[k] = values[i2];
                HighscoreHandler.values[i2] = string2;
                string2 = names[k];
                HighscoreHandler.names[k] = names[i2];
                HighscoreHandler.names[i2] = string2;
            }
        }
    }
}

