/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;

final class Screen
extends GameCanvas {
    static final int KEY_UP_BIT = 2;
    static final int KEY_LEFT_BIT = 4;
    static final int KEY_RIGHT_BIT = 32;
    static final int KEY_DOWN_BIT = 64;
    static final int KEY_MIDDLE_ACTION_BIT = 256;
    static final int KEY_LEFT_ACTION_BIT = 512;
    static final int KEY_RIGHT_ACTION_BIT = 1024;
    static final int KEY_UP_LEFT_BIT = 2048;
    static final int KEY_DOWN_LEFT_BIT = 4096;
    static final int KEY_UP_RIGHT_BIT = 8192;
    static final int KEY_DOWN_RIGHT_BIT = 16384;
    static final int KEY_SHIFT_MODE_BIT = 32768;
    final int[] screenRect = new int[]{0, 0, 0, 0};
    static final int[] NULL_RECT = new int[]{0, 0, 0, 0};
    public static int screenWidth;
    public static int screenHeight;
    int hMiddle = 0;
    int vMiddle = 0;
    int left = 0;
    int top = 0;
    int right = 0;
    int bottom = 0;
    int translateX = 0;
    int translateY = 0;
    int backgroundColor = 0xFFFFFF;
    private int progress = -1;
    private String progressText = null;
    public static boolean showPleaseWait;
    private static Screen screen;
    private Showable showable = null;
    private int keysPressed = 0;
    private int keysReleased = 0;
    private int keysClicked = 0;
    private int latchedKeysPressed = 0;
    private int latchedKeysClicked = 0;
    private int lastKeysPressed = 0;
    private boolean painting = false;
    boolean needsClearScreen = true;
    static final int TEXT_NORMAL = 0;
    static final int TEXT_SELECTED = 1;
    static final int TEXT_TITLE = 2;
    int textFormat = -1;
    private Font[] fonts = new Font[]{Font.getFont((int)32, (int)0, (int)8), Font.getFont((int)32, (int)1, (int)0), Font.getFont((int)32, (int)1, (int)16)};

    public Screen() {
        super(false);
        this.setFullScreenMode(true);
        screenWidth = this.getWidth();
        screenHeight = this.getHeight();
        this.progressText = Storage.getTheStorage().getString("Loading");
    }

    static Screen getScreen() {
        if (screen == null) {
            screen = new Screen();
            screenWidth = screen.getWidth();
            screenHeight = screen.getHeight();
            screen.reset();
        }
        return screen;
    }

    static void destroy() {
        if (screen != null) {
            if (Screen.screen.showable != null) {
                Screen.screen.showable.destroy();
                Screen.screen.showable = null;
            }
            screen = null;
        }
    }

    protected void hideNotify() {
        super.hideNotify();
    }

    protected void showNotify() {
        this.needsClearScreen = true;
        super.showNotify();
    }

    int[] getScreenRect() {
        return this.screenRect;
    }

    Showable getShowable() {
        return this.showable;
    }

    void setShowable1(Showable showable) {
        this.showable = showable;
    }

    void show(Showable showable) {
        Showable showable2 = this.showable;
        this.showable = showable;
        showable.setVisible(true);
        while (showable.isVisible()) {
            this.latchKeyState();
            showable.update();
            this.requestRepaint(true);
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            while (this.painting) {
                Thread.yield();
            }
        }
        showable.finished = true;
        this.showable = showable2;
    }

    void applyTextFormat(Graphics graphics, int n) {
        this.textFormat = n;
        graphics.setFont(this.fonts[n]);
    }

    int getStringWidth(String string, int n) {
        return this.fonts[n].stringWidth(string);
    }

    int getFontHeight(int n) {
        return this.fonts[n].getHeight();
    }

    void setProgress(int n, boolean bl) {
        if (this.progress != n) {
            this.progress = n;
            if (bl) {
                this.requestRepaint(false);
            }
        }
    }

    int getProgress() {
        return this.progress;
    }

    void initProgress(int n, String string, boolean bl) {
        this.progressText = string;
        this.setProgress(n, bl);
    }

    void reset() {
        this.left = 0;
        this.screenRect[0] = 0;
        this.top = 0;
        this.screenRect[1] = 0;
        this.screenRect[2] = this.right = screenWidth;
        this.screenRect[3] = this.bottom = screenHeight;
        this.hMiddle = this.right / 2;
        this.vMiddle = this.bottom / 2;
        this.translateX = 0;
        this.translateY = 0;
        this.needsClearScreen = true;
        this.keysPressed = 0;
        this.keysReleased = 0;
        this.latchedKeysPressed = 0;
        this.latchedKeysClicked = 0;
        this.lastKeysPressed = 0;
    }

    static int getGameActionBit(int n) {
        switch (n) {
            case -3: 
            case 52: {
                return 4;
            }
            case -4: 
            case 54: {
                return 32;
            }
            case -1: 
            case 50: {
                return 2;
            }
            case -2: 
            case 56: {
                return 64;
            }
            case 49: {
                return 2048;
            }
            case 51: {
                return 8192;
            }
            case 55: {
                return 4096;
            }
            case 57: {
                return 16384;
            }
            case -5: 
            case 53: {
                return 256;
            }
            case -6: {
                return 512;
            }
            case -7: {
                return 1024;
            }
        }
        System.out.println(n);
        return 0;
    }

    protected synchronized void keyReleased(int n) {
        int n2 = Screen.getGameActionBit(n);
        this.keysReleased |= n2;
    }

    protected synchronized void keyPressed(int n) {
        int n2 = Screen.getGameActionBit(n);
        this.keysPressed |= n2;
        if ((this.keysReleased & n2) != 0) {
            this.keysReleased &= ~n2;
        }
        this.keysClicked |= n2;
    }

    int getKeysPressed() {
        return this.latchedKeysPressed;
    }

    int getKeysClicked() {
        return this.latchedKeysClicked;
    }

    int getLastKeysPressed() {
        return this.lastKeysPressed;
    }

    private void latchKeyState() {
        this.lastKeysPressed = this.latchedKeysPressed;
        this.latchedKeysPressed = this.keysPressed;
        this.latchedKeysClicked = this.keysClicked;
        this.keysPressed &= ~this.keysReleased;
        this.keysReleased = 0;
        this.keysClicked = 0;
    }

    static int toPixelSpace(int n) {
        return n >> 8;
    }

    static int toObjectSpace(int n) {
        return n << 8;
    }

    int toScreenSpaceX(int n) {
        return Screen.toPixelSpace(n) - this.translateX;
    }

    int toScreenSpaceY(int n) {
        return Screen.toPixelSpace(n) - this.translateY;
    }

    int fromScreenSpaceX(int n) {
        return Screen.toObjectSpace(n + this.translateX);
    }

    int fromScreenSpaceY(int n) {
        return Screen.toObjectSpace(n + this.translateY);
    }

    private void requestRepaint(boolean bl) {
        this.painting = bl;
        this.repaint();
    }

    public void paint(Graphics graphics) {
        try {
            this.textFormat = -1;
            graphics.translate(-graphics.getTranslateX(), -graphics.getTranslateY());
            int n = this.getHeight() + 1;
            int n2 = this.getWidth() + 1;
            int n3 = (n - this.screenRect[3]) / 2;
            int n4 = (n2 - this.screenRect[2]) / 2;
            if (this.needsClearScreen && (n3 > 0 || n4 > 0)) {
                graphics.setColor(0);
                graphics.setClip(0, 0, n2, n);
                graphics.fillRect(0, 0, n2, n);
                this.needsClearScreen = false;
            }
            graphics.translate(n4, n3);
            graphics.setClip(this.screenRect[0], this.screenRect[1], this.screenRect[2], this.screenRect[3]);
            if (this.isPainting()) {
                if (this.showable != null) {
                    this.showable.paint(graphics);
                } else {
                    graphics.setColor(0x808080);
                }
            }
            if (this.progress > 0) {
                graphics.setColor(3416341);
                graphics.fillRect(0, 0, screenWidth, screenHeight);
                graphics.setClip(this.screenRect[0], this.screenRect[1], this.screenRect[2], this.screenRect[3]);
                graphics.setColor(0xFFFFFF);
                graphics.drawRect(this.left + screenWidth / 4, screenHeight >> 1, screenWidth / 2, 12);
                int n5 = screenWidth / 2 - 2;
                int n6 = n5 * this.progress / 100;
                graphics.setColor(13866573);
                graphics.fillRect(this.left + screenWidth / 4 + 2, (screenHeight >> 1) + 2, n6, 9);
                if (this.progressText != null) {
                    graphics.setColor(0xFFFFFF);
                    this.drawString(graphics, 0, this.progressText, this.hMiddle, (screenHeight >> 1) - this.getFontHeight(0) - 2, 17);
                }
            }
            if (showPleaseWait) {
                graphics.setColor(0x555555);
                this.drawString(graphics, 0, this.progressText, this.hMiddle, this.bottom - 22 - this.getFontHeight(0), 17);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.painting = false;
    }

    public boolean isPainting() {
        return this.painting;
    }

    void drawShadedString(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        this.applyTextFormat(graphics, n);
        if (n5 != -1) {
            int n6 = graphics.getColor();
            graphics.setColor(n5);
            graphics.drawString(string, n2 + 1, n3 + 1, n4);
            graphics.setColor(n6);
        }
        graphics.drawString(string, n2, n3, n4);
    }

    int drawShadedText(Graphics graphics, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6) {
        this.applyTextFormat(graphics, n);
        if (n6 != -1) {
            int n7 = graphics.getColor();
            graphics.setColor(n6);
            this.drawText(graphics, n, stringArray, n2 + 1, n3 + 1, n4, n5);
            graphics.setColor(n7);
        }
        return this.drawText(graphics, n, stringArray, n2, n3, n4, n5);
    }

    int drawShadedAndFadedString(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.applyTextFormat(graphics, n);
        if (n6 != -1) {
            int n11 = graphics.getColor();
            graphics.setColor(n6);
            this.drawFadedString(graphics, n, string, n2 + 1, n3 + 1, n4, n5, n7, n8, n9, n10);
            graphics.setColor(n11);
        }
        return this.drawFadedString(graphics, n, string, n2, n3, n4, n5, n7, n8, n9, n10);
    }

    int drawShadedAndFadedText(Graphics graphics, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        this.applyTextFormat(graphics, n);
        if (n6 != -1) {
            int n11 = graphics.getColor();
            graphics.setColor(n6);
            this.drawFadedText(graphics, n, stringArray, n2 + 1, n3 + 1, n4, n5, n7, n8, n9, n10);
            graphics.setColor(n11);
        }
        return this.drawFadedText(graphics, n, stringArray, n2, n3, n4, n5, n7, n8, n9, n10);
    }

    int drawText(Graphics graphics, int n, String[] stringArray, int n2, int n3, int n4, int n5) {
        this.applyTextFormat(graphics, n);
        for (int k = 0; k < stringArray.length; ++k) {
            if (n3 < this.bottom && n3 + n5 > this.top) {
                graphics.drawString(stringArray[k], n2, n3, n4);
            }
            n3 += n5;
        }
        return n3;
    }

    void drawString(Graphics graphics, int n, String string, int n2, int n3, int n4) {
        this.applyTextFormat(graphics, n);
        graphics.drawString(string, n2, n3, n4);
    }

    void drawChar(Graphics graphics, int n, char c2, int n2, int n3, int n4) {
        this.applyTextFormat(graphics, n);
        graphics.drawChar(c2, n2, n3, n4);
    }

    int drawFadedString(Graphics graphics, int n, String string, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.applyTextFormat(graphics, n);
        int n10 = graphics.getColor();
        graphics.setColor(Screen.edgeFadeColor(n3, n5, n6, n7, 30, n10, n9));
        graphics.drawString(string, n2, n3, n4);
        graphics.setColor(n10);
        return n3 + n5;
    }

    int drawFadedText(Graphics graphics, int n, String[] stringArray, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.applyTextFormat(graphics, n);
        int n10 = graphics.getColor();
        for (int k = 0; k < stringArray.length; ++k) {
            if (n3 < n7 && n3 + n5 > n6) {
                graphics.setColor(Screen.edgeFadeColor(n3, n5, n6, n7, 30, n10, n9));
                graphics.drawString(stringArray[k], n2, n3, n4);
                graphics.setColor(n10);
            }
            n3 += n5;
        }
        return n3;
    }

    private static int blendColors(int n, int n2, int n3) {
        int n4 = 255 - n3;
        return (n >>> 16 & 0xFF) * n3 / 255 + (n2 >>> 16 & 0xFF) * n4 / 255 << 16 | (n >>> 8 & 0xFF) * n3 / 255 + (n2 >>> 8 & 0xFF) * n4 / 255 << 8 | (n & 0xFF) * n3 / 255 + (n2 & 0xFF) * n4 / 255;
    }

    private static int edgeFadeColor(int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        if ((n = Math.min(n + n2 - n3, -(n - n4))) <= 0) {
            return n7;
        }
        if (n >= n5) {
            return n6;
        }
        return Screen.blendColors(n6, n7, n * 255 / n5);
    }

    private int findWrapIndex(String string, int n, int n2, int n3, Font font) {
        int n4;
        while (font.substringWidth(string, n, n2 - n) > n3 && (n4 = string.lastIndexOf(32, n2 - 1)) > n) {
            n2 = n4;
        }
        return n2;
    }

    private int countLines(String string, int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        do {
            int n5;
            int n6;
            if ((n3 = string.indexOf(10, n6 = n3 + 1)) == -1) {
                n3 = string.length();
            }
            while ((n5 = this.findWrapIndex(string, n6, n3, n2, this.fonts[n])) < n3) {
                n6 = n5 + 1;
                ++n4;
            }
            ++n4;
        } while (n3 < string.length());
        return n4;
    }

    String[] wrapText(String string, int n, int n2) {
        String[] stringArray = new String[this.countLines(string, n, n2)];
        int n3 = -1;
        int n4 = 0;
        do {
            int n5;
            int n6;
            if ((n3 = string.indexOf(10, n6 = n3 + 1)) == -1) {
                n3 = string.length();
            }
            while ((n5 = this.findWrapIndex(string, n6, n3, n2, this.fonts[n])) < n3) {
                stringArray[n4++] = string.substring(n6, n5);
                n6 = n5 + 1;
            }
            stringArray[n4++] = string.substring(n6, n3);
        } while (n3 < string.length());
        return stringArray;
    }

    public Font getFont(int n) {
        return this.fonts[n];
    }

    static {
        showPleaseWait = false;
        screen = null;
    }
}

