/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

class GameAudio {
    private static boolean musicCached;
    protected static boolean intro;
    protected static Player currentPlayer;
    private static int lastplayed;
    protected static Player[] jingles;
    public static final int SFX_TRAP = 0;
    public static final int SFX_METAL = 1;
    public static final int SFX_HIT2 = 2;
    public static final int SFX_EXPLOSION = 3;
    public static final int SFX_PLING = 4;
    public static final int SFX_ELECTRIC = 5;
    public static final int MID_TITLE = 6;

    public void update() {
    }

    public boolean loadSFX() {
        return true;
    }

    protected static boolean loadAMR() {
        System.out.println("LOAD AMR");
        try {
            InputStream inputStream = null;
            for (int k = 0; k < jingles.length; ++k) {
                System.out.println("amr no: " + k);
                if (k == 0) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/trap.amr");
                }
                if (k == 1) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/metal01.amr");
                }
                if (k == 2) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/smash01.amr");
                }
                if (k == 3) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/explosion.amr");
                }
                if (k == 4) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/pling2.amr");
                }
                if (k == 5) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/Electric.amr");
                }
                if (k == 6) {
                    inputStream = "".getClass().getResourceAsStream("/res/sfx/Title.mid");
                }
                if (k != 6) {
                    if (inputStream != null) {
                        GameAudio.jingles[k] = Manager.createPlayer((InputStream)inputStream, (String)"audio/AMR");
                    }
                } else if (inputStream != null) {
                    GameAudio.jingles[k] = Manager.createPlayer((InputStream)inputStream, (String)"audio/midi");
                }
                if (jingles[k] == null) continue;
                jingles[k].realize();
                jingles[k].prefetch();
                System.out.println("jingle: " + jingles[k]);
                inputStream.close();
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR!!!!");
            exception.printStackTrace();
        }
        return true;
    }

    public static boolean playAmr(int n) {
        if (RMS.getAsInteger("sound") == 0) {
            return false;
        }
        if (n < jingles.length) {
            try {
                if (currentPlayer != null && currentPlayer.getState() == 400) {
                    return false;
                }
                jingles[n].stop();
                ((VolumeControl)jingles[n].getControl("VolumeControl")).setLevel(70);
                jingles[n].start();
                currentPlayer = jingles[n];
                lastplayed = n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static boolean playAmr(int n, boolean bl) {
        if (RMS.getAsInteger("sound") == 0) {
            return false;
        }
        if (n < jingles.length) {
            try {
                if (currentPlayer != null && currentPlayer.getState() == 400) {
                    return false;
                }
                jingles[n].stop();
                jingles[n].setLoopCount(bl ? -1 : 1);
                jingles[n].start();
                currentPlayer = jingles[n];
                lastplayed = n;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return true;
    }

    public static boolean stopMidi() {
        try {
            for (int k = 0; k < jingles.length; ++k) {
                if (jingles[k] == null) continue;
                jingles[k].stop();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void destroyAll() {
        System.gc();
    }

    static {
        intro = true;
        lastplayed = -1;
        jingles = new Player[7];
    }
}

