/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public class LoadScreen {
    private boolean painting = false;
    private int fade = 255;
    private boolean doFade = false;
    private static int curFrame = 0;
    private static final int ASK_SOUND = 1;
    private static final int COME_TOWARDS_SPACECRAFT = 2;
    private static final int FLY_BY_SPLASH = 3;
    private static final int EARTH_ZOOM = 4;
    private static final int FLY_BY_EARTH = 6;
    private static final int FLY_BACK_TO_EARTH = 7;
    private static final int INTRO_FINSH = 5;
    private static final int LOADING_RES = 8;
    private static int introState = 1;
    boolean running = true;
    private int[][] starfield = new int[45][5];
    private Random rand = new Random();
    protected static int[] screenX;
    protected static int[] screenY;
    private boolean showCircles = false;
    private static int FRAME_START_CIRCLES;
    private boolean showLogo = false;
    private int FRAME_START_LOGO_SCROLL = 20;
    private int FRAME_END_LOGO_SCROLL = 60;
    private boolean slowDown = false;
    private int FRAME_START_SCROLL_SLOWDOWN = 60;
    private int vectorX = 512;
    protected static int FRAME_FLIPPY_HUH;
    private static int FRAME_FLIPPY_ANGER1;
    private static int FRAME_FLIPPY_ANGER2;
    private static int FRAME_FLIPPY_MAD;
    static int[] handYOffset;
    static int headYOffset;
    static int bodyYOffset;
    int[] firstYOffsetHeadSeq = new int[]{2, 2, 3, 3, 1, 1, 0, 0};
    int[] firstYOffsetBodySeq = new int[]{3, 3, 1, 1, 1, 1, 0, 0};
    int FRAME_FACE_VISIBLE = -1;
    int[] secondYOffsetHeadSeq = new int[]{-2, -2, -5, -5, 2, 2};
    Sprite2 ufo = null;
    Sprite2 splash = null;
    Sprite2 earth = null;
    private static int ufoR_Length;
    int ufoX = 0;
    int ufoY = 0;
    int splashX = 0;
    int splashY = 0;
    int ufoFrame = 0;
    int splashFrame = 0;
    int ufoAngle = 18000;
    int rot_ufoX;
    int rot_ufoY;
    boolean ufoInFront = true;
    boolean ufoForward = true;
    int ufoYMin = 0;
    int ufoYMax = 0;
    int ufoXMin = 0;
    int ufoXMax = 0;
    int lastRotX;
    int lastRotY;
    public static final short[] sinus;

    public static int getSinus(int n) {
        return sinus[Math.abs(n / (360 / sinus.length) % 128)];
    }

    public static int getCoSinus(int n) {
        return sinus[(n / (360 / sinus.length) + 32) % 128];
    }

    protected static void setHUHframe() {
        FRAME_FLIPPY_HUH = curFrame + 10;
        FRAME_FLIPPY_ANGER1 = curFrame + 36 + 10;
        FRAME_FLIPPY_ANGER2 = curFrame + 38 + 10;
        FRAME_FLIPPY_MAD = curFrame + 40 + 10;
        FRAME_START_CIRCLES = curFrame + 40 + 10;
    }

    public void newUfoPos() {
        this.rot_ufoX = (ufoR_Length * LoadScreen.getCoSinus(this.ufoAngle) >> 8) - (ufoR_Length * LoadScreen.getSinus(this.ufoAngle) >> 8);
        this.rot_ufoY = (ufoR_Length * LoadScreen.getSinus(this.ufoAngle) >> 8) + (ufoR_Length * LoadScreen.getCoSinus(this.ufoAngle) >> 8);
    }

    public LoadScreen() {
        try {
            this.ufoYMin = FlippysFlyingFrenzy.SCREEN_HEIGHT / 5;
            this.ufoYMax = FlippysFlyingFrenzy.SCREEN_HEIGHT * 2 / 3;
            this.ufoXMin = FlippysFlyingFrenzy.SCREEN_WIDTH / 8;
            this.ufoXMax = FlippysFlyingFrenzy.SCREEN_WIDTH * 2 / 3;
            this.makeStarField();
            try {
                Storage.getTheStorage().loadPackage("/res/splash.pak", false);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.ufo = new Sprite2(Storage.getTheStorage().getSpriteData("ufo.s"));
            this.ufoFrame = this.ufo.getRawFrameCount() - 1;
            this.splash = new Sprite2(Storage.getTheStorage().getSpriteData("logos.s"));
            this.earth = new Sprite2(Storage.getTheStorage().getSpriteData("planet.s"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void makeStarField() {
        for (int k = 0; k < this.starfield.length; ++k) {
            this.starfield[k][0] = Math.abs(this.rand.nextInt()) % FlippysFlyingFrenzy.SCREEN_WIDTH << 8;
            this.starfield[k][1] = Math.abs(this.rand.nextInt()) % FlippysFlyingFrenzy.SCREEN_HEIGHT << 8;
            this.starfield[k][2] = Math.abs(this.rand.nextInt()) % 2;
            this.starfield[k][3] = (Math.abs(this.rand.nextInt()) % 20 << 2) + 20;
            this.starfield[k][4] = Math.abs(this.rand.nextInt()) % 3 + 1;
        }
        System.out.println("made starfield");
    }

    private void updateStarField(int n) {
        int n2;
        if (curFrame % 6 == 1) {
            for (n2 = 0; n2 < this.starfield.length; ++n2) {
                this.starfield[n2][2] = Math.abs(this.rand.nextInt()) % 2;
            }
        }
        if (n == 1) {
            for (n2 = 0; n2 < this.starfield.length; ++n2) {
                int[] nArray = this.starfield[n2];
                nArray[0] = nArray[0] - this.starfield[n2][3];
                if (this.starfield[n2][0] >= -300) continue;
                this.reposStar(n2);
            }
        }
    }

    private void reposStar(int n) {
        this.starfield[n][0] = FlippysFlyingFrenzy.SCREEN_WIDTH + Math.abs(this.rand.nextInt()) % FlippysFlyingFrenzy.SCREEN_WIDTH << 8;
        this.starfield[n][1] = Math.abs(this.rand.nextInt()) % FlippysFlyingFrenzy.SCREEN_HEIGHT << 8;
        this.starfield[n][2] = Math.abs(this.rand.nextInt()) % 2;
        this.starfield[n][3] = Math.abs(this.rand.nextInt()) % 20 << 2;
        this.starfield[n][4] = Math.abs(this.rand.nextInt()) % 3 + 1;
    }

    private void paintStarField(Graphics graphics) {
        graphics.setColor(398892);
        graphics.fillRect(0, 0, FlippysFlyingFrenzy.SCREEN_WIDTH, FlippysFlyingFrenzy.SCREEN_HEIGHT);
        for (int k = 0; k < this.starfield.length; ++k) {
            graphics.setColor(0xFFFFFF);
            if (this.starfield[k][4] == 3 && this.starfield[k][2] == 1) {
                graphics.setColor(4360679);
                graphics.drawLine((this.starfield[k][0] >> 8) + 1, (this.starfield[k][1] >> 8) - 1, (this.starfield[k][0] >> 8) + 1, (this.starfield[k][1] >> 8) + 3);
                graphics.drawLine((this.starfield[k][0] >> 8) - 1, (this.starfield[k][1] >> 8) + 1, (this.starfield[k][0] >> 8) + 3, (this.starfield[k][1] >> 8) + 1);
            }
            if (this.starfield[k][2] == 1) {
                graphics.setColor(14149370);
            }
            graphics.fillArc(this.starfield[k][0] >> 8, this.starfield[k][1] >> 8, this.starfield[k][4], this.starfield[k][4], 0, 360);
        }
    }

    public void run() {
        while (this.running) {
            if (introState == 1) {
                if (this.doFade) {
                    if (this.fade < 6) {
                        introState = 8;
                    }
                    this.fade -= 10;
                }
            } else if (introState == 8) {
                try {
                    Storage.getTheStorage().loadPackage("/res/res.pak", false);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                introState = 2;
            } else if (introState == 2) {
                this.updateStarField(0);
                if (curFrame % 25 == 1) {
                    if (this.ufoFrame - 1 > 0) {
                        --this.ufoFrame;
                    } else {
                        introState = 3;
                        this.splashX = FlippysFlyingFrenzy.SCREEN_WIDTH + (FlippysFlyingFrenzy.SCREEN_WIDTH >> 1);
                        this.splashY = FlippysFlyingFrenzy.SCREEN_HEIGHT - this.splash.getHeight() >> 1;
                    }
                }
                if (curFrame % 7 == 1) {
                    ++ufoR_Length;
                }
                this.ufoAngle -= 4;
                this.newUfoPos();
                this.lastRotX = this.ufoX;
                this.lastRotY = this.ufoY;
            } else if (introState == 3) {
                this.updateStarField(1);
                this.splashX -= 3;
                if (this.splashX < -FlippysFlyingFrenzy.SCREEN_WIDTH) {
                    this.splashX = FlippysFlyingFrenzy.SCREEN_WIDTH + (FlippysFlyingFrenzy.SCREEN_WIDTH >> 1);
                    if (++this.splashFrame > this.splash.getRawFrameCount() - 1) {
                        introState = 6;
                    }
                }
                if (this.ufoInFront && this.ufoY < this.ufoYMax) {
                    int n = this.ufoYMax - this.ufoY >> 4;
                    if (n < 2) {
                        n = 2;
                    }
                    this.ufoY += n;
                    if (this.ufoY >= this.ufoYMax) {
                        this.ufoInFront = false;
                    }
                } else if (!this.ufoInFront && this.ufoY > this.ufoYMin) {
                    int n = 2;
                    this.ufoY -= n;
                    if (this.ufoY <= this.ufoYMin) {
                        this.ufoInFront = true;
                    }
                }
                if (this.ufoForward && this.ufoX < this.ufoXMax) {
                    int n = this.ufoXMax - this.ufoX >> 5;
                    if (n < 2) {
                        n = 2;
                    }
                    this.ufoX += n;
                    if (this.ufoX >= this.ufoXMax) {
                        this.ufoForward = false;
                    }
                } else if (!this.ufoForward && this.ufoX > this.ufoXMin) {
                    int n = this.ufoX - this.ufoXMin >> 5;
                    if (n < 2) {
                        n = 2;
                    }
                    this.ufoX -= n;
                    if (this.ufoX <= this.ufoXMin) {
                        this.ufoForward = true;
                    }
                }
            } else if (introState == 6) {
                this.updateStarField(1);
                this.splashX -= 4;
                this.ufoX += 2;
                if (this.splashX < -FlippysFlyingFrenzy.SCREEN_WIDTH) {
                    introState = 7;
                }
            } else if (introState == 7) {
                this.updateStarField(-1);
                this.splashX += 2;
                if (this.lastRotX <= this.ufoX) {
                    this.ufoX -= 2;
                }
                if (this.lastRotY > this.ufoY) {
                    ++this.ufoY;
                }
                if (this.lastRotY < this.ufoY) {
                    // empty if block
                }
                this.lastRotY = --this.ufoY;
                if (this.ufoX < this.lastRotX) {
                    introState = 4;
                }
            } else if (introState == 4) {
                if (this.splashY > FlippysFlyingFrenzy.SCREEN_HEIGHT - this.earth.getHeight() >> 1) {
                    --this.splashY;
                }
                if (this.ufoX + (this.ufo.getWidth() >> 1) < FlippysFlyingFrenzy.SCREEN_WIDTH >> 1) {
                    ++this.ufoX;
                }
                if (curFrame % 20 == 1) {
                    if (this.ufoFrame + 1 < this.ufo.getRawFrameCount() - 1) {
                        ++this.ufoFrame;
                    } else {
                        this.running = false;
                    }
                }
                if (curFrame % 7 == 1) {
                    --ufoR_Length;
                }
                this.ufoAngle -= 4;
                this.newUfoPos();
            }
            FlippysFlyingFrenzy.mainCanvas.customRepaint();
            try {
                while (this.painting) {
                }
                Thread.sleep(25L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++curFrame;
        }
        FlippysFlyingFrenzy.destroyLoadScreen();
    }

    public void paint(Graphics graphics) {
        this.painting = true;
        try {
            if (introState == 1) {
                graphics.setColor(this.fade, this.fade, this.fade);
                graphics.fillRect(0, 0, FlippysFlyingFrenzy.SCREEN_WIDTH, FlippysFlyingFrenzy.SCREEN_HEIGHT);
                graphics.setFont(FlippysFlyingFrenzy.FONT_SMALL_BOLD);
                if (this.fade < 220) {
                    graphics.setColor(this.fade, this.fade, this.fade);
                } else {
                    graphics.setColor(220, 220, 220);
                }
                graphics.drawString(Language.get("Sound") + "?", 1 + FlippysFlyingFrenzy.SCREEN_WIDTH / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.stringWidth(Language.get("Sound") + "?") / 2, 1 + FlippysFlyingFrenzy.SCREEN_HEIGHT / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.getHeight() / 2, 0);
                if (this.fade < 220) {
                    graphics.setColor(this.fade, this.fade, this.fade);
                } else {
                    graphics.setColor(398892);
                }
                graphics.drawString(Language.get("Sound") + "?", FlippysFlyingFrenzy.SCREEN_WIDTH / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.stringWidth(Language.get("Sound") + "?") / 2, FlippysFlyingFrenzy.SCREEN_HEIGHT / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.getHeight() / 2, 0);
                Game.paintButton(graphics, Language.get("On"), Game.BUTTON_POS_LEFT);
                Game.paintButton(graphics, Language.get("Off"), Game.BUTTON_POS_RIGHT);
            }
            if (introState == 8) {
                graphics.setColor(0xFFFFFF);
                graphics.drawString(Language.get("Loading"), FlippysFlyingFrenzy.SCREEN_WIDTH / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.stringWidth(Language.get("Loading")) / 2, FlippysFlyingFrenzy.SCREEN_HEIGHT / 2 - FlippysFlyingFrenzy.FONT_SMALL_BOLD.getHeight() / 2, 0);
            }
            if (introState == 2) {
                this.paintStarField(graphics);
                this.ufo.setFrame(this.ufoFrame);
                this.ufoX = (FlippysFlyingFrenzy.SCREEN_WIDTH >> 2) + this.rot_ufoX;
                this.ufoY = (FlippysFlyingFrenzy.SCREEN_HEIGHT >> 1) + this.rot_ufoY;
                this.ufo.paint(graphics, this.ufoX, this.ufoY);
            }
            if (introState == 3) {
                this.paintStarField(graphics);
                if (!this.ufoInFront) {
                    this.ufo.setFrame(this.ufoFrame + 1);
                    this.ufo.paint(graphics, this.ufoX, this.ufoY);
                    this.splash.setFrame(this.splashFrame);
                    this.splash.paint(graphics, this.splashX, this.splashY);
                } else {
                    this.splash.setFrame(this.splashFrame);
                    this.splash.paint(graphics, this.splashX, this.splashY);
                    this.ufo.setFrame(this.ufoFrame);
                    this.ufo.paint(graphics, this.ufoX, this.ufoY);
                }
            }
            if (introState == 6) {
                this.paintStarField(graphics);
                this.earth.paint(graphics, this.splashX, this.splashY);
                this.ufo.setFrame(this.ufoFrame);
                this.ufo.paint(graphics, this.ufoX, this.ufoY);
            }
            if (introState == 7) {
                this.paintStarField(graphics);
                this.earth.paint(graphics, this.splashX, this.splashY);
                this.ufo.setFrame(this.ufoFrame);
                this.ufo.paint(graphics, this.ufoX, this.ufoY);
            }
            if (introState == 4) {
                this.paintStarField(graphics);
                this.earth.paint(graphics, this.splashX, this.splashY);
                this.ufo.setFrame(this.ufoFrame);
                this.ufoX = (FlippysFlyingFrenzy.SCREEN_WIDTH >> 2) + this.rot_ufoX;
                this.ufoY = (FlippysFlyingFrenzy.SCREEN_HEIGHT >> 1) + this.rot_ufoY;
                this.ufo.paint(graphics, this.ufoX, this.ufoY);
            }
        }
        catch (Exception exception) {
            this.painting = false;
            exception.printStackTrace();
        }
        this.painting = false;
    }

    public void keyPressed(int n) {
        if (introState == 1) {
            if (FlippysFlyingFrenzy.checkKey(n, FlippysFlyingFrenzy.KEY_LEFT_SOFTKEY)) {
                RMS.put("sound", 1);
                RMS.saveSingle("sound");
                this.doFade = true;
                System.out.println("yes");
            }
            if (FlippysFlyingFrenzy.checkKey(n, FlippysFlyingFrenzy.KEY_RIGHT_SOFTKEY)) {
                RMS.put("sound", 0);
                RMS.saveSingle("sound");
                this.doFade = true;
                System.out.println("no");
            }
        } else {
            if (FlippysFlyingFrenzy.checkKey(n, FlippysFlyingFrenzy.KEY_LEFT_SOFTKEY)) {
                this.running = false;
            }
            if (FlippysFlyingFrenzy.checkKey(n, FlippysFlyingFrenzy.KEY_RIGHT_SOFTKEY)) {
                this.running = false;
            }
        }
        MainCanvas.resetClicked();
    }

    protected void destroy() {
    }

    static {
        FRAME_START_CIRCLES = Integer.MAX_VALUE;
        FRAME_FLIPPY_HUH = Integer.MAX_VALUE;
        FRAME_FLIPPY_ANGER1 = Integer.MAX_VALUE;
        FRAME_FLIPPY_ANGER2 = Integer.MAX_VALUE;
        FRAME_FLIPPY_MAD = Integer.MAX_VALUE;
        handYOffset = new int[]{-3, -1, 0, 1, 3, 1, 0, -1};
        headYOffset = 0;
        bodyYOffset = 0;
        ufoR_Length = 1;
        sinus = new short[]{0, 12, 25, 37, 50, 62, 74, 86, 98, 109, 121, 132, 142, 153, 163, 172, 181, 190, 198, 206, 213, 220, 226, 232, 237, 241, 245, 249, 252, 254, 255, 256, 256, 256, 255, 254, 252, 249, 245, 241, 237, 232, 226, 220, 213, 206, 198, 190, 181, 172, 163, 153, 142, 132, 121, 109, 98, 86, 74, 62, 50, 37, 25, 12, 0, -12, -25, -37, -50, -62, -74, -86, -98, -109, -121, -132, -142, -153, -163, -172, -181, -190, -198, -206, -213, -220, -226, -232, -237, -241, -245, -249, -252, -254, -255, -256, -256, -256, -255, -254, -252, -249, -245, -241, -237, -232, -226, -220, -213, -206, -198, -190, -181, -172, -163, -153, -142, -132, -121, -109, -98, -86, -74, -62, -50, -37, -25, -12};
    }
}

