/*
 * Decompiled with CFR 0.152.
 */
import breakpoint.vibration.VibrationBP;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;

public class KaczkiGame {
    private final int FREQUENCY;
    private final int START_INTERVAL;
    private final int INTERVAL_STEP_PERCENT;
    private final int NEEDED;
    private int shootedDown;
    private byte survived;
    private int interval;
    private int frequency;
    private int level;
    private boolean gameInProgress;
    private Timer timer = new Timer();
    private DuckMoover task;
    private KaczkiScreen screen;
    private Jajka midlet;

    KaczkiGame(Jajka jajka, KaczkiScreen kaczkiScreen) {
        this.FREQUENCY = 3;
        this.START_INTERVAL = 550;
        this.INTERVAL_STEP_PERCENT = 5;
        this.NEEDED = 20;
        this.midlet = jajka;
        this.screen = kaczkiScreen;
        this.interval = 550;
        this.frequency = 3;
        this.level = 0;
    }

    public DuckMoover getTask() {
        return this.task;
    }

    public int getLevel() {
        return this.level;
    }

    public void newRound() {
        this.screen.newRound();
        this.survived = 0;
        ++this.level;
        this.interval *= 95;
        this.interval /= 100;
        this.task = new DuckMoover(this.frequency, this.screen, this);
        this.timer.schedule((TimerTask)this.task, 2000L, (long)this.interval);
    }

    public void continueGame() {
        this.screen.repaint();
        this.task = new DuckMoover(this.frequency, this.screen, this);
        this.timer.schedule((TimerTask)this.task, this.interval, (long)this.interval);
    }

    public void newGame() {
        this.level = 0;
        this.shootedDown = 0;
        this.interval = 550;
        this.gameInProgress = true;
        this.newRound();
    }

    public void stopTimer() {
        this.task.cancel();
    }

    public void notifyKill() {
        ++this.shootedDown;
        KaczkiGame kaczkiGame = this;
        if (kaczkiGame.midlet.getSound()) {
            Sounds.playShot();
        }
        if (this.shootedDown % 20 == 0) {
            this.stopTimer();
            System.out.println("KOniecRundy");
            this.newRound();
        }
    }

    public void notifySurvived(int n) {
        KaczkiGame kaczkiGame = this;
        if (kaczkiGame.midlet.getVibra()) {
            VibrationBP.startVibra(50, 50L);
        }
        this.survived = (byte)(this.survived + n);
        if (this.survived > 2) {
            this.gameOver();
        }
    }

    public int getKilledNum() {
        return this.shootedDown;
    }

    public int getSurvivedNum() {
        return this.survived;
    }

    public Jajka myMIDlet() {
        return this.midlet;
    }

    public boolean isGameInProgress() {
        return this.gameInProgress;
    }

    private void gameOver() {
        this.stopTimer();
        this.midlet.showGameOver(this.shootedDown);
        this.gameInProgress = false;
    }

    public void load(DataInputStream dataInputStream) {
        try {
            this.interval = dataInputStream.readInt();
            this.shootedDown = dataInputStream.readInt();
            this.level = dataInputStream.readInt();
            this.survived = dataInputStream.readByte();
            for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
                this.screen.setDuckPos(n, dataInputStream.readByte());
                this.screen.setDuckAlive(n, dataInputStream.readBoolean());
            }
            this.screen.setShooterDirection(dataInputStream.readByte());
        }
        catch (IOException iOException) {
            System.out.println("nie udalo sie wczytac stanu gry");
        }
        this.gameInProgress = true;
    }

    public void save(DataOutputStream dataOutputStream) {
        try {
            dataOutputStream.writeInt(this.interval);
            dataOutputStream.writeInt(this.shootedDown);
            dataOutputStream.writeInt(this.level);
            dataOutputStream.writeByte(this.survived);
            for (int n = 0; n < 4; n = (int)((byte)(n + 1))) {
                dataOutputStream.writeByte(this.screen.getDuckPos(n));
                dataOutputStream.writeBoolean(this.screen.getDuckAlive(n));
            }
            dataOutputStream.writeByte(this.screen.getShooterDirection());
        }
        catch (IOException iOException) {
            System.out.println("nie udalo sie zapisac stanu gry");
        }
    }
}

