/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ClickField {
    public int sizeX;
    public int sizeY;
    public int nrCols = 4;
    public int[][] playField;
    public boolean[][] checkField;
    private int drawPosX;
    private int drawPosY;
    private int blockSizeX;
    private int blockSizeY;
    private int[] blockCols = new int[6];

    public ClickField(int n, int n2, int n3, int n4) {
        this.sizeX = n;
        this.sizeY = n2;
        this.playField = new int[this.sizeX][this.sizeY];
        this.checkField = new boolean[this.sizeX][this.sizeY];
        this.drawPosX = 1;
        this.drawPosY = 12;
        this.blockSizeX = n3;
        this.blockSizeY = n4;
        this.blockCols[0] = 0;
        this.blockCols[1] = 0x8080E8;
        this.blockCols[2] = 8447104;
        this.blockCols[3] = 0xE88080;
        this.blockCols[4] = 0xE0E080;
        this.blockCols[5] = 65535;
    }

    public void initCheckField() {
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                this.checkField[j][i] = false;
            }
        }
    }

    public void randomizeField() {
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                this.playField[j][i] = 1 + SdwUtil.Rand() % this.nrCols;
            }
        }
    }

    public int countBlocks() {
        int n = 0;
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                if (this.playField[j][i] == 0) continue;
                ++n;
            }
        }
        return n;
    }

    public void fallLine(int n, int n2) {
        for (int i = n2; i > 0; --i) {
            this.playField[n][i] = this.playField[n][i - 1];
        }
        this.playField[n][0] = 0;
    }

    public void moveLine(int n) {
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = n; j < this.sizeX - 1; ++j) {
                this.playField[j][i] = this.playField[j + 1][i];
            }
            this.playField[this.sizeX - 1][i] = 0;
        }
    }

    public boolean clearLine(int n, int n2) {
        int n3 = 0;
        for (int i = n2; i >= 0; --i) {
            n3 += this.playField[n][i];
        }
        return n3 == 0;
    }

    public boolean clearRow(int n) {
        int n2 = 0;
        if (n >= this.sizeX - 1) {
            return true;
        }
        for (int i = n + 1; i < this.sizeX; ++i) {
            n2 += this.playField[i][this.sizeY - 1];
        }
        return n2 == 0;
    }

    public void fallField() {
        int n;
        for (n = 0; n < this.sizeX; ++n) {
            for (int i = this.sizeY - 1; i > 0; --i) {
                while (this.playField[n][i] == 0 && !this.clearLine(n, i - 1)) {
                    this.fallLine(n, i);
                }
            }
        }
        for (n = 0; n < this.sizeX - 1; ++n) {
            while (this.playField[n][this.sizeY - 1] == 0 && !this.clearRow(n)) {
                this.moveLine(n);
            }
        }
    }

    public int countConnected(int n, int n2, int n3) {
        if (n < 0 || n >= this.sizeX || n2 < 0 || n2 >= this.sizeY) {
            return 0;
        }
        if (this.checkField[n][n2]) {
            return 0;
        }
        if (this.playField[n][n2] == n3) {
            this.checkField[n][n2] = true;
            return 1 + this.countConnected(n + 1, n2, n3) + this.countConnected(n - 1, n2, n3) + this.countConnected(n, n2 + 1, n3) + this.countConnected(n, n2 - 1, n3);
        }
        return 0;
    }

    public int countRemovable() {
        int n = 0;
        this.initCheckField();
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                int n2;
                if (this.playField[j][i] == 0 || (n2 = this.countConnected(j, i, this.playField[j][i])) <= 1) continue;
                n += n2;
            }
        }
        return n;
    }

    public void removePiece(int n, int n2, int n3) {
        if (n >= 0 && n < this.sizeX && n2 >= 0 && n2 < this.sizeY && this.playField[n][n2] == n3) {
            this.playField[n][n2] = -n3;
            this.removePiece(n + 1, n2, n3);
            this.removePiece(n - 1, n2, n3);
            this.removePiece(n, n2 + 1, n3);
            this.removePiece(n, n2 - 1, n3);
        }
    }

    public void removePieces(int n, int n2, int n3) {
        this.removePiece(n, n2, n3);
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                if (this.playField[j][i] >= 0) continue;
                this.playField[j][i] = 0;
            }
        }
    }

    public void drawField(Graphics graphics, Image[] imageArray) {
        graphics.setColor(0);
        graphics.fillRect(0, 0, 128, 128);
        for (int i = 0; i < this.sizeY; ++i) {
            for (int j = 0; j < this.sizeX; ++j) {
                graphics.drawImage(imageArray[this.playField[j][i]], j * this.blockSizeX + this.drawPosX, i * this.blockSizeY + this.drawPosY, 4 | 0x10);
            }
        }
    }

    public int getCol(int n, int n2) {
        return this.blockCols[this.playField[n][n2]];
    }

    public int checkClick(int n, int n2) {
        int n3 = 0;
        if (n >= 0 && n < this.sizeX && n2 >= 0 && n2 < this.sizeY && this.playField[n][n2] != 0) {
            this.initCheckField();
            n3 = this.countConnected(n, n2, this.playField[n][n2]);
            if (n3 > 1) {
                this.removePieces(n, n2, this.playField[n][n2]);
                this.fallField();
            }
        }
        return n3;
    }

    public void drawConnect(Graphics graphics, int n, int n2) {
        this.checkField[n][n2] = true;
        if (n - 1 >= 0) {
            if (!this.checkField[n - 1][n2]) {
                graphics.drawLine((n - 1) * this.blockSizeX, 11 + n2 * this.blockSizeY, (n - 1) * this.blockSizeX, 11 + n2 * this.blockSizeY + this.blockSizeY);
            } else {
                this.drawConnect(graphics, n - 1, n2);
            }
        }
        if (n + 1 < this.sizeX) {
            if (!this.checkField[n + 1][n2]) {
                graphics.drawLine((n + 1) * this.blockSizeX, 11 + n2 * this.blockSizeY, (n + 1) * this.blockSizeX, 11 + n2 * this.blockSizeY + this.blockSizeY);
            } else {
                this.drawConnect(graphics, n + 1, n2);
            }
        }
        if (n2 - 1 >= 0) {
            if (!this.checkField[n][n2 - 1]) {
                graphics.drawLine(n * this.blockSizeX, 11 + (n2 - 1) * this.blockSizeY, n * this.blockSizeX + this.blockSizeX, 11 + (n2 - 1) * this.blockSizeY);
            } else {
                this.drawConnect(graphics, n - 1, n2);
            }
        }
        if (n2 + 1 < this.sizeY) {
            if (!this.checkField[n][n2 - 1]) {
                graphics.drawLine(n * this.blockSizeX, (n2 + 1) * this.blockSizeY, n * this.blockSizeX + this.blockSizeX, 11 + (n2 + 1) * this.blockSizeY);
            } else {
                this.drawConnect(graphics, n + 1, n2);
            }
        }
    }

    public void drawConnected(Graphics graphics, int n, int n2) {
        this.initCheckField();
        if (this.countConnected(n, n2, this.playField[n][n2]) > 0) {
            this.initCheckField();
            this.drawConnect(graphics, n, n2);
        }
    }
}

