/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Intro
extends Game {
    public static final int PHYSIC_INTRO_TIME = 17;
    public static final int PHYSIC_OUTRO_TIME = 50;
    public static final int SCREEN_START_HEIGHT = 12;
    public static final int INTRO_ANIM_CAR = 0;
    public static final int INTRO_ANIM_BURGLER_RUN = 1;
    public static final int INTRO_ANIM_BURGLER_RUMB = 2;
    public static final int INTRO_ANIM_BURGLER_TAKE = 3;
    public static final int INTRO_ANIM_NUM = 4;
    private GameAnimation[] anims;
    public static final int CAR_MAX_SPEED = 20;
    public static final int CAR_BREAKING = 23;
    public static final int CAR_ACCELERATE = 15;
    private int carfPos;
    private int carfV = 20480;
    private int carWidth;
    private int carHeight;
    private int carHeightInPixels;
    public static final int BURGLERS_NUM = 4;
    public static final int BURGLER_SPEED = 5;
    private int[] burglersfPosX;
    private int[] burglersfPosY;
    private int[] burglersfVY;
    private int burglerHeightInPixels;
    private int burglerWidth;
    private int burglers;
    private int burglersState;
    private int takeWidth;
    private int takeHeightInPixels;
    private int sheriffHelpBubbleTime;
    private int camerafX;
    public static final int TEXT_GRATULATIONS = 10;
    public static final int TEXT_MORE_FUN = 11;
    public static final int TEXT_VISIT = 12;
    public static final int TEXT_ADDRESSES = 13;
    public int[] textWidths = new int[4];
    public static final int OUTRO_SHERIFF_POSX = 17408;
    private int outroState;
    private int jumpNum;
    public static final int TYPE_INTRO = 0;
    public static final int TYPE_OUTRO = 1;
    private int type;
    private GameAnimation sheriffAnim;
    private int sheriffWidth;
    private int sheriffHeight;
    private int sheriffWidthInPixels;
    private int sheriffHeightInPixels;
    private int sheriffTime;
    private int sheriffBubbleTime;
    private int time;
    private boolean end;

    public void loadIntro() {
        this.tickProgressBar(0);
        this.initLevelData(MainCanvas.midlet, "/level0.wmp");
        this.tickProgressBar(250);
        this.initLevelAnimations(MainCanvas.midlet);
        this.tickProgressBar(600);
        this.type = 0;
        this.anims = new GameAnimation[4];
        this.anims[0] = new GameAnimation(MainCanvas.midlet, "car.ani", "car", null, 176, 208);
        this.anims[2] = new GameAnimation(MainCanvas.midlet, "rumb.ani", "rumb", null, 176, 208);
        this.anims[1] = new GameAnimation(MainCanvas.midlet, "run.ani", "run", null, 176, 208);
        this.anims[3] = new GameAnimation(MainCanvas.midlet, "take.ani", "take", null, 176, 208);
        this.sheriffAnim = new GameAnimation(MainCanvas.midlet, "sheriff.ani", "sheriff", null, 176, 208);
        this.tickProgressBar(800);
        this.gradient = MainCanvas.createImage("/gradient2.png", Game.isDoublePixel);
        this.landscape = MainCanvas.createImage("/landscape1.png", Game.isDoublePixel);
        if (this.gradient == null) {
            this.gradient = MainCanvas.createImage("/gradient1.png", Game.isDoublePixel);
            if (this.landscape != null) {
                this.landscape = MainCanvas.replaceColor(this.landscape, 0, 10868479);
            }
        } else if (this.landscape != null) {
            this.landscape = MainCanvas.replaceColor(this.landscape, 0, 15454892);
        }
        this.tickProgressBar(900);
        int center = 7 * PlatformGameEngine.sectorWidth;
        PlatformGameEngine.screenPositionX = center - 88;
        if (PlatformGameEngine.screenPositionX < 0) {
            PlatformGameEngine.screenPositionX = 0;
        }
        this.camerafX = (PlatformGameEngine.screenPositionX << 10) / PlatformGameEngine.sectorWidth;
        PlatformGameEngine.screenPositionY = 12 * PlatformGameEngine.sectorHeight;
        this.carfPos = -(this.anims[0].getWidth() << 10) / PlatformGameEngine.sectorWidth;
        this.carHeightInPixels = this.anims[0].getHeight();
        this.carHeight = (this.carHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.carWidth = (this.anims[0].getWidth() << 10) / PlatformGameEngine.sectorWidth;
        this.burglerHeightInPixels = this.anims[1].getHeight();
        int burglerWidthInPixels = Math.max(this.anims[1].getWidth(), this.anims[2].getWidth());
        this.burglerWidth = (burglerWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        this.sheriffHeightInPixels = this.sheriffAnim.getHeight();
        this.sheriffWidthInPixels = this.sheriffAnim.getWidth();
        this.sheriffHeight = (this.sheriffHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.sheriffWidth = (this.sheriffWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        this.takeWidth = (this.anims[3].getWidth() << 10) / PlatformGameEngine.sectorWidth;
        this.takeHeightInPixels = this.anims[3].getHeight();
        this.burglersfPosX = new int[4];
        this.burglersfPosY = new int[4];
        this.burglersfVY = new int[4];
        Game.playerWidth = (Game.playerWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        Game.playerHeight = (Game.playerHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.initPlayer();
        Game.playerBubbleTime = 0;
        Game.fPlayerPosX = -Game.playerWidth;
        Game.fPlayerPosY = 2048;
        Game.fPlayerVX = 10240;
        Game.fPlayerVY = 0;
        Game.playerOutOfScreenAllowed = true;
        this.tickProgressBar(1024);
        this.fLoading = 1025;
        MainCanvas.playSound(0, true);
    }

    public void loadOutro() {
        this.tickProgressBar(0);
        this.initLevelData(MainCanvas.midlet, "/outro.wmp");
        this.tickProgressBar(250);
        this.initLevelAnimations(MainCanvas.midlet);
        this.tickProgressBar(600);
        this.type = 1;
        this.sheriffAnim = new GameAnimation(MainCanvas.midlet, "sheriff.ani", "sheriff", null, 176, 208);
        this.tickProgressBar(700);
        this.gradient = MainCanvas.createImage("/gradient1.png", Game.isDoublePixel);
        this.landscape = MainCanvas.createImage("/landscape2.png", Game.isDoublePixel);
        if (this.landscape == null) {
            this.landscape = MainCanvas.createImage("/landscape1.png", Game.isDoublePixel);
            if (this.landscape != null) {
                this.landscape = MainCanvas.replaceColor(this.landscape, 0, 10868479);
            }
        }
        this.tickProgressBar(800);
        this.sheriffHeightInPixels = this.sheriffAnim.getHeight();
        this.sheriffWidthInPixels = this.sheriffAnim.getWidth();
        this.sheriffHeight = (this.sheriffHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.sheriffWidth = (this.sheriffWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        Game.playerWidth = (Game.playerWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        Game.playerHeight = (Game.playerHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        this.initPlayer();
        Game.fPlayerPosX = 6144;
        Game.fPlayerPosY = 3072;
        this.updateCamera(0, true);
        this.tickProgressBar(1024);
        this.fLoading = 1025;
        MainCanvas.playSound(0, true);
    }

    public void close() {
        this.closeLevelData();
    }

    public void actionKeyPressed(int keyCode) {
        if (keyCode == 2048 && !this.endTable) {
            this.finish();
            return;
        }
        if (keyCode == 1024 && this.isNewRecordTable && MainCanvas.canvas.NickClass.getVisibleText().length() > 0) {
            this.addNewRecord();
            return;
        }
        if (this.endTable && !this.isNewRecordTable) {
            MainCanvas.stopSound();
            if (this.isNewRealRecord) {
                MainCanvas.gameOver(true);
            } else {
                MainCanvas.gameOver(false);
            }
            return;
        }
    }

    public void actionKeyReleased(int keyCode) {
    }

    private void createBurgler() {
        this.burglersfPosX[this.burglers] = this.carfPos;
        this.burglersfPosY[this.burglers] = 2048 + this.carHeight / 5;
        ++this.burglers;
    }

    private void finish() {
        this.end = true;
        if (this.type == 0) {
            Game.playerOutOfScreenAllowed = false;
            MainCanvas.stopSound();
            MainCanvas.nextLevel();
        } else if (Game.score >= 0) {
            this.createEndTable();
        } else {
            MainCanvas.stopSound();
            MainCanvas.gameOver(false);
        }
    }

    private void physicIntro(int delta) {
        if (this.end) {
            return;
        }
        this.time += delta;
        int descentTime = 2000;
        if (this.time < descentTime) {
            int t = descentTime - this.time;
            t *= t;
            PlatformGameEngine.screenPositionY = t * 12 * PlatformGameEngine.sectorHeight / (descentTime * descentTime);
        } else {
            PlatformGameEngine.screenPositionY = 0;
            if (this.carfPos < 0) {
                this.carfPos += this.carfV * delta / 1024;
            } else if (this.carfV > 0 && this.burglersState == 0) {
                this.carfV -= 23 * delta;
                if (this.carfV < 0) {
                    this.carfV = 0;
                }
                this.carfPos += this.carfV * delta / 1024;
            } else if (this.burglersState == 0) {
                if (this.burglers == 0) {
                    this.createBurgler();
                }
                for (int i = 0; i < this.burglers; ++i) {
                    int n = i;
                    this.burglersfPosX[n] = this.burglersfPosX[n] - 5 * delta;
                    if (this.burglersfPosY[i] <= 2048 || this.burglersfPosX[i] >= this.carfPos - this.burglerWidth / 2) continue;
                    int n2 = i;
                    this.burglersfVY[n2] = this.burglersfVY[n2] - 48 * delta;
                    if (-this.burglersfVY[i] > 10240) {
                        this.burglersfVY[i] = -10240;
                    }
                    int n3 = i;
                    this.burglersfPosY[n3] = this.burglersfPosY[n3] + this.burglersfVY[i] * delta / 1024;
                    if (this.burglersfPosY[i] > 2048) continue;
                    this.burglersfPosY[i] = 2048;
                    this.burglersfVY[i] = 0;
                    if (this.burglers >= 4) continue;
                    this.createBurgler();
                }
                if (this.burglersfPosX[3] + this.burglerWidth < 0) {
                    this.burglersState = 1;
                }
            } else if (this.burglersState == 1 && this.sheriffBubbleTime < 2000) {
                this.sheriffBubbleTime += delta;
            } else if (this.burglersState == 1 && this.burglers > 0 && this.sheriffBubbleTime >= 2000) {
                for (int i = 0; i < this.burglers; ++i) {
                    int prevPosX = this.burglersfPosX[i];
                    int n = i;
                    this.burglersfPosX[n] = this.burglersfPosX[n] + 5 * delta;
                    int jumpPoint = this.carfPos - this.burglerWidth;
                    if (this.burglersfPosX[i] >= jumpPoint && prevPosX < jumpPoint) {
                        this.burglersfVY[i] = 7168;
                    }
                    if (this.burglersfPosY[i] > 2048) {
                        int n4 = i;
                        this.burglersfVY[n4] = this.burglersfVY[n4] - 48 * delta;
                        if (this.burglersfVY[i] < 0) {
                            this.burglersfVY[i] = 0;
                        }
                    }
                    int n5 = i;
                    this.burglersfPosY[n5] = this.burglersfPosY[n5] + this.burglersfVY[i] * delta / 1024;
                    if (this.burglersfPosX[i] < this.carfPos) continue;
                    --this.burglers;
                }
            } else if (this.burglersState == 1 && this.burglers == 0 && this.sheriffTime < 750) {
                this.sheriffTime += delta;
            } else if (this.burglersState == 1 && this.burglers == 0) {
                this.carfV += 15 * delta;
                if (this.carfV > 20480) {
                    this.carfV = 20480;
                }
                this.carfPos += this.carfV * delta / 1024;
                if (this.carfPos > 15360) {
                    this.burglersState = 2;
                }
            } else if (this.burglersState == 2 && Game.fPlayerPosX < 5120) {
                this.carfPos += this.carfV * delta / 1024;
                this.actRight = true;
                this.updatePlayer(delta);
            } else if (this.burglersState == 2 && Game.fPlayerVX > 0 && this.sheriffHelpBubbleTime == 0) {
                this.carfPos += this.carfV * delta / 1024;
                this.actRight = false;
                this.updatePlayer(delta);
            } else if (this.burglersState == 2 && this.sheriffHelpBubbleTime < 500) {
                this.carfPos += this.carfV * delta / 1024;
                Game.playerBubbleType = 2;
                if (Game.playerBubbleTime == 0) {
                    Game.playerBubbleTime = 2000;
                }
                this.sheriffHelpBubbleTime += delta;
                this.updatePlayer(delta);
            } else if (this.burglersState == 2 && this.sheriffHelpBubbleTime < 1500) {
                Game.playerActiveAnim = 0;
                Game.playerAnimTime = 1000;
                this.carfPos += this.carfV * delta / 1024;
                this.sheriffHelpBubbleTime += delta;
                this.updatePlayer(delta);
            } else if (this.burglersState == 2) {
                this.carfPos += this.carfV * delta / 1024;
                this.actRight = true;
                this.updatePlayer(delta);
                this.camerafX += delta * 10;
                PlatformGameEngine.screenPositionX = this.camerafX * PlatformGameEngine.sectorWidth / 1024;
            }
        }
        if (PlatformGameEngine.screenPositionX + 176 >= PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH * PlatformGameEngine.sectorWidth) {
            this.finish();
        }
    }

    private void physicOutro(int delta) {
        if (this.end) {
            return;
        }
        this.time += delta;
        if (this.time < 1000) {
            this.updatePlayer(delta);
        } else if (this.outroState == 0) {
            this.actWalk = true;
            this.actRight = true;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (17408 - Game.fPlayerPosX < Game.playerWidth) {
                this.actWalk = false;
                this.actRight = false;
                this.outroState = 1;
            }
        } else if (this.outroState == 1) {
            if (Game.fPlayerVX == 0) {
                Game.idleTime += delta;
            }
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.idleTime > 3000) {
                Game.idleTime = 0;
                this.outroState = 2;
            }
        } else if (this.outroState == 2) {
            this.actUp = Game.fPlayerPosY < 4096;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (this.actUp && Game.fPlayerPosY >= 4096) {
                ++this.jumpNum;
            }
            if (this.jumpNum >= 3 && Game.fPlayerPosY < 4096) {
                this.outroState = 3;
            }
        } else if (this.outroState == 3) {
            this.actUp = true;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.fPlayerPosY >= 4096) {
                ++this.jumpNum;
            }
            if (this.jumpNum >= 4 && Game.fPlayerVY == 0) {
                this.actUp = false;
                this.outroState = 4;
            }
        } else if (this.outroState == 4) {
            this.actLeft = true;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.fPlayerPosX < 12288) {
                this.actLeft = false;
                this.outroState = 5;
            }
        } else if (this.outroState == 5) {
            this.actRight = true;
            this.actUp = Game.fPlayerPosX > 13312 && Game.fPlayerPosX < 16384 ? true : Game.fPlayerPosX > 26624 && Game.fPlayerPosX < 29696;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.fPlayerPosX > 32768) {
                this.actRight = false;
                this.actUp = false;
                this.outroState = 6;
            }
        } else if (this.outroState == 6) {
            if (Game.fPlayerVX == 0) {
                Game.idleTime += delta;
            }
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.idleTime > 2000) {
                Game.idleTime = 0;
                this.outroState = 7;
            }
        } else if (this.outroState == 7) {
            this.actRight = true;
            this.actUp = Game.fPlayerPosX > 35840 && Game.fPlayerPosX < 38912;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.fPlayerPosX > 40960) {
                this.actRight = false;
                this.actUp = false;
                this.outroState = 8;
            }
        } else if (this.outroState == 8) {
            if (Game.fPlayerVX == 0) {
                Game.idleTime += delta;
            }
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.idleTime > 500) {
                Game.idleTime = 0;
                this.outroState = 9;
            }
        } else if (this.outroState == 9) {
            this.actRight = true;
            this.actUp = Game.fPlayerPosX > 48128 && Game.fPlayerPosX < 50176 ? true : Game.fPlayerPosX > 57344 && Game.fPlayerPosX < 60416;
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.fPlayerPosX > 68608) {
                this.actRight = false;
                this.actUp = false;
                this.outroState = 10;
            }
        } else if (this.outroState == 10) {
            if (Game.fPlayerVX == 0) {
                Game.idleTime += delta;
            }
            this.updatePlayer(delta);
            this.updateCamera(delta, false);
            if (Game.idleTime > 3000) {
                Game.idleTime = 0;
                this.finish();
            }
        }
    }

    private void _physic(int delta) {
        if (this.end) {
            return;
        }
        if (this.type == 0) {
            this.physicIntro(delta);
        } else {
            this.physicOutro(delta);
        }
    }

    private void physic(int delta) {
        if (delta > 100) {
            delta = 100;
        }
        int physicTime = this.type == 0 ? 17 : 50;
        while (delta > 2 * physicTime) {
            this._physic(physicTime);
            delta -= physicTime;
        }
        if (delta > physicTime) {
            this._physic(delta / 2);
            this._physic(delta - delta / 2);
        } else if (delta > 0) {
            this._physic(delta);
        }
    }

    public void myAction(int delta) {
        if (this.endTable && !this.isNewRecordTable) {
            this.endTableTime -= delta;
            if (this.endTableTime < 0) {
                this.endTableTime = 0;
                this.endTable = false;
                MainCanvas.stopSound();
                if (this.isNewRealRecord) {
                    MainCanvas.gameOver(true);
                } else {
                    MainCanvas.gameOver(false);
                }
            }
        } else {
            this.physic(delta);
        }
    }

    private void paintCar(Graphics g) {
        int x = this.carfPos * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = 2 * PlatformGameEngine.sectorHeight - PlatformGameEngine.screenPositionY;
        int y = 208 - yr - this.carHeightInPixels + 1;
        GameAnimation anim = this.anims[0];
        anim.paintAnimation(0, 0, x, y, false, g);
    }

    private void paintSheriff(Graphics g) {
        int sheriffPosY;
        int sheriffPosX;
        int frame = 0;
        if (this.type == 0) {
            int sheriffPosX1 = 6656;
            int sheriffPosY1 = 2048;
            int sheriffPosX2 = this.carfPos;
            int sheriffPosY2 = 2048 + this.carHeight / 5;
            int _sheriffTime = this.sheriffTime - 250;
            if (_sheriffTime < 0) {
                _sheriffTime = 0;
            }
            int t = 500;
            sheriffPosX = (sheriffPosX2 * _sheriffTime + sheriffPosX1 * (t - _sheriffTime)) / t;
            sheriffPosY = (sheriffPosY2 * _sheriffTime + sheriffPosY1 * (t - _sheriffTime)) / t;
            frame = _sheriffTime * 4 / t;
        } else {
            sheriffPosX = 17408;
            sheriffPosY = 3072;
        }
        if (this.sheriffBubbleTime > 0 && this.sheriffBubbleTime < 2000) {
            Game.paintBubble(sheriffPosX + this.sheriffWidth / 2, sheriffPosY + this.sheriffHeight, 1, this.sheriffBubbleTime, g);
        }
        int x = sheriffPosX * PlatformGameEngine.sectorWidth / 1024 + PlatformGameEngine.sectorWidth / 2 - PlatformGameEngine.screenPositionX;
        int yr = sheriffPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 208 - yr - this.sheriffHeightInPixels + 1;
        GameAnimation anim = this.sheriffAnim;
        anim.paintAnimation(1, frame, x, y, false, g);
        if (this.sheriffTime >= 100 && this.sheriffTime < 500) {
            x = (this.carfPos + this.carWidth / 40 - this.takeWidth) * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
            yr = (2048 + this.carHeight * 2 / 5) * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
            y = 208 - yr - this.takeHeightInPixels + 1;
            anim = this.anims[3];
            frame = 0;
            int n = this.sheriffTime / 100;
            if (n == 1) {
                frame = 0;
            }
            if (n == 2) {
                frame = 2;
            }
            if (n == 3) {
                frame = 1;
            }
            if (n == 4) {
                frame = 0;
            }
            anim.paintAnimation(0, frame, x, y, false, g);
        }
    }

    private void paintBurglers(Graphics g) {
        for (int i = 0; i < this.burglers; ++i) {
            int x = this.burglersfPosX[i] * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
            int yr = this.burglersfPosY[i] * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
            int y = 208 - yr - this.burglerHeightInPixels + 1;
            GameAnimation anim = this.anims[1 + this.burglersState];
            anim.paintAnimation(0, anim.correctFrame(0, this.time / 100, 0), x, y, false, g);
        }
    }

    private void paintLabel(int textId, int x, int y, Graphics g) {
        int lines = BPFontReader.getLinesNum(textId);
        int w = this.textWidths[textId - 10];
        if (w == 0) {
            for (int i = 0; i < lines; ++i) {
                int _w = BPFontReader.getGraphicTextWidth(textId, i);
                if (_w <= w) continue;
                w = _w;
            }
            this.textWidths[textId - 10] = w;
        }
        int h = lines * (BPFontReader.getFontHeight(textId) + MainCanvas.lineSpacing);
        y = 208 - y;
        BPFontReader.drawGraphicTextInWindow(textId, 0, 0, x - w / 2, y - h / 2, w, h, g, 3, MainCanvas.lineSpacing);
        g.setClip(0, 0, 176, 208);
    }

    private void paintLabels(Graphics g) {
        int y = 8 * PlatformGameEngine.sectorHeight;
        this.paintLabel(10, 18 * PlatformGameEngine.sectorWidth - PlatformGameEngine.screenPositionX, y - PlatformGameEngine.screenPositionY, g);
        this.paintLabel(11, 36 * PlatformGameEngine.sectorWidth - PlatformGameEngine.screenPositionX, y - PlatformGameEngine.screenPositionY, g);
        this.paintLabel(12, 44 * PlatformGameEngine.sectorWidth - PlatformGameEngine.screenPositionX, y - PlatformGameEngine.screenPositionY, g);
        this.paintLabel(13, 71 * PlatformGameEngine.sectorWidth - PlatformGameEngine.screenPositionX, y - PlatformGameEngine.screenPositionY, g);
    }

    protected void paintObjects(Graphics g) {
        if (this.type == 1) {
            this.paintLabels(g);
        }
        this.paintSheriff(g);
        if (this.type == 0) {
            this.paintBurglers(g);
            this.paintCar(g);
        }
        Game.paintPlayer(g);
    }

    public void paint(Graphics g) {
        if (this.fLoading <= 1024) {
            this.paintLoading(g);
        } else {
            this.paintBackground(0xCCCE9C, g);
            MainCanvas.paintLogo(g);
            if (MainCanvas.gameStage == 1) {
                this.paintLevel(g);
                if (this.endTable) {
                    this.paintEndTable(g);
                } else {
                    MainCanvas.drawSofts(g, -100, 7);
                }
            }
        }
    }
}

