/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Particle {
    public static final int TYPE_STONE = 0;
    public static final int TYPE_TNT = 1;
    public static final int TYPE_BOX_PART = 2;
    public static final int TYPE_EXPLOSION = 3;
    private int type;
    private int subType;
    private int fPosX;
    private int fPosY;
    private int fVX;
    private int fVY;
    private int bouncingNum;
    private int timeToLive;
    private int time;
    private int particleWidth;
    private int particleHeight;
    private int particleWidthInPixels;
    private int particleHeightInPixels;
    private boolean isOnFloor;
    private int explosionX;
    private int explosionY;
    private int explosionType;

    public void recreate(int _type, int _subType, int _timeToLive, int _posX, int _posY, int _vx, int _vy) {
        this.type = _type;
        this.subType = _subType;
        this.fPosX = _posX;
        this.fPosY = _posY;
        this.fVX = _vx;
        this.fVY = _vy;
        this.particleWidthInPixels = Particle.getWidthInPixels(_type, _subType);
        this.particleWidth = Particle.getWidth(_type, _subType);
        this.particleHeightInPixels = Particle.getHeightInPixels(_type, _subType);
        this.particleHeight = Particle.getHeight(_type, _subType);
        this.bouncingNum = _type == 0 ? 2 : (_type == 1 ? 3 : 0);
        this.timeToLive = _timeToLive;
        this.time = 0;
        if (this.type == 3) {
            Game.shake(_timeToLive);
            Game.vibrate(_timeToLive);
            this.calcExplosion();
        }
    }

    public void kill() {
        this.timeToLive = 0;
    }

    public static int getWidthInPixels(int _type, int _subType) {
        if (_type == 0) {
            return Game.maxStoneImage.getWidth();
        }
        if (_type == 1) {
            return Game.tntAnim.getWidth();
        }
        if (_type == 2) {
            return Game.boxExplodeImage[_subType].getWidth();
        }
        if (_type == 3) {
            return PlatformGameEngine.sectorWidth * 3;
        }
        return 0;
    }

    public static int getHeightInPixels(int _type, int _subType) {
        if (_type == 0) {
            return Game.maxStoneImage.getHeight();
        }
        if (_type == 1) {
            return Game.tntAnim.getHeight();
        }
        if (_type == 2) {
            return Game.boxExplodeImage[_subType].getHeight();
        }
        if (_type == 3) {
            return PlatformGameEngine.sectorWidth * 3;
        }
        return 0;
    }

    public static int getWidth(int _type, int _subType) {
        return Particle.getWidthInPixels(_type, _subType) * 1024 / PlatformGameEngine.sectorWidth;
    }

    public static int getHeight(int _type, int _subType) {
        return Particle.getHeightInPixels(_type, _subType) * 1024 / PlatformGameEngine.sectorWidth;
    }

    public final int getTimeToLive() {
        return this.timeToLive;
    }

    public boolean canHit() {
        if ((this.type == 0 || this.type == 1) && this.fVX != 0) {
            return true;
        }
        return this.type == 3;
    }

    public final int getfPosX() {
        return this.fPosX;
    }

    public final int getfPosY() {
        return this.fPosY;
    }

    public final int getWidth() {
        return this.particleWidth;
    }

    public final int getHeight() {
        return this.particleHeight;
    }

    private void calcExplosion() {
        this.explosionType = MainCanvas.getRandom(0, Game.explosionImage.length - 1);
        int w = Game.explosionImage[this.explosionType].getWidth();
        int h = Game.explosionImage[this.explosionType].getHeight();
        this.explosionX = MainCanvas.getRandom(0, this.particleWidthInPixels - w - 1);
        this.explosionY = MainCanvas.getRandom(0, this.particleHeightInPixels - h - 1);
    }

    public void update(int delta) {
        if (this.timeToLive <= 0) {
            return;
        }
        this.timeToLive -= delta;
        if (this.timeToLive <= 0) {
            this.timeToLive = 0;
            if (this.type == 1) {
                int explosionTime = 1000;
                Game.createParticle(3, 0, explosionTime, this.fPosX + (this.particleWidth - Particle.getWidth(3, 0)) / 2, this.fPosY + (this.particleHeight - Particle.getHeight(3, 0)) / 2, 0, 0);
            }
        }
        this.time += delta;
        if (this.type == 3) {
            if (this.time >= 50) {
                this.time -= 50;
                this.calcExplosion();
            }
            return;
        }
        this.fVY -= 48 * delta;
        if (-this.fVY > 10240) {
            this.fVY = -10240;
        }
        int fNewPosX = this.fPosX + this.fVX * delta / 1024;
        int fNewPosY = this.fPosY + this.fVY * delta / 1024;
        if (this.type == 0 || this.type == 1) {
            Special s = null;
            if (this.fVX < 0) {
                boolean rightCollide = PlatformGameEngine.isCollide(this.fPosX, this.fPosY, fNewPosX, this.fPosY, 1);
                if (rightCollide) {
                    s = Game.findSpecial(PlatformGameEngine.collisionX / 1024, PlatformGameEngine.collisionY / 1024);
                    if (s == null || s.getType() != 10) {
                        this.fPosX = PlatformGameEngine.collisionX / 1024 + 1 << 10;
                        this.fVX = 0;
                    } else {
                        this.fPosX = fNewPosX;
                    }
                } else {
                    this.fPosX = fNewPosX;
                }
            }
            if (this.fVX > 0) {
                boolean leftCollide = PlatformGameEngine.isCollide(this.fPosX + this.particleWidth - 1, this.fPosY, fNewPosX + this.particleWidth - 1, this.fPosY, 2);
                if (leftCollide) {
                    s = Game.findSpecial(PlatformGameEngine.collisionX / 1024, PlatformGameEngine.collisionY / 1024);
                    if (s == null || s.getType() != 10) {
                        this.fPosX = (PlatformGameEngine.collisionX / 1024 << 10) - this.particleWidth;
                        this.fVX = 0;
                    } else {
                        this.fPosX = fNewPosX;
                    }
                } else {
                    this.fPosX = fNewPosX;
                }
            }
            this.isOnFloor = false;
            if (fNewPosY != this.fPosY) {
                if (this.fVY < 0) {
                    int fPosX2 = this.fPosX + this.particleWidth / 2;
                    int fZeroPosY = this.fPosY / 1024 << 10;
                    if (fZeroPosY < fNewPosY) {
                        fZeroPosY = this.fPosY;
                    }
                    if (!PlatformGameEngine.isCollide(fPosX2, fZeroPosY - 1, fPosX2, fNewPosY, 3)) {
                        this.fPosY = fNewPosY;
                        if (this.fPosY < -this.particleHeight) {
                            this.timeToLive = 0;
                        }
                    } else {
                        this.fPosY = PlatformGameEngine.collisionY / 1024 + 1 << 10;
                        if (this.bouncingNum > 0) {
                            this.fVY = -this.fVY * 3 / 4;
                            --this.bouncingNum;
                        } else {
                            this.isOnFloor = true;
                            this.fVY = 0;
                            if (this.type == 1) {
                                this.fVX = 0;
                            }
                            if (this.type == 0) {
                                if (this.fVX > 0) {
                                    this.fVX -= 5 * delta;
                                    if (this.fVX < 0) {
                                        this.fVX = 0;
                                    }
                                } else {
                                    this.fVX += 5 * delta;
                                    if (this.fVX > 0) {
                                        this.fVX = 0;
                                    }
                                }
                            }
                        }
                    }
                } else {
                    this.fPosY = fNewPosY;
                }
            } else {
                this.isOnFloor = true;
            }
        } else {
            this.fPosY = fNewPosY;
            this.fPosX = fNewPosX;
        }
    }

    public void paint(Graphics g) {
        if (this.timeToLive <= 0) {
            return;
        }
        int x = this.fPosX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = this.fPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 320 - yr - this.particleHeightInPixels + 1;
        if (x + this.particleWidthInPixels <= 0 || y + this.particleHeightInPixels <= 0 || x >= 240 || y >= 320) {
            return;
        }
        if (this.type == 0) {
            MainCanvas.drawImage(Game.maxStoneImage, x, y, 20, g, Game.isDoublePixel);
        } else if (this.type == 1) {
            int animNumber = 0;
            if (this.isOnFloor) {
                animNumber = 1;
            } else if (this.fVX < 0) {
                animNumber = 2;
            } else if (this.fVX >= 0) {
                animNumber = 3;
            }
            Game.tntAnim.paintAnimation(animNumber, Game.tntAnim.correctFrame(animNumber, this.time / 100, 0), x, y, false, g);
        } else if (this.type == 2) {
            MainCanvas.drawImage(Game.boxExplodeImage[this.subType], x, y, 20, g, Game.isDoublePixel);
        } else if (this.type == 3) {
            MainCanvas.drawImage(Game.explosionImage[this.explosionType], x + this.explosionX, y + this.explosionY, 20, g, Game.isDoublePixel);
        }
    }
}

