/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;

abstract class PlatformGameEngine {
    protected static final int SCREEN_WIDTH = 240;
    protected static final int SCREEN_HEIGHT = 320;
    protected static int screenPositionX;
    protected static int screenPositionY;
    protected static final int COLLIDE_TYPE_UP = 3;
    protected static final int COLLIDE_TYPE_LEFT = 2;
    protected static final int COLLIDE_TYPE_RIGHT = 1;
    protected static final int COLLIDE_TYPE_DOWN = 0;
    protected static final int BIT_MOVE = 10;
    protected static final int BIT_MOVE_VALUE = 1024;
    protected static final int BIT_MOVE_VALUE_SQRT = 32;
    protected GameAnimation[] animation;
    protected static final byte BOARD_LAYER2_STATIC = 1;
    protected static final byte BOARD_LAYER3_STATIC = 2;
    protected static byte levelWidth;
    protected static byte levelHeight;
    protected static byte[][] levelBoard;
    protected static int BOARD_WIDTH;
    protected static int BOARD_HEIGHT;
    protected static int sectorWidth;
    protected static int sectorHeight;
    protected static int bitSectorWidth;
    protected static int bitSectorHeight;
    protected byte sectorOffsetX;
    protected byte sectorOffsetY;
    protected byte boardNumber;
    protected static byte[] boardPositionX;
    protected static byte[] boardPositionY;
    protected static boolean[][][] boardPlatform;
    protected byte[][][] boardLayerTwo;
    protected boolean[] isAnimationTwo;
    protected byte[][][] boardLayerThree;
    protected boolean[] isAnimationThree;
    protected static final byte triggerTypeMax = 100;
    protected byte[][] triggerType;
    protected byte[][] triggerSectorX;
    protected byte[][] triggerSectorY;
    protected static int collisionX;
    protected static int collisionY;
    protected Image gradient;
    protected Image landscape;

    protected PlatformGameEngine() {
    }

    public static int countCellWidth(GameAnimation animation) {
        int sectorWidth = -1;
        for (int i = 0; i < animation.getAnimationNum(); ++i) {
            int w = animation.getWidth(i, 0);
            if (w <= 0 || w >= sectorWidth && sectorWidth != -1) continue;
            sectorWidth = w;
        }
        return sectorWidth;
    }

    public static int countCellHeight(GameAnimation animation) {
        int sectorHeight = -1;
        for (int i = 0; i < animation.getAnimationNum(); ++i) {
            int h = animation.getHeight(i, 0);
            if (h <= 0 || h >= sectorHeight && sectorHeight != -1) continue;
            sectorHeight = h;
        }
        return sectorHeight;
    }

    protected void initLevelAnimations(MIDlet midlet) {
        this.animation = new GameAnimation[3];
        this.animation[1] = new GameAnimation(midlet, "layer2.ani", "layer2", this.isAnimationTwo, 240, 320);
        this.animation[2] = new GameAnimation(midlet, "layer3.ani", "layer3", this.isAnimationThree, 240, 320);
        sectorWidth = PlatformGameEngine.countCellWidth(this.animation[1]);
        sectorHeight = PlatformGameEngine.countCellHeight(this.animation[1]);
    }

    protected void closeLevelData() {
        this.animation = null;
        levelBoard = null;
        boardPositionX = null;
        boardPositionY = null;
        boardPlatform = null;
        this.isAnimationTwo = null;
        this.isAnimationThree = null;
        this.boardLayerTwo = null;
        this.boardLayerThree = null;
        this.triggerType = null;
        this.triggerSectorX = null;
        this.triggerSectorY = null;
    }

    private void bad() throws Exception {
        throw new Exception("Bledna mapa");
    }

    protected void initLevelData(MIDlet midlet, String _levelFileName) {
        block24: {
            InputStream is = null;
            FilterInputStream dis = null;
            try {
                is = midlet.getClass().getResourceAsStream(_levelFileName);
                dis = new DataInputStream(is);
                byte a = ((DataInputStream)dis).readByte();
                byte b = ((DataInputStream)dis).readByte();
                levelWidth = ((DataInputStream)dis).readByte();
                levelHeight = ((DataInputStream)dis).readByte();
                BOARD_WIDTH = ((DataInputStream)dis).readByte();
                BOARD_HEIGHT = ((DataInputStream)dis).readByte();
                ((DataInputStream)dis).readByte();
                ((DataInputStream)dis).readByte();
                if (Game.isDoublePixel) {
                    sectorWidth *= 2;
                    sectorHeight *= 2;
                }
                ((DataInputStream)dis).readByte();
                this.sectorOffsetX = ((DataInputStream)dis).readByte();
                this.sectorOffsetY = ((DataInputStream)dis).readByte();
                this.boardNumber = (byte)((DataInputStream)dis).readShort();
                bitSectorWidth = sectorWidth << 10;
                bitSectorHeight = sectorHeight << 10;
                levelBoard = new byte[levelWidth][levelHeight];
                boardPositionX = new byte[this.boardNumber];
                boardPositionY = new byte[this.boardNumber];
                boardPlatform = new boolean[this.boardNumber][BOARD_WIDTH][4 * BOARD_HEIGHT];
                this.boardLayerTwo = new byte[this.boardNumber][][];
                this.boardLayerThree = new byte[this.boardNumber][][];
                this.triggerType = new byte[this.boardNumber][];
                this.triggerSectorX = new byte[this.boardNumber][];
                this.triggerSectorY = new byte[this.boardNumber][];
                this.isAnimationTwo = new boolean[256];
                this.isAnimationThree = new boolean[256];
                for (int i = 0; i < this.boardNumber; ++i) {
                    int j;
                    byte _sectorPosY;
                    byte _sectorPosX;
                    int anim;
                    short _sectorPos;
                    int _sectorType;
                    int j2;
                    ((DataInputStream)dis).readByte();
                    ((DataInputStream)dis).readByte();
                    byte _levelPosX = ((DataInputStream)dis).readByte();
                    byte _levelPosY = ((DataInputStream)dis).readByte();
                    PlatformGameEngine.levelBoard[_levelPosX][PlatformGameEngine.levelHeight - _levelPosY - 1] = (byte)(i + 1);
                    PlatformGameEngine.boardPositionX[i] = _levelPosX;
                    PlatformGameEngine.boardPositionY[i] = (byte)(levelHeight - _levelPosY - 1);
                    int _sectorNumber = ((DataInputStream)dis).readShort();
                    if (_sectorNumber > 0) {
                        this.bad();
                    }
                    if ((_sectorNumber = ((DataInputStream)dis).readShort()) > 0) {
                        this.boardLayerTwo[i] = new byte[BOARD_WIDTH][BOARD_HEIGHT];
                    }
                    for (j2 = 0; j2 < _sectorNumber; ++j2) {
                        _sectorType = ((DataInputStream)dis).readByte();
                        _sectorPos = (short)((DataInputStream)dis).readUnsignedByte();
                        anim = _sectorType;
                        if (anim < 0) {
                            anim += 256;
                        }
                        this.isAnimationTwo[--anim] = true;
                        _sectorPosX = (byte)(_sectorPos % BOARD_WIDTH);
                        _sectorPosY = (byte)(_sectorPos / BOARD_WIDTH);
                        this.boardLayerTwo[i][_sectorPosX][PlatformGameEngine.BOARD_HEIGHT - _sectorPosY - 1] = _sectorType;
                    }
                    byte _positionNumber = _sectorNumber % 4 == 0 ? (byte)(_sectorNumber / 4) : (byte)(_sectorNumber / 4 + 1);
                    for (j2 = 0; j2 < _positionNumber; ++j2) {
                        ((DataInputStream)dis).readByte();
                    }
                    _sectorNumber = ((DataInputStream)dis).readShort();
                    if (_sectorNumber > 0) {
                        this.boardLayerThree[i] = new byte[BOARD_WIDTH][BOARD_HEIGHT];
                    }
                    for (j2 = 0; j2 < _sectorNumber; ++j2) {
                        _sectorType = ((DataInputStream)dis).readByte();
                        _sectorPos = (short)((DataInputStream)dis).readUnsignedByte();
                        anim = _sectorType;
                        if (anim < 0) {
                            anim += 256;
                        }
                        this.isAnimationThree[--anim] = true;
                        _sectorPosX = (byte)(_sectorPos % BOARD_WIDTH);
                        _sectorPosY = (byte)(_sectorPos / BOARD_WIDTH);
                        this.boardLayerThree[i][_sectorPosX][PlatformGameEngine.BOARD_HEIGHT - _sectorPosY - 1] = _sectorType;
                    }
                    _positionNumber = _sectorNumber % 4 == 0 ? (byte)(_sectorNumber / 4) : (byte)(_sectorNumber / 4 + 1);
                    for (j2 = 0; j2 < _positionNumber; ++j2) {
                        ((DataInputStream)dis).readByte();
                    }
                    _sectorNumber = ((DataInputStream)dis).readShort();
                    if (_sectorNumber > 0) {
                        this.bad();
                    }
                    if ((_sectorNumber = (int)((DataInputStream)dis).readShort()) > 0) {
                        this.bad();
                    }
                    if ((_sectorNumber = (int)((DataInputStream)dis).readShort()) > 0) {
                        this.bad();
                    }
                    for (j = 0; j < BOARD_WIDTH * BOARD_HEIGHT / 2; ++j) {
                        short _platformType = (short)((DataInputStream)dis).readUnsignedByte();
                        int _platformA = _platformType & 0xF;
                        _platformA = _platformA >> 3 & 1 | (_platformA >> 2 & 1) << 1 | (_platformA >> 1 & 1) << 2 | (_platformA & 1) << 3;
                        int _platformB = _platformType >> 4 & 0xF;
                        _platformB = _platformB >> 3 & 1 | (_platformB >> 2 & 1) << 1 | (_platformB >> 1 & 1) << 2 | (_platformB & 1) << 3;
                        int _platformAPosX = j * 2 % BOARD_WIDTH;
                        int _platformBPosX = (j * 2 + 1) % BOARD_WIDTH;
                        int _platformAPosY = BOARD_HEIGHT - 1 - j * 2 / BOARD_WIDTH;
                        int _platformBPosY = BOARD_HEIGHT - 1 - (j * 2 + 1) / BOARD_WIDTH;
                        PlatformGameEngine.boardPlatform[i][_platformAPosX][4 * _platformAPosY] = (_platformA & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformAPosX][4 * _platformAPosY + 1] = (_platformA >> 1 & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformAPosX][4 * _platformAPosY + 2] = (_platformA >> 2 & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformAPosX][4 * _platformAPosY + 3] = (_platformA >> 3 & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformBPosX][4 * _platformBPosY] = (_platformB & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformBPosX][4 * _platformBPosY + 1] = (_platformB >> 1 & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformBPosX][4 * _platformBPosY + 2] = (_platformB >> 2 & 1) == 1;
                        PlatformGameEngine.boardPlatform[i][_platformBPosX][4 * _platformBPosY + 3] = (_platformB >> 3 & 1) == 1;
                    }
                    _sectorNumber = ((DataInputStream)dis).readShort();
                    this.triggerType[i] = new byte[_sectorNumber];
                    this.triggerSectorX[i] = new byte[_sectorNumber];
                    this.triggerSectorY[i] = new byte[_sectorNumber];
                    for (j = 0; j < _sectorNumber; ++j) {
                        this.triggerType[i][j] = ((DataInputStream)dis).readByte();
                        this.triggerSectorX[i][j] = ((DataInputStream)dis).readByte();
                        this.triggerSectorY[i][j] = (byte)(BOARD_HEIGHT - 1 - ((DataInputStream)dis).readByte());
                        int _parameterNumber = ((DataInputStream)dis).readByte();
                        for (int k = 0; k < _parameterNumber; ++k) {
                            ((DataInputStream)dis).readShort();
                        }
                    }
                    _sectorNumber = ((DataInputStream)dis).readShort();
                    if (_sectorNumber <= 0) continue;
                    this.bad();
                }
                dis.close();
                dis = null;
                is = null;
            }
            catch (Exception e) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception ed) {
                        // empty catch block
                    }
                    is = null;
                }
                if (dis == null) break block24;
                try {
                    dis.close();
                }
                catch (Exception ed) {
                    // empty catch block
                }
                dis = null;
            }
        }
    }

    protected static final boolean isOutOffMapX(int x) {
        return x < 0 || x >= levelWidth * BOARD_WIDTH << 10;
    }

    protected static final boolean isPointInRect(int x, int y, int x1, int y1, int x2, int y2) {
        return x >= x1 && x <= x2 && y >= y1 && y <= y2;
    }

    protected static boolean isCollide(int x0, int y0, int x1, int y1, int collideType) {
        if (x0 != x1 || y0 != y1) {
            if (Math.abs(x1 - x0) > Math.abs(y1 - y0)) {
                int fdy = (y1 - y0 << 10) / (x1 - x0);
                int k = 1024;
                if (x1 > x0) {
                    int fy = y0;
                    int xi = x0;
                    while (xi < x1) {
                        if (PlatformGameEngine.isPointCollide(xi, fy, collideType)) {
                            collisionX = xi;
                            collisionY = fy;
                            return true;
                        }
                        xi += k;
                        fy += fdy;
                    }
                } else {
                    int fy = y0;
                    int xi = x0;
                    while (xi > x1) {
                        if (PlatformGameEngine.isPointCollide(xi, fy, collideType)) {
                            collisionX = xi;
                            collisionY = fy;
                            return true;
                        }
                        xi -= k;
                        fy -= fdy;
                    }
                }
            } else {
                int fdx = (x1 - x0 << 10) / (y1 - y0);
                int k = 1024;
                if (y1 > y0) {
                    int fx = x0;
                    int yi = y0;
                    while (yi < y1) {
                        if (PlatformGameEngine.isPointCollide(fx, yi, collideType)) {
                            collisionX = fx;
                            collisionY = yi;
                            return true;
                        }
                        yi += k;
                        fx += fdx;
                    }
                } else {
                    int fx = x0;
                    int yi = y0;
                    while (yi > y1) {
                        if (PlatformGameEngine.isPointCollide(fx, yi, collideType)) {
                            collisionX = fx;
                            collisionY = yi;
                            return true;
                        }
                        yi -= k;
                        fx -= fdx;
                    }
                }
            }
        }
        if (PlatformGameEngine.isPointCollide(x1, y1, collideType)) {
            collisionX = x1;
            collisionY = y1;
            return true;
        }
        return false;
    }

    protected static boolean isPointCollide(int _x, int _y, int collideType) {
        if (_x < 0 || _y < 0) {
            return false;
        }
        int x = _x / 1024;
        int y = _y / 1024;
        if (x >= levelWidth * BOARD_WIDTH || y >= levelHeight * BOARD_HEIGHT) {
            return false;
        }
        int i = levelBoard[x / BOARD_WIDTH][y / BOARD_HEIGHT] - 1;
        if (i < 0) {
            return false;
        }
        int sx = x - boardPositionX[i] * BOARD_WIDTH;
        int sy = y - boardPositionY[i] * BOARD_HEIGHT;
        int sby = sy * 4 + collideType;
        return boardPlatform[i][sx][sby];
    }

    protected static void setCollision(int x, int y, int collideType, boolean collision) {
        if (x < 0 || y < 0 || x >= levelWidth * BOARD_WIDTH || y >= levelHeight * BOARD_HEIGHT) {
            return;
        }
        int i = levelBoard[x / BOARD_WIDTH][y / BOARD_HEIGHT] - 1;
        int sx = x - boardPositionX[i] * BOARD_WIDTH;
        int sy = y - boardPositionY[i] * BOARD_HEIGHT;
        int sby = sy * 4 + collideType;
        PlatformGameEngine.boardPlatform[i][sx][sby] = collision;
    }

    protected abstract void paintObjects(Graphics var1);

    protected boolean paintBoardPart2(Graphics _g, int _boardX, int _boardY) {
        int _boardNumber = levelBoard[_boardX / BOARD_WIDTH][_boardY / BOARD_HEIGHT] - 1;
        if (_boardNumber == -1) {
            return false;
        }
        if (this.boardLayerTwo[_boardNumber] != null) {
            int _boardPosX = _boardX % BOARD_WIDTH;
            int _boardPosY = _boardY % BOARD_HEIGHT;
            if (this.boardLayerTwo[_boardNumber][_boardPosX][_boardPosY] != 0) {
                int image = this.boardLayerTwo[_boardNumber][_boardPosX][_boardPosY];
                if (image < 0) {
                    image += 256;
                }
                int x = _boardX * sectorWidth - screenPositionX;
                int y = 320 - ((_boardY + 1) * sectorHeight - screenPositionY);
                this.animation[1].paintAnimationQuick(--image, x, y, _g);
            }
            return true;
        }
        return false;
    }

    protected boolean paintBoardPart3(Graphics _g, int _boardX, int _boardY) {
        int _boardNumber = levelBoard[_boardX / BOARD_WIDTH][_boardY / BOARD_HEIGHT] - 1;
        if (_boardNumber == -1) {
            return false;
        }
        if (this.boardLayerThree[_boardNumber] != null) {
            int _boardPosX = _boardX % BOARD_WIDTH;
            int _boardPosY = _boardY % BOARD_HEIGHT;
            if (this.boardLayerThree[_boardNumber][_boardPosX][_boardPosY] != 0) {
                int image = this.boardLayerThree[_boardNumber][_boardPosX][_boardPosY];
                if (image < 0) {
                    image += 256;
                }
                int x = _boardX * sectorWidth - screenPositionX;
                int y = 320 - ((_boardY + 1) * sectorHeight - screenPositionY);
                this.animation[2].paintAnimationQuick(--image, x, y, _g);
            }
            return true;
        }
        return false;
    }

    protected void paintLevel(Graphics _g) {
        int _width = 0;
        int _height = 0;
        int _sX = 0;
        int _sY = 0;
        if (sectorWidth > 0 && sectorHeight > 0) {
            boolean m;
            int i;
            int endX;
            int startX;
            int j;
            _width = 240 / sectorWidth;
            _height = 320 / sectorHeight;
            if (_width * sectorWidth < 240) {
                ++_width;
            }
            if (_height * sectorHeight < 320) {
                ++_height;
            }
            _sX = screenPositionX / sectorWidth;
            _sY = screenPositionY / sectorHeight;
            int o = 3;
            int startY = _sY;
            int endY = _sY + _height + o - 1;
            if (startY < 0) {
                startY = 0;
            }
            if (endY >= levelHeight * BOARD_HEIGHT) {
                endY = levelHeight * BOARD_HEIGHT - 1;
            }
            for (j = startY; j <= endY; ++j) {
                startX = _sX - o + 1;
                endX = _sX + _width;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= levelWidth * BOARD_WIDTH) {
                    endX = levelWidth * BOARD_WIDTH - 1;
                }
                i = startX;
                while (i <= endX) {
                    m = this.paintBoardPart2(_g, i, j);
                    if (m) {
                        ++i;
                        continue;
                    }
                    i = (i / BOARD_WIDTH + 1) * BOARD_WIDTH;
                }
            }
            startY = _sY;
            endY = _sY + _height + o - 1;
            if (startY < 0) {
                startY = 0;
            }
            if (endY >= levelHeight * BOARD_HEIGHT) {
                endY = levelHeight * BOARD_HEIGHT - 1;
            }
            for (j = startY; j <= endY; ++j) {
                startX = _sX - o + 1;
                endX = _sX + _width;
                if (startX < 0) {
                    startX = 0;
                }
                if (endX >= levelWidth * BOARD_WIDTH) {
                    endX = levelWidth * BOARD_WIDTH - 1;
                }
                i = startX;
                while (i <= endX) {
                    m = this.paintBoardPart3(_g, i, j);
                    if (m) {
                        ++i;
                        continue;
                    }
                    i = (i / BOARD_WIDTH + 1) * BOARD_WIDTH;
                }
            }
        }
        this.paintObjects(_g);
    }

    public static void _paintBackground(Image gradient, Image landscape, int screenPositionX, int screenPositionY, int backgroundColor, Graphics g) {
        int x;
        if (gradient != null) {
            int y = 320 - gradient.getHeight();
            for (x = 0; x < 240; x += gradient.getWidth()) {
                MainCanvas.drawImage(gradient, x, y, 20, g, Game.isDoublePixel);
            }
        } else {
            g.setColor(backgroundColor);
            g.fillRect(0, 0, 240, 320);
        }
        if (landscape != null) {
            int d = 3;
            int y = 320 + screenPositionY / d;
            if (y <= 0 || y - landscape.getHeight() >= 320) {
                return;
            }
            for (x = -(screenPositionX / d % landscape.getWidth()); x < 240; x += landscape.getWidth()) {
                MainCanvas.drawImage(landscape, x, y, 36, g, Game.isDoublePixel);
            }
        }
    }

    protected void paintBackground(int backgroundColor, Graphics g) {
        PlatformGameEngine._paintBackground(this.gradient, this.landscape, screenPositionX, screenPositionY, backgroundColor, g);
    }
}

