/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Enemy {
    public static final int TYPE_FROG1 = 0;
    public static final int TYPE_FROG2 = 1;
    public static final int TYPE_JUMPING_FROG = 2;
    public static final int TYPE_SNAKE = 3;
    public static final int TYPE_MAX = 4;
    public static final int TYPE_MAX_TNT = 5;
    public static final int TYPE_TED = 6;
    public static final int TYPE_FISH1 = 7;
    public static final int TYPE_FISH2 = 8;
    public static final int TYPE_BOSS = 9;
    public static final int TYPE_NUM = 10;
    public static final int STATE_WALKING = 1;
    public static final int STATE_WAITING = 2;
    public static final int STATE_JUMPING_OR_FALLING = 3;
    public static final int STATE_ATTACKING = 4;
    public static final int STATE_HITTING = 5;
    public static final int STATE_TURNING = 6;
    public static final int STATE_DIEING = 7;
    private int type;
    private int fPosX;
    private int fPosY;
    private int fVX;
    private int fVY;
    private int isTurnRight;
    private GameAnimation anim;
    private int enemyWidthInPixels;
    private int enemyHeightInPixels;
    private int enemyHeight;
    private int enemyWidth;
    private int fStartPosX;
    private int fStartPosY;
    private int state = 1;
    private int stateTime;
    private int ammoTime;
    private int energy;
    private boolean isActive;
    private boolean isAlive = true;
    private boolean isSawPlayer;

    public Enemy(int _type, int _fPosX, int _fPosY, GameAnimation _anim) {
        int cX;
        this.type = _type;
        this.fPosX = _fPosX;
        this.fPosY = _fPosY;
        this.fStartPosX = _fPosX;
        this.fStartPosY = _fPosY;
        this.isTurnRight = this.type == 0 ? (((cX = _fPosX / 1024) & 1) > 0 ? 0 : 1) : MainCanvas.getRandom(0, 1);
        this.anim = _anim;
        this.enemyWidthInPixels = this.anim.getWidth();
        this.enemyHeightInPixels = this.anim.getHeight();
        this.enemyWidth = (this.enemyWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        this.enemyHeight = (this.enemyHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        if (_type == 7 || _type == 8) {
            this.state = 2;
        }
        this.energy = 5;
    }

    public final int getType() {
        return this.type;
    }

    public final int getfPosX() {
        return this.fPosX;
    }

    public final int getfPosY() {
        return this.fPosY;
    }

    public final int getWidth() {
        return this.enemyWidth;
    }

    public final int getHeight() {
        return this.enemyHeight;
    }

    public final boolean isAlive() {
        if (this.type == 9) {
            return this.energy > 0;
        }
        return this.state != 7;
    }

    public boolean collideConfirm(int x1, int y1, int x2, int y2) {
        if (this.type == 3) {
            int enemyX1 = this.fPosX;
            int enemyY1 = this.fPosY;
            int enemyX2 = this.fPosX + this.enemyWidth - 1;
            int enemyY2 = this.fPosY + this.enemyHeight / 3;
            if (PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2)) {
                return true;
            }
            if (this.isTurnRight == 1) {
                enemyX1 = this.fPosX + this.enemyWidth * 2 / 3;
                enemyY1 = this.fPosY;
                enemyX2 = this.fPosX + this.enemyWidth - 1;
                enemyY2 = this.fPosY + this.enemyHeight - 1;
            } else {
                enemyX1 = this.fPosX;
                enemyY1 = this.fPosY;
                enemyX2 = this.fPosX + this.enemyWidth / 3;
                enemyY2 = this.fPosY + this.enemyHeight - 1;
            }
            return PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2);
        }
        if (this.type == 9) {
            if (this.state == 7) {
                return false;
            }
            int enemyX1 = this.fPosX + this.enemyWidth / 4;
            int enemyY1 = this.fPosY;
            int enemyX2 = this.fPosX + this.enemyWidth * 3 / 4;
            int enemyY2 = this.fPosY + this.enemyHeight / 2;
            if (PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2)) {
                return true;
            }
            enemyX1 = this.fPosX + this.enemyWidth / 2;
            enemyY1 = this.fPosY + this.enemyHeight / 2;
            enemyX2 = this.fPosX + this.enemyWidth * 3 / 4;
            enemyY2 = this.fPosY + this.enemyHeight * 3 / 4;
            return PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2);
        }
        if (this.type == 6) {
            int enemyX1 = this.fPosX + this.enemyWidth / 3;
            int enemyY1 = this.fPosY;
            int enemyX2 = this.fPosX + this.enemyWidth * 2 / 3;
            int enemyY2 = this.fPosY + this.enemyHeight - 1;
            return PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2);
        }
        return true;
    }

    public boolean hitConfirm(int x1, int y1, int x2, int y2) {
        if (this.type == 9) {
            if (this.state == 7) {
                return false;
            }
            int enemyX1 = this.fPosX + this.enemyWidth / 2;
            int enemyY1 = this.fPosY + this.enemyHeight / 2;
            int enemyX2 = this.fPosX + this.enemyWidth * 3 / 4;
            int enemyY2 = this.fPosY + this.enemyHeight * 3 / 4;
            return PlatformGameEngine.isPointInRect(x1, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y1, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x2, y2, enemyX1, enemyY1, enemyX2, enemyY2) || PlatformGameEngine.isPointInRect(x1, y2, enemyX1, enemyY1, enemyX2, enemyY2);
        }
        if (this.type == 6) {
            if (Game.isPlayerOnFloor) {
                return true;
            }
            int isPlayerJumpFromRight = 0;
            if (Game.lastJumpfPosX + Game.playerWidth / 2 - (this.fPosX + this.enemyWidth / 2) > 0) {
                isPlayerJumpFromRight = 1;
            }
            return isPlayerJumpFromRight != this.isTurnRight;
        }
        return true;
    }

    public void die() {
        if (this.state == 7) {
            return;
        }
        this.state = 7;
        --this.energy;
        if (this.type == 9 && this.energy > 0) {
            this.fVX = 0;
            this.fVY = 2048;
        } else {
            this.fVY = 5120;
            this.fVX = MainCanvas.getRandom(-2, 2) << 10;
        }
        switch (this.type) {
            case 0: 
            case 1: 
            case 4: 
            case 5: {
                Game.giveScore(100, this.fPosX, this.fPosY, this.enemyWidth, this.enemyHeight);
                break;
            }
            case 2: 
            case 3: 
            case 6: {
                Game.giveScore(200, this.fPosX, this.fPosY, this.enemyWidth, this.enemyHeight);
            }
        }
    }

    private boolean isInTedRange() {
        int x = Game.fPlayerPosX + Game.playerWidth / 2 - (this.fPosX + this.enemyWidth / 2);
        int y = Game.fPlayerPosY - this.fPosY;
        int r = (this.enemyWidth + Game.playerWidth) / 2;
        if (y > -Game.playerHeight && y < this.enemyHeight && x > -r && x < r) {
            if (Game.isPlayerOnFloor) {
                return true;
            }
            int isPlayerJumpFromRight = 0;
            if (Game.lastJumpfPosX + Game.playerWidth / 2 - (this.fPosX + this.enemyWidth / 2) > 0) {
                isPlayerJumpFromRight = 1;
            }
            return isPlayerJumpFromRight == this.isTurnRight;
        }
        return false;
    }

    private void checkActive() {
        int x1 = this.fPosX;
        int y1 = this.fPosY;
        int x2 = this.fPosX + this.enemyWidth;
        int y2 = this.fPosY + this.enemyHeight;
        x1 = x1 * PlatformGameEngine.sectorWidth / 1024;
        y1 = y1 * PlatformGameEngine.sectorHeight / 1024;
        x2 = x2 * PlatformGameEngine.sectorWidth / 1024;
        y2 = y2 * PlatformGameEngine.sectorHeight / 1024;
        int sx1 = PlatformGameEngine.screenPositionX;
        int sy1 = PlatformGameEngine.screenPositionY;
        int sx2 = sx1 + 240;
        int sy2 = sy1 + 320;
        if (PlatformGameEngine.isPointInRect(x1, y1, sx1, sy1, sx2, sy2) || PlatformGameEngine.isPointInRect(x2, y1, sx1, sy1, sx2, sy2) || PlatformGameEngine.isPointInRect(x2, y2, sx1, sy1, sx2, sy2) || PlatformGameEngine.isPointInRect(x1, y2, sx1, sy1, sx2, sy2)) {
            this.isActive = true;
        } else if (MainCanvas.levelNumber <= 4 && this.state != 7) {
            this.isActive = false;
        }
    }

    public void update(int delta) {
        int x;
        int fPosX2;
        int fNewPosY;
        if (!this.isAlive) {
            return;
        }
        this.checkActive();
        if (!this.isActive) {
            return;
        }
        this.stateTime += delta;
        int newState = this.state;
        if (this.state == 7 && this.type != 9 || this.energy == 0) {
            this.fVY -= 48 * delta;
            if (-this.fVY > 10240) {
                this.fVY = -10240;
            }
            this.fPosX += this.fVX * delta / 1024;
            this.fPosY += this.fVY * delta / 1024;
            if (this.fPosY < -this.enemyHeight) {
                if (this.type == 7 || this.type == 8) {
                    this.fPosX = this.fStartPosX;
                    this.fPosY = this.fStartPosY;
                    newState = 2;
                } else {
                    this.isAlive = false;
                }
            }
            if (this.type != 7 && this.type != 8) {
                return;
            }
        }
        if (this.state == 7 && this.type == 9 && this.stateTime > 2000) {
            newState = 1;
        }
        if (this.type != 9 || this.state != 7) {
            this.fVY -= 48 * delta;
            if (-this.fVY > 10240) {
                this.fVY = -10240;
            }
        }
        if (this.fVY > 0) {
            fNewPosY = this.fPosY + this.fVY * delta / 1024;
            if (this.type == 2 || this.type == 9) {
                fPosX2 = this.fPosX + this.enemyWidth / 2;
                int fNewPosY2 = fNewPosY + this.enemyHeight - 1;
                if (!PlatformGameEngine.isCollide(fPosX2, this.fPosY + this.enemyHeight - 1 + 1, fPosX2, fNewPosY2, 0)) {
                    this.fPosY = fNewPosY;
                    if (this.type != 9 && this.state != 7) {
                        newState = 3;
                    }
                } else {
                    this.fPosY = (PlatformGameEngine.collisionY / 1024 << 10) - this.enemyHeight;
                    this.fVX = 0;
                    this.fVY = 0;
                }
            } else {
                this.fPosY = fNewPosY;
                newState = 3;
            }
        }
        if ((this.type == 2 || this.type == 9) && this.fVX != 0) {
            int fNewPosX1 = this.fPosX + this.fVX * delta / 1024;
            int fNewPosX2 = fNewPosX1 + this.enemyWidth - 1;
            if (fNewPosX1 < 0) {
                this.fPosX = 0;
                this.fVX = 0;
            } else if (fNewPosX1 + this.enemyWidth >= PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH << 10) {
                this.fPosX = (PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH << 10) - this.enemyWidth;
                this.fVX = 0;
            } else {
                boolean rightCollide = PlatformGameEngine.isCollide(this.fPosX, this.fPosY, fNewPosX1, this.fPosY, 1);
                if (rightCollide) {
                    this.fPosX = PlatformGameEngine.collisionX / 1024 + 1 << 10;
                    this.fVX = 0;
                } else {
                    boolean leftCollide = PlatformGameEngine.isCollide(this.fPosX + this.enemyWidth - 1, this.fPosY, fNewPosX2, this.fPosY, 2);
                    if (leftCollide) {
                        this.fPosX = (PlatformGameEngine.collisionX / 1024 << 10) - this.enemyWidth;
                        this.fVX = 0;
                    } else {
                        this.fPosX = fNewPosX1;
                    }
                }
            }
        }
        if (this.type == 7 || this.type == 8) {
            this.fPosX += this.fVX * delta / 1024;
        }
        if (this.state == 1 && this.type != 2 && this.type != 9) {
            int dir = this.isTurnRight;
            if (dir == 0) {
                dir = -1;
            }
            int fPosX0 = this.fPosX + this.enemyWidth;
            int fPosY0 = this.fPosY + this.enemyHeight;
            int fNewPosX = this.fPosX + dir * 2 * delta;
            int fPosY2 = this.type == 3 || this.type == 6 ? this.fPosY + this.enemyHeight / 4 : this.fPosY + this.enemyHeight / 2;
            int k = 0;
            int collType = 1;
            if (this.isTurnRight == 1) {
                collType = 2;
                k = this.enemyWidth - 1;
            }
            Special s = null;
            boolean isCollide = PlatformGameEngine.isCollide(this.fPosX + k, fPosY2, fNewPosX + k, fPosY2, collType);
            if (isCollide) {
                s = Game.findSpecial(PlatformGameEngine.collisionX / 1024, PlatformGameEngine.collisionY / 1024);
            }
            if (isCollide && (s == null || s.getType() != 10) || this.type != 0 && PlatformGameEngine.isOutOffMapX(fNewPosX + k)) {
                if (this.type != 6 && this.type != 4 && this.type != 5) {
                    this.isTurnRight = this.isTurnRight == 0 ? 1 : 0;
                }
                if (this.type == 3) {
                    newState = 6;
                }
                if (this.type == 6 || this.type == 4 || this.type == 5) {
                    newState = 2;
                }
            } else if (this.type == 0) {
                this.fPosX = fNewPosX;
                if (PlatformGameEngine.isOutOffMapX(this.fPosX) && PlatformGameEngine.isOutOffMapX(this.fPosX + this.enemyWidth)) {
                    this.isAlive = false;
                }
            } else {
                fPosY2 = this.fPosY - 1;
                if (!PlatformGameEngine.isCollide(this.fPosX + k, fPosY2, fNewPosX + k, fPosY2, 3)) {
                    if (this.type != 6 && this.type != 4 && this.type != 5) {
                        this.isTurnRight = this.isTurnRight == 0 ? 1 : 0;
                    }
                    if (this.type == 3) {
                        newState = 6;
                    }
                    if (this.type == 6 || this.type == 4 || this.type == 5) {
                        newState = 2;
                    }
                } else {
                    this.fPosX = fNewPosX;
                }
            }
        }
        if (this.state == 2 && this.type == 9 && this.stateTime > 200) {
            newState = 1;
        }
        if (this.state == 1 && (this.type == 2 || this.type == 9)) {
            x = Game.fPlayerPosX + Game.playerWidth / 2 - (this.fPosX + this.enemyWidth / 2);
            if (!this.isSawPlayer && Math.abs(x / 1024) < 12) {
                this.isSawPlayer = true;
            }
            int time = this.type == 9 ? 100 : 200;
            if (this.isSawPlayer && this.stateTime > time) {
                int minSpeed = 2;
                int maxSpeed = 8;
                if (this.type == 9) {
                    minSpeed = 4;
                    maxSpeed = 10;
                }
                int p = 3;
                int v = Game.sqrtInt(Math.abs(x) * 48 / (2 * p), 0, maxSpeed << 10);
                if ((v *= 32) > maxSpeed << 10) {
                    v = maxSpeed << 10;
                }
                if (v < minSpeed << 10) {
                    v = minSpeed << 10;
                }
                this.fVY = v * p;
                this.fVX = v;
                if (x < 0) {
                    this.fVX = -this.fVX;
                }
                newState = 3;
            }
        }
        if ((this.state == 1 || this.state == 2) && this.type == 6) {
            x = Game.fPlayerPosX + Game.playerWidth / 2 - (this.fPosX + this.enemyWidth / 2);
            if (this.isInTedRange()) {
                newState = 4;
                if (Game.isPlayerOnFloor) {
                    this.isTurnRight = x >= 0 ? 1 : 0;
                }
            }
        }
        if (this.state == 2 && (this.type == 6 || this.type == 4 || this.type == 5) && this.stateTime > 1000) {
            newState = 1;
            this.isTurnRight = this.isTurnRight == 0 ? 1 : 0;
        }
        if (this.state == 4 && this.type == 6) {
            if (this.isInTedRange()) {
                if (Game.isPlayerOnFloor) {
                    if (this.stateTime / 100 % 4 == 3) {
                        Game.hit();
                    }
                } else if (this.stateTime / 100 % 4 == 1 || this.stateTime / 100 % 4 == 2) {
                    Game.hit();
                }
            } else {
                newState = 1;
            }
        }
        if (!(this.state != 1 && this.state != 2 || this.type != 4 && this.type != 5 || Math.abs((x = Game.fPlayerPosX - this.fPosX) / 1024) >= 12 || this.ammoTime > 0)) {
            newState = 4;
        }
        if (this.state == 4 && (this.type == 4 || this.type == 5)) {
            x = Game.fPlayerPosX - this.fPosX;
            this.isTurnRight = x >= 0 ? 1 : 0;
            if (this.stateTime > 600) {
                int ph;
                int pw;
                int vy;
                int vx;
                int maxSpeedY;
                int maxSpeed;
                int particleType;
                int y = Game.fPlayerPosY - this.fPosY;
                int x2 = x + Game.fPlayerVX / 2;
                if (x2 < this.fPosX && x > this.fPosX || x2 > this.fPosX && x < this.fPosX) {
                    x2 = x;
                }
                if (this.type == 4) {
                    particleType = 0;
                    maxSpeed = 10;
                    maxSpeedY = maxSpeed * 2;
                    vx = maxSpeed << 10;
                    if (x < 0) {
                        vx = -vx;
                    }
                    if ((vy = x2 * 48 / (2 * vx) << 10) > maxSpeedY << 10) {
                        vy = maxSpeedY << 10;
                    }
                } else {
                    particleType = 1;
                    maxSpeedY = 13;
                    vy = maxSpeedY << 10;
                    vx = x2 * 48 / (2 * vy) << 10;
                    maxSpeed = 4;
                    if (vx > maxSpeed << 10) {
                        vx = maxSpeed << 10;
                    }
                    if (-vx > maxSpeed << 10) {
                        vx = -maxSpeed << 10;
                    }
                }
                if (this.type == 4) {
                    pw = Particle.getWidth(0, 0);
                    ph = Particle.getHeight(0, 0);
                } else {
                    pw = Particle.getWidth(1, 0);
                    ph = Particle.getHeight(1, 0);
                }
                int posX = this.fPosX + (this.enemyWidth - pw) / 2;
                int posY = this.fPosY + (this.enemyHeight - ph) / 2;
                Game.createParticle(particleType, 0, 4000, posX, posY, vx, vy);
                this.ammoTime = 5000;
                newState = 1;
            }
        }
        if (this.state == 3 && (this.type == 7 || this.type == 8) && this.fPosY < -this.enemyHeight) {
            newState = 2;
        }
        if (this.state == 2 && (this.type == 7 || this.type == 8) && this.stateTime > 1000) {
            this.fPosX = this.fStartPosX;
            this.fPosY = this.fStartPosY;
            this.fVY = 30720;
            this.fVX = this.type == 8 ? -5120 : 0;
            newState = 3;
        }
        if (this.state == 6 && this.stateTime > 200) {
            newState = 1;
        }
        if (this.fVY < 0) {
            fNewPosY = this.fPosY + this.fVY * delta / 1024;
            if (this.type != 7 && this.type != 8) {
                fPosX2 = this.fPosX + this.enemyWidth / 2;
                if (fNewPosY != this.fPosY) {
                    int fZeroPosY = this.fPosY / 1024 << 10;
                    if (fZeroPosY < fNewPosY) {
                        fZeroPosY = this.fPosY;
                    }
                    if (!PlatformGameEngine.isCollide(fPosX2, fZeroPosY - 1, fPosX2, fNewPosY, 3) && !PlatformGameEngine.isOutOffMapX(fPosX2)) {
                        this.fPosY = fNewPosY;
                        newState = 3;
                        if (this.fPosY < -this.enemyHeight) {
                            this.isAlive = false;
                        }
                    } else {
                        this.fPosY = PlatformGameEngine.collisionY / 1024 + 1 << 10;
                        this.fVX = 0;
                        this.fVY = 0;
                        if (this.state == 3) {
                            if (this.type == 0) {
                                Special left = Game.findSpecial((this.fPosX - 1) / 1024, this.fPosY / 1024);
                                Special right = Game.findSpecial((this.fPosX + this.enemyWidth) / 1024, this.fPosY / 1024);
                                this.isTurnRight = left != null && left.getType() == 10 ? 1 : (right != null && right.getType() == 10 ? 0 : MainCanvas.getRandom(0, 1));
                            }
                            if (this.type == 9) {
                                newState = 2;
                                Game.littleShake(200);
                                Game.vibrate(200);
                            } else {
                                newState = 1;
                            }
                        }
                    }
                }
            } else {
                this.fPosY = fNewPosY;
            }
        }
        if (newState != this.state) {
            this.stateTime = 0;
            this.state = newState;
        }
        if (this.ammoTime > 0) {
            this.ammoTime -= delta;
            if (this.ammoTime < 0) {
                this.ammoTime = 0;
            }
        }
    }

    public void paint(Graphics g) {
        int animNumber;
        if (!this.isAlive) {
            return;
        }
        int x = this.fPosX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = this.fPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 320 - yr - this.enemyHeightInPixels + 1;
        if (x + this.enemyWidthInPixels <= 0 || y + this.enemyHeightInPixels <= 0 || x >= 240 || y >= 320) {
            return;
        }
        int frameDelay = 100;
        int animType = 0;
        if (this.state == 1) {
            if (this.type == 0 || this.type == 1 || this.type == 2) {
                animNumber = 0;
            } else if (this.type == 3) {
                frameDelay = 200;
                animNumber = this.state == 6 ? 4 : this.isTurnRight;
            } else {
                animNumber = this.type == 9 ? 3 : this.isTurnRight;
            }
        } else if (this.state == 3) {
            animNumber = this.type == 2 ? 2 : (this.type == 7 || this.type == 8 ? (this.fVY > 0 ? (this.fVY > 2 * Math.abs(this.fVX) ? 2 : (this.fVY > Math.abs(this.fVX) ? 3 : 0)) : (-this.fVY > 2 * Math.abs(this.fVX) ? 1 : (-this.fVY > Math.abs(this.fVX) ? 4 : 0))) : (this.type == 9 ? (this.fVY > 0 ? 1 : 2) : 0));
            animType = 1;
        } else if (this.state == 7) {
            animNumber = this.type == 0 || this.type == 1 || this.type == 2 ? 1 : (this.type == 7 || this.type == 8 ? 5 : (this.type == 9 ? 4 : 2 + this.isTurnRight));
        } else if (this.state == 2) {
            animNumber = this.type == 9 ? 0 : 4 + this.isTurnRight;
        } else if (this.state == 4) {
            if (this.type == 4 || this.type == 5) {
                frameDelay = 150;
                animType = 1;
            }
            animNumber = 6 + this.isTurnRight;
        } else {
            animNumber = 0;
        }
        this.anim.paintAnimation(animNumber, this.anim.correctFrame(animNumber, this.stateTime / frameDelay, animType), x, y, false, g);
    }
}

