/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Special {
    public static final int TYPE_SPRING_LEFT = 0;
    public static final int TYPE_SPRING_UP = 1;
    public static final int TYPE_SPRING_MEGA_UP = 2;
    public static final int TYPE_SPRING_RIGHT = 3;
    public static final int TYPE_TRAP = 4;
    public static final int TYPE_BOX = 5;
    public static final int TYPE_BOX_TNT = 6;
    public static final int TYPE_WOODEN_BOARD = 7;
    public static final int TYPE_KEY = 8;
    public static final int TYPE_DETONATOR = 9;
    public static final int TYPE_STONE = 10;
    public static final int TYPE_COIN = 11;
    public static final int TYPE_BILLY = 12;
    public static final int TYPE_CAGE_AND_FLAXY = 13;
    public static final int TYPE_BIRD = 14;
    public static final int TYPE_SPRING_SMALL_UP = 15;
    public static final int TYPE_NUM = 16;
    private int type;
    private int fPosX;
    private int fPosY;
    private int cellX;
    private int cellY;
    private int width;
    private int height;
    private int isActive;
    private int stateTime;
    private boolean isAlive = true;
    private GameAnimation anim;
    private int specialWidthInPixels;
    private int specialHeightInPixels;
    private int specialHeight;
    private int specialWidth;
    private boolean isKeyMovable;
    private static int FALLING_LEFT = 1;
    private static int FALLING_RIGHT = 2;
    private int fallingDir;
    private int fallingDelay;
    private int fVY;
    private boolean isFalling;
    private int isStonePrevActive;
    private boolean isStonePrevFalling;
    private int bouncingNum;
    private int flaxyWidthInPixels;
    private int flaxyHeightInPixels;
    private int flaxyWidth;
    private int flaxyHeight;
    private int fFlaxyPosX;
    private int fFlaxyPosY;
    private boolean isLanding;
    private int fLandingPosX;
    private int fLandingPosY;
    private Special billy;
    private boolean isLanded;
    private boolean isDisarmed;
    private int dir;
    private int bubbleTime;

    public Special(int _type, int _cellX, int _cellY, int _fPosX, int _fPosY, GameAnimation _anim) {
        this.type = _type;
        this.cellX = _cellX;
        this.cellY = _cellY;
        this.fPosX = _fPosX;
        this.fPosY = _fPosY;
        this.anim = _anim;
        this.specialWidthInPixels = this.anim.getWidth();
        this.specialHeightInPixels = this.anim.getHeight();
        this.specialWidth = (this.specialWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
        this.specialHeight = (this.specialHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        if (_type == 5 || _type == 10 || _type == 6 || _type == 9) {
            for (int i = 0; i < 4; ++i) {
                PlatformGameEngine.setCollision(_cellX, _cellY, i, true);
            }
        }
        if (_type == 7) {
            PlatformGameEngine.setCollision(_cellX, _cellY, 3, true);
        }
        if (_type == 13) {
            this.flaxyWidthInPixels = Game.flaxyAnim.getWidth();
            this.flaxyHeightInPixels = Game.flaxyAnim.getHeight();
            this.flaxyWidth = (this.flaxyWidthInPixels << 10) / PlatformGameEngine.sectorWidth;
            this.flaxyHeight = (this.flaxyHeightInPixels << 10) / PlatformGameEngine.sectorHeight;
        }
        if (_type == 14) {
            this.dir = MainCanvas.getRandom(-1, 1);
        }
        if (_type == 8) {
            this.bouncingNum = 3;
        }
        if (_type == 11) {
            this.fPosY += 256;
        }
    }

    public void close() {
        if (this.type == 10) {
            if (this.isFalling) {
                this.setFallingCollisionOff();
            }
            if (this.isActive == 1) {
                int x = this.fPosX / 1024;
                for (int i = 0; i < 4; ++i) {
                    PlatformGameEngine.setCollision(x, this.cellY, i, false);
                    if (x << 10 == this.fPosX) continue;
                    PlatformGameEngine.setCollision(x + 1, this.cellY, i, false);
                }
            }
            for (int i = 0; i < 4; ++i) {
                PlatformGameEngine.setCollision(this.cellX, this.cellY, i, false);
            }
        }
    }

    public final void setfPos(int x, int y) {
        this.fPosX = x;
        this.fPosY = y;
        this.cellX = x / 1024;
        this.cellY = y / 1024;
    }

    public final void setKeyMovable(boolean movable) {
        this.isKeyMovable = movable;
    }

    public final int getType() {
        return this.type;
    }

    public final int getCellX() {
        return this.cellX;
    }

    public final int getCellY() {
        return this.cellY;
    }

    public final int getfPosX() {
        return this.fPosX;
    }

    public final int getfPosY() {
        return this.fPosY;
    }

    public final int getWidth() {
        return this.specialWidth;
    }

    public final int getHeight() {
        return this.specialHeight;
    }

    public final boolean isAlive() {
        return this.isAlive;
    }

    public final boolean isMoving() {
        return this.type == 10 && (this.isActive == 1 || this.isFalling);
    }

    public final boolean wasMoving() {
        return this.type == 10 && (this.isStonePrevActive == 1 || this.isStonePrevFalling);
    }

    public boolean canKill() {
        return this.type == 10 && (this.isFalling || this.isActive == 1);
    }

    public boolean isKill(int x1, int y1, int x2, int y2) {
        if (this.type == 10) {
            if (this.isFalling || this.isActive == 1) {
                int xc = (x2 + x1) / 2;
                x1 = xc - 5;
                x2 = xc + 5 - 1;
                int specialX1 = this.fPosX;
                int specialY1 = this.fPosY;
                int specialX2 = this.fPosX + this.specialWidth - 1;
                int specialY2 = this.fPosY + this.specialHeight - 1;
                if (PlatformGameEngine.isPointInRect(x1, y1, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x2, y1, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x2, y2, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x1, y2, specialX1, specialY1, specialX2, specialY2)) {
                    if (this.isFalling) {
                        int y = Game.fPlayerPosY - this.fPosY;
                        return y <= 0;
                    }
                    if (this.isActive == 1) {
                        int x = Game.fPlayerPosX - this.fPosX;
                        if (this.fallingDir == FALLING_RIGHT && x > 0) {
                            return true;
                        }
                        return this.fallingDir == FALLING_LEFT && x < 0;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public boolean collideConfirm(int x1, int y1, int x2, int y2) {
        if (this.type == 1 || this.type == 2 || this.type == 15) {
            int specialX1 = this.fPosX + this.specialWidth / 6;
            int specialY1 = this.fPosY;
            int specialX2 = this.fPosX + this.specialWidth * 5 / 6;
            int specialY2 = this.fPosY + this.specialHeight / 4;
            return PlatformGameEngine.isPointInRect(x1, y1, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x2, y1, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x2, y2, specialX1, specialY1, specialX2, specialY2) || PlatformGameEngine.isPointInRect(x1, y2, specialX1, specialY1, specialX2, specialY2);
        }
        if (this.type == 0) {
            int x = x1 - this.fPosX;
            int y = y1 - this.fPosY;
            return x >= y;
        }
        if (this.type == 3) {
            int x = x1 - this.fPosX;
            int y = y1 - this.fPosY;
            return this.specialWidth - x >= y;
        }
        if (this.type == 13) {
            int specialX1 = this.fPosX;
            int specialY1 = this.fPosY;
            int specialX2 = this.fPosX + this.specialWidth;
            int specialY2 = this.fPosY + this.specialHeight;
            return PlatformGameEngine.isPointInRect((x1 + x2) / 2, (y1 + y2) / 2, specialX1, specialY1, specialX2, specialY2);
        }
        if (this.type == 9) {
            if (Game.fPlayerVY > 0) {
                return false;
            }
            int specialX1 = this.fPosX;
            int specialY1 = this.fPosY;
            int specialX2 = this.fPosX + this.specialWidth;
            int specialY2 = this.fPosY + this.specialHeight;
            return PlatformGameEngine.isPointInRect((x1 + x2) / 2, y1, specialX1, specialY1, specialX2, specialY2);
        }
        return true;
    }

    private void destroyBox() {
        int v = 5120;
        for (int i = 0; i < 4; ++i) {
            PlatformGameEngine.setCollision(this.cellX, this.cellY, i, false);
        }
        if (this.type == 5) {
            Game.createParticle(2, 0, 3000, this.fPosX, this.fPosY, -v, v * 3);
            Game.createParticle(2, 1, 3000, this.fPosX, this.fPosY, -v, v * 2);
            Game.createParticle(2, 2, 3000, this.fPosX, this.fPosY, v, v * 3);
            Game.createParticle(2, 3, 3000, this.fPosX, this.fPosY, v, v * 2);
        } else {
            Game.createParticle(2, 0, 3000, this.fPosX, this.fPosY, -v, v);
            Game.createParticle(2, 1, 3000, this.fPosX, this.fPosY, -v, -v);
            Game.createParticle(2, 2, 3000, this.fPosX, this.fPosY, v, v);
            Game.createParticle(2, 3, 3000, this.fPosX, this.fPosY, v, -v);
        }
    }

    private void setFallingCollisionOff() {
        int y = this.fPosY / 1024;
        for (int i = 0; i < 4; ++i) {
            PlatformGameEngine.setCollision(this.cellX, y, i, false);
            if (y << 10 >= this.fPosY) continue;
            PlatformGameEngine.setCollision(this.cellX, y + 1, i, false);
        }
    }

    private void setFallingCollisionOn() {
        int y = this.fPosY / 1024;
        PlatformGameEngine.setCollision(this.cellX, y, 2, true);
        PlatformGameEngine.setCollision(this.cellX, y, 1, true);
        if (y << 10 < this.fPosY) {
            PlatformGameEngine.setCollision(this.cellX, y + 1, 2, true);
            PlatformGameEngine.setCollision(this.cellX, y + 1, 1, true);
            PlatformGameEngine.setCollision(this.cellX, y + 1, 3, true);
        } else {
            PlatformGameEngine.setCollision(this.cellX, y, 3, true);
        }
    }

    public void update(int delta) {
        int tntTime;
        if (!this.isAlive) {
            return;
        }
        this.stateTime += delta;
        this.bubbleTime -= delta;
        if (this.bubbleTime < 0) {
            this.bubbleTime = 0;
        }
        if (this.type != 10 && this.type != 7 && this.type != 14 && this.type != 9 && this.type != 13 && this.type != 12 && this.isActive == 1 && this.stateTime > 1000) {
            this.isActive = 0;
        }
        if (this.type == 10) {
            this.isStonePrevFalling = this.isFalling;
            if (this.isActive == 0) {
                if (this.fallingDelay > 0) {
                    this.fallingDelay -= delta;
                    if (this.fallingDelay <= 0) {
                        this.fallingDelay = -1;
                    }
                } else {
                    this.fVY -= 48 * delta;
                    if (-this.fVY > 10240) {
                        this.fVY = -10240;
                    }
                    int fPosX2 = this.fPosX + this.specialWidth / 2;
                    int fNewPosY = this.fPosY + this.fVY * delta / 1024;
                    if (fNewPosY != this.fPosY) {
                        int newCellY = fNewPosY / 1024;
                        if (PlatformGameEngine.isCollide(fPosX2, this.fPosY - 1, fPosX2, fNewPosY, 3)) {
                            int i;
                            if (this.isFalling) {
                                int cellY2 = PlatformGameEngine.collisionY / 1024;
                                Special s = Game.findSpecial(this.cellX, cellY2);
                                if (s != null && s.getType() == 7) {
                                    this.setFallingCollisionOff();
                                    this.fPosY = fNewPosY;
                                    this.setFallingCollisionOn();
                                    for (i = -1; i <= 1; ++i) {
                                        s = Game.findSpecial(this.cellX + i, cellY2);
                                        if (s == null || s.getType() != 7) continue;
                                        for (int j = 0; j < 4; ++j) {
                                            PlatformGameEngine.setCollision(this.cellX + i, cellY2, j, false);
                                        }
                                        s.activate(false);
                                    }
                                } else {
                                    this.setFallingCollisionOff();
                                    this.fPosY = PlatformGameEngine.collisionY / 1024 + 1 << 10;
                                    this.cellY = this.fPosY / 1024;
                                    this.fVY = 0;
                                    for (i = 0; i < 4; ++i) {
                                        PlatformGameEngine.setCollision(this.cellX, this.cellY, i, true);
                                    }
                                    this.isFalling = false;
                                }
                            } else {
                                Special under;
                                this.fallingDelay = 0;
                                this.fVY = 0;
                                Special over = Game.findSpecial(this.cellX, this.cellY + 1);
                                if ((over == null || over.getType() != 10) && (under = Game.findSpecial(this.cellX, this.cellY - 1)) != null && under.getType() == 10) {
                                    if (this.cellX > 0 && !PlatformGameEngine.isPointCollide(this.cellX - 1 << 10, this.cellY << 10, 1) && !PlatformGameEngine.isPointCollide(this.cellX - 1 << 10, this.cellY - 1 << 10, 3)) {
                                        this.isActive = 1;
                                        this.fallingDir = FALLING_LEFT;
                                        for (i = 0; i < 4; ++i) {
                                            PlatformGameEngine.setCollision(this.cellX - 1, this.cellY, i, true);
                                        }
                                    } else if (this.cellX < PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH - 1 && !PlatformGameEngine.isPointCollide(this.cellX + 1 << 10, this.cellY << 10, 2) && !PlatformGameEngine.isPointCollide(this.cellX + 1 << 10, this.cellY - 1 << 10, 3)) {
                                        this.isActive = 1;
                                        this.fallingDir = FALLING_RIGHT;
                                        for (i = 0; i < 4; ++i) {
                                            PlatformGameEngine.setCollision(this.cellX + 1, this.cellY, i, true);
                                        }
                                    }
                                }
                            }
                        } else if (!this.isFalling) {
                            if (this.isStonePrevActive == 0 && this.fallingDelay != -1) {
                                this.fallingDelay = 333;
                                this.fVY = 0;
                            } else {
                                this.fallingDelay = 0;
                                for (int i = 0; i < 4; ++i) {
                                    PlatformGameEngine.setCollision(this.cellX, this.cellY, i, false);
                                }
                                this.fPosY = fNewPosY;
                                this.setFallingCollisionOn();
                                this.isFalling = true;
                            }
                        } else {
                            this.setFallingCollisionOff();
                            this.fPosY = fNewPosY;
                            if (this.fPosY < -this.specialHeight) {
                                this.isAlive = false;
                            } else {
                                this.setFallingCollisionOn();
                            }
                        }
                    } else {
                        this.isFalling = false;
                    }
                }
            }
            this.isStonePrevActive = this.isActive;
            if (this.isActive == 1) {
                int i;
                int i2;
                int stoneSpeed = 5;
                if (this.fallingDir == FALLING_RIGHT) {
                    this.fPosX += stoneSpeed * delta;
                    if (this.fPosX >= this.cellX + 1 << 10) {
                        for (i2 = 0; i2 < 4; ++i2) {
                            PlatformGameEngine.setCollision(this.cellX, this.cellY, i2, false);
                        }
                        ++this.cellX;
                        this.fPosX = this.cellX << 10;
                        this.isActive = 0;
                        Special under = Game.findSpecial(this.cellX, this.cellY - 1);
                        if (under != null && under.getType() == 10 && this.cellX < PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH - 1 && !PlatformGameEngine.isPointCollide(this.cellX + 1 << 10, this.cellY << 10, 2) && !PlatformGameEngine.isPointCollide(this.cellX + 1 << 10, this.cellY - 1 << 10, 3)) {
                            this.isActive = 1;
                            this.fallingDir = FALLING_RIGHT;
                            for (i = 0; i < 4; ++i) {
                                PlatformGameEngine.setCollision(this.cellX + 1, this.cellY, i, true);
                            }
                        }
                    }
                }
                if (this.fallingDir == FALLING_LEFT) {
                    this.fPosX -= stoneSpeed * delta;
                    if (this.fPosX <= this.cellX - 1 << 10 || this.fPosX < 0) {
                        for (i2 = 0; i2 < 4; ++i2) {
                            PlatformGameEngine.setCollision(this.cellX, this.cellY, i2, false);
                        }
                        --this.cellX;
                        this.fPosX = this.cellX << 10;
                        this.isActive = 0;
                        Special under = Game.findSpecial(this.cellX, this.cellY - 1);
                        if (under != null && under.getType() == 10 && this.cellX > 0 && !PlatformGameEngine.isPointCollide(this.cellX - 1 << 10, this.cellY << 10, 1) && !PlatformGameEngine.isPointCollide(this.cellX - 1 << 10, this.cellY - 1 << 10, 3)) {
                            this.isActive = 1;
                            this.fallingDir = FALLING_LEFT;
                            for (i = 0; i < 4; ++i) {
                                PlatformGameEngine.setCollision(this.cellX - 1, this.cellY, i, true);
                            }
                        }
                    }
                }
            }
        }
        if (this.type == 7 && this.isActive == 1) {
            this.fVY -= 48 * delta;
            if (-this.fVY > 10240) {
                this.fVY = -10240;
            }
            this.fPosY += this.fVY * delta / 1024;
            if (this.fPosY < -this.specialHeight) {
                this.isAlive = false;
            }
        }
        if (this.type == 8 && this.isKeyMovable) {
            int fNewPosY;
            this.fVY -= 48 * delta;
            if (-this.fVY > 10240) {
                this.fVY = -10240;
            }
            if (PlatformGameEngine.isCollide(this.fPosX + this.specialWidth / 2, this.fPosY, this.fPosX + this.specialWidth / 2, fNewPosY = this.fPosY + this.fVY * delta / 1024, 3)) {
                this.fPosY = PlatformGameEngine.collisionY / 1024 + 1 << 10;
                if (this.bouncingNum > 0) {
                    this.fVY = -this.fVY * 3 / 4;
                    --this.bouncingNum;
                }
            } else {
                this.fPosY = fNewPosY;
            }
        }
        if (this.type == 9 && this.isActive == 1 && !this.isDisarmed && this.stateTime > (tntTime = 1000)) {
            boolean isNext = Game.detonate();
            this.stateTime -= tntTime;
            if (!isNext) {
                this.isDisarmed = true;
            }
        }
        if (this.type == 13 && this.isActive == 1) {
            int y;
            int x;
            if (this.isLanding) {
                x = this.fLandingPosX - this.fFlaxyPosX;
                y = this.fLandingPosY - this.fFlaxyPosY;
                if (Math.abs(x) < 128 && Math.abs(y) < 128) {
                    this.isLanded = true;
                    this.billy.activate(false);
                }
                this.fFlaxyPosX += x * delta / 1024;
                this.fFlaxyPosY += y * delta / 1024;
            } else {
                for (int i = -1; i <= 1; ++i) {
                    for (int j = -2; j <= 0; ++j) {
                        Special s = Game.findSpecial(this.fFlaxyPosX / 1024 + i, this.fFlaxyPosY / 1024 + j);
                        if (s == null || s.getType() != 12) continue;
                        this.isLanding = true;
                        this.billy = s;
                        this.fLandingPosX = s.getfPosX();
                        this.fLandingPosY = s.getfPosY() + 1024;
                    }
                }
                if (!this.isLanding) {
                    x = Game.fPlayerPosX + Game.playerWidth / 2 - (this.fFlaxyPosX + this.flaxyWidth / 2);
                    y = Game.fPlayerPosY + Game.playerHeight / 2 + 2048 - (this.fFlaxyPosY + this.flaxyHeight / 2);
                    this.fFlaxyPosX += x * delta / 1024;
                    this.fFlaxyPosY += y * delta / 1024;
                }
            }
        }
        if (this.type == 14) {
            if (this.isActive == 1) {
                this.fPosX += this.dir * 5 * delta;
                this.fPosY += 5 * delta;
            } else {
                int turnTime = 500;
                if (this.stateTime > turnTime) {
                    this.stateTime -= turnTime;
                    if (MainCanvas.getRandom(0, 3) == 0) {
                        this.dir = MainCanvas.getRandom(-1, 1);
                    }
                }
            }
        }
    }

    public boolean canBeActivatedFromCollision() {
        return this.type == 5 || this.type == 10;
    }

    public void activateFromCollision(int collType) {
        if (this.type == 5 && collType == 0) {
            this.isAlive = false;
            this.destroyBox();
        }
        if (this.type == 10 && Game.isPlayerOnFloor && !this.isMoving()) {
            int i;
            if (collType == 2 && this.cellX < PlatformGameEngine.levelWidth * PlatformGameEngine.BOARD_WIDTH - 1 && !PlatformGameEngine.isPointCollide(this.cellX + 1 << 10, this.cellY << 10, 2)) {
                this.isActive = 1;
                this.stateTime = 0;
                this.fallingDir = FALLING_RIGHT;
                for (i = 0; i < 4; ++i) {
                    PlatformGameEngine.setCollision(this.cellX + 1, this.cellY, i, true);
                }
            }
            if (collType == 1 && this.cellX > 0 && !PlatformGameEngine.isPointCollide(this.cellX - 1 << 10, this.cellY << 10, 1)) {
                this.isActive = 1;
                this.stateTime = 0;
                this.fallingDir = FALLING_LEFT;
                for (i = 0; i < 4; ++i) {
                    PlatformGameEngine.setCollision(this.cellX - 1, this.cellY, i, true);
                }
            }
        }
    }

    public boolean canBeActivatedByPlayer() {
        return this.type != 5 && this.type != 10 && this.type != 6 && this.type != 7;
    }

    public void activate(boolean byPlayer) {
        if (this.isActive == 1) {
            return;
        }
        if (this.type == 11) {
            Game.giveCoin();
            this.isAlive = false;
            Game.giveScore(100, this.fPosX, this.fPosY, this.specialWidth, this.specialHeight);
        }
        if (this.type == 8) {
            Game.giveKey(this.fPosX, this.fPosY, this.width, this.height);
            this.isAlive = false;
        }
        if (this.type == 15) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.fPlayerVY = 49152;
        }
        if (this.type == 1) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.fPlayerVY = 63488;
        }
        if (this.type == 2) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.fPlayerVY = 90112;
        }
        if (this.type == 3) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.fPlayerVX = 30720;
            Game.fPlayerVY = 30720;
        }
        if (this.type == 0) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.fPlayerVX = -38912;
            Game.fPlayerVY = 38912;
        }
        if (this.type == 4) {
            this.isActive = 1;
            this.stateTime = 0;
            Game.hit();
        }
        if (this.type == 7 && !byPlayer) {
            this.isActive = 1;
            this.stateTime = 0;
        }
        if (this.type == 9) {
            this.isActive = 1;
            this.stateTime = 0;
            boolean isNext = Game.detonate();
            if (!isNext) {
                this.isDisarmed = true;
            }
        }
        if (this.type == 6 && !byPlayer) {
            int i;
            this.destroyBox();
            Special[] s = Game.findSpecialGroup(this.cellX, this.cellY);
            for (i = 0; i < s.length && s[i] != null; ++i) {
                if (s[i].getType() != 7) continue;
                for (int k = 0; k < 4; ++k) {
                    PlatformGameEngine.setCollision(s[i].getCellX(), s[i].getCellY(), k, false);
                }
                s[i].activate(false);
            }
            for (i = 0; i < s.length; ++i) {
                s[i] = null;
            }
            s = null;
            int explosionTime = 1000;
            Game.createParticle(3, 0, explosionTime, this.fPosX + (this.specialWidth - Particle.getWidth(3, 0)) / 2, this.fPosY + (this.specialHeight - Particle.getHeight(3, 0)) / 2, 0, 0);
            Game.shake(explosionTime);
            this.isAlive = false;
        }
        if (this.type == 13) {
            this.isActive = 1;
            this.fFlaxyPosX = this.fPosX + (this.specialWidth - this.flaxyWidth) / 2;
            this.fFlaxyPosY = this.fPosY + (this.specialHeight - this.flaxyHeight) / 2;
            this.bubbleTime = 2000;
        }
        if (this.type == 12) {
            if (byPlayer) {
                if (this.isActive == 0) {
                    if (this.bubbleTime == 0) {
                        this.bubbleTime = 2000;
                    } else if (this.bubbleTime < 1000) {
                        this.bubbleTime = 1000;
                    }
                }
            } else {
                this.isActive = 1;
                Game.giveScore(2000, this.fPosX, this.fPosY, this.specialWidth, this.specialHeight);
            }
        }
        if (this.type == 14) {
            this.isActive = 1;
        }
    }

    public void paint(Graphics g) {
        if (!this.isAlive) {
            return;
        }
        int x = this.fPosX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
        int yr = this.fPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
        int y = 320 - yr - this.specialHeightInPixels + 1;
        if (x + this.specialWidthInPixels > 0 && y + this.specialHeightInPixels > 0 && x < 240 && y < 320) {
            int animType = 0;
            int animNumber = this.isActive;
            int offset = 0;
            if (this.type == 0 || this.type == 1 || this.type == 15 || this.type == 2 || this.type == 3) {
                animNumber = this.type * 2 + this.isActive;
                if (this.type > 1) {
                    animNumber -= 2;
                }
                if (this.type == 15) {
                    animNumber = 2 + this.isActive;
                }
            }
            if (this.type == 14) {
                animNumber = this.isActive == 1 ? 3 : this.dir + 1;
                offset = this.specialHeightInPixels / 4;
            }
            this.anim.paintAnimation(animNumber, this.anim.correctFrame(animNumber, this.stateTime / 100, animType), x, y + offset, false, g);
        }
        if (this.type == 13 && this.isActive == 1 && !this.isLanded) {
            x = this.fFlaxyPosX * PlatformGameEngine.sectorWidth / 1024 - PlatformGameEngine.screenPositionX;
            yr = this.fFlaxyPosY * PlatformGameEngine.sectorHeight / 1024 - PlatformGameEngine.screenPositionY;
            y = 320 - yr - this.flaxyHeightInPixels + 1;
            int animNumber = 1;
            Game.flaxyAnim.paintAnimation(animNumber, Game.flaxyAnim.correctFrame(animNumber, this.stateTime / 50, 0), x, y, true, g);
        }
        if (this.bubbleTime > 0) {
            int posX = this.fPosX + this.specialWidth / 2;
            int posY = this.fPosY + this.specialHeight;
            int n = 0;
            if (this.type == 12) {
                n = 5;
            }
            if (this.type == 13) {
                posX = this.fFlaxyPosX + this.specialWidth / 2;
                posY = this.fFlaxyPosY + this.specialHeight;
                n = 4;
            }
            Game.paintBubble(posX, posY, n, this.bubbleTime, g);
        }
    }
}

