/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemies {
    public static final byte BLOB = 2;
    public static final byte BLUE_BUG = 8;
    public static final byte BUG = 4;
    public static final byte CASTING = 4;
    public static final byte DYING = 3;
    public static final byte FACE_DOWN = 0;
    public static final byte FACE_LEFT = 1;
    public static final byte FACE_RIGHT = 3;
    public static final byte FACE_UP = 2;
    public static final byte FROZEN = 5;
    public static final byte GHOST = 1;
    public static final byte IMMOBILE = 1;
    public static final byte MAGE = 5;
    public static final byte MOVING = 0;
    public static final byte NONE = 0;
    public static final byte NORMAL = 6;
    public static final byte NO_FACE = -1;
    public static final byte PLAYER = 6;
    public static final int[] STEPS5 = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
    public static final byte THINKING = 2;
    public static final byte TROLL = 3;
    public static final byte YETI = 7;
    int activeEnemies;
    Image blobDIm;
    Image blobIm;
    Image bugIm;
    Image bugbIm;
    private Enemy[] _$459;
    public static final byte[] enemyHits;
    public static final int[] enemyPoints;
    public static final byte[] enemySpeeds;
    int firstEmpty;
    Image ghostDIm;
    Image ghostIm;
    Image mageIm;
    int numEnemies;
    public Player player;
    public Playfield playfield;
    private Random _$780 = new Random();
    Image trollDIm;
    Image trollIm;
    Image yetiDIm;
    Image yetiIm;

    static {
        enemySpeeds = new byte[]{0, 4, 2, 3, 1, 2, 0, 3, 2};
        enemyHits = new byte[]{0, 1, 1, 3, 3, 1, 0, 3, 1};
        enemyPoints = new int[]{0, 7, 5, 30, 8, 20, 0, 20, 10};
    }

    public Enemies(int n) {
        this.numEnemies = n;
        this._$459 = new Enemy[n];
        int n2 = 0;
        while (n2 < n) {
            this._$459[n2] = new Enemy();
            ++n2;
        }
        this.reset();
        this.blobIm = GameMidlet.getImage("enemy6");
        this.ghostIm = GameMidlet.getImage("enemy4");
        this.bugIm = GameMidlet.getImage("enemy3");
        this.bugbIm = GameMidlet.getImage("enemy2");
        this.mageIm = GameMidlet.getImage("enemy1");
        this.trollIm = GameMidlet.getImage("enemy7");
        this.yetiIm = GameMidlet.getImage("enemy5");
        this.yetiDIm = GameMidlet.getImage("enemy52");
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, int n3, byte by8, int n4, boolean bl) {
        int n5 = this.firstEmpty;
        while (n5 < this.numEnemies) {
            if (this._$459[n5].type == 0) break;
            ++n5;
        }
        if (n5 == this.numEnemies) {
            return -1;
        }
        this._$459[n5].type = by;
        this._$459[n5].x = n;
        this._$459[n5].y = n2;
        this._$459[n5].face = by2;
        this._$459[n5].state = by3;
        this._$459[n5].speed = by4;
        this._$459[n5].step = by5;
        this._$459[n5].mode = by6;
        this._$459[n5].hits = by7;
        this._$459[n5].span = n3;
        this._$459[n5].invinc = by8;
        this._$459[n5].power = n4;
        this._$459[n5].immaterial = bl;
        this.firstEmpty = n5;
        return n5;
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, int n3) {
        return this.addEnemy(by, n * 32, n2 * 32, by2, by3, enemySpeeds[by], (byte)0, (byte)6, enemyHits[by], 0, (byte)0, 0, false);
    }

    byte canISeeThePlayer(int n, int n2) {
        if (this.player.mode == 2) {
            return -1;
        }
        if (this.player.fx == n) {
            if (this.player.fy == n2) {
                return -1;
            }
            int n3 = this.player.fy;
            int n4 = n2;
            byte by = 2;
            if (this.player.fy > n2) {
                n4 = n3;
                n3 = n2;
                by = 0;
            }
            int n5 = n3;
            while (n5 <= n4) {
                if (!this.playfield.isPassable(n, n5, -1)) {
                    return -1;
                }
                ++n5;
            }
            return by;
        }
        if (this.player.fy == n2) {
            int n6 = this.player.fx;
            int n7 = n;
            byte by = 1;
            if (this.player.fx > n) {
                n7 = n6;
                n6 = n;
                by = 3;
            }
            int n8 = n6;
            while (n8 <= n7) {
                if (!this.playfield.isPassable(n8, n2, -1)) {
                    return -1;
                }
                ++n8;
            }
            return by;
        }
        return -1;
    }

    boolean canMove(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 == -1) {
            return false;
        }
        int n6 = n3 == 1 ? -1 : (n5 = n3 == 3 ? 1 : 0);
        int n7 = n3 == 2 ? -1 : (n3 == 0 ? 1 : 0);
        return this.playfield.isPassable(n + n5, n2 + n7, n4) && !this.playfield.isOccupied(n + n5, n2 + n7);
    }

    public void decode(String string) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        try {
            int n3 = string.indexOf(44);
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(0, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1, n4));
            by = (byte)Integer.parseInt(string.substring(n4 + 1));
        }
        catch (Exception exception) {
            System.err.println("Enemies.decode");
            exception.printStackTrace();
        }
        if (by == 6) {
            this.player.startX = n * 32;
            this.player.startY = n2 * 32;
            return;
        }
        this.addEnemy(by, n, n2, (byte)0, (byte)2, 0);
    }

    private byte _$795(byte by) {
        if (by == 0) {
            return 3;
        }
        return (byte)(by - 1);
    }

    private byte _$796(byte by) {
        if (by == 3) {
            return 0;
        }
        return (byte)(by + 1);
    }

    byte getRandomStrollDirection(int n, int n2, byte by, boolean bl) {
        int n3 = Math.abs(this._$780.nextInt()) % 2 == 0 ? 1 : -1;
        boolean[] blArray = new boolean[]{this.canMove(n, n2, by, -1), this.canMove(n, n2, this.turn(by, n3), -1), this.canMove(n, n2, this.turn(by, -n3), -1), this.canMove(n, n2, this.turn(by, 2), -1)};
        if (!blArray[0]) {
            if (!blArray[1]) {
                if (!blArray[2]) {
                    if (!blArray[3]) {
                        return -1;
                    }
                    return this.turn(by, 2);
                }
                return this.turn(by, -n3);
            }
            return this.turn(by, n3);
        }
        if (!bl) {
            return by;
        }
        if (blArray[1] && Math.abs(this._$780.nextInt()) % 4 == 0) {
            return this.turn(by, n3);
        }
        if (blArray[2] && Math.abs(this._$780.nextInt()) % 4 == 0) {
            return this.turn(by, -n3);
        }
        return by;
    }

    private void _$800(int n) {
        this._$459[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    public void reset() {
        int n = 0;
        while (n < this.numEnemies) {
            this._$459[n].type = 0;
            ++n;
        }
        this.activeEnemies = 0;
        this.firstEmpty = 0;
    }

    byte turn(byte by, int n) {
        if ((by = (byte)(by + n)) > 3) {
            by = (byte)(by - 4);
        }
        if (by < 0) {
            by = (byte)(by + 4);
        }
        return by;
    }

    public int update() {
        int n = 0;
        int n2 = 16;
        int n3 = 0;
        while (n3 < this.numEnemies) {
            if (this._$459[n3].type != 0) {
                int n4;
                int n5;
                int n6;
                ++n;
                Enemy enemy = this._$459[n3];
                int n7 = this.playfield.getGridX(enemy.x + n2);
                int n8 = this.playfield.getGridY(enemy.y + n2);
                int n9 = (enemy.x + n2) % 32;
                int n10 = (enemy.y + n2) % 32;
                if (enemy.invinc > 0) {
                    enemy.invinc = (byte)(enemy.invinc - 1);
                }
                if (enemy.state != 3) {
                    if (n7 == this.player.fx && n8 == this.player.fy && this.player.mode != 1 && this.player.mode != 2 && !GameMidlet.instance.menuScreen.gameScreen.godmode) {
                        this.player.kill();
                    }
                    if ((n6 = this.playfield.passThrough(n7, n8, false)) == 10 && enemy.invinc == 0) {
                        if (enemy.type == 7) {
                            if (enemy.mode == 5) {
                                enemy.state = (byte)3;
                                enemy.mode = (byte)6;
                                this.player.givePoints(enemyPoints[enemy.type]);
                                enemy.span = 1;
                            } else {
                                enemy.mode = (byte)5;
                                enemy.step = (byte)70;
                            }
                        } else {
                            enemy.hits = (byte)(enemy.hits - 1);
                        }
                        enemy.invinc = (byte)15;
                        if (enemy.hits == 0) {
                            enemy.state = (byte)3;
                            this.player.givePoints(enemyPoints[enemy.type]);
                            enemy.span = 0;
                        }
                    }
                }
                if (enemy.type == 1) {
                    enemy.step = (byte)(enemy.step + 1);
                    if (enemy.step == 8) {
                        enemy.step = 0;
                    }
                    if (enemy.state == 2) {
                        if (this.canMove(n7, n8, enemy.face, n3)) {
                            enemy.state = 0;
                            enemy.span = 32;
                        } else {
                            enemy.face = this.getRandomStrollDirection(n7, n8, enemy.face, true);
                        }
                    }
                } else if (enemy.type == 3) {
                    if (enemy.state == 2) {
                        enemy.speed = (byte)(6 - enemy.hits);
                        n6 = this.getRandomStrollDirection(n7, n8, enemy.face, true);
                        if (n6 != -1) {
                            enemy.face = n6;
                            enemy.state = 0;
                            enemy.span = 32;
                        }
                        byte by = this.canISeeThePlayer(n7, n8);
                        n6 = by;
                        if (by != -1) {
                            enemy.speed = (byte)5;
                            enemy.face = (byte)n6;
                            enemy.span = n6 == 0 || n6 == 2 ? Math.abs(this.player.fy - n8) : Math.abs(this.player.fx - n7);
                            enemy.span *= 32;
                        }
                    }
                    if (enemy.state != 0) {
                        enemy.step = 0;
                    } else {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 8) {
                            enemy.step = 0;
                        }
                    }
                } else if (enemy.type == 4 || enemy.type == 8) {
                    if (enemy.state == 2 && (n6 = this.getRandomStrollDirection(n7, n8, enemy.face, true)) != -1) {
                        enemy.face = n6;
                        enemy.state = 0;
                        enemy.span = 32;
                    }
                } else if (enemy.type == 7) {
                    if (enemy.mode == 5) {
                        enemy.step = (byte)(enemy.step - 1);
                        if (enemy.step == 0) {
                            enemy.step = 0;
                            enemy.mode = (byte)6;
                        }
                    } else {
                        if (enemy.state == 2 && (n6 = (n5 = this.playfield.trace[n8][n7]) == -1 ? (int)this.getRandomStrollDirection(n7, n8, enemy.face, true) : (this.canMove(n7, n8, n5, n3) ? n5 : -1)) != -1) {
                            enemy.face = (byte)n6;
                            enemy.state = 0;
                            enemy.span = 32;
                        }
                        if (enemy.state != 0) {
                            enemy.step = 0;
                        } else {
                            enemy.step = (byte)(enemy.step + 1);
                            if (enemy.step == 16) {
                                enemy.step = 0;
                            }
                        }
                    }
                } else if (enemy.type == 5) {
                    if (enemy.power < 30) {
                        ++enemy.power;
                    }
                    if (enemy.state != 3 && enemy.face == this.canISeeThePlayer(n7, n8) && enemy.mode != 4) {
                        enemy.mode = (byte)4;
                        enemy.step = (byte)15;
                    }
                    if (enemy.mode == 4) {
                        enemy.step = (byte)(enemy.step - 1);
                        if (enemy.step == 10) {
                            int n11 = enemy.face == 1 ? -1 : (n5 = enemy.face == 3 ? 1 : 0);
                            n4 = enemy.face == 2 ? -1 : (enemy.face == 0 ? 1 : 0);
                            this.playfield.addFire((byte)1, n7 * 32, n8 * 32, n5 * 32, n4 * 32, (byte)4);
                            enemy.power = 0;
                        } else if (enemy.step == 0) {
                            enemy.mode = (byte)6;
                        }
                    } else {
                        if (enemy.state == 2 && (n6 = (int)this.getRandomStrollDirection(n7, n8, enemy.face, true)) != -1) {
                            enemy.face = (byte)n6;
                            enemy.state = 0;
                            enemy.span = 32;
                        }
                        if (enemy.state != 0) {
                            enemy.step = 0;
                        } else {
                            enemy.step = (byte)(enemy.step + 1);
                            if (enemy.step == 8) {
                                enemy.step = 0;
                            }
                        }
                    }
                } else if (enemy.type == 2) {
                    enemy.step = (byte)(enemy.step + 1);
                    if (enemy.step == 8) {
                        enemy.step = 0;
                    }
                    enemy.speed = (byte)(1 + Math.abs(this._$780.nextInt()) % 3);
                    if (enemy.state == 2) {
                        int n12;
                        n6 = this.player.fx - n7;
                        n5 = this.player.fy - n8;
                        int n13 = n6 == 0 ? -1 : (n4 = n6 > 0 ? 3 : 1);
                        int n14 = n5 == 0 ? -1 : (n12 = n5 > 0 ? 0 : 2);
                        if (Math.abs(n6) < Math.abs(n5)) {
                            int n15 = n4;
                            n4 = n12;
                            n12 = n15;
                        }
                        if (this.canMove(n7, n8, n4, n3)) {
                            enemy.state = 0;
                            enemy.face = (byte)n4;
                            enemy.span = 32;
                        } else if (this.canMove(n7, n8, n12, n3)) {
                            enemy.state = 0;
                            enemy.face = (byte)n12;
                            enemy.span = 32;
                        }
                    }
                }
                if (enemy.state == 3) {
                    this._$800(n3);
                } else {
                    if (enemy.state == 0 && enemy.mode == 6) {
                        n6 = Math.min(enemy.speed, enemy.span);
                        switch (enemy.face) {
                            case 0: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n2), this.playfield.getGridY(enemy.y + 32), n3)) {
                                    enemy.face = (byte)2;
                                    enemy.span = n10 > n2 ? n10 - n2 : n10 + n2;
                                    break;
                                }
                                enemy.y += n6 * 32 / 16;
                                enemy.span -= n6;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 2: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n2), this.playfield.getGridY(enemy.y - 1), n3)) {
                                    enemy.face = 0;
                                    enemy.span = n10 < n2 ? n2 - n10 : n2 * 3 - n10;
                                    break;
                                }
                                enemy.y -= n6 * 32 / 16;
                                enemy.span -= n6;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 3: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + 32), this.playfield.getGridY(enemy.y + n2), n3)) {
                                    enemy.face = 1;
                                    enemy.span = n9 > n2 ? n9 - n2 : n9 + n2;
                                    break;
                                }
                                enemy.x += n6 * 32 / 16;
                                enemy.span -= n6;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                                break;
                            }
                            case 1: {
                                if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x - 1), this.playfield.getGridY(enemy.y + n2), n3)) {
                                    enemy.face = (byte)3;
                                    enemy.span = n9 < n2 ? n2 - n9 : n2 * 3 - n9;
                                    break;
                                }
                                enemy.x -= n6 * 32 / 16;
                                enemy.span -= n6;
                                if (enemy.span > 0) break;
                                enemy.state = (byte)2;
                            }
                        }
                    }
                    if (enemy.type == 2) {
                        this.playfield.occupy(n7, n8);
                    }
                }
            }
            ++n3;
        }
        return n;
    }

    public void updateGraphics(int n, int n2, int n3, int n4, Graphics graphics) {
        Image image = this.ghostIm;
        int n5 = 0;
        while (n5 < this.numEnemies) {
            if (this._$459[n5].type != 0) {
                Enemy enemy = this._$459[n5];
                if (enemy.type == 1) {
                    image = this.ghostIm;
                } else if (enemy.type == 3) {
                    image = this.trollIm;
                } else if (enemy.type == 4 || enemy.type == 8) {
                    image = enemy.type == 4 ? this.bugIm : this.bugbIm;
                } else if (enemy.type == 7) {
                    image = enemy.mode == 5 ? (enemy.step < 15 && enemy.step % 2 == 0 ? this.yetiIm : this.yetiDIm) : (enemy.state == 2 ? this.yetiDIm : this.yetiIm);
                } else if (enemy.type == 5) {
                    image = this.mageIm;
                } else if (enemy.type == 2) {
                    image = this.blobIm;
                }
                int n6 = enemy.x + n;
                int n7 = enemy.y + n2;
                if (n6 > -8 && n6 < n3 + 8 && n7 > -8 && n7 < n4 + 8 && (enemy.invinc % 2 == 0 || enemy.state == 3)) {
                    graphics.drawImage(image, n6, n7, 3);
                }
            }
            ++n5;
        }
    }

    public class Enemy {
        public static final int DATA_LENGTH = 25;
        byte face;
        byte hits;
        boolean immaterial;
        byte invinc;
        byte mode;
        int power;
        int span;
        byte speed;
        byte state;
        byte step;
        byte type = 0;
        int x;
        int y;
    }
}

