/*
 * Decompiled with CFR 0.152.
 */
import java.util.Random;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Enemies {
    public static final byte NONE = 0;
    public static final byte GHOST = 1;
    public static final byte BLOB = 2;
    public static final byte TROLL = 3;
    public static final byte BUG = 4;
    public static final byte MAGE = 5;
    public static final byte PLAYER = 6;
    public static final byte YETI = 7;
    public static final byte BLUE_BUG = 8;
    public static final byte NO_FACE = -1;
    public static final byte FACE_DOWN = 0;
    public static final byte FACE_LEFT = 1;
    public static final byte FACE_UP = 2;
    public static final byte FACE_RIGHT = 3;
    public static final byte MOVING = 0;
    public static final byte IMMOBILE = 1;
    public static final byte THINKING = 2;
    public static final byte DYING = 3;
    public static final byte CASTING = 4;
    public static final byte FROZEN = 5;
    public static final byte NORMAL = 6;
    public static final int[] STEPS5;
    public static final byte[] enemySpeeds;
    public static final byte[] enemyHits;
    public static final int[] enemyPoints;
    private Random _$43052 = new Random();
    int numEnemies;
    int activeEnemies;
    int firstEmpty;
    private Enemy[] _$1476;
    public Playfield playfield;
    public Player player;
    Image ghostIm;
    Image ghostDIm;
    Image blobIm;
    Image blobDIm;
    Image trollDIm;
    Image bugIm;
    Image bugbIm;
    Image yetiDIm;
    Image trollIm;
    Image mageIm;
    Image yetiIm;

    public Enemies(int n) {
        this.numEnemies = n;
        this._$1476 = new Enemy[n];
        for (int i = 0; i < n; ++i) {
            this._$1476[i] = new Enemy(this);
        }
        this.reset();
        this.blobIm = GameMidlet.getImage("enemy6");
        this.ghostIm = GameMidlet.getImage("enemy4");
        this.bugIm = GameMidlet.getImage("enemy3");
        this.bugbIm = GameMidlet.getImage("enemy2");
        this.mageIm = GameMidlet.getImage("enemy1");
        this.trollIm = GameMidlet.getImage("enemy7");
        this.yetiIm = GameMidlet.getImage("enemy5");
        this.yetiDIm = GameMidlet.getImage("enemy52");
    }

    public void reset() {
        for (int i = 0; i < this.numEnemies; ++i) {
            this._$1476[i].type = 0;
        }
        this.activeEnemies = 0;
        this.firstEmpty = 0;
    }

    private byte _$43053(byte by) {
        if (by == 0) {
            return 3;
        }
        return (byte)(by - 1);
    }

    private byte _$43054(byte by) {
        if (by == 3) {
            return 0;
        }
        return (byte)(by + 1);
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, int n3) {
        return this.addEnemy(by, n * 10, n2 * 10, by2, by3, enemySpeeds[by], (byte)0, (byte)6, enemyHits[by], 0, (byte)0, 0, false);
    }

    public int addEnemy(byte by, int n, int n2, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, int n3, byte by8, int n4, boolean bl) {
        int n5;
        for (n5 = this.firstEmpty; n5 < this.numEnemies && this._$1476[n5].type != 0; ++n5) {
        }
        if (n5 == this.numEnemies) {
            return -1;
        }
        this._$1476[n5].type = by;
        this._$1476[n5].x = n;
        this._$1476[n5].y = n2;
        this._$1476[n5].face = by2;
        this._$1476[n5].state = by3;
        this._$1476[n5].speed = by4;
        this._$1476[n5].step = by5;
        this._$1476[n5].mode = by6;
        this._$1476[n5].hits = by7;
        this._$1476[n5].span = n3;
        this._$1476[n5].invinc = by8;
        this._$1476[n5].power = n4;
        this._$1476[n5].immaterial = bl;
        this.firstEmpty = n5;
        return n5;
    }

    private void _$43058(int n) {
        this._$1476[n].type = 0;
        if (this.firstEmpty > n) {
            this.firstEmpty = n;
        }
    }

    public void decode(String string) {
        int n = 0;
        int n2 = 0;
        byte by = 0;
        try {
            int n3 = string.indexOf(44);
            int n4 = string.indexOf(44, n3 + 1);
            n = Integer.parseInt(string.substring(0, n3));
            n2 = Integer.parseInt(string.substring(n3 + 1, n4));
            by = (byte)Integer.parseInt(string.substring(n4 + 1));
        }
        catch (Exception exception) {
            System.err.println("Enemies.decode");
            exception.printStackTrace();
        }
        if (by == 6) {
            this.player.startX = n * 10;
            this.player.startY = n2 * 10;
            return;
        }
        this.addEnemy(by, n, n2, (byte)0, (byte)2, 0);
    }

    public int update() {
        int n = 0;
        int n2 = 5;
        for (int i = 0; i < this.numEnemies; ++i) {
            int n3;
            int n4;
            int n5;
            if (this._$1476[i].type == 0) continue;
            ++n;
            Enemy enemy = this._$1476[i];
            int n6 = this.playfield.getGridX(enemy.x + n2);
            int n7 = this.playfield.getGridY(enemy.y + n2);
            int n8 = (enemy.x + n2) % 10;
            int n9 = (enemy.y + n2) % 10;
            if (enemy.invinc > 0) {
                enemy.invinc = (byte)(enemy.invinc - 1);
            }
            if (enemy.state != 3) {
                if (n6 == this.player.fx && n7 == this.player.fy && this.player.mode != 1 && this.player.mode != 2 && !GameMidlet.instance.menuScreen.gameScreen.godmode) {
                    this.player.kill();
                }
                if ((n5 = this.playfield.passThrough(n6, n7, false)) == 10 && enemy.invinc == 0) {
                    if (enemy.type == 7) {
                        if (enemy.mode == 5) {
                            enemy.state = (byte)3;
                            enemy.mode = (byte)6;
                            this.player.givePoints(enemyPoints[enemy.type]);
                            enemy.span = 1;
                        } else {
                            enemy.mode = (byte)5;
                            enemy.step = (byte)70;
                        }
                    } else {
                        enemy.hits = (byte)(enemy.hits - 1);
                    }
                    enemy.invinc = (byte)15;
                    if (enemy.hits == 0) {
                        enemy.state = (byte)3;
                        this.player.givePoints(enemyPoints[enemy.type]);
                        enemy.span = 0;
                    }
                }
            }
            if (enemy.type == 1) {
                enemy.step = (byte)(enemy.step + 1);
                if (enemy.step == 8) {
                    enemy.step = 0;
                }
                if (enemy.state == 2) {
                    if (this.canMove(n6, n7, enemy.face, i)) {
                        enemy.state = 0;
                        enemy.span = 10;
                    } else {
                        enemy.face = this.getRandomStrollDirection(n6, n7, enemy.face, true);
                    }
                }
            } else if (enemy.type == 3) {
                if (enemy.state == 2) {
                    enemy.speed = (byte)(6 - enemy.hits);
                    n5 = this.getRandomStrollDirection(n6, n7, enemy.face, true);
                    if (n5 != -1) {
                        enemy.face = n5;
                        enemy.state = 0;
                        enemy.span = 10;
                    }
                    byte by = this.canISeeThePlayer(n6, n7);
                    n5 = by;
                    if (by != -1) {
                        enemy.speed = (byte)5;
                        enemy.face = (byte)n5;
                        enemy.span = n5 == 0 || n5 == 2 ? Math.abs(this.player.fy - n7) : Math.abs(this.player.fx - n6);
                        enemy.span *= 10;
                    }
                }
                if (enemy.state != 0) {
                    enemy.step = 0;
                } else {
                    enemy.step = (byte)(enemy.step + 1);
                    if (enemy.step == 8) {
                        enemy.step = 0;
                    }
                }
            } else if (enemy.type == 4 || enemy.type == 8) {
                if (enemy.state == 2 && (n5 = this.getRandomStrollDirection(n6, n7, enemy.face, true)) != -1) {
                    enemy.face = n5;
                    enemy.state = 0;
                    enemy.span = 10;
                }
            } else if (enemy.type == 7) {
                if (enemy.mode == 5) {
                    enemy.step = (byte)(enemy.step - 1);
                    if (enemy.step == 0) {
                        enemy.step = 0;
                        enemy.mode = (byte)6;
                    }
                } else {
                    if (enemy.state == 2 && (n5 = (n4 = this.playfield.trace[n7][n6]) == -1 ? (int)this.getRandomStrollDirection(n6, n7, enemy.face, true) : (this.canMove(n6, n7, n4, i) ? n4 : -1)) != -1) {
                        enemy.face = (byte)n5;
                        enemy.state = 0;
                        enemy.span = 10;
                    }
                    if (enemy.state != 0) {
                        enemy.step = 0;
                    } else {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 16) {
                            enemy.step = 0;
                        }
                    }
                }
            } else if (enemy.type == 5) {
                if (enemy.power < 30) {
                    ++enemy.power;
                }
                if (enemy.state != 3 && enemy.face == this.canISeeThePlayer(n6, n7) && enemy.mode != 4) {
                    enemy.mode = (byte)4;
                    enemy.step = (byte)15;
                }
                if (enemy.mode == 4) {
                    enemy.step = (byte)(enemy.step - 1);
                    if (enemy.step == 10) {
                        int n10 = enemy.face == 1 ? -1 : (n4 = enemy.face == 3 ? 1 : 0);
                        n3 = enemy.face == 2 ? -1 : (enemy.face == 0 ? 1 : 0);
                        this.playfield.addFire((byte)1, n6 * 10, n7 * 10, n4 * 10, n3 * 10, (byte)4);
                        enemy.power = 0;
                    } else if (enemy.step == 0) {
                        enemy.mode = (byte)6;
                    }
                } else {
                    if (enemy.state == 2 && (n5 = (int)this.getRandomStrollDirection(n6, n7, enemy.face, true)) != -1) {
                        enemy.face = (byte)n5;
                        enemy.state = 0;
                        enemy.span = 10;
                    }
                    if (enemy.state != 0) {
                        enemy.step = 0;
                    } else {
                        enemy.step = (byte)(enemy.step + 1);
                        if (enemy.step == 8) {
                            enemy.step = 0;
                        }
                    }
                }
            } else if (enemy.type == 2) {
                enemy.step = (byte)(enemy.step + 1);
                if (enemy.step == 8) {
                    enemy.step = 0;
                }
                enemy.speed = (byte)(1 + Math.abs(this._$43052.nextInt()) % 3);
                if (enemy.state == 2) {
                    int n11;
                    n5 = this.player.fx - n6;
                    n4 = this.player.fy - n7;
                    int n12 = n5 == 0 ? -1 : (n3 = n5 > 0 ? 3 : 1);
                    int n13 = n4 == 0 ? -1 : (n11 = n4 > 0 ? 0 : 2);
                    if (Math.abs(n5) < Math.abs(n4)) {
                        int n14 = n3;
                        n3 = n11;
                        n11 = n14;
                    }
                    if (this.canMove(n6, n7, n3, i)) {
                        enemy.state = 0;
                        enemy.face = (byte)n3;
                        enemy.span = 10;
                    } else if (this.canMove(n6, n7, n11, i)) {
                        enemy.state = 0;
                        enemy.face = (byte)n11;
                        enemy.span = 10;
                    }
                }
            }
            if (enemy.state == 3) {
                this._$43058(i);
                continue;
            }
            if (enemy.state == 0 && enemy.mode == 6) {
                n5 = Math.min(enemy.speed, enemy.span);
                switch (enemy.face) {
                    case 0: {
                        if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n2), this.playfield.getGridY(enemy.y + 10), i)) {
                            enemy.face = (byte)2;
                            enemy.span = n9 > n2 ? n9 - n2 : n9 + n2;
                            break;
                        }
                        enemy.y += n5;
                        enemy.span -= n5;
                        if (enemy.span > 0) break;
                        enemy.state = (byte)2;
                        break;
                    }
                    case 2: {
                        if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + n2), this.playfield.getGridY(enemy.y - 1), i)) {
                            enemy.face = 0;
                            enemy.span = n9 < n2 ? n2 - n9 : n2 * 3 - n9;
                            break;
                        }
                        enemy.y -= n5;
                        enemy.span -= n5;
                        if (enemy.span > 0) break;
                        enemy.state = (byte)2;
                        break;
                    }
                    case 3: {
                        if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x + 10), this.playfield.getGridY(enemy.y + n2), i)) {
                            enemy.face = 1;
                            enemy.span = n8 > n2 ? n8 - n2 : n8 + n2;
                            break;
                        }
                        enemy.x += n5;
                        enemy.span -= n5;
                        if (enemy.span > 0) break;
                        enemy.state = (byte)2;
                        break;
                    }
                    case 1: {
                        if (!this.playfield.isPassable(this.playfield.getGridX(enemy.x - 1), this.playfield.getGridY(enemy.y + n2), i)) {
                            enemy.face = (byte)3;
                            enemy.span = n8 < n2 ? n2 - n8 : n2 * 3 - n8;
                            break;
                        }
                        enemy.x -= n5;
                        enemy.span -= n5;
                        if (enemy.span > 0) break;
                        enemy.state = (byte)2;
                    }
                }
            }
            if (enemy.type != 2) continue;
            this.playfield.occupy(n6, n7);
        }
        return n;
    }

    public void updateGraphics(int n, int n2, int n3, int n4, Graphics graphics) {
        Image image = this.ghostIm;
        for (int i = 0; i < this.numEnemies; ++i) {
            if (this._$1476[i].type == 0) continue;
            Enemy enemy = this._$1476[i];
            if (enemy.type == 1) {
                image = this.ghostIm;
            } else if (enemy.type == 3) {
                image = this.trollIm;
            } else if (enemy.type == 4 || enemy.type == 8) {
                image = enemy.type == 4 ? this.bugIm : this.bugbIm;
            } else if (enemy.type == 7) {
                image = enemy.mode == 5 ? (enemy.step < 15 && enemy.step % 2 == 0 ? this.yetiIm : this.yetiDIm) : (enemy.state == 2 ? this.yetiDIm : this.yetiIm);
            } else if (enemy.type == 5) {
                image = this.mageIm;
            } else if (enemy.type == 2) {
                image = this.blobIm;
            }
            int n5 = enemy.x + n;
            int n6 = enemy.y + n2;
            if (n5 <= -8 || n5 >= n3 + 8 || n6 <= -8 || n6 >= n4 + 8 || enemy.invinc % 2 != 0 && enemy.state != 3) continue;
            graphics.drawImage(image, n5, n6, 3);
        }
    }

    byte getRandomStrollDirection(int n, int n2, byte by, boolean bl) {
        int n3 = Math.abs(this._$43052.nextInt()) % 2 == 0 ? 1 : -1;
        boolean[] blArray = new boolean[]{this.canMove(n, n2, by, -1), this.canMove(n, n2, this.turn(by, n3), -1), this.canMove(n, n2, this.turn(by, -n3), -1), this.canMove(n, n2, this.turn(by, 2), -1)};
        if (!blArray[0]) {
            if (!blArray[1]) {
                if (!blArray[2]) {
                    if (!blArray[3]) {
                        return -1;
                    }
                    return this.turn(by, 2);
                }
                return this.turn(by, -n3);
            }
            return this.turn(by, n3);
        }
        if (!bl) {
            return by;
        }
        if (blArray[1] && Math.abs(this._$43052.nextInt()) % 4 == 0) {
            return this.turn(by, n3);
        }
        if (blArray[2] && Math.abs(this._$43052.nextInt()) % 4 == 0) {
            return this.turn(by, -n3);
        }
        return by;
    }

    byte turn(byte by, int n) {
        if ((by = (byte)(by + n)) > 3) {
            by = (byte)(by - 4);
        }
        if (by < 0) {
            by = (byte)(by + 4);
        }
        return by;
    }

    byte canISeeThePlayer(int n, int n2) {
        if (this.player.mode == 2) {
            return -1;
        }
        if (this.player.fx == n) {
            if (this.player.fy == n2) {
                return -1;
            }
            int n3 = this.player.fy;
            int n4 = n2;
            byte by = 2;
            if (this.player.fy > n2) {
                n4 = n3;
                n3 = n2;
                by = 0;
            }
            for (int i = n3; i <= n4; ++i) {
                if (this.playfield.isPassable(n, i, -1)) continue;
                return -1;
            }
            return by;
        }
        if (this.player.fy == n2) {
            int n5 = this.player.fx;
            int n6 = n;
            byte by = 1;
            if (this.player.fx > n) {
                n6 = n5;
                n5 = n;
                by = 3;
            }
            for (int i = n5; i <= n6; ++i) {
                if (this.playfield.isPassable(i, n2, -1)) continue;
                return -1;
            }
            return by;
        }
        return -1;
    }

    boolean canMove(int n, int n2, int n3, int n4) {
        int n5;
        if (n3 == -1) {
            return false;
        }
        int n6 = n3 == 1 ? -1 : (n5 = n3 == 3 ? 1 : 0);
        int n7 = n3 == 2 ? -1 : (n3 == 0 ? 1 : 0);
        return this.playfield.isPassable(n + n5, n2 + n7, n4) && !this.playfield.isOccupied(n + n5, n2 + n7);
    }

    static {
        NONE = 0;
        GHOST = 1;
        BLOB = (byte)2;
        TROLL = (byte)3;
        BUG = (byte)4;
        MAGE = (byte)5;
        PLAYER = (byte)6;
        YETI = (byte)7;
        BLUE_BUG = (byte)8;
        NO_FACE = (byte)-1;
        FACE_DOWN = 0;
        FACE_LEFT = 1;
        FACE_UP = (byte)2;
        FACE_RIGHT = (byte)3;
        MOVING = 0;
        IMMOBILE = 1;
        THINKING = (byte)2;
        DYING = (byte)3;
        CASTING = (byte)4;
        FROZEN = (byte)5;
        NORMAL = (byte)6;
        STEPS5 = new int[]{0, 1, 2, 1, 0, 3, 4, 3};
        enemySpeeds = new byte[]{0, 4, 2, 3, 1, 2, 0, 3, 2};
        enemyHits = new byte[]{0, 1, 1, 3, 3, 1, 0, 3, 1};
        enemyPoints = new int[]{0, 7, 5, 30, 8, 20, 0, 20, 10};
    }

    public class Enemy {
        public static final int DATA_LENGTH = 25;
        byte type = 0;
        int x;
        int y;
        byte face;
        byte state;
        byte speed;
        byte step;
        byte mode;
        byte hits;
        int span;
        byte invinc;
        int power;
        boolean immaterial;

        public Enemy(Enemies enemies) {
        }

        static {
            DATA_LENGTH = 25;
        }
    }
}

