/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class Truck {
    private StringBuffer buf = new StringBuffer();
    private static final int BLACK = 0;
    private static final int WHITE = 0xFFFFFF;
    private static final int RED = 0xFF0000;
    private static final int GREEN = 65280;
    private static final int PINK = 0xFF6666;
    private static final int BLUE = 255;
    private static final int YELLOW = 0xFFFF00;
    private static final int GRAY = 0x888888;
    private double truckFrontGearX;
    private double truckFrontGearY;
    private double truckBackGearX;
    private double truckBackGearY;
    private double coachBackGearX;
    private double coachBackGearY;
    private double steerAngle;
    private double maxSteerAngle = 1.0471975511965976;
    private double speed;
    private double maxSpeed = 1.0;
    private double sinTruckAngle;
    private double cosTruckAngle;
    private double sinCoachAngle;
    private double cosCoachAngle;
    private double sinSteerAngle;
    private double cosSteerAngle;
    private double truckGearDist = 14.0;
    private double truckFrontGearDist = 6.0;
    private double truckLength = 24.0;
    private double truckWidth = 10.0;
    private double pilotLength = 10.0;
    private double coachGearDist = 28.0;
    private double coachFrontGearDist = 8.0;
    public double coachLength = 52.0;
    private double gearRadius = 2.0;
    private double cosAPlusB;
    private double sinAPlusB;
    private double dist;
    private double deltaX;
    private double deltaY;
    private double truckFrontX;
    private double truckFrontY;
    private double truckFrontLeftX;
    private double truckFrontLeftY;
    private double truckFrontRightX;
    private double truckFrontRightY;
    private double truckBackLeftX;
    private double truckBackLeftY;
    private double truckBackRightX;
    private double truckBackRightY;
    private double truckGearLeftX;
    private double truckGearLeftY;
    private double truckGearRightX;
    private double truckGearRightY;
    private double pilotBackLeftX;
    private double pilotBackLeftY;
    private double pilotBackRightX;
    private double pilotBackRightY;
    private double coachFrontX;
    private double coachFrontY;
    private double coachFrontLeftX;
    private double coachFrontLeftY;
    private double coachFrontRightX;
    private double coachFrontRightY;
    private double coachBackLeftX;
    private double coachBackLeftY;
    private double coachBackRightX;
    private double coachBackRightY;
    private double coachGearLeftX;
    private double coachGearLeftY;
    private double coachGearRightX;
    private double coachGearRightY;
    public boolean collision = false;
    private int collisionValue;
    private int maxCollisionValue = 25;
    private int numberOfRestAreas;
    private int[][] restAreas;
    private int[] pickUpArea;
    private int[] destArea;
    private double x;
    private double y;
    private double steepness;
    private double minimum;
    private double maximum;
    private double cosCoachTruckAngle;
    private double minCosCoachTruckAngle = Math.cos(1.9198621771937625);
    private int percentLoaded;
    private boolean loading;
    private boolean levelDone;
    private TruckCanvas truckCanvas;

    public Truck(TruckCanvas truckCanvas) {
        this.truckCanvas = truckCanvas;
    }

    public void setStartPosition(Depo depo) {
        if (depo.getStartPosition() == 1) {
            this.truckFrontGearX = depo.getCurrentWidth() - 70;
            this.truckFrontGearY = depo.getCurrentHeight() - 32 - 8;
            this.truckBackGearX = this.truckFrontGearX + this.truckGearDist;
            this.truckBackGearY = this.truckFrontGearY;
            this.coachBackGearX = this.truckBackGearX + this.coachGearDist;
            this.coachBackGearY = this.truckFrontGearY;
            this.sinTruckAngle = 0.0;
            this.cosTruckAngle = -1.0;
        } else {
            this.truckFrontGearX = 70.0;
            this.truckFrontGearY = depo.getCurrentHeight() - 16 - 9;
            this.truckBackGearX = this.truckFrontGearX - this.truckGearDist;
            this.truckBackGearY = this.truckFrontGearY;
            this.coachBackGearX = this.truckBackGearX - this.coachGearDist;
            this.coachBackGearY = this.truckFrontGearY;
            this.sinTruckAngle = 0.0;
            this.cosTruckAngle = 1.0;
        }
        this.steerAngle = 0.0;
        this.speed = 0.0;
        this.collisionValue = 0;
        this.percentLoaded = 0;
        this.loading = false;
        this.levelDone = false;
    }

    public void goRight() {
        this.steerAngle += Math.PI / 90;
        if (this.steerAngle > this.maxSteerAngle) {
            this.steerAngle = this.maxSteerAngle;
        }
    }

    public void goLeft() {
        this.steerAngle -= Math.PI / 90;
        if (this.steerAngle < -this.maxSteerAngle) {
            this.steerAngle = -this.maxSteerAngle;
        }
    }

    public void forward() {
        this.speed += 0.01;
        if (this.speed > this.maxSpeed) {
            this.speed = this.maxSpeed;
        }
    }

    public void back() {
        this.speed -= 0.01;
        if (this.speed < -this.maxSpeed) {
            this.speed = -this.maxSpeed;
        }
    }

    public void brake() {
        if (this.speed > 0.0) {
            this.speed -= 0.05;
        }
        if (this.speed < 0.0) {
            this.speed += 0.05;
        }
        if (Math.abs(this.speed) < 0.05) {
            this.speed = 0.0;
        }
    }

    public void tick() {
        this.cosSteerAngle = Math.cos(this.steerAngle);
        this.sinSteerAngle = Math.sin(this.steerAngle);
        for (int i = 1; i <= 20; ++i) {
            this.cosAPlusB = this.cosTruckAngle * this.cosSteerAngle - this.sinTruckAngle * this.sinSteerAngle;
            this.sinAPlusB = this.sinTruckAngle * this.cosSteerAngle + this.cosTruckAngle * this.sinSteerAngle;
            this.truckFrontGearX += this.speed / 20.0 * this.cosAPlusB;
            this.truckFrontGearY += this.speed / 20.0 * this.sinAPlusB;
            this.deltaX = this.truckFrontGearX - this.truckBackGearX;
            this.deltaY = this.truckFrontGearY - this.truckBackGearY;
            this.dist = Math.sqrt(this.deltaX * this.deltaX + this.deltaY * this.deltaY);
            this.cosTruckAngle = this.deltaX / this.dist;
            this.sinTruckAngle = this.deltaY / this.dist;
            this.truckBackGearX = this.truckFrontGearX - this.cosTruckAngle * this.truckGearDist;
            this.truckBackGearY = this.truckFrontGearY - this.sinTruckAngle * this.truckGearDist;
            this.deltaX = this.truckBackGearX - this.coachBackGearX;
            this.deltaY = this.truckBackGearY - this.coachBackGearY;
            this.dist = Math.sqrt(this.deltaX * this.deltaX + this.deltaY * this.deltaY);
            this.cosCoachAngle = this.deltaX / this.dist;
            this.sinCoachAngle = this.deltaY / this.dist;
            this.coachBackGearX = this.truckBackGearX - this.cosCoachAngle * this.coachGearDist;
            this.coachBackGearY = this.truckBackGearY - this.sinCoachAngle * this.coachGearDist;
        }
        this.truckFrontX = this.truckFrontGearX + this.truckFrontGearDist * this.cosTruckAngle;
        this.truckFrontY = this.truckFrontGearY + this.truckFrontGearDist * this.sinTruckAngle;
        this.truckFrontLeftX = this.truckFrontX + this.truckWidth / 2.0 * this.sinTruckAngle;
        this.truckFrontLeftY = this.truckFrontY - this.truckWidth / 2.0 * this.cosTruckAngle;
        this.truckFrontRightX = this.truckFrontX - this.truckWidth / 2.0 * this.sinTruckAngle;
        this.truckFrontRightY = this.truckFrontY + this.truckWidth / 2.0 * this.cosTruckAngle;
        this.truckBackLeftX = this.truckFrontLeftX - this.truckLength * this.cosTruckAngle;
        this.truckBackLeftY = this.truckFrontLeftY - this.truckLength * this.sinTruckAngle;
        this.truckBackRightX = this.truckFrontRightX - this.truckLength * this.cosTruckAngle;
        this.truckBackRightY = this.truckFrontRightY - this.truckLength * this.sinTruckAngle;
        this.pilotBackLeftX = this.truckFrontLeftX - this.pilotLength * this.cosTruckAngle;
        this.pilotBackLeftY = this.truckFrontLeftY - this.pilotLength * this.sinTruckAngle;
        this.pilotBackRightX = this.truckFrontRightX - this.pilotLength * this.cosTruckAngle;
        this.pilotBackRightY = this.truckFrontRightY - this.pilotLength * this.sinTruckAngle;
        this.truckGearLeftX = this.truckFrontGearX + this.truckWidth / 2.0 * this.sinTruckAngle;
        this.truckGearLeftY = this.truckFrontGearY - this.truckWidth / 2.0 * this.cosTruckAngle;
        this.truckGearRightX = this.truckFrontGearX - this.truckWidth / 2.0 * this.sinTruckAngle;
        this.truckGearRightY = this.truckFrontGearY + this.truckWidth / 2.0 * this.cosTruckAngle;
        this.coachFrontX = this.truckBackGearX + this.coachFrontGearDist * this.cosCoachAngle;
        this.coachFrontY = this.truckBackGearY + this.coachFrontGearDist * this.sinCoachAngle;
        this.coachFrontLeftX = this.coachFrontX + this.truckWidth / 2.0 * this.sinCoachAngle;
        this.coachFrontLeftY = this.coachFrontY - this.truckWidth / 2.0 * this.cosCoachAngle;
        this.coachFrontRightX = this.coachFrontX - this.truckWidth / 2.0 * this.sinCoachAngle;
        this.coachFrontRightY = this.coachFrontY + this.truckWidth / 2.0 * this.cosCoachAngle;
        this.coachBackLeftX = this.coachFrontLeftX - this.coachLength * this.cosCoachAngle;
        this.coachBackLeftY = this.coachFrontLeftY - this.coachLength * this.sinCoachAngle;
        this.coachBackRightX = this.coachFrontRightX - this.coachLength * this.cosCoachAngle;
        this.coachBackRightY = this.coachFrontRightY - this.coachLength * this.sinCoachAngle;
        this.coachGearLeftX = this.coachBackGearX + this.truckWidth / 2.0 * this.sinCoachAngle;
        this.coachGearLeftY = this.coachBackGearY - this.truckWidth / 2.0 * this.cosCoachAngle;
        this.coachGearRightX = this.coachBackGearX - this.truckWidth / 2.0 * this.sinCoachAngle;
        this.coachGearRightY = this.coachBackGearY + this.truckWidth / 2.0 * this.cosCoachAngle;
    }

    public void drawTruck(Graphics graphics, int n, int n2) {
        graphics.setColor(0xFF0000);
        graphics.fillTriangle((int)this.truckFrontLeftX, (int)this.truckFrontLeftY, (int)this.truckBackLeftX, (int)this.truckBackLeftY, (int)this.truckBackRightX, (int)this.truckBackRightY);
        graphics.fillTriangle((int)this.truckFrontLeftX, (int)this.truckFrontLeftY, (int)this.truckFrontRightX, (int)this.truckFrontRightY, (int)this.truckBackRightX, (int)this.truckBackRightY);
        graphics.setColor(0xFF6666);
        graphics.fillTriangle((int)this.truckFrontLeftX, (int)this.truckFrontLeftY, (int)this.pilotBackLeftX, (int)this.pilotBackLeftY, (int)this.pilotBackRightX, (int)this.pilotBackRightY);
        graphics.fillTriangle((int)this.truckFrontLeftX, (int)this.truckFrontLeftY, (int)this.truckFrontRightX, (int)this.truckFrontRightY, (int)this.pilotBackRightX, (int)this.pilotBackRightY);
        graphics.setColor(0xFFFF00);
        graphics.drawLine((int)this.truckFrontLeftX, (int)this.truckFrontLeftY, (int)this.truckFrontLeftX, (int)this.truckFrontLeftY);
        graphics.drawLine((int)this.truckFrontRightX, (int)this.truckFrontRightY, (int)this.truckFrontRightX, (int)this.truckFrontRightY);
        graphics.setColor(0xFFFFFF);
        graphics.fillTriangle((int)this.coachFrontLeftX, (int)this.coachFrontLeftY, (int)this.coachBackLeftX, (int)this.coachBackLeftY, (int)this.coachBackRightX, (int)this.coachBackRightY);
        graphics.fillTriangle((int)this.coachFrontLeftX, (int)this.coachFrontLeftY, (int)this.coachFrontRightX, (int)this.coachFrontRightY, (int)this.coachBackRightX, (int)this.coachBackRightY);
        graphics.drawLine((int)this.truckBackGearX, (int)this.truckBackGearY, (int)this.coachBackGearX, (int)this.coachBackGearY);
        graphics.setColor(0xFF0000);
        graphics.drawLine((int)this.coachBackLeftX, (int)this.coachBackLeftY, (int)this.coachBackLeftX, (int)this.coachBackLeftY);
        graphics.drawLine((int)this.coachBackRightX, (int)this.coachBackRightY, (int)this.coachBackRightX, (int)this.coachBackRightY);
        graphics.setColor(0);
        graphics.drawLine((int)(this.coachGearLeftX + 2.0 * this.cosCoachAngle), (int)(this.coachGearLeftY + this.gearRadius * this.sinCoachAngle), (int)(this.coachGearLeftX - this.gearRadius * this.cosCoachAngle), (int)(this.coachGearLeftY - this.gearRadius * this.sinCoachAngle));
        graphics.drawLine((int)(this.coachGearRightX + 2.0 * this.cosCoachAngle), (int)(this.coachGearRightY + this.gearRadius * this.sinCoachAngle), (int)(this.coachGearRightX - this.gearRadius * this.cosCoachAngle), (int)(this.coachGearRightY - this.gearRadius * this.sinCoachAngle));
        graphics.drawLine((int)(this.truckGearLeftX + 2.0 * this.cosAPlusB), (int)(this.truckGearLeftY + this.gearRadius * this.sinAPlusB), (int)(this.truckGearLeftX - this.gearRadius * this.cosAPlusB), (int)(this.truckGearLeftY - this.gearRadius * this.sinAPlusB));
        graphics.drawLine((int)(this.truckGearRightX + 2.0 * this.cosAPlusB), (int)(this.truckGearRightY + this.gearRadius * this.sinAPlusB), (int)(this.truckGearRightX - this.gearRadius * this.cosAPlusB), (int)(this.truckGearRightY - this.gearRadius * this.sinAPlusB));
    }

    public void drawLoadingText(Graphics graphics, int n, int n2) {
        if (this.loading) {
            graphics.setColor(0x6060FF);
            if (this.percentLoaded < 100) {
                graphics.drawString(Integer.toString(this.percentLoaded) + "% loaded", (int)((double)n) / 2, (int)((double)n2) / 2, 65);
            } else {
                graphics.drawString("100% loaded", (int)((double)n) / 2, (int)((double)n2) / 2, 65);
                graphics.drawString("You can leave the yard", (int)((double)n) / 2, (int)((double)n2) / 2, 17);
            }
        }
    }

    public boolean checkCollision(Depo depo) {
        this.restAreas = depo.getRestrictedAreas();
        this.numberOfRestAreas = depo.getNumberOfRestrictedAreas();
        this.collision = false;
        this.cosCoachTruckAngle = this.cosTruckAngle * this.cosCoachAngle + this.sinTruckAngle * this.sinCoachAngle;
        if (this.cosCoachTruckAngle < this.minCosCoachTruckAngle) {
            this.collision = true;
        }
        for (int i = 0; i < this.numberOfRestAreas; ++i) {
            if (this.cosTruckAngle != 0.0) {
                this.steepness = this.sinTruckAngle / this.cosTruckAngle;
                this.minimum = Math.min(this.truckFrontLeftX, this.truckBackLeftX);
                this.maximum = Math.max(this.truckFrontLeftX, this.truckBackLeftX);
                this.y = this.steepness * ((double)this.restAreas[i][0] - this.truckFrontLeftX) + this.truckFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = this.steepness * ((double)this.restAreas[i][2] - this.truckFrontLeftX) + this.truckFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.minimum = Math.min(this.truckFrontRightX, this.truckBackRightX);
                this.maximum = Math.max(this.truckFrontRightX, this.truckBackRightX);
                this.y = this.steepness * ((double)this.restAreas[i][0] - this.truckFrontRightX) + this.truckFrontRightY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = this.steepness * ((double)this.restAreas[i][2] - this.truckFrontRightX) + this.truckFrontRightY;
                boolean bl = this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            }
            if (this.sinTruckAngle != 0.0) {
                this.steepness = this.cosTruckAngle / this.sinTruckAngle;
                this.minimum = Math.min(this.truckFrontLeftY, this.truckBackLeftY);
                this.maximum = Math.max(this.truckFrontLeftY, this.truckBackLeftY);
                this.x = this.steepness * ((double)this.restAreas[i][1] - this.truckFrontLeftY) + this.truckFrontLeftX;
                this.collision = this.collision || (double)this.restAreas[i][1] >= this.minimum && (double)this.restAreas[i][1] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
                this.x = this.steepness * ((double)this.restAreas[i][3] - this.truckFrontLeftY) + this.truckFrontLeftX;
                this.collision = this.collision || (double)this.restAreas[i][3] >= this.minimum && (double)this.restAreas[i][3] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
                this.minimum = Math.min(this.truckFrontRightY, this.truckBackRightY);
                this.maximum = Math.max(this.truckFrontRightY, this.truckBackRightY);
                this.x = this.steepness * ((double)this.restAreas[i][1] - this.truckFrontRightY) + this.truckFrontRightX;
                this.collision = this.collision || (double)this.restAreas[i][1] >= this.minimum && (double)this.restAreas[i][1] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
                this.x = this.steepness * ((double)this.restAreas[i][3] - this.truckFrontRightY) + this.truckFrontRightX;
                this.collision = this.collision || (double)this.restAreas[i][3] >= this.minimum && (double)this.restAreas[i][3] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
                this.minimum = Math.min(this.truckFrontLeftX, this.truckFrontRightX);
                this.maximum = Math.max(this.truckFrontLeftX, this.truckFrontRightX);
                this.y = -this.steepness * ((double)this.restAreas[i][0] - this.truckFrontLeftX) + this.truckFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = -this.steepness * ((double)this.restAreas[i][2] - this.truckFrontLeftX) + this.truckFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.minimum = Math.min(this.truckBackLeftX, this.truckBackRightX);
                this.maximum = Math.max(this.truckBackLeftX, this.truckBackRightX);
                this.y = -this.steepness * ((double)this.restAreas[i][0] - this.truckBackLeftX) + this.truckBackLeftY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = -this.steepness * ((double)this.restAreas[i][2] - this.truckBackLeftX) + this.truckBackLeftY;
                boolean bl = this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            }
            if (this.cosCoachAngle != 0.0) {
                this.steepness = this.sinCoachAngle / this.cosCoachAngle;
                this.minimum = Math.min(this.coachFrontLeftX, this.coachBackLeftX);
                this.maximum = Math.max(this.coachFrontLeftX, this.coachBackLeftX);
                this.y = this.steepness * ((double)this.restAreas[i][0] - this.coachFrontLeftX) + this.coachFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = this.steepness * ((double)this.restAreas[i][2] - this.coachFrontLeftX) + this.coachFrontLeftY;
                this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.minimum = Math.min(this.coachFrontRightX, this.coachBackRightX);
                this.maximum = Math.max(this.coachFrontRightX, this.coachBackRightX);
                this.y = this.steepness * ((double)this.restAreas[i][0] - this.coachFrontRightX) + this.coachFrontRightY;
                this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
                this.y = this.steepness * ((double)this.restAreas[i][2] - this.coachFrontRightX) + this.coachFrontRightY;
                boolean bl = this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            }
            if (this.sinCoachAngle == 0.0) continue;
            this.steepness = this.cosCoachAngle / this.sinCoachAngle;
            this.minimum = Math.min(this.coachFrontLeftY, this.coachBackLeftY);
            this.maximum = Math.max(this.coachFrontLeftY, this.coachBackLeftY);
            this.x = this.steepness * ((double)this.restAreas[i][1] - this.coachFrontLeftY) + this.coachFrontLeftX;
            this.collision = this.collision || (double)this.restAreas[i][1] >= this.minimum && (double)this.restAreas[i][1] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
            this.x = this.steepness * ((double)this.restAreas[i][3] - this.coachFrontLeftY) + this.coachFrontLeftX;
            this.collision = this.collision || (double)this.restAreas[i][3] >= this.minimum && (double)this.restAreas[i][3] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
            this.minimum = Math.min(this.coachFrontRightY, this.coachBackRightY);
            this.maximum = Math.max(this.coachFrontRightY, this.coachBackRightY);
            this.x = this.steepness * ((double)this.restAreas[i][1] - this.coachFrontRightY) + this.coachFrontRightX;
            this.collision = this.collision || (double)this.restAreas[i][1] >= this.minimum && (double)this.restAreas[i][1] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
            this.x = this.steepness * ((double)this.restAreas[i][3] - this.coachFrontRightY) + this.coachFrontRightX;
            this.collision = this.collision || (double)this.restAreas[i][3] >= this.minimum && (double)this.restAreas[i][3] <= this.maximum && this.x >= (double)this.restAreas[i][0] && this.x <= (double)this.restAreas[i][2];
            this.minimum = Math.min(this.coachFrontLeftX, this.coachFrontRightX);
            this.maximum = Math.max(this.coachFrontLeftX, this.coachFrontRightX);
            this.y = -this.steepness * ((double)this.restAreas[i][0] - this.coachFrontLeftX) + this.coachFrontLeftY;
            this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            this.y = -this.steepness * ((double)this.restAreas[i][2] - this.coachFrontLeftX) + this.coachFrontLeftY;
            this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            this.minimum = Math.min(this.coachBackLeftX, this.coachBackRightX);
            this.maximum = Math.max(this.coachBackLeftX, this.coachBackRightX);
            this.y = -this.steepness * ((double)this.restAreas[i][0] - this.coachBackLeftX) + this.coachBackLeftY;
            this.collision = this.collision || (double)this.restAreas[i][0] >= this.minimum && (double)this.restAreas[i][0] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
            this.y = -this.steepness * ((double)this.restAreas[i][2] - this.coachBackLeftX) + this.coachBackLeftY;
            this.collision = this.collision || (double)this.restAreas[i][2] >= this.minimum && (double)this.restAreas[i][2] <= this.maximum && this.y >= (double)this.restAreas[i][1] && this.y <= (double)this.restAreas[i][3];
        }
        if (this.collision) {
            ++this.collisionValue;
        }
        this.pickUpArea = depo.getPickUpArea();
        this.loading = this.speed == 0.0;
        this.loading = this.loading && this.coachBackLeftX >= (double)this.pickUpArea[0] && this.coachBackLeftX <= (double)this.pickUpArea[2] && this.coachBackLeftY >= (double)this.pickUpArea[1] && this.coachBackLeftY <= (double)this.pickUpArea[3];
        boolean bl = this.loading = this.loading && this.coachBackRightX >= (double)this.pickUpArea[0] && this.coachBackRightX <= (double)this.pickUpArea[2] && this.coachBackRightY >= (double)this.pickUpArea[1] && this.coachBackRightY <= (double)this.pickUpArea[3];
        if (this.loading) {
            this.percentLoaded += 5;
            if (this.percentLoaded > 100) {
                this.percentLoaded = 100;
            }
        }
        if (this.percentLoaded == 100) {
            this.destArea = depo.getDestArea();
            this.levelDone = this.coachBackLeftX >= (double)this.destArea[0] && this.coachBackLeftX <= (double)this.destArea[2] && this.coachBackLeftY >= (double)this.destArea[1] && this.coachBackLeftY <= (double)this.destArea[3];
            this.levelDone = this.levelDone && this.coachBackRightX >= (double)this.destArea[0] && this.coachBackRightX <= (double)this.destArea[2] && this.coachBackRightY >= (double)this.destArea[1] && this.coachBackRightY <= (double)this.destArea[3];
        }
        return this.collisionValue >= this.maxCollisionValue;
    }

    public int getMiddleX() {
        return (int)this.truckBackGearX;
    }

    public int getMiddleY() {
        return (int)this.truckBackGearY;
    }

    public double getSteerAngle() {
        return this.steerAngle / this.maxSteerAngle;
    }

    public double getSpeed() {
        return this.speed / this.maxSpeed;
    }

    public double getCollisionValue() {
        return (double)this.collisionValue / (double)this.maxCollisionValue;
    }

    public int getPercentLoaded() {
        return this.percentLoaded;
    }

    public boolean getLevelDone() {
        return this.levelDone;
    }
}

