/*
 * Decompiled with CFR 0.152.
 */
package subgame;

import java.io.IOException;
import java.io.InputStream;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordComparator;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import subgame.Defs;
import subgame.Depth;
import subgame.Explosion;
import subgame.GameDesign;
import subgame.GamePlayer;
import subgame.Menu;
import subgame.Mine;
import subgame.Resizer;
import subgame.ScoresComparator;
import subgame.Ship;
import subgame.SoundPlayerClass;
import subgame.SubgameMidlet;

public class SubGameCanvas
extends GameCanvas
implements Runnable {
    public Sprite spriteSub;
    public Sprite spriteMine;
    public Sprite spriteWater;
    public Sprite spriteBullet;
    public Sprite spriteClouds;
    public Sprite spriteSky;
    public Sprite spriteIsland;
    public Sprite spriteShip;
    public Sprite spriteJet;
    public Sprite spriteAA;
    public Sprite spriteShip2;
    public Sprite spriteDepth;
    public Sprite spriteExplosion;
    public Sprite spriteEnemySub;
    public Sprite spriteHP;
    public Sprite spriteMenuBG;
    public Sprite spriteMobi;
    private GameDesign gameDesign;
    private GamePlayer player;
    private Ship[] ships;
    private Ship[] shipSubs;
    private Mine[] mines;
    private Depth[] depths;
    private Explosion[] explosions;
    private Menu mainMenu;
    private Menu difSelect;
    private float skyPos;
    private float islandPos;
    private int mineTimer;
    private int score;
    public boolean keysLocked;
    private int gameState;
    private boolean playing;
    private int exploIndex = 0;
    private SubgameMidlet subMid;
    private Player[] explosionSounds = new Player[3];
    private Player jetpassSound;
    private float prevTime;
    private float currentTime;
    public Font fontLarge;
    public Font fontSmall;
    private boolean jetPassed;
    public boolean soundDisabled = false;

    public SubGameCanvas(SubgameMidlet m) {
        super(true);
        this.subMid = m;
        this.prevTime = System.currentTimeMillis();
        this.currentTime = System.currentTimeMillis();
        this.jetPassed = false;
        try {
            this.setFullScreenMode(true);
            this.loader();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    protected void showNotify() {
        this.soundDisabled = false;
    }

    protected void hideNotify() {
        this.soundDisabled = true;
    }

    private void loadMenus() throws IOException {
        this.unloadGame();
        if (this.getWidth() > 200) {
            this.spriteMenuBG = this.gameDesign.getSpriteMenuBG();
            this.spriteMobi = this.gameDesign.getSpriteMobi();
        } else {
            Image temp = this.gameDesign.getMenuBGTex();
            this.spriteMenuBG = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getMobiTex();
            this.spriteMobi = new Sprite(Resizer.resizeImage(temp, 0.5f));
        }
        this.spriteMobi.setPosition(this.getWidth() / 2 - this.spriteMobi.getWidth() / 2, 0);
        this.spriteMenuBG.setPosition(this.getWidth() / 2 - this.spriteMenuBG.getWidth() / 2, 0);
    }

    private void unloadMenus() {
        this.spriteMenuBG = null;
        this.spriteMobi = null;
    }

    private void loadGame() throws IOException {
        int i;
        this.unloadMenus();
        if (this.getWidth() > 200) {
            this.spriteSub = this.gameDesign.getSpriteSub();
            this.spriteMine = this.gameDesign.getSpriteMine();
            this.spriteBullet = this.gameDesign.getSpriteBullet();
            this.spriteClouds = this.gameDesign.getSpriteClouds();
            this.spriteSky = this.gameDesign.getSpriteSky();
            this.spriteShip = this.gameDesign.getSpriteShip();
            this.spriteShip2 = this.gameDesign.getSpriteShip2();
            this.spriteJet = this.gameDesign.getSpriteJet();
            this.spriteAA = this.gameDesign.getSpriteAA();
            this.spriteDepth = this.gameDesign.getSpriteDepth();
            this.spriteExplosion = this.gameDesign.getSpriteExplo();
            try {
                this.spriteExplosion.setFrame(2);
            }
            catch (IndexOutOfBoundsException iobex) {
                this.spriteExplosion.setFrame(0);
                try {
                    this.spriteExplosion = this.gameDesign.getSpriteSimpleExplo();
                }
                catch (IOException ioex) {
                    // empty catch block
                }
            }
            this.spriteEnemySub = new Sprite(this.spriteSub);
            this.spriteEnemySub.setTransform(2);
            this.spriteHP = this.gameDesign.getSpriteHP();
            this.spriteIsland = this.gameDesign.getSpriteIsland();
        } else {
            Image temp = this.gameDesign.getSubTex();
            this.spriteSub = new Sprite(Resizer.resizeImage(temp, 0.51f));
            temp = this.gameDesign.getMineTex();
            this.spriteMine = new Sprite(Resizer.resizeImage(temp, 0.51f));
            temp = this.gameDesign.getBulletTex();
            this.spriteBullet = new Sprite(Resizer.resizeImage(temp, 0.6f));
            temp = this.gameDesign.getCloudsTex();
            this.spriteClouds = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getSkyTex();
            this.spriteSky = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getIslandTex();
            this.spriteIsland = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getShipTex();
            this.spriteShip = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getShipTex();
            this.spriteShip2 = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getJetTex();
            this.spriteJet = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getAATex();
            this.spriteAA = new Sprite(Resizer.resizeImage(temp, 0.5f));
            temp = this.gameDesign.getDepthTex();
            this.spriteDepth = new Sprite(Resizer.resizeImage(temp, 0.75f));
            temp = this.gameDesign.getExploTex();
            this.spriteExplosion = new Sprite(Resizer.resizeImage(temp, 0.5f));
            try {
                this.spriteExplosion.setFrame(2);
            }
            catch (IndexOutOfBoundsException iobex) {
                this.spriteExplosion.setFrame(0);
                try {
                    temp = this.gameDesign.getSimpleExploTex();
                    this.spriteExplosion = new Sprite(Resizer.resizeImage(temp, 0.5f));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.spriteEnemySub = new Sprite(this.spriteSub);
            this.spriteEnemySub.setTransform(2);
            temp = this.gameDesign.getSubHPTex();
            this.spriteHP = new Sprite(Resizer.resizeImage(temp, 0.6f));
        }
        this.fontSmall = Font.getFont((int)32, (int)0, (int)8);
        this.fontLarge = Font.getFont((int)32, (int)0, (int)16);
        this.skyPos = Defs.SKYLIMIT - this.spriteSky.getHeight() + 50;
        this.spriteBullet.setVisible(false);
        this.player = new GamePlayer(this);
        this.mines = new Mine[Defs.MAX_MINES];
        this.depths = new Depth[5];
        this.explosions = new Explosion[10];
        this.ships = new Ship[5];
        this.shipSubs = new Ship[5];
        Random rand = new Random();
        for (i = 0; i < Defs.MAX_MINES; ++i) {
            this.mines[i] = new Mine((float)rand.nextInt(500) + (float)this.getWidth() + 100.0f, (float)rand.nextInt(this.getHeight() - Defs.SKYLIMIT - 50) + (float)Defs.SKYLIMIT + 20.0f);
        }
        this.islandPos = 200.0f;
        this.mineTimer = 3000;
        this.score = 0;
        this.addShip((float)rand.nextInt(this.getWidth()) + (float)(1000 / Defs.DIFFICULTY), (float)Defs.SKYLIMIT - (float)this.spriteShip.getHeight() + (float)(this.spriteShip.getHeight() / 4), this.spriteShip, 0, false, this.spriteShip.getHeight() / 4);
        this.addShip((float)rand.nextInt(this.getWidth()) + (float)(2000 / Defs.DIFFICULTY), (float)Defs.SKYLIMIT - (float)this.spriteShip2.getHeight() + (float)(this.spriteShip2.getHeight() / 4), this.spriteShip2, 0, false, this.spriteShip2.getHeight() / 4);
        for (i = this.shipSubs.length; i >= 0; --i) {
            this.addShip((float)rand.nextInt(3000) + (float)(1000 * i / Defs.DIFFICULTY), rand.nextInt(100) + Defs.SKYLIMIT, this.spriteEnemySub, 1, true, 0);
        }
        this.spriteClouds.setPosition(0, -10);
        this.spriteJet.setPosition(1000, 40);
    }

    private void unloadGame() {
        this.spriteSub = null;
        this.spriteMine = null;
        this.spriteBullet = null;
        this.spriteClouds = null;
        this.spriteSky = null;
        this.spriteIsland = null;
        this.spriteShip = null;
        this.spriteShip2 = null;
        this.spriteJet = null;
        this.spriteAA = null;
        this.spriteDepth = null;
        this.spriteExplosion = null;
        this.spriteEnemySub = null;
        this.spriteHP = null;
    }

    private void loader() throws IOException {
        this.gameDesign = new GameDesign();
        if (this.getWidth() > 200) {
            this.spriteWater = this.gameDesign.getSpriteWater();
        } else {
            Image temp = this.gameDesign.getWaterTex();
            this.spriteWater = new Sprite(Resizer.resizeImage(temp, 0.51f));
        }
        this.mainMenu = new Menu(5);
        this.mainMenu.addOption("START", 4);
        this.mainMenu.addOption("SCORES", 3);
        this.mainMenu.addOption("INSTRUCTIONS", 6);
        this.mainMenu.addOption("ABOUT", 7);
        this.mainMenu.addOption("QUIT", 2);
        this.difSelect = new Menu(3);
        this.difSelect.addOption("ENSIGN", 1);
        this.difSelect.addOption("COMMANDER", 2);
        this.difSelect.addOption("ADMIRAL", 3);
        this.playing = true;
        Defs.SKYLIMIT = this.getHeight() / 3;
        if (this.getWidth() > 320) {
            Defs.MASK_EXTRA_HORIZONTAL = (this.getWidth() - 320) / 2;
        }
        if (this.getHeight() > 320) {
            Defs.MASK_EXTRA_VERTICAL = (this.getHeight() - 320) / 2;
        }
        try {
            InputStream is;
            for (int i = 0; i < this.explosionSounds.length; ++i) {
                is = this.getClass().getResourceAsStream("subexplosion.wav");
                this.explosionSounds[i] = Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
                this.explosionSounds[i].prefetch();
                VolumeControl vc = (VolumeControl)this.explosionSounds[i].getControl("VolumeControl");
                vc.setLevel(30);
            }
            is = this.getClass().getResourceAsStream("jetpass.wav");
            this.jetpassSound = Manager.createPlayer((InputStream)is, (String)"audio/X-wav");
            this.jetpassSound.prefetch();
            VolumeControl vc = (VolumeControl)this.jetpassSound.getControl("VolumeControl");
            vc.setLevel(30);
        }
        catch (IOException ioe) {
        }
        catch (MediaException me) {
            try {
                InputStream is;
                for (int i = 0; i < this.explosionSounds.length; ++i) {
                    is = this.getClass().getResourceAsStream("subexplosion.wav");
                    this.explosionSounds[i] = Manager.createPlayer((InputStream)is, (String)"audio/wav");
                    this.explosionSounds[i].prefetch();
                    VolumeControl vc = (VolumeControl)this.explosionSounds[i].getControl("VolumeControl");
                    vc.setLevel(30);
                }
                is = this.getClass().getResourceAsStream("jetpass.wav");
                this.jetpassSound = Manager.createPlayer((InputStream)is, (String)"audio/wav");
                this.jetpassSound.prefetch();
                VolumeControl vc = (VolumeControl)this.jetpassSound.getControl("VolumeControl");
                vc.setLevel(30);
            }
            catch (IOException ioe) {
            }
            catch (MediaException mex) {
                this.soundDisabled = true;
            }
        }
        this.resetGame();
        this.gameState = 5;
    }

    public void run() {
        Graphics g = this.getGraphics();
        Random rand = new Random();
        int splashTimer = 130;
        while (this.playing) {
            this.releaseKeys();
            this.prevTime = this.currentTime;
            this.currentTime = System.currentTimeMillis();
            switch (this.gameState) {
                case 5: {
                    this.spriteMobi.paint(g);
                    if (--splashTimer >= 0) break;
                    this.gameState = 0;
                    break;
                }
                case 6: {
                    int y = 10;
                    int addY = this.getHeight() / 8;
                    this.spriteWater.setPosition(0, 0);
                    this.spriteWater.paint(g);
                    g.setFont(this.fontSmall);
                    g.drawString("Move:", this.getWidth() / 2, y, 17);
                    g.drawString("Navigation key or", this.getWidth() / 2, y += addY, 17);
                    g.drawString("2, 4, 6, 8", this.getWidth() / 2, y += addY, 17);
                    g.drawString("Fire:", this.getWidth() / 2, y += addY, 17);
                    g.drawString("Selection key or", this.getWidth() / 2, y += addY, 17);
                    g.drawString("5", this.getWidth() / 2, y += addY, 17);
                    g.drawString("Press any key to return", this.getWidth() / 2, this.getHeight() - 30, 17);
                    if (this.getKeyStates() == 0 || this.keysLocked) break;
                    this.gameState = 0;
                    this.keysLocked = true;
                    break;
                }
                case 7: {
                    this.spriteWater.setPosition(0, 0);
                    this.spriteWater.paint(g);
                    g.setFont(this.fontSmall);
                    g.drawString("Version 1.0", this.getWidth() / 2, 50, 17);
                    g.drawString("2010, mobilive", this.getWidth() / 2, 100, 17);
                    g.drawString("Press any key to return", this.getWidth() / 2, this.getHeight() - 30, 17);
                    if (this.getKeyStates() == 0 || this.keysLocked) break;
                    this.gameState = 0;
                    this.keysLocked = true;
                    break;
                }
                case 2: {
                    this.subMid.exitMidlet();
                    break;
                }
                case 4: {
                    int rValue = this.difSelect.handleInput(this);
                    if (rValue != -1) {
                        Defs.DIFFICULTY = rValue;
                        this.resetGame();
                        try {
                            this.loadGame();
                        }
                        catch (IOException ioex) {
                            // empty catch block
                        }
                        this.gameState = 1;
                        break;
                    }
                    this.spriteMenuBG.paint(g);
                    this.difSelect.render(g, this);
                    break;
                }
                case 0: {
                    this.spriteMenuBG.setPosition(this.getWidth() / 2 - this.spriteMenuBG.getWidth() / 2, 0);
                    this.spriteMenuBG.paint(g);
                    this.mainMenu.render(g, this);
                    int rValue = this.mainMenu.handleInput(this);
                    if (rValue == -1) break;
                    this.gameState = rValue;
                    break;
                }
                case 3: {
                    try {
                        RecordStore rs = RecordStore.openRecordStore((String)"Highscores", (boolean)true);
                        while (rs.getNumRecords() < 5) {
                            String str = new String("Mr. Unknown - 10");
                            byte[] strb = str.getBytes();
                            rs.addRecord(strb, 0, strb.length);
                        }
                        this.spriteWater.setPosition(0, 0);
                        this.spriteWater.paint(g);
                        RecordEnumeration enumerator = rs.enumerateRecords(null, (RecordComparator)new ScoresComparator(), false);
                        int counter = 0;
                        g.setFont(this.fontSmall);
                        while (enumerator.hasNextElement()) {
                            int id = enumerator.nextRecordId();
                            byte[] record = rs.getRecord(id);
                            String str = new String(record);
                            if (str.length() <= 0) continue;
                            int h = this.getHeight() / 8;
                            g.drawString(str, this.getWidth() / 2, 10 + h * 5 - h * counter, 17);
                            ++counter;
                        }
                        rs.closeRecordStore();
                        g.drawString("Press any key to return", this.getWidth() / 2, this.getHeight() - 40, 17);
                        int keyState = this.getKeyStates();
                        if (keyState == 0 || this.keysLocked) break;
                        this.keysLocked = true;
                        this.gameState = 0;
                    }
                    catch (RecordStoreException rex) {}
                    break;
                }
                case 1: {
                    int i;
                    this.updateMines();
                    this.updateShips();
                    this.spriteBullet.move(3, 0);
                    if (this.spriteBullet.getX() > this.getWidth()) {
                        this.spriteBullet.setVisible(false);
                    }
                    this.updateBackground();
                    this.spriteSky.setPosition(this.getWidth() / 2 - this.spriteSky.getWidth() / 2, (int)this.skyPos);
                    this.spriteSky.paint(g);
                    this.spriteJet.paint(g);
                    this.spriteIsland.setPosition((int)this.islandPos, Defs.SKYLIMIT - this.spriteIsland.getHeight() / 5);
                    this.spriteAA.setPosition(this.spriteIsland.getWidth() / 2 + (int)this.islandPos + 30, this.spriteIsland.getY() - this.spriteAA.getHeight() / 2);
                    this.spriteAA.paint(g);
                    this.spriteAA.setPosition(this.spriteIsland.getWidth() / 2 + (int)this.islandPos - 50, this.spriteIsland.getY() - this.spriteAA.getHeight() / 2);
                    this.spriteAA.paint(g);
                    this.spriteIsland.paint(g);
                    for (i = 0; i < this.ships.length; ++i) {
                        if (this.ships[i] == null) continue;
                        this.ships[i].sprite.setPosition((int)this.ships[i].x, (int)this.ships[i].y);
                        this.ships[i].sprite.paint(g);
                        if (this.spriteBullet.collidesWith(this.ships[i].sprite, true) && !this.ships[i].isDead) {
                            this.addExplosion(this.spriteBullet.getX() + this.spriteBullet.getWidth() / 2, this.spriteBullet.getY() + this.spriteBullet.getHeight() / 2, true);
                            this.spriteBullet.setVisible(false);
                            this.ships[i].hp -= 1.0f;
                            if (this.ships[i].hp < 0.0f && !this.ships[i].isDead) {
                                this.score += Defs.SCORE_SHIP;
                                this.ships[i].isDead = true;
                            }
                        }
                        if (!this.spriteSub.collidesWith(this.ships[i].sprite, true) || this.ships[i].isDead) continue;
                        this.player.hp = -1.0f;
                        this.addExplosion(this.player.x + (float)rand.nextInt(40), this.player.y + (float)rand.nextInt(20), true);
                    }
                    this.spriteWater.setPosition(this.getWidth() / 2 - this.spriteWater.getWidth() / 2, Defs.SKYLIMIT);
                    this.spriteWater.paint(g);
                    this.spriteClouds.paint(g);
                    this.spriteSub.setPosition((int)this.player.x, (int)this.player.y);
                    this.spriteSub.paint(g);
                    this.spriteBullet.paint(g);
                    for (i = 0; i < this.shipSubs.length; ++i) {
                        this.spriteEnemySub.setPosition((int)this.shipSubs[i].x, (int)this.shipSubs[i].y);
                        this.spriteEnemySub.paint(g);
                        if (this.spriteBullet.collidesWith(this.spriteEnemySub, true)) {
                            this.addExplosion(this.spriteBullet.getX() + this.spriteBullet.getWidth(), this.spriteBullet.getY() + 2, true);
                            this.spriteBullet.setVisible(false);
                            this.shipSubs[i].hp -= 1.0f;
                            if (this.shipSubs[i].hp < 0.0f && !this.shipSubs[i].isDead) {
                                this.score += Defs.SCORE_SHIP;
                                this.shipSubs[i].isDead = true;
                            }
                        }
                        if (this.spriteSub.collidesWith(this.spriteEnemySub, true) && !this.shipSubs[i].isDead) {
                            this.player.hp = -1.0f;
                            this.addExplosion(this.player.x + (float)rand.nextInt(40), this.player.y + (float)rand.nextInt(20), true);
                            this.shipSubs[i].hp = -1.0f;
                            if (this.shipSubs[i].hp < 0.0f && !this.shipSubs[i].isDead) {
                                this.score += Defs.SCORE_SHIP;
                                this.shipSubs[i].isDead = true;
                            }
                        }
                        if (!this.shipSubs[i].isDead || this.explosions[3] != null) continue;
                        this.addExplosion(this.shipSubs[i].x + (float)rand.nextInt(40), this.shipSubs[i].y + (float)rand.nextInt(20), false);
                    }
                    for (i = 0; i < this.depths.length; ++i) {
                        if (this.depths[i] == null) continue;
                        if (this.depths[i].update(this) == 1) {
                            this.depths[i] = null;
                            continue;
                        }
                        this.spriteDepth.setPosition((int)this.depths[i].x, (int)this.depths[i].y);
                        this.spriteDepth.paint(g);
                        if (this.spriteDepth.collidesWith(this.spriteSub, true)) {
                            this.addExplosion(this.depths[i].x + (float)(this.spriteDepth.getWidth() / 2), this.depths[i].y + (float)(this.spriteDepth.getHeight() / 2), true);
                            this.player.hp -= 1.0f;
                            this.depths[i] = null;
                            continue;
                        }
                        if (!this.spriteDepth.collidesWith(this.spriteBullet, true)) continue;
                        this.addExplosion(this.spriteBullet.getX() + this.spriteBullet.getWidth(), this.spriteBullet.getY() + 2, true);
                        this.spriteBullet.setVisible(false);
                        this.depths[i] = null;
                    }
                    for (i = 0; i < this.mines.length; ++i) {
                        this.spriteMine.setPosition((int)this.mines[i].x, (int)this.mines[i].y);
                        if (this.spriteBullet.collidesWith(this.spriteMine, true)) {
                            this.addExplosion(this.mines[i].x + (float)(this.spriteMine.getWidth() / 2), this.mines[i].y + (float)(this.spriteMine.getHeight() / 2), true);
                            this.mines[i].x = rand.nextInt(150) + this.getWidth();
                            this.mines[i].y = rand.nextInt(this.getHeight() - Defs.SKYLIMIT) + Defs.SKYLIMIT;
                            this.spriteMine.setPosition((int)this.mines[i].x, (int)this.mines[i].y);
                            this.spriteBullet.setVisible(false);
                            this.score += Defs.SCORE_MINE;
                        }
                        if (this.spriteSub.collidesWith(this.spriteMine, true)) {
                            this.addExplosion(this.mines[i].x + (float)(this.spriteMine.getWidth() / 2), this.mines[i].y + (float)(this.spriteMine.getHeight() / 2), true);
                            this.mines[i].x = rand.nextInt(150) + this.getWidth();
                            this.mines[i].y = rand.nextInt(this.getHeight() - Defs.SKYLIMIT) + Defs.SKYLIMIT;
                            this.spriteMine.setPosition((int)this.mines[i].x, (int)this.mines[i].y);
                            this.player.hp -= 1.0f;
                        }
                        this.spriteMine.paint(g);
                    }
                    for (i = 0; i < this.explosions.length; ++i) {
                        if (this.explosions[i] == null) continue;
                        this.spriteExplosion.setPosition((int)this.explosions[i].x, (int)this.explosions[i].y);
                        try {
                            this.spriteExplosion.setFrame(this.explosions[i].currentFrame);
                        }
                        catch (IndexOutOfBoundsException iobex) {
                            this.spriteExplosion.setFrame(0);
                        }
                        this.drawCentered(g, this.spriteExplosion);
                        if (this.explosions[i].update(this) != 1) continue;
                        this.explosions[i] = null;
                    }
                    if (this.player.hp < 0.0f) {
                        if (this.explosions[5] == null) {
                            this.addExplosion(this.player.x + (float)rand.nextInt(40), this.player.y + (float)rand.nextInt(20), false);
                        }
                        this.player.canControl = false;
                        this.player.y += 2.0f;
                    }
                    if (this.player.y > (float)this.getHeight()) {
                        g.setFont(this.fontLarge);
                        g.drawString("Game Over", this.getWidth() / 2, this.getHeight() / 2, 17);
                        g.setFont(this.fontSmall);
                        g.drawString("Press 'Fire' to continue", this.getWidth() / 2, this.getHeight() / 2 + 30, 17);
                    }
                    String s = Integer.toString(this.score);
                    g.setFont(this.fontSmall);
                    g.setColor(255, 255, 255);
                    g.drawString(s, 5, 5, 0);
                    int i2 = 0;
                    while ((float)i2 < this.player.hp) {
                        this.spriteHP.setPosition(this.getWidth() - 5 - this.spriteHP.getWidth(), this.getHeight() - 15 - (this.spriteHP.getHeight() + 2) * i2);
                        this.spriteHP.paint(g);
                        ++i2;
                    }
                    this.handlePlayerInput();
                }
            }
            g.setColor(0, 0, 0);
            if (this.getWidth() > 320) {
                int width = (this.getWidth() - 320) / 2;
                g.fillRect(0, 0, width, this.getHeight());
                g.fillRect(this.getWidth() - width, 0, width, this.getHeight());
            }
            if (this.getHeight() > 320) {
                int height = (this.getHeight() - 320) / 2;
                g.fillRect(0, 0, this.getWidth(), height);
                g.fillRect(0, this.getHeight() - height, this.getWidth(), height);
            }
            this.flushGraphics();
            float delay = 22.0f - (this.currentTime - this.prevTime);
            if (!(delay > 0.0f)) continue;
            try {
                Thread.sleep((int)delay);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void releaseDepthCharge(Ship ship) {
        for (int i = 0; i < this.depths.length; ++i) {
            if (this.depths[i] != null) continue;
            this.depths[i] = new Depth(ship.x + 20.0f, ship.y + (float)ship.sprite.getHeight() - 5.0f);
            return;
        }
    }

    private void addExplosion(float x, float y, boolean withSound) {
        for (int i = 0; i < this.explosions.length; ++i) {
            if (this.explosions[i] != null) continue;
            this.explosions[i] = new Explosion(x, y);
            if (withSound) {
                this.playSound(this.explosionSounds[this.exploIndex]);
                this.exploIndex = this.exploIndex < this.explosionSounds.length - 1 ? ++this.exploIndex : 0;
            }
            return;
        }
    }

    private void drawCentered(Graphics g, Sprite s) {
        Sprite temp = new Sprite(s);
        temp.move(-temp.getWidth() / 2, -temp.getHeight() / 2);
        temp.paint(g);
    }

    private void resetGame() {
        this.mines = null;
        this.explosions = null;
        this.depths = null;
        try {
            this.loadMenus();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.gameState = 0;
        this.keysLocked = true;
    }

    private void playSound(Player p) {
        if (!this.soundDisabled) {
            Thread sound = new Thread(new SoundPlayerClass(p));
            sound.start();
        }
    }

    private void handlePlayerInput() {
        int r = this.player.update(this);
        if (r == 1 && !this.spriteBullet.isVisible()) {
            this.spriteBullet.setPosition(this.spriteSub.getWidth() + (int)this.player.x, (int)this.player.y + this.spriteSub.getHeight() / 2);
            this.spriteBullet.setVisible(true);
        }
        if (r == 2) {
            this.unloadGame();
            System.gc();
            this.addHighScore();
            System.gc();
            this.resetGame();
            System.gc();
            this.gameState = 3;
        }
    }

    private void addShip(float x, float y, Sprite s, int weapType, boolean sub, int depth) {
        if (!sub) {
            for (int i = 0; i < this.ships.length; ++i) {
                if (this.ships[i] != null) continue;
                this.ships[i] = new Ship(x, y, s, weapType, sub, depth);
                return;
            }
        } else {
            for (int i = 0; i < this.shipSubs.length; ++i) {
                if (this.shipSubs[i] != null) continue;
                this.shipSubs[i] = new Ship(x, y, s, weapType, sub, depth);
                return;
            }
        }
    }

    private void releaseKeys() {
        if (this.getKeyStates() == 0) {
            this.keysLocked = false;
        }
    }

    private void updateMines() {
        if (this.mineTimer < 19000) {
            this.mineTimer += Defs.DIFFICULTY * 2;
        }
        for (int i = 0; i < this.mines.length; ++i) {
            if (i >= this.mineTimer / 1000) continue;
            this.mines[i].update(this);
        }
    }

    private void updateShips() {
        int a;
        int i;
        for (i = 0; i < this.ships.length; ++i) {
            if (this.ships[i] == null || (a = this.ships[i].update(this)) != 1) continue;
            switch (this.ships[i].weaponType) {
                case 0: {
                    this.releaseDepthCharge(this.ships[i]);
                }
            }
        }
        for (i = 0; i < this.shipSubs.length; ++i) {
            if (this.shipSubs[i] == null || (a = this.shipSubs[i].update(this)) != 1) continue;
            switch (this.shipSubs[i].weaponType) {
                case 0: {
                    this.releaseDepthCharge(this.ships[i]);
                }
            }
        }
    }

    public void stop() {
        this.playing = false;
    }

    private void updateBackground() {
        Random rand = new Random();
        if (this.skyPos < 0.0f) {
            this.skyPos += 0.05f;
        }
        this.islandPos += (float)Defs.SPEED;
        if (this.islandPos + (float)this.spriteIsland.getWidth() < -20.0f) {
            this.islandPos = rand.nextInt(400) + this.getWidth();
        }
        this.spriteClouds.move(Defs.SPEED, 0);
        if (this.spriteClouds.getX() + this.spriteClouds.getWidth() < -20) {
            this.spriteClouds.setPosition(this.getWidth() + 30, this.spriteClouds.getY());
        }
        this.spriteJet.move(-8, 0);
        if (this.spriteJet.getX() < -50) {
            this.spriteJet.setPosition(rand.nextInt(1300) + 2000, rand.nextInt(20) + 40);
            this.jetPassed = false;
        }
        if (this.spriteJet.getX() < this.getWidth() && !this.jetPassed) {
            this.playSound(this.jetpassSound);
            this.jetPassed = true;
        }
    }

    private void addHighScore() {
        try {
            RecordStore rs = RecordStore.openRecordStore((String)"Highscores", (boolean)true);
            RecordEnumeration enumerator = rs.enumerateRecords(null, (RecordComparator)new ScoresComparator(), false);
            while (enumerator.hasNextElement()) {
                int i;
                int id = enumerator.nextRecordId();
                byte[] record = rs.getRecord(id);
                String str = new String(record);
                String s = str.substring((i = str.indexOf("-")) + 2);
                int thisScore = Integer.parseInt(s);
                if (this.score <= thisScore) continue;
                String string = this.subMid.askPlayerName() + " - " + Integer.toString(this.score);
                byte[] strb = string.getBytes();
                rs.deleteRecord(id);
                rs.addRecord(strb, 0, strb.length);
                return;
            }
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
    }
}

